/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.aws.ofd.util.ofd.OfdUtil;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.InvoiceImageNotifyService;
import kd.imc.rim.common.invoice.recognitionnew.task.FileSaveTask;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.compress.utils.Lists;

public class SnapshotService {
    private static final Log logger = LogFactory.getLog(SnapshotService.class);
    public static final String tabId = "rim_invoice_snapshot";
    private static final int cacheHour = 72;
    public static final String STATUS_WAITING = "0";
    public static final String STATUS_SUCCESS = "1";
    public static final String STATUS_FAIL = "2";
    private static final String OFD = "ofd";
    private static final String PDF = "pdf";
    private static final int maxtime = 5;
    private static final String fields = "id,file_hash,status,serial_no,update_time,traceid,file_type,file_url,snapshot_url,pdf_url,deal_times";
    private static final String id = UUID.randomUUIDZero();

    public void start(String from) {
        logger.info("\u5feb\u7167\u751f\u6210\u4efb\u52a1\u5f00\u59cb:{}", (Object)from);
        this.start();
    }

    public void start() {
        ThreadPools.executeOnceIncludeRequestContext((String)"SnapshotServiceThread", (Runnable)new Runnable(){

            @Override
            public void run() {
                try (DLock lock = DLock.create((String)("SnapshotThread" + id), (String)"SnapshotThread");){
                    if (lock.tryLock()) {
                        logger.info("\u5feb\u7167\u751f\u6210\u4efb\u52a1\u5f00\u59cb{}", (Object)id);
                        String repushFlag = RimConfigUtils.getConfig("renotify_image");
                        int i = 0;
                        while (i < 10) {
                            List<Object> billIds;
                            ++i;
                            ArrayList serialNos = Lists.newArrayList();
                            QFilter filter1 = new QFilter("status", "in", (Object)SnapshotService.STATUS_WAITING);
                            DynamicObjectCollection collect = QueryServiceHelper.query((String)SnapshotService.tabId, (String)"id,serial_no", (QFilter[])new QFilter[]{filter1}, (String)"id", (int)100);
                            if (collect.isEmpty()) {
                                logger.info("\u5feb\u7167\u751f\u6210\u4efb\u52a1\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u8bb0\u5f55{}", (Object)id);
                                break;
                            }
                            for (DynamicObject obj : collect) {
                                boolean isSuccess = SnapshotService.this.createSnapshot(obj.get("id"));
                                if (!isSuccess) continue;
                                serialNos.add(obj.getString("serial_no"));
                            }
                            boolean checkFlag = SnapshotService.STATUS_SUCCESS.equals(repushFlag);
                            if (!checkFlag || (billIds = ExpenseService.getBillIds(serialNos)).isEmpty()) continue;
                            DynamicObject[] notityInfos = BusinessDataServiceHelper.load((String)"rim_image_notify_log", (String)"json", (QFilter[])new QFilter[]{new QFilter("expense_id", "in", billIds)});
                            List<String> params = Arrays.stream(notityInfos).map(v -> v.getString("json")).distinct().collect(Collectors.toList());
                            InvoiceImageNotifyService.imageNotify(params);
                            logger.info("\u5feb\u7167\u751f\u6210\u4efb\u52a1\u91cd\u65b0\u901a\u77e5\u5f71\u50cf..\u6570\u91cf\uff1a{}", (Object)notityInfos.length);
                        }
                        logger.info("\u5feb\u7167\u751f\u6210\u4efb\u52a1\u7ed3\u675f{}", (Object)id);
                    } else {
                        logger.info("\u5feb\u7167\u751f\u6210\u4efb\u52a1\u83b7\u53d6\u9501\u5931\u8d25{}", (Object)id);
                    }
                }
            }
        });
    }

    public void createSnapshot(List<Object> pks) {
        for (Object pk : pks) {
            this.createSnapshot(pk);
        }
    }

    public boolean createSnapshot(Object pk) {
        try (DLock lock = DLock.create((String)("createSnapshot" + pk), (String)"createSnapshot");){
            if (lock.tryLock()) {
                boolean success = false;
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tabId));
                if (STATUS_WAITING.equals(obj.getString("status"))) {
                    long start = System.currentTimeMillis();
                    obj.set("update_time", (Object)new Date());
                    int dealTimes = obj.getInt("deal_times") + 1;
                    obj.set("deal_times", (Object)dealTimes);
                    String fileUrl = obj.getString("file_url");
                    String traceId = RequestContext.get().getTraceId();
                    obj.set("traceid", (Object)traceId);
                    byte[] fileContent = FileUtils.getAttachmentByte(fileUrl);
                    try {
                        JSONObject result = this.createSnapshot(fileContent, obj.getString("file_type"), obj.getString("pdf_url"), obj.getString("snapshot_url"));
                        obj.set("snapshot_url", (Object)result.getString("snapshotUrl"));
                        obj.set("pdf_url", (Object)result.getString("pdfUrl"));
                        success = !StringUtils.isEmpty((CharSequence)result.getString("snapshotUrl"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (success) {
                        obj.set("status", (Object)STATUS_SUCCESS);
                    } else if (dealTimes >= 5) {
                        obj.set("status", (Object)STATUS_FAIL);
                    }
                    SaveServiceHelper.update((DynamicObject)obj);
                    logger.info("\u5feb\u7167\u751f\u6210\u7ed3\u675f{},\u8017\u65f6{}", (Object)obj.getString("file_name"), (Object)(System.currentTimeMillis() - start));
                    if (success) {
                        this.updateInvoiceFile(obj);
                    }
                }
                boolean bl = success;
                return bl;
            }
            logger.info("\u5feb\u7167\u751f\u6210\u6b63\u5728\u5904\u7406{}", pk);
        }
        return false;
    }

    public JSONObject updateInvoiceFile(String fileHash, String serialNo) {
        if (StringUtils.isNotEmpty((CharSequence)fileHash)) {
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject fileIdDynamicObject = CommonUtils.loadSingle("rim_invoice_file", new QFilter[]{tenantFilter, serialFilter});
            if (StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("snapshot_url"))) {
                QFilter filter1 = new QFilter("file_hash", "=", (Object)fileHash);
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)tabId, (String)fields, (QFilter[])new QFilter[]{filter1});
                return this.updateInvoiceFile(obj, serialNo, fileHash, fileIdDynamicObject);
            }
        }
        return new JSONObject();
    }

    private JSONObject updateInvoiceFile(DynamicObject obj) {
        String serialNo = obj.getString("serial_no");
        String fileHash = obj.getString("file_hash");
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            serialNo = CacheHelper.get("snapNo" + fileHash);
        }
        if (!StringUtils.isEmpty((CharSequence)serialNo)) {
            logger.info("\u5feb\u7167\u751f\u6210\u6210\u529f,\u66f4\u65b0\u53d1\u7968{}", (Object)serialNo);
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject fileIdDynamicObject = CommonUtils.loadSingle("rim_invoice_file", new QFilter[]{tenantFilter, serialFilter});
            return this.updateInvoiceFile(obj, serialNo, fileHash, fileIdDynamicObject);
        }
        return new JSONObject();
    }

    private JSONObject updateInvoiceFile(DynamicObject obj, String serialNo, String fileHash, DynamicObject fileIdDynamicObject) {
        JSONObject result = new JSONObject();
        if (obj != null && fileIdDynamicObject != null && fileHash.equals(fileIdDynamicObject.getString("file_hash"))) {
            Map<String, Object> oldMap = DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject);
            if (PDF.equals(obj.get("file_type"))) {
                fileIdDynamicObject.set("pdf_url", obj.get("file_url"));
            } else if (OFD.equals(obj.get("file_type"))) {
                fileIdDynamicObject.set("ofd_url", obj.get("file_url"));
                fileIdDynamicObject.set("pdf_url", obj.get("pdf_url"));
            }
            fileIdDynamicObject.set("snapshot_url", obj.get("snapshot_url"));
            fileIdDynamicObject.set("image_url", obj.get("snapshot_url"));
            Map<String, Object> newMap = DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject);
            SaveServiceHelper.update((DynamicObject)fileIdDynamicObject);
            FileSaveTask.saveHis(oldMap, newMap);
            result.put("pdfUrl", (Object)fileIdDynamicObject.getString("pdf_url"));
            result.put("ofdUrl", (Object)fileIdDynamicObject.getString("ofd_url"));
            result.put("snapshotUrl", (Object)fileIdDynamicObject.getString("snapshot_url"));
        } else {
            logger.info("\u5feb\u7167\u751f\u6210\u6210\u529f,\u6587\u4ef6\u8bb0\u5f55\u4e0d\u5b58\u5728\u4e0d\u66f4\u65b0\u53d1\u7968{}-{}", (Object)serialNo, (Object)fileHash);
        }
        return result;
    }

    public JSONObject createSnapshot(byte[] fileContent, String fileType, String pdfUrl, String imageUrl) {
        JSONObject result = new JSONObject();
        String path = FileUploadUtils.getInvoiceDir("snap") + UUID.randomUUIDZero();
        try {
            if (OFD.equalsIgnoreCase(fileType)) {
                if (StringUtils.isEmpty((CharSequence)pdfUrl)) {
                    pdfUrl = path + ".pdf";
                }
                if (StringUtils.isEmpty((CharSequence)imageUrl)) {
                    imageUrl = path + ".jpg";
                }
                byte[] pdfByte = OfdUtil.convertToPdfNew((byte[])fileContent);
                byte[] imageArray = FileConvertUtils.pdf2imageByte((byte[])pdfByte, (String)"jpg");
                String pdfResult = FileConvertUtils.upload((byte[])pdfByte, null, (String)pdfUrl);
                String imageResult = FileConvertUtils.upload((byte[])imageArray, null, (String)imageUrl);
                result.put("snapshotUrl", (Object)imageResult);
                result.put("pdfUrl", (Object)pdfResult);
            } else if (PDF.equalsIgnoreCase(fileType)) {
                if (StringUtils.isEmpty((CharSequence)imageUrl)) {
                    imageUrl = path + ".jpg";
                }
                String image = FileConvertUtils.pdf2imageAndUpload((byte[])fileContent, null, (String)imageUrl);
                result.put("snapshotUrl", (Object)image);
            }
        }
        catch (Throwable t) {
            logger.info("\u5feb\u7167\u751f\u6210\u5931\u8d25:{}", (Object)t);
        }
        return result;
    }

    public JSONObject createSnapshot(byte[] fileContent, String fileHash, String fileUrl, String fileName, String fileType, boolean sync) {
        DynamicObject obj;
        logger.info("\u5feb\u7167\u751f\u6210\u662f\u5426\u5f02\u6b65{}", (Object)sync);
        JSONObject result = new JSONObject();
        QFilter filter1 = new QFilter("file_hash", "=", (Object)fileHash);
        DynamicObject[] list = BusinessDataServiceHelper.load((String)tabId, (String)fields, (QFilter[])new QFilter[]{filter1});
        Long id = null;
        if (list != null && list.length > 0) {
            obj = list[0];
            if (STATUS_SUCCESS.equals(obj.getString("status"))) {
                result.put("snapshotUrl", obj.get("snapshot_url"));
                result.put("pdfUrl", obj.get("pdf_url"));
                return result;
            }
            id = obj.getLong("id");
        }
        if (sync) {
            obj = null;
            if (id == null) {
                obj = BusinessDataServiceHelper.newDynamicObject((String)tabId);
                obj.set("create_time", (Object)new Date());
            } else {
                obj = BusinessDataServiceHelper.loadSingle(id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tabId));
            }
            String traceId = RequestContext.get().getTraceId();
            obj.set("file_hash", (Object)fileHash);
            obj.set("file_name", (Object)fileName);
            obj.set("file_type", (Object)fileType);
            obj.set("file_url", (Object)fileUrl);
            obj.set("status", (Object)STATUS_WAITING);
            obj.set("update_time", (Object)new Date());
            obj.set("traceid", (Object)traceId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            this.start();
        } else {
            JSONObject fileResult = this.createSnapshot(fileContent, fileType, null, null);
            logger.info("\u5feb\u7167\u751f\u6210\u540c\u6b65\u751f\u6210\u7ed3\u679c\uff1a{}", (Object)fileResult);
            DynamicObject obj2 = null;
            if (id == null) {
                obj2 = BusinessDataServiceHelper.newDynamicObject((String)tabId);
                obj2.set("create_time", (Object)new Date());
                obj2.set("file_hash", (Object)fileHash);
                obj2.set("file_type", (Object)fileType);
                obj2.set("file_url", (Object)fileUrl);
                obj2.set("status", (Object)STATUS_WAITING);
            } else {
                obj2 = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tabId));
                obj2.set("status", (Object)STATUS_WAITING);
                obj2.set("deal_times", (Object)0);
            }
            if (!StringUtils.isEmpty((CharSequence)fileResult.getString("snapshotUrl"))) {
                obj2.set("status", (Object)STATUS_SUCCESS);
                obj2.set("snapshot_url", (Object)fileResult.getString("snapshotUrl"));
                obj2.set("pdf_url", (Object)fileResult.getString("pdfUrl"));
                result.put("pdfUrl", (Object)fileResult.getString("pdfUrl"));
                result.put("snapshotUrl", (Object)fileResult.getString("snapshotUrl"));
            }
            obj2.set("file_name", (Object)fileName);
            obj2.set("update_time", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj2});
        }
        return result;
    }

    public JSONObject getResultAndUpdateSerial(String fileHash, String serialNo) {
        logger.info("\u5feb\u7167\u751f\u6210,\u66f4\u65b0\u53d1\u7968\u6d41\u6c34\u53f7{}-{}", (Object)serialNo, (Object)fileHash);
        JSONObject result = new JSONObject();
        QFilter filter = new QFilter("file_hash", "=", (Object)fileHash);
        DynamicObject[] list = BusinessDataServiceHelper.load((String)tabId, (String)fields, (QFilter[])new QFilter[]{filter});
        CacheHelper.put("snapNo" + fileHash, serialNo, 300);
        if (list != null && list.length > 0) {
            DynamicObject obj = list[0];
            obj.set("serial_no", (Object)serialNo);
            obj.set("update_time", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            String snapshot_url = obj.getString("snapshot_url");
            if (!StringUtils.isEmpty((CharSequence)snapshot_url)) {
                result.put("snapshotUrl", obj.get("snapshot_url"));
                if (PDF.equals(obj.get("file_type"))) {
                    result.put("pdfUrl", obj.get("file_url"));
                } else if (OFD.equals(obj.get("file_type"))) {
                    result.put("ofdUrl", obj.get("file_url"));
                    result.put("pdfUrl", obj.get("pdf_url"));
                }
            }
        }
        return result;
    }
}

