/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task.handle;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleAttachDownService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleCoverDownService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleCreateImgService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleDownAndCreateImgService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleGenPdfService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleInvoiceDownService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleMultiTenantDownService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections.CollectionUtils;

public abstract class FileHandleService {
    private static final Log logger = LogFactory.getLog(FileHandleService.class);
    public static String DOWN_TYPE_ATT = "att";
    public static String DOWN_TYPE_COV = "cov";
    public static String DOWN_TYPE_GEN = "gen";
    public static String DOWN_TYPE_IMG = "img";
    public static String DOWN_TYPE_IMG2 = "img2";
    public static String DOWN_TYPE_DOWN = "down";
    public static String DOWN_TYPE_TENANT = "tenant";
    private static int max_time = 2;
    private static final String lockId = UUID.randomUUIDZero();

    public static FileHandleService newInstance(String type) {
        if (DOWN_TYPE_ATT.equals(type)) {
            return new FileHandleAttachDownService();
        }
        if (DOWN_TYPE_COV.equals(type)) {
            return new FileHandleCoverDownService();
        }
        if (DOWN_TYPE_GEN.equals(type)) {
            return new FileHandleGenPdfService();
        }
        if (DOWN_TYPE_IMG.equals(type)) {
            return new FileHandleCreateImgService();
        }
        if (DOWN_TYPE_IMG2.equals(type)) {
            return new FileHandleDownAndCreateImgService();
        }
        if (DOWN_TYPE_DOWN.equals(type)) {
            return new FileHandleInvoiceDownService();
        }
        if (DOWN_TYPE_TENANT.equals(type)) {
            return new FileHandleMultiTenantDownService();
        }
        return new FileHandleInvoiceDownService();
    }

    public static void operate(String fileId) {
        block18: {
            try (DLock idlock = DLock.create((String)("FileHandleService" + fileId));){
                DynamicObject object = FileHandleService.getFileDynamicObject(fileId);
                if (object == null || !idlock.tryLock()) break block18;
                int deal_times = object.getBigDecimal("deal_times").intValue();
                String serialNo = object.getString("serial_no");
                String downType = object.getString("down_type");
                FileHandleService service = FileHandleService.newInstance(downType);
                ++deal_times;
                boolean result = false;
                try {
                    result = service.doBusiness(object);
                }
                catch (Exception e) {
                    logger.error("\u6587\u4ef6\u5904\u7406\u5931\u8d25" + serialNo, (Throwable)e);
                    result = false;
                }
                object.set("update_time", (Object)new Date());
                object.set("deal_times", (Object)deal_times);
                if (result) {
                    logger.info("\u6587\u4ef6\u5904\u7406:{}-{}\u6210\u529f", (Object)fileId, (Object)serialNo);
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_file_aws"), (Object[])new Object[]{object.get("id")});
                    service.success(object);
                } else {
                    if (deal_times >= max_time) {
                        object.set("status", (Object)"2");
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                    if (deal_times >= max_time) {
                        service.fail(object);
                    }
                }
            }
        }
    }

    private static DynamicObject getFileDynamicObject(String fileId) {
        try {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)fileId, (String)"rim_invoice_file_aws");
            return object;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void startDownAwsFile(String number) {
        ThreadPools.executeOnce((String)("FileGenerate_downAws" + number), () -> {
            block21: {
                try (DLock lock = DLock.create((String)("downAws" + number + lockId));){
                    if (lock.tryLock()) {
                        int emptyTime = 0;
                        logger.info("\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u5f00\u59cb{}", (Object)number);
                        int count = 0;
                        while (count < 5000) {
                            DynamicObjectCollection pklist;
                            ++count;
                            QFilter filter1 = new QFilter("status", "=", (Object)"0");
                            QFilter filter2 = new QFilter("deal_times", "<", (Object)2);
                            QFilter filter3 = null;
                            if (!"0".equals(number)) {
                                filter3 = new QFilter("down_type", "!=", (Object)"gen");
                            }
                            if (!CollectionUtils.isEmpty((Collection)(pklist = QueryServiceHelper.query((String)"rim_invoice_file_aws", (String)"id,serial_no,down_type", (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"create_time", (int)200)))) {
                                emptyTime = 0;
                                for (DynamicObject object : pklist) {
                                    String stopFlag = CacheHelper.get("stop-downAwsFile");
                                    if (!StringUtils.isEmpty((CharSequence)stopFlag)) {
                                        logger.info("\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u505c\u6b62{}", (Object)number);
                                        return;
                                    }
                                    String down_type = object.getString("down_type");
                                    if ((DOWN_TYPE_GEN.equals(down_type) || DOWN_TYPE_IMG.equals(down_type)) && !"0".equals(number)) continue;
                                    FileHandleService.operate(object.getString("id"));
                                }
                                continue;
                            }
                            if (emptyTime > 0) break;
                            ++emptyTime;
                        }
                        logger.info("\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u7ed3\u675f{}", (Object)number);
                        break block21;
                    }
                    logger.info("\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u8fd0\u884c\u4e2d{}", (Object)number);
                }
            }
        });
    }

    public abstract void insert(String var1, JSONObject var2);

    public abstract boolean doBusiness(DynamicObject var1);

    public void success(DynamicObject object) {
    }

    public void fail(DynamicObject object) {
    }
}

