/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task.handle.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class FileHandleDownAndCreateImgService
extends FileHandleService {
    private static final Log logger = LogFactory.getLog(FileHandleDownAndCreateImgService.class);

    @Override
    public void insert(String fileId, JSONObject object) {
        QFilter filter1 = new QFilter("id", "=", (Object)fileId);
        QFilter filter2 = new QFilter("down_type", "=", (Object)DOWN_TYPE_IMG2);
        DeleteServiceHelper.delete((String)"rim_invoice_file_aws", (QFilter[])new QFilter[]{filter1, filter2});
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
        obj.set("id", (Object)fileId);
        obj.set("serial_no", (Object)fileId);
        obj.set("deal_times", (Object)0);
        obj.set("update_time", (Object)new Date());
        obj.set("status", (Object)"0");
        obj.set("create_time", (Object)new Date());
        String invoiceType = object.getString("invoiceType");
        String fileType = object.getString("fileType");
        obj.set("attachment_name", (Object)invoiceType);
        obj.set("download_url", (Object)object.getString("fileUrl"));
        if (("26".equals(invoiceType) || "27".equals(invoiceType)) && "1".equals(object.get((Object)"sim_down_file"))) {
            obj.set("snapshot_url", (Object)object.getString("snapshot_url"));
            if ("4".equals(fileType) && StringUtils.isNotBlank((CharSequence)object.getString("ofd_url"))) {
                obj.set("ofd_url", (Object)object.getString("ofd_url"));
            }
        }
        obj.set("file_type", (Object)fileType);
        obj.set("down_type", (Object)DOWN_TYPE_IMG2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    @Override
    public boolean doBusiness(DynamicObject object) {
        String download_url = object.getString("download_url");
        String invoiceTypeAws = object.getString("attachment_name");
        String xmlUrl = null;
        String pdfUrlElec = null;
        boolean electricFlag = false;
        boolean hasPdfElecFlag = false;
        if ("26".equals(invoiceTypeAws) || "27".equals(invoiceTypeAws)) {
            electricFlag = true;
            xmlUrl = object.getString("snapshot_url");
            pdfUrlElec = object.getString("ofd_url");
        }
        String serialNo = object.getString("serial_no");
        try {
            long orgId;
            String filePath = download_url;
            byte[] fileContent = null;
            String fileType = null;
            if (StringUtils.isNotEmpty((CharSequence)download_url) && download_url.startsWith("http")) {
                boolean proxy = download_url.indexOf("piaozone") > 0;
                JSONObject fileInfo = FileUtils.downLoadAndUploadWithFileType(download_url, null);
                fileType = StringUtils.isEmpty((CharSequence)fileInfo.getString("file_type")) ? object.getString("file_type") : fileInfo.getString("file_type");
                filePath = fileInfo.getString("file_url");
                if (StringUtils.isEmpty((CharSequence)filePath)) {
                    logger.info("\u9500\u9879\u53d1\u7968\u6587\u4ef6\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25{}-{}", (Object)serialNo, (Object)filePath);
                    return false;
                }
                fileContent = this.getContent(filePath);
            } else {
                filePath = download_url;
                fileContent = this.getContent(filePath);
                if (!this.exists(fileContent)) {
                    fileContent = null;
                }
                if (fileContent == null) {
                    String downPath = this.downIsmcFile(filePath);
                    if (downPath != null) {
                        filePath = downPath;
                        fileContent = this.getContent(downPath);
                    } else {
                        logger.info("\u9500\u9879\u53d1\u7968\u6587\u4ef6\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25{}-{}", (Object)serialNo, (Object)filePath);
                        return true;
                    }
                }
            }
            if (electricFlag) {
                xmlUrl = this.getDownloadUrlElec(xmlUrl, serialNo);
                pdfUrlElec = this.getDownloadUrlElec(pdfUrlElec, serialNo);
            }
            String imageUrl = null;
            String pdfUrl = null;
            String originalType = null;
            logger.info("FileHandleDownAndCreateImgService filePath: {},{}", (Object)filePath, (Object)fileType);
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                if (StringUtils.isEmpty((CharSequence)fileType)) {
                    fileType = FileUtils.getFileType(filePath);
                }
                logger.info("fileType: {}", (Object)fileType);
                String path = FileUploadUtils.getSnapshotPathByUploadUrl(download_url);
                logger.info("path: {}", (Object)path);
                try {
                    if ("pdf".equalsIgnoreCase(fileType)) {
                        originalType = "1";
                        imageUrl = FileConvertUtils.pdf2imageAndUpload((byte[])fileContent, (String)(serialNo + ".jpg"), (String)(path + ".jpg"));
                    } else if ("ofd".equalsIgnoreCase(fileType)) {
                        originalType = "4";
                        imageUrl = FileConvertUtils.ofd2image((byte[])fileContent, (int)0, (String)(serialNo + ".jpg"), (String)(path + ".jpg"));
                        if (StringUtils.isNotEmpty((CharSequence)imageUrl)) {
                            if (electricFlag) {
                                if (StringUtils.isNotBlank((CharSequence)pdfUrlElec)) {
                                    pdfUrl = pdfUrlElec;
                                    hasPdfElecFlag = true;
                                } else {
                                    pdfUrl = FileConvertUtils.ofd2pdf((byte[])fileContent, (String)(serialNo + ".pdf"), (String)(path + ".pdf"));
                                }
                            } else {
                                pdfUrl = FileConvertUtils.ofd2pdf((byte[])fileContent, (String)(serialNo + ".pdf"), (String)(path + ".pdf"));
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    logger.info("FileHandleDownAndCreateImgService Throwable: {}", (Object)t);
                }
            }
            if (StringUtils.isEmpty(imageUrl)) {
                logger.info("\u9500\u9879\u53d1\u7968\u6587\u4ef6\u751f\u6210\u5feb\u7167\u5931\u8d25{}-{}", (Object)serialNo, (Object)filePath);
                return false;
            }
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id,original_state,snapshot_url", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
            boolean genFlag = false;
            if (fileIdDynamicObject == null) {
                fileIdDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
                fileIdDynamicObject.set("tenant_no", (Object)tenantNo);
                fileIdDynamicObject.set("serial_no", (Object)serialNo);
                fileIdDynamicObject.set("create_time", (Object)new Date());
                fileIdDynamicObject.set("update_time", (Object)new Date());
            } else {
                fileIdDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileIdDynamicObject.get("id"), (String)"rim_invoice_file");
                fileIdDynamicObject.set("update_time", (Object)new Date());
                genFlag = "2".equals(fileIdDynamicObject.getString("original_state"));
            }
            DynamicObject mainObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id, invoice_type", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
            String originalStateElectric = "0";
            Long invoiceType = 0L;
            if (mainObject != null) {
                invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.getLong("invoice_type"));
                mainObject = BusinessDataServiceHelper.loadSingle((Object)mainObject.get("id"), (String)"rim_invoice");
                originalStateElectric = mainObject.getString("original_state");
            }
            fileIdDynamicObject.set("original_type", (Object)originalType);
            if (electricFlag) {
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(imageUrl, fileIdDynamicObject, "snapshot_url", genFlag);
                    this.setElecPersonFile(imageUrl, fileIdDynamicObject, "image_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("snapshot_url", (Object)imageUrl);
                fileIdDynamicObject.set("image_url", (Object)imageUrl);
            }
            if (electricFlag && StringUtils.isNotBlank((CharSequence)xmlUrl)) {
                fileIdDynamicObject.set("tax_xml_url", (Object)xmlUrl);
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(xmlUrl, fileIdDynamicObject, "xml_url", genFlag);
                }
            }
            if ("4".equals(originalType)) {
                if (electricFlag) {
                    fileIdDynamicObject.set("tax_ofd_url", (Object)filePath);
                    if (StringUtils.isNotBlank((CharSequence)pdfUrl) && hasPdfElecFlag) {
                        fileIdDynamicObject.set("tax_pdf_url", (Object)pdfUrl);
                    }
                    if ("0".equals(originalStateElectric)) {
                        this.setElecPersonFile(filePath, fileIdDynamicObject, "ofd_url", genFlag);
                        this.setElecPersonFile(pdfUrl, fileIdDynamicObject, "pdf_url", genFlag);
                    }
                } else {
                    fileIdDynamicObject.set("ofd_url", (Object)filePath);
                    fileIdDynamicObject.set("pdf_url", (Object)pdfUrl);
                }
            } else if (electricFlag) {
                fileIdDynamicObject.set("tax_pdf_url", (Object)filePath);
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(filePath, fileIdDynamicObject, "pdf_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("pdf_url", (Object)filePath);
            }
            String needSign = "0";
            if (!"1".equals(originalStateElectric) && electricFlag && mainObject != null && (orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("org"))) > 0L) {
                needSign = SysParamUtil.getSysParamByOrgId(orgId, "tax_file_auto_sign") ? "1" : "0";
            }
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileIdDynamicObject});
                    if ("1".equals(needSign)) {
                        mainObject.set("original_state", (Object)"1");
                        mainObject.set("original_time", (Object)new Date());
                        mainObject.set("modifytime", (Object)new Date());
                        InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceType.toString());
                        if (service != null) {
                            service.setMainInvoiceInfo(mainObject);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject});
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("\u4fdd\u5b58\u53d1\u7968\u6587\u4ef6\u62a5\u9519", e);
                    h.markRollback();
                    throw e;
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u5feb\u7167\u5931\u8d25:" + serialNo, (Throwable)e);
            return false;
        }
    }

    private String getDownloadUrlElec(String fileUrl, String serialNo) {
        if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
            byte[] fileContentElec = null;
            if (StringUtils.isNotEmpty((CharSequence)fileUrl) && fileUrl.startsWith("http")) {
                JSONObject fileInfo = FileUtils.downLoadAndUploadWithFileType(fileUrl, null);
                if (StringUtils.isEmpty((CharSequence)(fileUrl = fileInfo.getString("file_url")))) {
                    logger.info("\u9500\u9879\u53d1\u7968\u6587\u4ef6xmlUrl\u6216pdf\u6587\u4ef6\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25{}-{}", (Object)serialNo, (Object)fileUrl);
                }
            } else {
                fileContentElec = this.getContent(fileUrl);
                if (!this.exists(fileContentElec)) {
                    fileContentElec = null;
                }
                if (fileContentElec == null) {
                    String downPath = this.downIsmcFile(fileUrl);
                    if (downPath != null) {
                        fileUrl = downPath;
                    } else {
                        logger.info("\u9500\u9879\u53d1\u7968\u6587\u4ef6\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25{}-{}", (Object)serialNo, (Object)fileUrl);
                    }
                }
            }
            return fileUrl;
        }
        return null;
    }

    private void setElecPersonFile(String filePath, DynamicObject fileIdDynamicObject, String propertyName, boolean genFlag) {
        if ((StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString(propertyName)) || genFlag) && StringUtils.isNotBlank((CharSequence)filePath)) {
            fileIdDynamicObject.set(propertyName, (Object)filePath);
        }
    }

    private boolean exists(byte[] fileContent) {
        if (fileContent != null && fileContent.length < 100) {
            String str = new String(fileContent);
            return str.indexOf("not exist.") < 0;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getContent(String filePath) {
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(filePath));){
            byte[] fileContent;
            byte[] byArray = fileContent = FileUtils.getByte(fileInputStream);
            return byArray;
        }
        catch (IOException e) {
            logger.info("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25{}", (Object)filePath);
            return null;
        }
    }

    @Override
    public void success(DynamicObject object) {
        try {
            String serialNo = object.getString("serial_no");
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id,original_state,pdf_url,image_url,snapshot_url", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
            if (fileIdDynamicObject == null) {
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_GEN);
                JSONObject json = new JSONObject();
                json.put("invoiceType", (Object)object.getString("attachment_name"));
                service.insert(serialNo, json);
            }
        }
        catch (Exception e) {
            logger.info("\u751f\u6210\u5730\u5740\u6570\u636e\u5931\u8d25");
        }
    }

    public String downIsmcFile(String url) {
        try {
            JSONObject ismcConfig = this.getIsmcConfig();
            if (ismcConfig.isEmpty()) {
                return null;
            }
            String token = this.login(ismcConfig.getString("url"), ismcConfig.getString("appid"), ismcConfig.getString("appsecuret"), ismcConfig.getString("accountid"), ismcConfig.getString("user"), "UserName");
            if (token == null) {
                return null;
            }
            String fileUrl = ismcConfig.getString("url") + "/attachment/download.do?path=" + url;
            String downUrl = null;
            try {
                downUrl = FileHandleDownAndCreateImgService.encryptAcessToken(fileUrl, token);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            String urlFileType = FileUtils.getFileType(url);
            String fileName = null;
            if ("pdf".equals(urlFileType) || "ofd".equals(urlFileType) || FileUtils.isImage(urlFileType)) {
                fileName = MD5.md5Hex(url) + '.' + urlFileType;
            }
            return FileUtils.downLoadAndUpload(downUrl, fileName, false);
        }
        catch (Exception e) {
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static String encryptAcessToken(String url, String accessToken) throws UnsupportedEncodingException {
        String value = accessToken + "~~" + System.currentTimeMillis();
        Base64.Encoder encoder = Base64.getEncoder();
        String encodeValue = encoder.encodeToString(value.getBytes("UTF-8"));
        String flag = "&";
        if (url != null && url.indexOf("?") == -1) {
            flag = "?";
        }
        return url + flag + "kdedcba=" + URLEncoder.encode(encodeValue, "UTF-8");
    }

    private JSONObject getIsmcConfig() {
        String configType = "bdm_ismc_config";
        QFilter filter = new QFilter("config_type", "=", (Object)"bdm_ismc_config");
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_type,config_key,config_value", (QFilter[])new QFilter[]{filter});
        JSONObject ismcConfig = new JSONObject();
        if (collection != null && collection.length > 0) {
            String typeStr = configType + '_';
            for (DynamicObject obj : collection) {
                String key = obj.getString("config_key");
                String val = obj.getString("config_value");
                ismcConfig.put(key.replace(typeStr, ""), (Object)val);
            }
        }
        return ismcConfig;
    }

    public String login(String baseUrl, String appId, String appSecuret, String accountId, String user, String userType) {
        if (StringUtils.isEmpty((CharSequence)baseUrl) || StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)appSecuret) || StringUtils.isEmpty((CharSequence)user)) {
            return null;
        }
        String app_token = this.getAppToken(baseUrl, appId, appSecuret, accountId);
        JSONObject params = new JSONObject();
        params.put("user", (Object)user);
        params.put("usertype", (Object)userType);
        params.put("apptoken", (Object)app_token);
        params.put("accountId", (Object)accountId);
        try {
            String data = HttpClientUtils.postjson((String)(baseUrl + "/api/login.do"), null, (String)params.toJSONString());
            JSONObject json = JSONObject.parseObject((String)data);
            if ("success".equals(json.getString("state"))) {
                JSONObject respData = json.getJSONObject("data");
                return respData.getString("access_token");
            }
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u767b\u5f55\u8fd0\u8425\u5e73\u53f0\u5931\u8d25\uff1a%1$s", (String)"FileHandleDownAndCreateImgService_0", (String)"imc-rim-common", (Object[])new Object[0]), json.getString("errorMsg")));
        }
        catch (IOException e) {
            throw new MsgException(e, ResManager.loadKDString((String)"\u767b\u5f55\u8fd0\u8425\u5e73\u53f0\u5f02\u5e38", (String)"FileHandleDownAndCreateImgService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    private String getAppToken(String baseUrl, String appId, String appSecuret, String accountId) {
        JSONObject map = new JSONObject();
        map.put("appId", (Object)appId);
        map.put("appSecuret", (Object)appSecuret);
        map.put("accountId", (Object)accountId);
        try {
            String data = HttpClientUtils.postjson((String)(baseUrl + "/api/getAppToken.do"), null, (String)map.toJSONString());
            if (StringUtils.isBlank((CharSequence)data)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u7a0e\u63a7\u4e91AppToken\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"FileHandleDownAndCreateImgService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            JSONObject json = JSON.parseObject((String)data);
            if ("success".equals(json.getString("state"))) {
                JSONObject respData = json.getJSONObject("data");
                return respData.getString("app_token");
            }
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8fd0\u8425\u5e73\u53f0app_token\u5931\u8d25\uff1a%s", (String)"FileHandleDownAndCreateImgService_3", (String)"imc-rim-common", (Object[])new Object[0]), json.getString("errorMsg")));
        }
        catch (Exception e) {
            throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8fd0\u8425\u5e73\u53f0app_token\u5f02\u5e38:%s", (String)"FileHandleDownAndCreateImgService_4", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

