/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.InputInvoiceConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.SpecialTypeMarkEnum;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.service.InvoiceSaveEkService;
import kd.imc.rim.common.expense.service.ExpenseCallBackService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.recognitionnew.task.FileSaveTask;
import kd.imc.rim.common.invoice.recognitionnew.task.SnapshotService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.impl.AirEleSaveService;
import kd.imc.rim.common.invoice.save.impl.AirSaveService;
import kd.imc.rim.common.invoice.save.impl.CustomSaveService;
import kd.imc.rim.common.invoice.save.impl.ElectricSaveService;
import kd.imc.rim.common.invoice.save.impl.FinancialSaveService;
import kd.imc.rim.common.invoice.save.impl.GeneralSaveService;
import kd.imc.rim.common.invoice.save.impl.InvoiceHisSaveService;
import kd.imc.rim.common.invoice.save.impl.MotorSaveService;
import kd.imc.rim.common.invoice.save.impl.OrdinarySaveService;
import kd.imc.rim.common.invoice.save.impl.OtherSaveService;
import kd.imc.rim.common.invoice.save.impl.OverSeaSaveService;
import kd.imc.rim.common.invoice.save.impl.QuotaSaveService;
import kd.imc.rim.common.invoice.save.impl.SpecialSaveService;
import kd.imc.rim.common.invoice.save.impl.TaxProofSaveService;
import kd.imc.rim.common.invoice.save.impl.TaxiSaveService;
import kd.imc.rim.common.invoice.save.impl.TollSaveService;
import kd.imc.rim.common.invoice.save.impl.TrainEleSaveService;
import kd.imc.rim.common.invoice.save.impl.TrainRefundSaveService;
import kd.imc.rim.common.invoice.save.impl.TrainSaveService;
import kd.imc.rim.common.invoice.save.impl.TransportSaveService;
import kd.imc.rim.common.invoice.save.impl.UserCarSaveService;
import kd.imc.rim.common.invoice.save.impl.WithHoldSaveService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.file.model.FileConvertResult;
import kd.imc.rim.file.service.PdfHandleService;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceSaveService {
    private static Log logger = LogFactory.getLog(InvoiceSaveService.class);
    protected Long invoiceType;
    private Long newOrgId;
    private String calculateDeductionFlag;
    private static BigDecimal maxAmount = new BigDecimal("9999999999999.9999999999");

    public static InvoiceSaveService newInstance(String invoiceType) {
        InvoiceSaveService saveService = null;
        Long type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
        if (type == null || type == 0L) {
            return null;
        }
        if (InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(type) || InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(type) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(type)) {
            saveService = new OrdinarySaveService();
        } else if (InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(type) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(type)) {
            saveService = new SpecialSaveService();
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(type)) {
            saveService = new AirSaveService();
        } else if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(type)) {
            saveService = new TollSaveService();
        } else if (InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(type) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(type) || InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(type)) {
            saveService = new GeneralSaveService();
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(type)) {
            saveService = new TrainSaveService();
        } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(type) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(type)) {
            saveService = new TransportSaveService();
        } else if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(type)) {
            saveService = new TaxiSaveService();
        } else if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(type)) {
            saveService = new QuotaSaveService();
        } else if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(type)) {
            saveService = new TaxProofSaveService();
        } else if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(type)) {
            saveService = new OtherSaveService();
        } else if (InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(type)) {
            saveService = new MotorSaveService();
        } else if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(type)) {
            saveService = new UserCarSaveService();
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(type)) {
            saveService = new CustomSaveService();
        } else if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(type)) {
            saveService = new TrainRefundSaveService();
        } else if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(type)) {
            saveService = new FinancialSaveService();
        } else if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(type) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(type)) {
            saveService = new ElectricSaveService();
        } else if (InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(type)) {
            saveService = new OverSeaSaveService();
        } else if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(type)) {
            saveService = new AirEleSaveService();
        } else if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(type)) {
            saveService = new TrainEleSaveService();
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(type)) {
            saveService = new WithHoldSaveService();
        }
        if (saveService != null) {
            saveService.setInvoiceType(type);
        }
        return saveService;
    }

    public InvoiceSaveResult save(JSONObject invoiceJson) {
        String lockKey = this.getLockKey(invoiceJson);
        if (!StringUtils.isEmpty((CharSequence)lockKey)) {
            Throwable throwable = null;
            try (DLock lock = DLock.create((String)("rim.invoiceSave" + lockKey), (String)"saveInvoice");){
                if (lock.tryLock(100L)) {
                    InvoiceSaveResult invoiceSaveResult = this.saveInvoice(invoiceJson);
                    return invoiceSaveResult;
                }
                try {
                    throw new MsgException(ErrorType.REPEAT_SAVE_INVOICE.getCode(), ErrorType.REPEAT_SAVE_INVOICE.getName());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return this.saveInvoice(invoiceJson);
    }

    private InvoiceSaveResult saveInvoice(JSONObject invoiceJson) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            boolean synConvert;
            boolean expenseStatusCheck;
            long start = System.currentTimeMillis();
            InvoiceSaveService.setDefaultValue(invoiceJson);
            this.toEmptyAll0BuyerTaxNo(invoiceJson);
            InvoiceSaveService.setReplaceOrgFlag(invoiceJson);
            if (!"1".equals(invoiceJson.getString("isSaleListInvoice"))) {
                invoiceJson.put("salelistComplete", (Object)"1");
            }
            if ("2".equals(invoiceJson.getString("delete"))) {
                invoiceJson.put("forbid_save", (Object)"1");
            }
            String awsSerialNo = invoiceJson.getString("serialNo");
            logger.info("\u67e5\u9a8c\u56de\u6765\u7684serialno\uff1a{}", (Object)awsSerialNo);
            InvoiceSaveResult result = new InvoiceSaveResult();
            DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
            DynamicObject mainObject = this.getMainDynamicObject(invoiceObject, invoiceJson);
            String expenseStatus = mainObject.getString("expense_status");
            boolean checkType = InputInvoiceTypeEnum.needCheck(this.invoiceType);
            boolean bl = expenseStatusCheck = "60".equals(expenseStatus) || "65".equals(expenseStatus);
            if (!checkType && expenseStatusCheck) {
                InvoiceSaveResult invoiceSaveResult = this.dbResult(mainObject, invoiceJson, false);
                return invoiceSaveResult;
            }
            this.setInvoiceFieldValue(invoiceJson, invoiceObject);
            this.setDeductionFieldValue(this.invoiceType, invoiceObject, invoiceJson);
            this.setDiscountInfo(this.invoiceType, invoiceJson, mainObject);
            Boolean newFlag = this.checkIdIsNull(mainObject.getPkValue());
            if (newFlag.booleanValue()) {
                invoiceObject.set("createtime", (Object)InvoiceSaveService.getDate(invoiceJson, "billCreateTime1"));
            }
            this.setMainFieldValue(invoiceJson, mainObject);
            DeductionConstant.searchBlacklist(mainObject.getString("saler_tax_no"));
            this.setDeductionFieldValue(this.invoiceType, mainObject, invoiceJson);
            String expense_status = mainObject.getString("expense_status");
            invoiceJson.put("expenseStatus", (Object)expense_status);
            invoiceJson.put("transportDeduction", (Object)mainObject.getString("transport_deduction"));
            invoiceJson.put("ext_info", (Object)mainObject.getString("ext_info"));
            this.setPersonInvoiceDeductionFlag(mainObject);
            this.setDeductionFlag(invoiceJson, mainObject);
            this.setDeductionFlag(invoiceJson, invoiceObject);
            InvoiceSaveService.setSerialNo(mainObject, invoiceObject);
            String snapshotUrl = invoiceJson.getString("snapshotUrl");
            String serial_no = invoiceObject.getString("serial_no");
            boolean startDown = false;
            boolean createGen = false;
            String xmlUrl = invoiceJson.getString("xmlUrl");
            String serialNo = invoiceObject.getString("serial_no");
            if (StringUtils.isBlank((CharSequence)serialNo)) {
                serialNo = UUID.randomUUIDZero();
                invoiceObject.set("invoice_no", (Object)serialNo);
                mainObject.set("invoice_no", (Object)serialNo);
            }
            if (StringUtils.isEmpty((CharSequence)snapshotUrl)) {
                createGen = true;
            }
            if (synConvert = this.synConvert(invoiceJson, serialNo)) {
                createGen = false;
            }
            if (!synConvert && (StringUtils.isNotEmpty((CharSequence)snapshotUrl) || StringUtils.isNotEmpty((CharSequence)xmlUrl))) {
                if (snapshotUrl.startsWith("http")) {
                    FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_DOWN);
                    service.insert(serial_no, invoiceJson);
                    startDown = true;
                } else {
                    FileSaveTask fileSaveTask = new FileSaveTask(RequestContext.get(), serial_no, invoiceJson);
                    fileSaveTask.call();
                }
            }
            if ("0".equals(invoiceJson.getString("generatePdf"))) {
                createGen = false;
            }
            if (invoiceJson.containsKey((Object)"isZipFile") || createGen) {
                Map<String, Object> stringObjectMap = DynamicObjectUtil.dynamicObjectToMap(invoiceObject);
                InvoiceConvertService convertService = InvoiceConvertService.newInstance(this.invoiceType);
                JSONObject generateInfo = convertService.convert(stringObjectMap);
                generateInfo.put("checkStatus", (Object)invoiceJson.getString("checkStatus"));
                logger.info("\u5e95\u8d26generateInfo:{}", (Object)generateInfo);
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_GEN);
                service.insert(serial_no, generateInfo);
                startDown = true;
            }
            this.setCustomFieldValue(invoiceJson, mainObject, invoiceObject);
            this.setDownAgricData(this.invoiceType, mainObject, invoiceJson);
            this.setDownAgricData(this.invoiceType, invoiceObject, invoiceJson);
            this.setAgricData(mainObject, invoiceObject, invoiceJson);
            InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
            ekService.beforeSave(mainObject, invoiceObject, invoiceJson);
            InvoiceCheckUtils.enIDNum(invoiceObject);
            InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_FILETYPE_NOW, FileUtils.getFileType(invoiceJson.getString("fileName")));
            if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType)) {
                InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_EINVOICE_COMPARE_RESULT, invoiceJson.getString("compareResult"));
            }
            this.setDiscountInfo(this.invoiceType, invoiceJson, invoiceObject);
            this.setMainInvoiceInfo(mainObject);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject});
            this.clearUncheckInvoice(mainObject);
            this.updateInvoiceStatusByRedRemark(this.invoiceType, mainObject, invoiceJson);
            String resource = invoiceJson.getString("resource");
            String originalState = mainObject.getString("original_state");
            String prevOriginalState = "0";
            try {
                JSONObject extInfo = invoiceJson.getJSONObject("ext_info");
                prevOriginalState = extInfo.getString("prevOriginalState");
            }
            catch (Exception extInfo) {
                // empty catch block
            }
            if ("1".equals(originalState) || "1".equals(prevOriginalState)) {
                ExpenseCallBackService.signInvoice(serialNo, "1");
            }
            result.setNewFlag(newFlag);
            result.setInvoiceEntity(invoiceObject.getDynamicObjectType().getName());
            result.setInvoiceType(this.invoiceType);
            result.setSerialNo(serialNo);
            result.setAwsSerialNo(awsSerialNo);
            result.setInvoiceId(invoiceObject.get("id"));
            result.setMainId(mainObject.get("id"));
            result.setTenantNo(invoiceObject.getString("tenant_no"));
            result.setInvoiceInfo(mainObject.getString("invoice_info"));
            ekService.afterSave(result);
            logger.info(invoiceJson.getString("fileName") + "\u7b2c" + invoiceJson.getString("fileIndex") + "\u9875\uff0cInvoiceSaveService.save\u7edf\u8ba1\u4fe1\u606f:" + result.getSerialNo() + ",\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            JSONObject logInfo = new JSONObject();
            logInfo.put("mainId", result.getMainId());
            logInfo.put("invId", result.getInvoiceId());
            logInfo.put("trace", (Object)RequestContext.get().getTraceId());
            logInfo.put("authenticateFlag", (Object)invoiceJson.getString("authenticateFlag"));
            logInfo.put("invoiceStatus", (Object)invoiceJson.getString("invoiceStatus"));
            logInfo.put("allowDeduction", (Object)invoiceJson.getString("allowDeduction"));
            logInfo.put("deductionFlag", (Object)mainObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            logInfo.put("currAuthenticateFlag", (Object)mainObject.getString("authenticate_flag"));
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("org"));
            InvoiceLog.insert("save", serialNo, logInfo.toJSONString(), orgId, resource, invoiceJson.getString("collect_type"));
            if (startDown) {
                FileHandleService.startDownAwsFile("0");
            }
            InvoiceSaveResult invoiceSaveResult = result;
            return invoiceSaveResult;
        }
        catch (Throwable e) {
            try {
                logger.error("\u53d1\u7968\u4fdd\u5b58\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void updateInvoiceStatusByRedRemark(Long invoiceType, DynamicObject mainObject, JSONObject invoiceJson) {
        String remark = mainObject.getString("remark");
        BigDecimal totalAmount = mainObject.getBigDecimal("total_amount");
        if (totalAmount.compareTo(BigDecimal.ZERO) >= 0) {
            return;
        }
        if (Arrays.asList(InputInvoiceTypeEnum.getRedInvoiceType()).contains(invoiceType)) {
            String invoiceCode = invoiceJson.getString("originalInvoiceCode");
            String invoiceNo = invoiceJson.getString("originalInvoiceNo");
            if (StringUtils.isNotEmpty((CharSequence)remark)) {
                remark = remark.replaceAll("\uff1a", ":");
                if (StringUtils.isEmpty((CharSequence)invoiceNo)) {
                    invoiceNo = InvoiceConvertUtils.extractRemarkInvoiceCodeAndNo(remark, "\u53f7\u7801");
                }
                if (StringUtils.isEmpty((CharSequence)invoiceCode)) {
                    invoiceCode = InvoiceConvertUtils.extractRemarkInvoiceCodeAndNo(remark, "\u53d1\u7968\u4ee3\u7801");
                }
            }
            logger.info("\u7ea2\u5b57\u53d1\u7968\u66f4\u65b0\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u53d1\u7968\u72b6\u6001-\u83b7\u53d6\u7684\u4ee3\u7801\uff0c\u53f7\u7801:{},{}", (Object)invoiceCode, (Object)invoiceNo);
            if (StringUtils.isEmpty((CharSequence)invoiceNo)) {
                return;
            }
            try {
                DynamicObject[] invoiceInfos;
                DynamicObject invoice = null;
                QFilter noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
                QFilter codeFilter = null;
                if (invoiceNo.length() != 20) {
                    if (StringUtils.isEmpty((CharSequence)invoiceCode)) {
                        return;
                    }
                    codeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
                }
                if ((invoiceInfos = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"invoice_type, total_amount, invoice_status, invoice_info", (QFilter[])new QFilter[]{noFilter, codeFilter})).length == 0) {
                    return;
                }
                DynamicObject mainInvoice = invoiceInfos[0];
                String invoiceStatus = mainInvoice.getString("invoice_status");
                if ("8".equals(invoiceStatus)) {
                    return;
                }
                DynamicObject redBlueRelation = this.getRedBlueRelationDynamic(invoiceCode, invoiceNo, invoiceJson);
                redBlueRelation.set("red_total_amount", (Object)totalAmount);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{redBlueRelation});
                Long blueInvoiceType = mainInvoice.getDynamicObject("invoice_type").getLong("id");
                String entityName = InputInvoiceTypeEnum.getEntity(blueInvoiceType);
                DynamicObject[] entityObj = BusinessDataServiceHelper.load((String)entityName, (String)"total_amount, invoice_status", (QFilter[])new QFilter[]{noFilter, codeFilter});
                if (entityObj.length > 0) {
                    invoice = entityObj[0];
                }
                BigDecimal blueTotalAmount = mainInvoice.getBigDecimal("total_amount");
                String invoiceInfo = mainInvoice.getString("invoice_info");
                if (blueTotalAmount.add(totalAmount).compareTo(BigDecimal.ZERO) <= 0) {
                    invoiceStatus = "8";
                } else if (blueTotalAmount.add(totalAmount).compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal redTotalAmountSum;
                    DynamicObjectCollection relations;
                    invoiceStatus = "7";
                    QFilter blueInvoiceNo = new QFilter("blue_invoice_no", "=", (Object)invoiceNo);
                    QFilter blueInvoiceCode = null;
                    if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() != 20) {
                        blueInvoiceCode = new QFilter("blue_invoice_code", "=", (Object)invoiceCode);
                    }
                    if ((relations = QueryServiceHelper.query((String)"rim_redblue_relation", (String)"red_total_amount", (QFilter[])new QFilter[]{blueInvoiceNo, blueInvoiceCode})).size() > 0 && (redTotalAmountSum = relations.stream().map(m -> m.getBigDecimal("red_total_amount")).reduce(BigDecimal.ZERO, BigDecimal::add)).add(blueTotalAmount).compareTo(BigDecimal.ZERO) <= 0) {
                        invoiceStatus = "8";
                    }
                }
                mainInvoice.set("invoice_status", (Object)invoiceStatus);
                mainInvoice.set("invoice_info", (Object)this.setInvoiceStatusIcon(invoiceInfo, invoiceStatus));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainInvoice});
                if (invoice != null) {
                    invoice.set("invoice_status", (Object)invoiceStatus);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
                }
            }
            catch (Exception e) {
                logger.info("\u7ea2\u5b57\u53d1\u7968\u66f4\u65b0\u5bf9\u5e94\u84dd\u5b57\u53d1\u7968\u53d1\u7968\u72b6\u6001\u5931\u8d25", (Object)e);
            }
        }
    }

    private DynamicObject getRedBlueRelationDynamic(String blueInvoiceCode, String blueInvoiceNo, JSONObject invoiceJson) {
        String redInvoiceCode = invoiceJson.getString("invoiceCode");
        String redInvoiceNo = invoiceJson.getString("invoiceNo");
        QFilter blueCodeFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)blueInvoiceNo) && blueInvoiceNo.length() != 20) {
            blueCodeFilter = new QFilter("blue_invoice_code", "=", (Object)blueInvoiceCode);
        }
        QFilter redCodeFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)redInvoiceNo) && redInvoiceNo.length() != 20) {
            redCodeFilter = new QFilter("red_invoice_code", "=", (Object)redInvoiceCode);
        }
        QFilter blueNoFilter = new QFilter("blue_invoice_no", "=", (Object)blueInvoiceNo);
        QFilter redNoFilter = new QFilter("red_invoice_no", "=", (Object)redInvoiceNo);
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"rim_redblue_relation", (String)MetadataUtil.getFields("rim_redblue_relation"), (QFilter[])new QFilter[]{blueCodeFilter, blueNoFilter, redCodeFilter, redNoFilter});
        if (relations.length > 0) {
            return relations[0];
        }
        DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)"rim_redblue_relation");
        relation.set("blue_invoice_code", (Object)blueInvoiceCode);
        relation.set("blue_invoice_no", (Object)blueInvoiceNo);
        relation.set("red_invoice_code", (Object)redInvoiceCode);
        relation.set("red_invoice_no", (Object)redInvoiceNo);
        return relation;
    }

    private String setInvoiceStatusIcon(String invoiceInfo, String invoiceStatus) {
        StringBuilder infoString = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)invoiceInfo)) {
            String[] info;
            for (String str : info = invoiceInfo.split(",")) {
                if (StringUtils.isEmpty((CharSequence)str)) continue;
                if (str.contains("st_")) {
                    str = "st_" + invoiceStatus;
                }
                infoString.append(str).append(',');
            }
        }
        return infoString.toString();
    }

    private void setPersonInvoiceDeductionFlag(DynamicObject mainObject) {
        boolean isCompanyTaxNo;
        if (!(!InputInvoiceTypeEnum.needCheck(this.invoiceType).booleanValue() || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(this.invoiceType) || (isCompanyTaxNo = VerifyUtil.isComapnyTaxNo(mainObject.getString("buyer_tax_no"))))) {
            this.calculateDeductionFlag = "0";
        }
    }

    private void setDiscountInfo(Long invoiceType, JSONObject invoiceJson, DynamicObject mainObject) {
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            String businessType = invoiceJson.getString("businessType");
            mainObject.set("invoice_status", (Object)"0");
            if ("\u552e".equals(businessType)) {
                mainObject.set("deduction_flag", (Object)"1");
                BigDecimal taxAmount = invoiceJson.getBigDecimal("taxAmount");
                mainObject.set("effective_tax_amount", (Object)taxAmount);
            }
            if ("\u9000".equals(businessType)) {
                mainObject.set("deduction_flag", (Object)"0");
            }
        }
    }

    public InvoiceSaveResult saveUncheckInvoice(JSONObject invoiceJson, String recource) {
        String lockKey = this.getLockKey(invoiceJson);
        if (!StringUtils.isEmpty((CharSequence)lockKey)) {
            Throwable throwable = null;
            try (DLock lock = DLock.create((String)("rim.invoiceSave" + lockKey), (String)"saveInvoice");){
                if (lock.tryLock(100L)) {
                    InvoiceSaveResult invoiceSaveResult = this.saveUncheckInvoiceNew(invoiceJson, recource);
                    return invoiceSaveResult;
                }
                try {
                    logger.info("\u540c\u4e00\u53d1\u7968\u4e0d\u80fd\u5e76\u53d1\u5165\u5e93{}", (Object)lockKey);
                    throw new MsgException(ErrorType.REPEAT_SAVE_INVOICE.getCode(), ErrorType.REPEAT_SAVE_INVOICE.getName());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return this.saveUncheckInvoiceNew(invoiceJson, recource);
    }

    private InvoiceSaveResult saveUncheckInvoiceNew(JSONObject invoiceJson, String recource) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            logger.info("\u53d1\u7968save\u7684saveUncheckInvoice\uff1a" + invoiceJson);
            long start = System.currentTimeMillis();
            InvoiceSaveService.setReplaceOrgFlag(invoiceJson);
            InvoiceSaveResult saveResult = new InvoiceSaveResult();
            String tenantNo = TenantUtils.getTenantNo();
            if ("2".equals(invoiceJson.getString("delete"))) {
                invoiceJson.put("forbid_save", (Object)"1");
            }
            Long orgId = this.getOrgId(invoiceJson);
            String userId = InvoiceSaveService.getOperateUser(invoiceJson);
            String serialNo = UUID.randomUUIDZero();
            boolean newFlag = false;
            String invoiceCode = invoiceJson.getString("invoiceCode");
            String invoiceNo = invoiceJson.getString("invoiceNo");
            String awsType = invoiceJson.getString("invoiceType");
            this.invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsType);
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter typeFilter = new QFilter("invoice_type", "=", (Object)this.invoiceType);
            QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode));
            if (InputInvoiceTypeEnum.isEleInvoice(this.invoiceType).booleanValue()) {
                invoiceCodeFilter = null;
                typeFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode(), InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode(), InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode()});
            }
            QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, typeFilter}, null, (int)100);
            String checkDescription = CheckContant.getCheckResultDesc(invoiceJson.getString("errcode"));
            if (StringUtils.isEmpty((CharSequence)checkDescription) && StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("description"))) {
                checkDescription = invoiceJson.getString("description");
            }
            String checkResult = "[" + StringUtils.trimToEmpty((String)invoiceJson.getString("errcode")) + "]" + checkDescription;
            String file_name = invoiceJson.getString("fileName");
            if (StringUtils.isNotEmpty((CharSequence)file_name) && file_name.length() > 50) {
                file_name = file_name.substring(file_name.length() - 50);
            }
            checkResult = StringUtils.substring((String)checkResult, (int)0, (int)300);
            InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
            if (CollectionUtils.isEmpty((Collection)idList)) {
                FileHandleService service;
                logger.info("\u65b0\u7968\uff0c\u4ee3\u7801\uff1a{} \u53f7\u7801\uff1a{}  \u7c7b\u578b\uff1a{}", new Object[]{invoiceCode, invoiceNo, this.invoiceType});
                newFlag = true;
                DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_uncheck");
                invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
                invoiceDynamicObject.set("org", (Object)orgId);
                invoiceDynamicObject.set("creater", (Object)userId);
                invoiceDynamicObject.set("serial_no", (Object)serialNo);
                invoiceDynamicObject.set("invoice_type", (Object)this.invoiceType);
                invoiceDynamicObject.set("invoice_code", (Object)invoiceCode);
                invoiceDynamicObject.set("invoice_no", (Object)invoiceNo);
                this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), invoiceDynamicObject);
                invoiceDynamicObject.set("check_code", (Object)invoiceJson.getString("checkCode"));
                invoiceDynamicObject.set("invoice_amount", (Object)invoiceJson.getString("invoiceAmount"));
                invoiceDynamicObject.set("total_tax_amount", (Object)invoiceJson.getString("totalTaxAmount"));
                invoiceDynamicObject.set("total_amount", (Object)invoiceJson.getString("totalAmount"));
                invoiceDynamicObject.set("saler_name", (Object)invoiceJson.getString("salerName"));
                invoiceDynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
                invoiceDynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
                invoiceDynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
                invoiceDynamicObject.set("check_result", (Object)checkResult);
                invoiceDynamicObject.set("expense_status", (Object)"1");
                String checkStatus = invoiceJson.getString("checkStatus");
                if (StringUtils.isEmpty((CharSequence)checkStatus)) {
                    checkStatus = "2";
                }
                invoiceDynamicObject.set("check_status", (Object)checkStatus);
                invoiceDynamicObject.set("resource", (Object)recource);
                invoiceDynamicObject.set("collect_type", (Object)invoiceJson.getString("collect_type"));
                this.setDelete(invoiceJson, invoiceDynamicObject, null);
                invoiceDynamicObject.set("create_time", (Object)new Date());
                invoiceDynamicObject.set("update_time", (Object)new Date());
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("companySeal"))) {
                    invoiceDynamicObject.set("company_seal", (Object)invoiceJson.getString("companySeal"));
                } else {
                    String company_seal = invoiceDynamicObject.getString("company_seal");
                    if (StringUtils.isEmpty((CharSequence)company_seal)) {
                        invoiceDynamicObject.set("company_seal", (Object)"0");
                    }
                }
                if ("1".equals(invoiceJson.getString("continuousNo"))) {
                    invoiceDynamicObject.set("continuous_no", (Object)"1");
                } else {
                    invoiceDynamicObject.set("continuous_no", (Object)"0");
                }
                if (StringUtils.isNotEmpty((CharSequence)file_name)) {
                    invoiceDynamicObject.set("file_name", (Object)file_name);
                }
                if ("2".equals(invoiceJson.getString("isRevise"))) {
                    invoiceDynamicObject.set("is_revise", (Object)"1");
                } else if (invoiceDynamicObject.get("is_revise") == null) {
                    invoiceDynamicObject.set("is_revise", (Object)"0");
                }
                String page_no = invoiceJson.getString("fileIndex");
                if (StringUtils.isNotEmpty((CharSequence)page_no)) {
                    invoiceDynamicObject.set("page_no", (Object)invoiceJson.getInteger("fileIndex"));
                }
                this.setDeductionFieldValue(this.invoiceType, invoiceDynamicObject, invoiceJson);
                this.setMainInvoiceInfo(invoiceDynamicObject);
                String invoice_info = invoiceDynamicObject.getString("invoice_info");
                String originalState = invoiceJson.getString("originalState");
                if (StringUtils.isNotEmpty((CharSequence)invoice_info) && "1".equals(originalState)) {
                    invoice_info = invoice_info.replaceAll("or_0", "or_1");
                    invoiceDynamicObject.set("invoice_info", (Object)invoice_info);
                }
                Map<String, String> oldMap = InvoiceHisSaveService.dynamicObjectToMap(invoiceDynamicObject);
                List<DynamicObject> hisList = InvoiceHisSaveService.createDynamicObject(oldMap, invoiceDynamicObject);
                DynamicObject mainDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice");
                mainDynamicObject.set("tenant_no", (Object)tenantNo);
                this.setOrgAndTaxOrg(invoiceJson, mainDynamicObject);
                mainDynamicObject.set("org", (Object)orgId);
                mainDynamicObject.set("serial_no", (Object)serialNo);
                mainDynamicObject.set("invoice_type", (Object)this.invoiceType);
                mainDynamicObject.set("createtime", (Object)new Date());
                mainDynamicObject.set("modifytime", (Object)new Date());
                mainDynamicObject.set("invoice_code", (Object)invoiceCode);
                mainDynamicObject.set("invoice_no", (Object)invoiceNo);
                this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), mainDynamicObject);
                mainDynamicObject.set("invoice_amount", (Object)invoiceJson.getString("invoiceAmount"));
                mainDynamicObject.set("total_tax_amount", (Object)invoiceJson.getString("totalTaxAmount"));
                mainDynamicObject.set("total_amount", (Object)invoiceJson.getString("totalAmount"));
                mainDynamicObject.set("saler_name", (Object)invoiceJson.getString("salerName"));
                mainDynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
                mainDynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
                mainDynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
                mainDynamicObject.set("expense_status", (Object)"1");
                String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
                if (!"1".equals(isSaleListInvoice)) {
                    mainDynamicObject.set("salelist_complete", (Object)"1");
                }
                mainDynamicObject.set("check_result", (Object)checkResult);
                String mainCheckStatus = invoiceJson.getString("checkStatus");
                if (StringUtils.isEmpty((CharSequence)mainCheckStatus)) {
                    mainCheckStatus = "2";
                }
                mainDynamicObject.set("check_status", (Object)mainCheckStatus);
                mainDynamicObject.set("resource", (Object)recource);
                mainDynamicObject.set("audit_result", (Object)"0");
                this.setDelete(invoiceJson, mainDynamicObject, null);
                if ("2".equals(invoiceJson.getString("isRevise"))) {
                    mainDynamicObject.set("is_revise", (Object)"1");
                } else if (mainDynamicObject.get("is_revise") == null) {
                    mainDynamicObject.set("is_revise", (Object)"0");
                }
                if (this.isAllowSave(invoiceJson)) {
                    this.setUserAndOrg(userId, String.valueOf(orgId), this.getRimUser(invoiceJson), mainDynamicObject, this.needUserRelation(invoiceJson));
                }
                this.setMainFieldValue(invoiceJson, mainDynamicObject);
                mainDynamicObject.set("invoice_status", (Object)invoiceJson.getString("invoiceStatus"));
                Map<String, String> oldMap1 = null;
                if (this.checkIdIsNull(mainDynamicObject.getPkValue()).booleanValue()) {
                    mainDynamicObject.set("id", (Object)ORM.create().genLongId(mainDynamicObject.getDataEntityType().getName()));
                    oldMap1 = InvoiceHisSaveService.dynamicObjectToMap(mainDynamicObject);
                } else {
                    oldMap1 = InvoiceHisSaveService.dynamicObjectToMap(mainDynamicObject);
                }
                this.setDeductionFieldValue(this.invoiceType, mainDynamicObject, invoiceJson);
                String expense_status = mainDynamicObject.getString("expense_status");
                invoiceJson.put("expenseStatus", (Object)expense_status);
                invoiceJson.put("transportDeduction", (Object)mainDynamicObject.getString("transport_deduction"));
                this.setPersonInvoiceDeductionFlag(mainDynamicObject);
                this.setDeductionFlag(invoiceJson, mainDynamicObject);
                mainDynamicObject.set("modifytime", (Object)new Date());
                this.setMainInvoiceInfo(mainDynamicObject);
                invoiceJson.put("invoice_info", (Object)mainDynamicObject.getString("invoice_info"));
                saveResult.setMainId(mainDynamicObject.get("id"));
                saveResult.setInvoiceInfo(invoiceJson.getString("invoice_info"));
                hisList.addAll(InvoiceHisSaveService.createDynamicObject(oldMap1, mainDynamicObject));
                String snapshotUrl = invoiceJson.getString("snapshotUrl");
                boolean createGen = false;
                String xmlUrl = invoiceJson.getString("xmlUrl");
                if (StringUtils.isEmpty((CharSequence)snapshotUrl)) {
                    createGen = true;
                }
                if (!this.synConvert(invoiceJson, serialNo) && (StringUtils.isNotEmpty((CharSequence)snapshotUrl) || StringUtils.isNotEmpty((CharSequence)xmlUrl))) {
                    if (snapshotUrl.startsWith("http")) {
                        service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_DOWN);
                        service.insert(serialNo, invoiceJson);
                        FileHandleService.startDownAwsFile("0");
                    } else {
                        FileSaveTask fileSaveTask = new FileSaveTask(RequestContext.get(), serialNo, invoiceJson);
                        fileSaveTask.call();
                    }
                }
                if (createGen || StringUtils.isEmpty((CharSequence)snapshotUrl) && StringUtils.isEmpty((CharSequence)xmlUrl)) {
                    service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_GEN);
                    service.insert(serialNo, invoiceJson);
                }
                this.setDiscountInfo(this.invoiceType, invoiceJson, mainDynamicObject);
                DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
                this.setInvoiceFieldValue(invoiceJson, invoiceObject);
                this.setDeductionFieldValue(this.invoiceType, invoiceObject, invoiceJson);
                invoiceObject.set("org", (Object)orgId);
                invoiceObject.set("creator", (Object)userId);
                invoiceObject.set("org_id", (Object)orgId);
                invoiceObject.set("creator_id", (Object)userId);
                InvoiceSaveService.setSerialNo(mainDynamicObject, invoiceObject);
                Map<String, Object> detailMap = DynamicObjectUtil.dynamicObjectToMap(invoiceObject);
                JSONObject detailMapJson = new JSONObject();
                JSONObject fileMap = new JSONObject();
                fileMap.put("pdf_url", (Object)invoiceJson.getString("pdfUrl"));
                fileMap.put("ofd_url", (Object)invoiceJson.getString("ofdUrl"));
                fileMap.put("image_url", (Object)invoiceJson.getString("imageUrl"));
                fileMap.put("snapshot_url", (Object)invoiceJson.getString("snapshotUrl"));
                fileMap.put("original_type", (Object)invoiceJson.getString("fileType"));
                fileMap.put("xml_url", (Object)invoiceJson.getString("xmlUrl"));
                fileMap.put("region", invoiceJson.get((Object)"region"));
                fileMap.put("rotation_angle", invoiceJson.get((Object)"rotationAngle"));
                fileMap.put("pixel", invoiceJson.get((Object)"pixel"));
                detailMapJson.put("detail", detailMap);
                detailMapJson.put("file", (Object)fileMap);
                detailMapJson.put("fileType", (Object)FileUtils.getFileType(invoiceJson.getString("fileName")));
                invoiceDynamicObject.set("invoice_detail_tag", (Object)detailMapJson.toJSONString());
                invoiceDynamicObject.set("invoice_info", (Object)mainDynamicObject.getString("invoice_info"));
                ekService.beforeSave(mainDynamicObject, invoiceObject, invoiceJson);
                InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_FILETYPE_NOW, FileUtils.getFileType(invoiceJson.getString("fileName")));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                SaveServiceHelper.save((DynamicObject[])hisList.toArray(new DynamicObject[hisList.size()]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceDynamicObject});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
                saveResult.setUnCheckId(invoiceDynamicObject.get("id"));
                saveResult.setInvoiceEntity(invoiceObject.getDynamicObjectType().getName());
                saveResult.setMainId(mainDynamicObject.get("id"));
                saveResult.setInvoiceId(invoiceObject.get("id"));
            } else {
                String expenseStatus;
                Object service;
                String page_no;
                DynamicObject[] mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
                DynamicObject mainInvoice = mainDynamicObjectsTemp[0];
                String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
                String salelist_complete = mainInvoice.getString("salelist_complete");
                if (StringUtils.isEmpty((CharSequence)salelist_complete) && !"1".equals(isSaleListInvoice)) {
                    mainInvoice.set("salelist_complete", (Object)"1");
                }
                serialNo = mainInvoice.getString("serial_no");
                if (this.isAllowSave(invoiceJson)) {
                    this.setUserAndOrg(userId, String.valueOf(orgId), this.getRimUser(invoiceJson), mainInvoice, this.needUserRelation(invoiceJson));
                }
                Map<String, String> oldMap = InvoiceHisSaveService.dynamicObjectToMap(mainInvoice);
                List<DynamicObject> hisList = InvoiceHisSaveService.createDynamicObject(oldMap, mainInvoice);
                QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)mainInvoice.getString("serial_no"));
                List uncheckIdList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice_uncheck", (QFilter[])new QFilter[]{tenantFilter, serialNoFilter}, null, (int)100);
                DynamicObject uncheckInvoice = null;
                if (CollectionUtils.isEmpty((Collection)uncheckIdList)) {
                    uncheckInvoice = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_uncheck");
                } else {
                    DynamicObject[] uncheckDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])uncheckIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"));
                    uncheckInvoice = uncheckDynamicObjectsTemp[0];
                }
                uncheckInvoice.set("tenant_no", (Object)tenantNo);
                if (this.overrideOrg(uncheckInvoice, invoiceJson).booleanValue()) {
                    uncheckInvoice.set("org", (Object)orgId);
                }
                uncheckInvoice.set("creater", (Object)userId);
                uncheckInvoice.set("serial_no", (Object)serialNo);
                uncheckInvoice.set("invoice_type", (Object)this.invoiceType);
                uncheckInvoice.set("invoice_code", (Object)invoiceCode);
                uncheckInvoice.set("invoice_no", (Object)invoiceNo);
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(this.invoiceType)) {
                    this.setInvoiceDate(invoiceJson.getDate("issueDate"), uncheckInvoice);
                } else {
                    this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), uncheckInvoice);
                }
                uncheckInvoice.set("check_code", (Object)invoiceJson.getString("checkCode"));
                uncheckInvoice.set("invoice_amount", (Object)invoiceJson.getString("invoiceAmount"));
                uncheckInvoice.set("total_tax_amount", (Object)invoiceJson.getString("totalTaxAmount"));
                uncheckInvoice.set("total_amount", (Object)invoiceJson.getString("totalAmount"));
                uncheckInvoice.set("saler_name", (Object)invoiceJson.getString("salerName"));
                uncheckInvoice.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
                uncheckInvoice.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
                uncheckInvoice.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
                uncheckInvoice.set("expense_status", (Object)"1");
                if (!StringUtils.isEmpty((CharSequence)mainInvoice.getString("expense_status"))) {
                    uncheckInvoice.set("expense_status", (Object)mainInvoice.getString("expense_status"));
                }
                uncheckInvoice.set("check_result", (Object)checkResult);
                uncheckInvoice.set("check_status", (Object)"2");
                uncheckInvoice.set("resource", (Object)recource);
                uncheckInvoice.set("collect_type", (Object)invoiceJson.getString("collect_type"));
                this.setDelete(invoiceJson, uncheckInvoice, null);
                uncheckInvoice.set("update_time", (Object)new Date());
                if (uncheckInvoice.get("create_time") == null) {
                    uncheckInvoice.set("create_time", (Object)new Date());
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("companySeal"))) {
                    uncheckInvoice.set("company_seal", (Object)invoiceJson.getString("companySeal"));
                } else {
                    String company_seal = uncheckInvoice.getString("company_seal");
                    if (StringUtils.isEmpty((CharSequence)company_seal)) {
                        uncheckInvoice.set("company_seal", (Object)"0");
                    }
                }
                if ("1".equals(invoiceJson.getString("continuousNo"))) {
                    uncheckInvoice.set("continuous_no", (Object)"1");
                } else {
                    uncheckInvoice.set("continuous_no", (Object)"0");
                }
                if ("2".equals(invoiceJson.getString("isRevise"))) {
                    uncheckInvoice.set("is_revise", (Object)"1");
                } else if (uncheckInvoice.get("is_revise") == null) {
                    uncheckInvoice.set("is_revise", (Object)"0");
                }
                if (StringUtils.isNotEmpty((CharSequence)file_name)) {
                    uncheckInvoice.set("file_name", (Object)file_name);
                }
                if (StringUtils.isNotEmpty((CharSequence)(page_no = invoiceJson.getString("fileIndex")))) {
                    uncheckInvoice.set("page_no", (Object)invoiceJson.getInteger("fileIndex"));
                }
                this.setDeductionFieldValue(this.invoiceType, uncheckInvoice, invoiceJson);
                this.setMainInvoiceInfo(uncheckInvoice);
                this.setMainFieldValue(invoiceJson, mainInvoice);
                String invoice_info = uncheckInvoice.getString("invoice_info");
                String originalState = invoiceJson.getString("originalState");
                if (StringUtils.isNotEmpty((CharSequence)invoice_info) && "1".equals(originalState)) {
                    invoice_info = invoice_info.replaceAll("or_0", "or_1");
                    uncheckInvoice.set("invoice_info", (Object)invoice_info);
                }
                String snapshotUrl = invoiceJson.getString("snapshotUrl");
                String xmlUrl = invoiceJson.getString("xmlUrl");
                if (!"1".equals(mainInvoice.getString("check_status"))) {
                    boolean createGen = false;
                    if (!this.synConvert(invoiceJson, serialNo) && (StringUtils.isNotEmpty((CharSequence)snapshotUrl) || StringUtils.isNotEmpty((CharSequence)xmlUrl))) {
                        if (StringUtils.isNotEmpty((CharSequence)xmlUrl) && StringUtils.isEmpty((CharSequence)snapshotUrl)) {
                            createGen = true;
                        }
                        if (snapshotUrl.startsWith("http")) {
                            service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_DOWN);
                            ((FileHandleService)service).insert(serialNo, invoiceJson);
                            FileHandleService.startDownAwsFile("0");
                        } else {
                            FileSaveTask fileSaveTask = new FileSaveTask(RequestContext.get(), serialNo, invoiceJson);
                            fileSaveTask.call();
                        }
                    }
                    if (createGen || StringUtils.isEmpty((CharSequence)snapshotUrl) && StringUtils.isEmpty((CharSequence)xmlUrl)) {
                        service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_GEN);
                        ((FileHandleService)service).insert(serialNo, invoiceJson);
                    }
                }
                if ("60".equals(expenseStatus = mainInvoice.getString("expense_status")) || "65".equals(expenseStatus)) {
                    service = this.dbResult(mainInvoice, invoiceJson, true);
                    return service;
                }
                mainInvoice.set("tenant_no", (Object)tenantNo);
                if (this.overrideOrg(mainInvoice, invoiceJson).booleanValue()) {
                    this.setOrgAndTaxOrg(invoiceJson, mainInvoice);
                    mainInvoice.set("org", (Object)orgId);
                }
                mainInvoice.set("serial_no", (Object)serialNo);
                mainInvoice.set("invoice_type", (Object)this.invoiceType);
                mainInvoice.set("invoice_code", (Object)invoiceCode);
                mainInvoice.set("invoice_no", (Object)invoiceNo);
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(this.invoiceType)) {
                    this.setInvoiceDate(invoiceJson.getDate("issueDate"), mainInvoice);
                } else {
                    this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), mainInvoice);
                }
                mainInvoice.set("invoice_amount", (Object)invoiceJson.getString("invoiceAmount"));
                mainInvoice.set("total_tax_amount", (Object)invoiceJson.getString("totalTaxAmount"));
                mainInvoice.set("total_amount", (Object)invoiceJson.getString("totalAmount"));
                mainInvoice.set("saler_name", (Object)invoiceJson.getString("salerName"));
                mainInvoice.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
                mainInvoice.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
                mainInvoice.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
                mainInvoice.set("source_area", (Object)invoiceJson.getString("sourceArea"));
                mainInvoice.set("dest_area", (Object)invoiceJson.getString("destArea"));
                if (StringUtils.isEmpty((CharSequence)mainInvoice.getString("expense_status"))) {
                    mainInvoice.set("expense_status", (Object)"1");
                }
                mainInvoice.set("check_result", (Object)checkResult);
                mainInvoice.set("resource", (Object)recource);
                this.setDelete(invoiceJson, mainInvoice, new Date());
                mainInvoice.set("modifytime", (Object)new Date());
                if ("2".equals(invoiceJson.getString("isRevise"))) {
                    mainInvoice.set("is_revise", (Object)"1");
                } else if (mainInvoice.get("is_revise") == null) {
                    mainInvoice.set("is_revise", (Object)"0");
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("companySeal"))) {
                    mainInvoice.set("company_seal", (Object)invoiceJson.getString("companySeal"));
                } else {
                    String company_seal = mainInvoice.getString("company_seal");
                    if (StringUtils.isEmpty((CharSequence)company_seal)) {
                        mainInvoice.set("company_seal", (Object)"0");
                    }
                }
                if ("1".equals(invoiceJson.getString("continuousNo"))) {
                    mainInvoice.set("continuous_no", (Object)"1");
                } else {
                    mainInvoice.set("continuous_no", (Object)"0");
                }
                this.setEtaxInvoiceNo(invoiceJson, mainInvoice);
                this.setSourceAndRiskLevel(invoiceJson, mainInvoice);
                this.setPersonInvoiceDeductionFlag(mainInvoice);
                this.setDeductionFlag(invoiceJson, mainInvoice);
                this.setDeductionFieldValue(this.invoiceType, mainInvoice, invoiceJson);
                this.setInvoiceStatusTaxImport(mainInvoice, invoiceJson);
                this.setMainInvoiceInfo(mainInvoice);
                DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
                this.setInvoiceFieldValue(invoiceJson, invoiceObject);
                this.setDeductionFieldValue(this.invoiceType, invoiceObject, invoiceJson);
                invoiceObject.set("org", (Object)orgId);
                invoiceObject.set("creator", (Object)userId);
                invoiceObject.set("org_id", (Object)orgId);
                invoiceObject.set("creator_id", (Object)userId);
                Map<String, Object> detailMap = DynamicObjectUtil.dynamicObjectToMap(invoiceObject);
                JSONObject detailMapJson = new JSONObject();
                JSONObject fileMap = new JSONObject();
                fileMap.put("pdf_url", (Object)invoiceJson.getString("pdfUrl"));
                fileMap.put("ofd_url", (Object)invoiceJson.getString("ofdUrl"));
                fileMap.put("image_url", (Object)invoiceJson.getString("imageUrl"));
                fileMap.put("snapshot_url", (Object)invoiceJson.getString("snapshotUrl"));
                fileMap.put("original_type", (Object)invoiceJson.getString("fileType"));
                fileMap.put("xml_url", (Object)invoiceJson.getString("xmlUrl"));
                fileMap.put("region", invoiceJson.get((Object)"region"));
                fileMap.put("rotation_angle", invoiceJson.get((Object)"rotationAngle"));
                fileMap.put("pixel", invoiceJson.get((Object)"pixel"));
                detailMapJson.put("detail", detailMap);
                detailMapJson.put("file", (Object)fileMap);
                detailMapJson.put("fileType", (Object)FileUtils.getFileType(invoiceJson.getString("fileName")));
                uncheckInvoice.set("invoice_detail_tag", (Object)detailMapJson.toJSONString());
                uncheckInvoice.set("invoice_info", (Object)mainInvoice.getString("invoice_info"));
                ekService.beforeSave(mainInvoice, invoiceObject, invoiceJson);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{uncheckInvoice});
                saveResult.setUnCheckId(uncheckInvoice.get("id"));
                Map<String, String> oldMap1 = InvoiceHisSaveService.dynamicObjectToMap(uncheckInvoice);
                hisList.addAll(InvoiceHisSaveService.createDynamicObject(oldMap1, uncheckInvoice));
                if (!"1".equals(mainInvoice.getString("check_status"))) {
                    mainInvoice.set("check_status", (Object)"2");
                    mainInvoice.set("modifytime", (Object)new Date());
                    this.setDiscountInfo(this.invoiceType, invoiceJson, mainInvoice);
                    InvoiceSaveService.setExtInfo(mainInvoice, InvoiceSaveConstant.EXT_FILETYPE_NOW, FileUtils.getFileType(invoiceJson.getString("fileName")));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainInvoice});
                    this.setDiscountInfo(this.invoiceType, invoiceJson, invoiceObject);
                    this.setInvoiceStatusTaxImport(invoiceObject, invoiceJson);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
                    saveResult.setInvoiceEntity(invoiceObject.getDynamicObjectType().getName());
                }
                invoiceJson.put("invoice_info", (Object)mainInvoice.getString("invoice_info"));
                saveResult.setInvoiceInfo(invoiceJson.getString("invoice_info"));
                saveResult.setMainId(mainInvoice.get("id"));
                saveResult.setInvoiceId(invoiceObject.get("id"));
                SaveServiceHelper.save((DynamicObject[])hisList.toArray(new DynamicObject[hisList.size()]));
            }
            saveResult.setSerialNo(serialNo);
            saveResult.setNewFlag(newFlag);
            saveResult.setTenantNo(tenantNo);
            saveResult.setInvoiceType(this.invoiceType);
            invoiceJson.put("serialNo", (Object)serialNo);
            saveResult.setInvoiceInfo(invoiceJson.getString("invoice_info"));
            saveResult.setInvoiceJson(invoiceJson);
            ekService.afterSave(saveResult);
            logger.info(invoiceJson.getString("fileName") + "\u7b2c" + invoiceJson.getString("fileIndex") + "\u9875\uff0cInvoiceSaveService.saveUncheckInvoice\u7edf\u8ba1\u4fe1\u606f:" + serialNo + ",\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            InvoiceLog.insert("save", serialNo, "\u672a\u67e5\u9a8c", orgId, invoiceJson.getString("resource"), invoiceJson.getString("collect_type"));
            if ("true".equals(invoiceJson.getString("synConvert"))) {
                FileHandleService.startDownAwsFile("0");
            }
            InvoiceSaveResult invoiceSaveResult = saveResult;
            return invoiceSaveResult;
        }
        catch (Throwable e) {
            try {
                logger.error("\u53d1\u7968\u4fdd\u5b58\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private InvoiceSaveResult dbResult(DynamicObject mainInvoice, JSONObject invoiceJson, boolean isUncheck) {
        List list;
        String originalState;
        String serialNo = mainInvoice.getString("serial_no");
        DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
        Object invoice_type = mainInvoice.get("invoice_type");
        Long invoiceType = invoice_type instanceof DynamicObject ? Long.valueOf(((DynamicObject)invoice_type).getLong("id")) : (Long)invoice_type;
        InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType);
        DynamicObject fileObj = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)MetadataUtil.getFields("rim_invoice_file"), (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
        if (fileObj == null) {
            fileObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
        }
        if (!"1".equals(originalState = mainInvoice.getString("original_state"))) {
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("pdfUrl"))) {
                fileObj.set("pdf_url", (Object)invoiceJson.getString("pdfUrl"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("ofdUrl"))) {
                fileObj.set("ofd_url", (Object)invoiceJson.getString("ofdUrl"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("imageUrl"))) {
                fileObj.set("image_url", (Object)invoiceJson.getString("imageUrl"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("snapshotUrl"))) {
                fileObj.set("snapshot_url", (Object)invoiceJson.getString("snapshotUrl"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("xmlUrl"))) {
                fileObj.set("xml_url", (Object)invoiceJson.getString("xmlUrl"));
            }
        }
        JSONObject convertResult = convertService.convert(mainInvoice, invoiceObject, fileObj);
        InvoiceSaveResult saveResult = new InvoiceSaveResult();
        saveResult.setMainId(mainInvoice.getPkValue());
        saveResult.setInvoiceId(invoiceObject.getPkValue());
        saveResult.setInvoiceJson(convertResult);
        saveResult.setSerialNo(serialNo);
        saveResult.setTenantNo(TenantUtils.getTenantNo());
        saveResult.setInvoiceType(invoiceType);
        saveResult.setInvoiceInfo(invoiceJson.getString("invoice_info"));
        if (isUncheck && (list = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice_uncheck", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)}, (String)"id", (int)1)).size() > 0) {
            saveResult.setUnCheckId(list.get(0));
        }
        InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
        ekService.afterSave(saveResult);
        return saveResult;
    }

    private void setInvoiceStatusTaxImport(DynamicObject invoice, JSONObject invoiceJson) {
        if (invoiceJson.containsKey((Object)"collect_type") && CollectTypeEnum.TAX_EXCEL_IMPORT.getCode().equals(invoiceJson.getString("collect_type")) && invoiceJson.containsKey((Object)"invoiceStatus") && StringUtils.isNotBlank((CharSequence)invoiceJson.getString("invoiceStatus"))) {
            invoice.set("invoice_status", (Object)invoiceJson.getString("invoiceStatus"));
        }
    }

    public boolean isInvoiceExists(JSONObject invoiceJson) {
        String tenantNo = TenantUtils.getTenantNo();
        String serialNo = "";
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("checkStatus")) && !"1".equals(invoiceJson.getString("checkStatus"))) {
            QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceJson.getString("invoiceCode")));
            QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)this.invoiceType);
            QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceJson.getString("invoiceNo"));
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter});
            if (null != idObject) {
                serialNo = idObject.getString("serial_no");
            }
        } else {
            DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
            serialNo = invoiceObject.getString("serial_no");
        }
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialFilter}, null, (int)100);
        return !CollectionUtils.isEmpty((Collection)idList);
    }

    public String setInvoiceFiled(JSONObject invoiceJson) {
        Object[] invoiceArray;
        String tenantNo = TenantUtils.getTenantNo();
        String serialNo = "";
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("checkStatus")) && !"1".equals(invoiceJson.getString("checkStatus"))) {
            QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceJson.getString("invoiceCode")));
            QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)this.invoiceType);
            QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceJson.getString("invoiceNo"));
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter});
            if (null != idObject) {
                serialNo = idObject.getString("serial_no");
            }
        } else {
            DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
            serialNo = invoiceObject.getString("serial_no");
        }
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialFilter}, null, (int)100);
        if (!CollectionUtils.isEmpty((Collection)idList) && ArrayUtils.isNotEmpty((Object[])(invoiceArray = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"))))) {
            String delete = invoiceArray[0].getString("delete");
            return "1".equals(delete) ? "1" : "2";
        }
        return "2";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkInvoiceExists(JSONObject invoiceJson) {
        QFilter serialFilter;
        List idList;
        String tenantNo = TenantUtils.getTenantNo();
        String userId = InvoiceSaveService.getOperateUser(invoiceJson);
        String serialNo = "";
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("checkStatus")) && !"1".equals(invoiceJson.getString("checkStatus"))) {
            DynamicObject idObject;
            String invoiceNo = invoiceJson.getString("invoiceNo");
            QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceJson.getString("invoiceCode")));
            QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)this.invoiceType);
            QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            if (InputInvoiceTypeEnum.isEleInvoice(this.invoiceType).booleanValue()) {
                invoiceCodeFilter = null;
            }
            if (null == (idObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no,delete", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter}))) return false;
            logger.info("\u5df2\u91c7\u96c6\u8fc7\uff0c\u6d41\u6c34\u53f7\uff1a{}", (Object)idObject.getString("serial_no"));
            serialNo = idObject.getString("serial_no");
        } else {
            DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
            serialNo = invoiceObject.getString("serial_no");
        }
        if (CollectionUtils.isEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialFilter = new QFilter("serial_no", "=", (Object)serialNo)}, null, (int)100)))) {
            return false;
        }
        DynamicObject[] mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
        DynamicObject invoice = mainDynamicObjectsTemp[0];
        DynamicObjectCollection userEntry = invoice.getDynamicObjectCollection("collect_user_entry");
        for (DynamicObject userObj : userEntry) {
            String pk;
            DynamicObject user = userObj.getDynamicObject("collect_user");
            if (null == user || !(pk = user.getPkValue() + "").equals(userId)) continue;
            return true;
        }
        return false;
    }

    public DynamicObject getMainDynamicObject(DynamicObject invoiceObject, JSONObject invoiceJson) {
        String userId = InvoiceSaveService.getOperateUser(invoiceJson);
        String orgId = invoiceJson.getString("org_id");
        if (orgId == null && (orgId = invoiceJson.getString("org")) == null) {
            orgId = RequestContext.get().getOrgId() + "";
        }
        String tenantNo = invoiceObject.getString("tenant_no");
        String serialNo = invoiceObject.getString("serial_no");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialFilter}, null, (int)100);
        DynamicObject mainDynamicObject = null;
        Boolean newFlag = Boolean.FALSE;
        Date createTime = InvoiceSaveService.getDate(invoiceJson, "billCreateTime1");
        if (CollectionUtils.isEmpty((Collection)idList)) {
            newFlag = Boolean.TRUE;
            mainDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice");
            mainDynamicObject.set("tenant_no", (Object)tenantNo);
            mainDynamicObject.set("org", (Object)orgId);
            mainDynamicObject.set("serial_no", (Object)serialNo);
            mainDynamicObject.set("billstatus", (Object)"C");
            mainDynamicObject.set("invoice_type", (Object)this.invoiceType);
            mainDynamicObject.set("expense_status", (Object)"1");
            mainDynamicObject.set("check_status", (Object)invoiceJson.getString("checkStatus"));
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("resource"))) {
                mainDynamicObject.set("resource", invoiceJson.get((Object)"resource"));
            }
            mainDynamicObject.set("original_state", (Object)"0");
            mainDynamicObject.set("createtime", (Object)createTime);
            mainDynamicObject.set("audit_result", (Object)"0");
        } else {
            mainDynamicObject = BusinessDataServiceHelper.loadSingle(idList.get(0), (String)"rim_invoice");
            invoiceJson.put("prev_check_status", (Object)mainDynamicObject.getString("check_status"));
            invoiceJson.put("prevOriginalState", (Object)mainDynamicObject.getString("original_state"));
            String delete = mainDynamicObject.getString("delete");
            if ("1".equals(delete)) {
                invoiceJson.put("delete", (Object)"1");
            }
            if ("2".equals(invoiceJson.getString("prev_check_status")) && "1".equals(invoiceJson.getString("checkStatus"))) {
                mainDynamicObject.set("createtime", (Object)new Date());
            }
        }
        if ("2".equals(invoiceJson.getString("isRevise"))) {
            mainDynamicObject.set("is_revise", (Object)"1");
        } else if (mainDynamicObject.get("is_revise") == null) {
            mainDynamicObject.set("is_revise", (Object)"0");
        }
        String checkStatus = invoiceJson.getString("checkStatus");
        if ("1".equals(checkStatus) || "4".equals(checkStatus)) {
            mainDynamicObject.set("check_status", (Object)checkStatus);
            mainDynamicObject.set("check_result", (Object)"");
            if ("1".equals(checkStatus) && InputInvoiceTypeEnum.needCheck(this.invoiceType).booleanValue()) {
                if (null == mainDynamicObject.get("check_time")) {
                    mainDynamicObject.set("check_time", (Object)new Date());
                }
                mainDynamicObject.set("is_revise", (Object)"0");
            }
        } else {
            String preCheckStatus = mainDynamicObject.getString("check_status");
            if (StringUtils.isEmpty((CharSequence)preCheckStatus) && StringUtils.isNotEmpty((CharSequence)checkStatus)) {
                mainDynamicObject.set("check_status", (Object)checkStatus);
            }
        }
        if ((newFlag.booleanValue() || !"0".equals(invoiceJson.getString("overrideOrg"))) && this.isAllowSave(invoiceJson)) {
            this.setUserAndOrg(userId, orgId, this.getRimUser(invoiceJson), mainDynamicObject, this.needUserRelation(invoiceJson));
        }
        mainDynamicObject.set("modifytime", (Object)new Date());
        return mainDynamicObject;
    }

    public void setDeductionFlag(JSONObject invoiceJson, DynamicObject mainDynamicObject) {
        try {
            String deductionFlag = mainDynamicObject.getString("deduction_flag");
            String collectType = invoiceJson.getString("collect_type");
            if (this.calculateDeductionFlag == null) {
                this.calculateDeductionFlag = InvoiceSaveService.getBillDeductionFlag(mainDynamicObject, collectType);
            }
        }
        catch (Exception deductionFlag) {
            // empty catch block
        }
        String deduction_flag = this.calculateDeductionFlag;
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainDynamicObject.get("org"));
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType)) {
            if (deduction_flag == null) {
                this.calculateDeductionFlag = StringUtils.isNotEmpty((CharSequence)mainDynamicObject.getString("agric_handle_status")) ? DeductionConstant.canBeAgricInvoice(invoiceJson.getString("invoiceStatus"), invoiceJson.getBigDecimal("totalTaxAmount")) : (deduction_flag = DeductionConstant.canBeDeductionForOrdinary(invoiceJson, orgId));
            }
            mainDynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)deduction_flag);
            if (StringUtils.isEmpty((CharSequence)mainDynamicObject.getString("agric_handle_status"))) {
                if ("1".equals(deduction_flag) && StringUtils.isEmpty((CharSequence)mainDynamicObject.getString("transport_deduction"))) {
                    mainDynamicObject.set("transport_deduction", (Object)"0");
                }
                if ("1".equals(deduction_flag)) {
                    mainDynamicObject.set("effective_tax_amount", mainDynamicObject.get("total_tax_amount"));
                } else {
                    mainDynamicObject.set("effective_tax_amount", (Object)BigDecimal.ZERO);
                }
            }
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(this.invoiceType)) {
            if (deduction_flag == null) {
                this.calculateDeductionFlag = deduction_flag = DeductionConstant.canBeDeductionForTransport(invoiceJson, orgId);
            }
            mainDynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)deduction_flag);
            if ("1".equals(deduction_flag)) {
                if (StringUtils.isEmpty((CharSequence)mainDynamicObject.getString("transport_deduction"))) {
                    mainDynamicObject.set("transport_deduction", (Object)"0");
                }
                mainDynamicObject.set("effective_tax_amount", mainDynamicObject.get("total_tax_amount"));
            } else {
                mainDynamicObject.set("effective_tax_amount", (Object)BigDecimal.ZERO);
            }
        }
        if (InputInvoiceTypeEnum.canDeduction(this.invoiceType).booleanValue()) {
            if (deduction_flag == null) {
                this.calculateDeductionFlag = deduction_flag = DeductionConstant.canBeDeductionForTaxInvoice(invoiceJson);
            }
            mainDynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)deduction_flag);
            String authenticateFlag = mainDynamicObject.getString("authenticate_flag");
            if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                mainDynamicObject.set("authenticate_flag", (Object)"0");
            }
        }
    }

    public void setDownAgricData(Long invoiceType, DynamicObject dynamicObject, JSONObject invoiceJson) {
        if (!"agricDown".equals(invoiceJson.getString("downResource"))) {
            return;
        }
        if (InputInvoiceTypeEnum.canSmallScaleSpecialType(invoiceType) || InputInvoiceTypeEnum.canSelfproducedAgric(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
            String deductionFlag;
            dynamicObject.set("purchase_ticket", (Object)invoiceJson.getString("farmProductType"));
            dynamicObject.set("agric_handle_status", (Object)invoiceJson.getString("processingStatus"));
            String authenticateFlag = dynamicObject.getString("authenticate_flag");
            if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                dynamicObject.set("authenticate_flag", (Object)"0");
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("effectiveTaxAmount"))) {
                dynamicObject.set("effective_tax_amount", (Object)invoiceJson.getBigDecimal("effectiveTaxAmount"));
            }
            if ("1".equals(invoiceJson.getString("processingStatus"))) {
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("selfProducedAmount"))) {
                    dynamicObject.set("agric_partial_amount", (Object)invoiceJson.getBigDecimal("selfProducedAmount"));
                }
                dynamicObject.set("agric_prehandletype", (Object)invoiceJson.getString("processType"));
                if (StringUtils.isEmpty((CharSequence)authenticateFlag) || "0".equals(authenticateFlag) || "4".equals(authenticateFlag)) {
                    if ("2".equals(invoiceJson.getString("processType"))) {
                        dynamicObject.set("deduction_purpose", (Object)"2");
                    } else {
                        dynamicObject.set("deduction_purpose", (Object)"1");
                    }
                }
            }
            if ("rim_invoice".equals(dynamicObject.getDataEntityType().getName())) {
                InvoiceSaveService.setExtInfo(dynamicObject, InvoiceSaveConstant.EXT_AGRIC_DOWN_FLAG, "1");
                this.calculateDeductionFlag = InvoiceSaveService.getBillDeductionFlag(dynamicObject, CollectTypeEnum.PC_SHUIPAN.getCode());
            }
            if (this.calculateDeductionFlag == null) {
                this.calculateDeductionFlag = deductionFlag = DeductionConstant.canBeAgricInvoice(invoiceJson.getString("invoiceStatus"), invoiceJson.getBigDecimal("totalTaxAmount"));
            } else {
                deductionFlag = this.calculateDeductionFlag;
            }
            dynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)deductionFlag);
            if ("rim_invoice".equals(dynamicObject.getDataEntityType().getName())) {
                InvoiceSaveService.setExtInfo(dynamicObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, dynamicObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            }
            if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                dynamicObject.set("transport_deduction", null);
            }
        }
    }

    public void setAgricData(DynamicObject mainObject, DynamicObject invoiceObject, JSONObject invoiceJson) {
        String agricHandleStatus = mainObject.getString("agric_handle_status");
        if ("1".equals(agricHandleStatus) || "3".equals(agricHandleStatus)) {
            return;
        }
        try {
            String extInfo = mainObject.getString("ext_info");
            JSONObject extObj = JSON.parseObject((String)extInfo);
            String billDeductionFlag = extObj.getString(InvoiceSaveConstant.EXT_AGRIC_DOWN_FLAG);
            if ("1".equals(billDeductionFlag)) {
                return;
            }
        }
        catch (Exception extInfo) {
            // empty catch block
        }
        Date invoiceDate = mainObject.getDate("invoice_date");
        boolean invoiceDateFlag = invoiceDate != null && invoiceDate.compareTo(DeductionConstant.AGRIC_START_DATE) >= 0;
        String collectType = invoiceJson.getString("collect_type");
        if (InputInvoiceTypeEnum.canSmallScaleSpecialType(this.invoiceType)) {
            String salerType = invoiceObject.getString("saler_type");
            if (!"2".equals(salerType) || !invoiceDateFlag) {
                this.setAgricFiled(mainObject, invoiceObject, null, null, collectType);
                return;
            }
            String specialTypeMark = mainObject.getString("special_type_mark");
            boolean isSpecialTypeMark = false;
            isSpecialTypeMark = InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(this.invoiceType) && StringUtils.isEmpty((CharSequence)mainObject.getString("electronic_no")) ? true : SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS.getCode().equals(specialTypeMark);
            boolean isAgricItems = this.getAgricItems(invoiceObject, false);
            if (isSpecialTypeMark && isAgricItems) {
                this.setAgricFiled(mainObject, invoiceObject, "2", "0", collectType);
            } else {
                this.setAgricFiled(mainObject, invoiceObject, null, null, collectType);
            }
        } else if (InputInvoiceTypeEnum.canSelfproducedAgric(this.invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType)) {
            String specialTypeMark = mainObject.getString("special_type_mark");
            boolean isSpecialTypeMark = false;
            boolean isAgricItems = false;
            if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(this.invoiceType) && StringUtils.isEmpty((CharSequence)mainObject.getString("electronic_no"))) {
                if (SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS_PURCHASE.getCode().equals(specialTypeMark)) {
                    this.setAgricFiled(mainObject, invoiceObject, null, "2", collectType);
                    return;
                }
                if (!invoiceDateFlag) {
                    this.setAgricFiled(mainObject, invoiceObject, null, null, collectType);
                    return;
                }
                isSpecialTypeMark = !SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS_PURCHASE.getCode().equals(specialTypeMark);
                isAgricItems = this.getAgricItems(invoiceObject, true);
                if (isSpecialTypeMark && isAgricItems) {
                    this.setAgricFiled(mainObject, invoiceObject, "1", "0", collectType);
                } else {
                    this.setAgricFiled(mainObject, invoiceObject, null, null, collectType);
                }
                return;
            }
            if (SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS_PURCHASE.getCode().equals(specialTypeMark) || SpecialTypeMarkEnum.SELFPRODUCED_AGRICULTURAL_PRODUCTS_SALES.getCode().equals(specialTypeMark)) {
                this.setAgricFiled(mainObject, invoiceObject, null, "2", collectType);
                return;
            }
            this.setAgricFiled(mainObject, invoiceObject, null, null, collectType);
        }
    }

    private boolean getAgricItems(DynamicObject invoiceObject, boolean isSelfproduced) {
        DynamicObjectCollection collection = (DynamicObjectCollection)invoiceObject.get("items");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return false;
        }
        boolean isAgricItems = false;
        for (DynamicObject item : collection) {
            boolean agricItems;
            boolean zeroTaxFlag = true;
            if (isSelfproduced) {
                zeroTaxFlag = "1".equals(item.getString("zerotaxrate_flag"));
                agricItems = DeductionUtils.isAgricItems(item.getString("goods_code"));
            } else {
                agricItems = DeductionUtils.isAgricItems(item.getString("goods_code"), item.getString("tax_rate"));
            }
            if (!agricItems || !zeroTaxFlag) continue;
            isAgricItems = agricItems;
            break;
        }
        return isAgricItems;
    }

    private void setAgricFiled(DynamicObject mainObject, DynamicObject invoiceObject, String purchaseTicket, String agricHandleStatus, String collectType) {
        mainObject.set("purchase_ticket", (Object)purchaseTicket);
        mainObject.set("agric_handle_status", (Object)agricHandleStatus);
        invoiceObject.set("purchase_ticket", (Object)purchaseTicket);
        invoiceObject.set("agric_handle_status", (Object)agricHandleStatus);
        if ("1".equals(purchaseTicket) || "2".equals(agricHandleStatus)) {
            boolean isBlue;
            String invoiceStatus = mainObject.getString("invoice_status");
            boolean invoiceStatusFlag = "0".equals(invoiceStatus) || "7".equals(invoiceStatus);
            boolean bl = isBlue = BigDecimalUtil.transDecimal(mainObject.get("invoice_amount")).compareTo(BigDecimal.ZERO) >= 0;
            if (!invoiceStatusFlag || !isBlue) {
                mainObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
                invoiceObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
                InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            } else {
                String deductionFlag = InvoiceSaveService.getBillDeductionFlag(mainObject, collectType);
                if (deductionFlag == null) {
                    mainObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"1");
                    invoiceObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"1");
                    String authenticateFlag = mainObject.getString("authenticate_flag");
                    if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                        mainObject.set("authenticate_flag", (Object)"0");
                        invoiceObject.set("authenticate_flag", (Object)"0");
                    }
                    InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
                }
            }
            this.updateTranFlag(mainObject, invoiceObject);
        }
        if ("2".equals(agricHandleStatus)) {
            BigDecimal effectiveTaxAmount = mainObject.getBigDecimal("invoice_amount").multiply(new BigDecimal("0.09"));
            mainObject.set("effective_tax_amount", (Object)BigDecimalUtil.format(effectiveTaxAmount));
            invoiceObject.set("effective_tax_amount", (Object)BigDecimalUtil.format(effectiveTaxAmount));
            mainObject.set("deduction_purpose", (Object)"1");
            invoiceObject.set("deduction_purpose", (Object)"1");
            this.updateTranFlag(mainObject, invoiceObject);
        }
    }

    private void updateTranFlag(DynamicObject mainObject, DynamicObject invoiceObject) {
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType)) {
            mainObject.set("transport_deduction", null);
            invoiceObject.set("transport_deduction", null);
        }
    }

    public void setUserAndOrg(String userId, String orgId, Long rimUser, DynamicObject mainDynamicObject, boolean saveUserRelation) {
        Iterator item;
        String pk;
        if (saveUserRelation) {
            DynamicObjectCollection userEntry = mainDynamicObject.getDynamicObjectCollection("collect_user_entry");
            Boolean curUserFlag = Boolean.FALSE;
            if (!CollectionUtils.isEmpty((Collection)userEntry)) {
                for (DynamicObject userObj : userEntry) {
                    DynamicObject user = userObj.getDynamicObject("collect_user");
                    if (null == user) continue;
                    pk = user.getPkValue() + "";
                    Long rim_user = userObj.getLong("rim_user");
                    if (!pk.equals(userId) || !rim_user.equals(rimUser)) continue;
                    userObj.set("collect_user_org", (Object)orgId);
                    curUserFlag = Boolean.TRUE;
                    break;
                }
            }
            if (!curUserFlag.booleanValue()) {
                item = userEntry.addNew();
                item.set("collect_user", userId);
                item.set("rim_user", rimUser);
                item.set("collect_user_org", orgId);
                item.set("collect_user_time", new Date());
            }
        }
        DynamicObjectCollection orgEntry = mainDynamicObject.getDynamicObjectCollection("collect_org_entry");
        Boolean curOrgFlag = Boolean.FALSE;
        if (!CollectionUtils.isEmpty((Collection)orgEntry)) {
            for (DynamicObject orgObj : orgEntry) {
                DynamicObject org = orgObj.getDynamicObject("collect_org");
                if (org == null || !(pk = org.getPkValue() + "").equals(orgId)) continue;
                orgObj.set("collect_org_user", (Object)userId);
                curOrgFlag = Boolean.TRUE;
                break;
            }
        }
        if (!curOrgFlag.booleanValue()) {
            item = orgEntry.addNew();
            item.set("collect_org_user", userId);
            item.set("collect_org", orgId);
            item.set("collect_org_time", new Date());
        }
    }

    private boolean needUserRelation(JSONObject invoiceJson) {
        return !"0".equals(invoiceJson.get((Object)"needUserRelation"));
    }

    public static void notSetUserRelationIfExist(JSONObject invoiceJson) {
        String serialNo = invoiceJson.getString("serialNo");
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return;
        }
        invoiceJson.put("needUserRelation", (Object)"1");
        DynamicObject mainDynamicObject = CommonUtils.loadSingle("rim_invoice", new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
        if (mainDynamicObject == null) {
            DynamicObjectCollection userEntry;
            String oldSerialNo = invoiceJson.getString("oldSerialNo");
            if (oldSerialNo == null) {
                return;
            }
            DynamicObject oldMainDynamicObject = CommonUtils.loadSingle("rim_invoice", new QFilter[]{new QFilter("serial_no", "=", (Object)oldSerialNo)});
            if (oldMainDynamicObject != null && !CollectionUtils.isEmpty((Collection)(userEntry = oldMainDynamicObject.getDynamicObjectCollection("collect_user_entry")))) {
                invoiceJson.put("needUserRelation", (Object)"0");
            }
            return;
        }
        DynamicObjectCollection userEntry = mainDynamicObject.getDynamicObjectCollection("collect_user_entry");
        if (!CollectionUtils.isEmpty((Collection)userEntry)) {
            invoiceJson.put("needUserRelation", (Object)"0");
        }
    }

    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        String invoiceNo = invoiceJson.getString("invoiceNo");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)this.invoiceType);
        QFilter invoiceCodeFilter = null;
        if (!InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(this.invoiceType)) {
            invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceJson.getString("invoiceCode")));
        } else {
            invoiceTypeFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()});
        }
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        DynamicObject idObject = null;
        String serialNo = null;
        DynamicObject serialObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"serial_no,delete", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter});
        if (serialObject != null) {
            serialNo = serialObject.getString("serial_no");
        }
        idObject = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(this.invoiceType) ? QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceNoFilter}) : QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            String invoice_no = invoiceJson.getString("invoiceNo");
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            if (!InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(this.invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType)) {
                invoiceDynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
            }
            invoiceDynamicObject.set("invoice_no", (Object)invoice_no);
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                this.setSerialNo(invoiceJson, invoiceDynamicObject);
            } else {
                invoiceDynamicObject.set("serial_no", (Object)serialNo);
            }
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
            if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                invoiceDynamicObject.set("serial_no", (Object)serialNo);
            }
            invoiceDynamicObject.set("invoice_type", (Object)this.invoiceType);
        }
        return invoiceDynamicObject;
    }

    public void setMainInvoiceInfo(DynamicObject invoiceObject) {
        String is_revise;
        DynamicObject voucherObject;
        Map<String, Object> invoiceMap = DynamicObjectUtil.dynamicObjectToMap(invoiceObject);
        String invoiceStatus = (String)invoiceMap.get("invoice_status");
        String expenseStatus = (String)invoiceMap.get("expense_status");
        String checkStatus = (String)invoiceMap.get("check_status");
        String originalState = (String)invoiceMap.get("original_state");
        if (!"1".equals(originalState)) {
            originalState = "0";
            if (invoiceMap.containsKey("original_state")) {
                invoiceObject.set("original_state", (Object)"0");
            }
        }
        String authenticateFlag = invoiceObject.getString("authenticate_flag");
        String transportDeduction = (String)invoiceMap.get("transport_deduction");
        StringBuilder infoString = new StringBuilder();
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(invoiceObject.get("invoice_type"));
        String awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
        if (StringUtils.isNotEmpty((CharSequence)awsType)) {
            infoString.append("ty_").append(awsType).append(',');
        }
        if ((voucherObject = QueryServiceHelper.queryOne((String)"rim_invoice_voucher", (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)invoiceObject.getString("serial_no"))})) != null) {
            infoString.append("vc_1").append(',');
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceStatus)) {
            invoiceStatus = TaxInvoiceConvertUtil.getInvoiceStateByCN(invoiceStatus);
            infoString.append("st_").append(invoiceStatus).append(',');
        }
        if (StringUtils.isNotEmpty((CharSequence)expenseStatus)) {
            infoString.append("ex_").append(expenseStatus).append(',');
        } else {
            infoString.append("ex_").append('1').append(',');
        }
        if (InputInvoiceTypeEnum.needCheck(invoiceType).booleanValue()) {
            if (StringUtils.isNotEmpty((CharSequence)checkStatus)) {
                infoString.append("ch_").append(checkStatus).append(',');
            }
        } else {
            invoiceObject.set("check_status", (Object)"1");
        }
        if (StringUtils.isNotEmpty((CharSequence)originalState)) {
            infoString.append("or_").append(originalState).append(',');
        }
        if (StringUtils.isNotEmpty((CharSequence)authenticateFlag)) {
            infoString.append("au_").append(authenticateFlag).append(',');
        }
        if (StringUtils.isNotEmpty((CharSequence)transportDeduction)) {
            infoString.append("td_").append(transportDeduction).append(',');
        }
        if ("1".equals(is_revise = (String)invoiceMap.get("is_revise"))) {
            infoString.append("mo_1").append(',');
        } else if (invoiceMap.containsKey("is_revise")) {
            invoiceObject.set("is_revise", (Object)"0");
        }
        invoiceObject.set("invoice_info", (Object)infoString.toString());
    }

    public void clearUncheckInvoice(DynamicObject invoiceDynamic) {
        if (InvoiceConvertUtils.isVatInvoiceType(this.invoiceType) && StringUtils.isNotEmpty((CharSequence)invoiceDynamic.getString("serial_no"))) {
            InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
            invoiceCollectService.deleteUncheckInvoice(invoiceDynamic.getString("invoice_code"), invoiceDynamic.getString("invoice_no"));
        }
    }

    public void saveFileSync(String tenantNo, String serialNo, JSONObject invoiceJson, boolean override) {
        String imageUrlTemp;
        String pdfUrlTemp;
        String fileType;
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return;
        }
        String snapshotUrl = invoiceJson.getString("snapshotUrl");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject mainDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"original_state,original_time,continuous_no,company_seal", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        DynamicObject fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id,original_state,snapshot_url", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        if (fileIdDynamicObject == null) {
            fileIdDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
            fileIdDynamicObject.set("tenant_no", (Object)tenantNo);
            fileIdDynamicObject.set("serial_no", (Object)serialNo);
            fileIdDynamicObject.set("create_time", (Object)new Date());
            fileIdDynamicObject.set("update_time", (Object)new Date());
        } else {
            fileIdDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileIdDynamicObject.get("id"), (String)"rim_invoice_file");
            fileIdDynamicObject.set("update_time", (Object)new Date());
        }
        String fileState = fileIdDynamicObject.getString("original_state");
        String originalState = "0";
        if (mainDynamicObject != null) {
            originalState = mainDynamicObject.getString("original_state");
        }
        String fileSnapshotUrl = fileIdDynamicObject.getString("snapshot_url");
        if (StringUtils.isEmpty((CharSequence)snapshotUrl)) {
            if (!StringUtils.isEmpty((CharSequence)fileSnapshotUrl)) {
                if (mainDynamicObject != null) {
                    invoiceJson.put("originalState", (Object)mainDynamicObject.getString("original_state"));
                    invoiceJson.put("originalTime", (Object)DynamicObjectUtil.fieldToString(mainDynamicObject.get("original_time"), "yyyy-MM-dd HH:mm:ss"));
                    invoiceJson.put("continuousNo", (Object)mainDynamicObject.getString("continuous_no"));
                    invoiceJson.put("companySeal", (Object)mainDynamicObject.getString("company_seal"));
                }
                return;
            }
        } else if ("1".equals(originalState) && !StringUtils.isEmpty((CharSequence)fileSnapshotUrl)) {
            boolean stateFlag_2;
            boolean stateFlag = "1".equals(fileState);
            String invoiceOriginalState = invoiceJson.getString("originalState");
            boolean bl = stateFlag_2 = !"1".equals(fileState) && !"1".equals(invoiceOriginalState);
            if (stateFlag || stateFlag_2) {
                if (mainDynamicObject != null) {
                    invoiceJson.put("originalState", (Object)mainDynamicObject.getString("original_state"));
                    invoiceJson.put("originalTime", (Object)DynamicObjectUtil.fieldToString(mainDynamicObject.get("original_time"), "yyyy-MM-dd HH:mm:ss"));
                    invoiceJson.put("continuousNo", (Object)mainDynamicObject.getString("continuous_no"));
                    invoiceJson.put("companySeal", (Object)mainDynamicObject.getString("company_seal"));
                }
                return;
            }
        }
        if (StringUtils.isEmpty((CharSequence)(fileType = invoiceJson.getString("fileType")))) {
            fileType = "2";
        }
        fileIdDynamicObject.set("rotation_angle", (Object)invoiceJson.getBigDecimal("rotationAngle"));
        fileIdDynamicObject.set("region", (Object)invoiceJson.getString("region"));
        fileIdDynamicObject.set("pixel", (Object)invoiceJson.getString("pixel"));
        String kdCloudUrlTemp = invoiceJson.getString("kdcloudUrl");
        if (StringUtils.isEmpty((CharSequence)kdCloudUrlTemp)) {
            kdCloudUrlTemp = invoiceJson.getString("localUrl");
        }
        if (StringUtils.isNotEmpty((CharSequence)kdCloudUrlTemp) && fileType.equals("pdf")) {
            fileIdDynamicObject.set("pdf_url", (Object)kdCloudUrlTemp);
        } else if (StringUtils.isNotEmpty((CharSequence)kdCloudUrlTemp) && fileType.equals("ofd")) {
            fileIdDynamicObject.set("ofd_url", (Object)kdCloudUrlTemp);
        } else {
            fileIdDynamicObject.set("image_url", (Object)kdCloudUrlTemp);
        }
        fileIdDynamicObject.set("snapshot_url", (Object)invoiceJson.getString("snapshotUrl"));
        String ofdUrlTemp = invoiceJson.getString("ofdUrl");
        if (StringUtils.isNotEmpty((CharSequence)ofdUrlTemp)) {
            fileIdDynamicObject.set("ofd_url", (Object)ofdUrlTemp);
        }
        if (StringUtils.isNotEmpty((CharSequence)(pdfUrlTemp = invoiceJson.getString("pdfUrl")))) {
            fileIdDynamicObject.set("pdf_url", (Object)pdfUrlTemp);
        }
        if (StringUtils.isNotEmpty((CharSequence)(imageUrlTemp = invoiceJson.getString("imageUrl")))) {
            fileIdDynamicObject.set("image_url", (Object)imageUrlTemp);
        }
        this.setFileType(fileIdDynamicObject);
        CacheHelper.put("FileCache:" + serialNo, JSON.toJSONString(DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject)), 300);
        DynamicObject finalFileIdDynamicObject = fileIdDynamicObject;
        String cacheFileType = CacheHelper.get("FileType" + serialNo);
        if ("1".equals(cacheFileType)) {
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"InvoiceSaveService.saveFileSync", () -> {
            String fileOriginalState = StringUtils.isEmpty((CharSequence)invoiceJson.getString("originalState")) ? "0" : invoiceJson.getString("originalState");
            CacheHelper.put("FileType" + serialNo, fileOriginalState, 20);
            finalFileIdDynamicObject.set("original_state", (Object)invoiceJson.getString("originalState"));
            if (StringUtils.isEmpty((CharSequence)snapshotUrl)) {
                try {
                    FileConvertResult fileConvertResult = this.generatePdf(tenantNo, serialNo);
                    if (fileConvertResult == null) {
                        return;
                    }
                    logger.info("\u751f\u6210\u5e95\u8d26\u6570\u636e{},{},{}", new Object[]{serialNo, fileConvertResult.getPdfUrl(), fileConvertResult.getImageUrl()});
                    invoiceJson.put("imageUrl", (Object)fileConvertResult.getImageUrl());
                    invoiceJson.put("ofdUrl", (Object)fileConvertResult.getOfdUrl());
                    invoiceJson.put("pdfUrl", (Object)fileConvertResult.getPdfUrl());
                    invoiceJson.put("snapshotUrl", (Object)fileConvertResult.getSnapshotUrl());
                    invoiceJson.put("localUrl", (Object)fileConvertResult.getPdfUrl());
                    invoiceJson.put("kdcloudUrl", (Object)fileConvertResult.getPdfUrl());
                    invoiceJson.put("downloadUrl", (Object)fileConvertResult.getPdfUrl());
                    invoiceJson.put("originalState", (Object)"2");
                    finalFileIdDynamicObject.set("pdf_url", (Object)fileConvertResult.getPdfUrl());
                    finalFileIdDynamicObject.set("image_url", (Object)fileConvertResult.getImageUrl());
                    finalFileIdDynamicObject.set("snapshot_url", (Object)fileConvertResult.getSnapshotUrl());
                    finalFileIdDynamicObject.set("original_state", (Object)"2");
                }
                catch (Exception e) {
                    logger.error("\u751f\u6210\u5e95\u8d26\u6570\u636e\u5931\u8d25{}", (Object)serialNo, (Object)e);
                    return;
                }
            } else {
                boolean downFile;
                String ofdUrl = finalFileIdDynamicObject.getString("ofd_url");
                String kdCloudUrl = invoiceJson.getString("kdcloudUrl");
                if (StringUtils.isEmpty((CharSequence)kdCloudUrl)) {
                    kdCloudUrl = invoiceJson.getString("localUrl");
                }
                String snapshot = finalFileIdDynamicObject.getString("snapshot_url");
                boolean bl = downFile = !"0".equals(RimConfigUtils.getConfig("down_invoice_file"));
                if (downFile) {
                    if (!StringUtils.isEmpty((CharSequence)ofdUrl)) {
                        ofdUrl = FileUtils.downLoadAndUpload(ofdUrl, serialNo + "_ofd");
                    }
                    snapshot = FileUtils.downLoadAndUpload(snapshot, serialNo + "_snap");
                    kdCloudUrl = FileUtils.downLoadAndUpload(kdCloudUrl, serialNo + "_kd");
                }
                if (StringUtils.isEmpty((CharSequence)snapshot) && StringUtils.isEmpty((CharSequence)kdCloudUrl) && StringUtils.isEmpty((CharSequence)ofdUrl)) {
                    return;
                }
                if (StringUtils.isNotEmpty((CharSequence)kdCloudUrl) && kdCloudUrl.endsWith("pdf")) {
                    finalFileIdDynamicObject.set("pdf_url", (Object)kdCloudUrl);
                    finalFileIdDynamicObject.set("image_url", (Object)snapshot);
                } else if (StringUtils.isNotEmpty((CharSequence)kdCloudUrl) && kdCloudUrl.endsWith("ofd")) {
                    finalFileIdDynamicObject.set("ofd_url", (Object)kdCloudUrl);
                    finalFileIdDynamicObject.set("image_url", (Object)snapshot);
                } else if (StringUtils.isNotEmpty((CharSequence)kdCloudUrl)) {
                    finalFileIdDynamicObject.set("image_url", (Object)kdCloudUrl);
                    if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("imageUrl"))) {
                        finalFileIdDynamicObject.set("image_url", (Object)invoiceJson.getString("imageUrl"));
                    }
                }
                this.setFileType(finalFileIdDynamicObject);
                finalFileIdDynamicObject.set("snapshot_url", (Object)snapshot);
                if (StringUtils.isEmpty((CharSequence)finalFileIdDynamicObject.getString("image_url"))) {
                    finalFileIdDynamicObject.set("image_url", (Object)snapshot);
                }
                if (StringUtils.isNotEmpty((CharSequence)ofdUrl)) {
                    finalFileIdDynamicObject.set("original_type", (Object)"4");
                    finalFileIdDynamicObject.set("ofd_url", (Object)ofdUrl);
                }
            }
            logger.info("\u5f02\u6b65\u4e0a\u4f20\u548c\u4fdd\u5b58\u6587\u4ef6{},{},{},{}", new Object[]{serialNo, finalFileIdDynamicObject.getString("snapshot_url"), finalFileIdDynamicObject.getString("image_url"), finalFileIdDynamicObject.getString("pdf_url")});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finalFileIdDynamicObject});
            CacheHelper.remove("FileCache:" + serialNo);
            CacheHelper.remove("FileType" + serialNo);
        });
    }

    private void setFileType(DynamicObject fileObject) {
        if (!StringUtils.isEmpty((CharSequence)fileObject.getString("ofd_url"))) {
            fileObject.set("original_type", (Object)"4");
        } else if (!StringUtils.isEmpty((CharSequence)fileObject.getString("pdf_url"))) {
            fileObject.set("original_type", (Object)"1");
        } else {
            fileObject.set("original_type", (Object)"2");
        }
    }

    public void setDeductionFieldValue(Long invoiceType, DynamicObject dynamicObject, JSONObject invoiceJson) {
        if (InputInvoiceTypeEnum.canDeduction(invoiceType).booleanValue()) {
            boolean over;
            String deductionFlag = DeductionConstant.canBeDeductionForTaxInvoiceByInv(invoiceJson);
            String authenticate_flag = dynamicObject.getString("authenticate_flag");
            Boolean newInvoice = this.checkIdIsNull(dynamicObject.getPkValue());
            String prevCheckStatus = invoiceJson.getString("prev_check_status");
            String checkStatus = invoiceJson.getString("checkStatus");
            boolean bl = over = newInvoice != false || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) || !"1".equals(prevCheckStatus) && Arrays.asList(CheckContant.getSuccessStatus()).contains(checkStatus);
            if ("1".equals(deductionFlag) && BigDecimal.ZERO.compareTo(dynamicObject.getBigDecimal("effective_tax_amount")) == 0 && over && ("0".equals(authenticate_flag) || StringUtils.isEmpty((CharSequence)authenticate_flag))) {
                BigDecimal totalTaxAmount;
                try {
                    totalTaxAmount = dynamicObject.getBigDecimal("total_tax_amount");
                }
                catch (Exception e) {
                    totalTaxAmount = dynamicObject.getBigDecimal("tax_amount");
                }
                dynamicObject.set("effective_tax_amount", (Object)totalTaxAmount);
            }
            if ((InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) && ("0".equals(authenticate_flag) || StringUtils.isEmpty((CharSequence)authenticate_flag))) {
                dynamicObject.set("effective_tax_amount", dynamicObject.get("total_tax_amount"));
            }
        }
        String allowDeduction = invoiceJson.getString("allowDeduction");
        String authenticateFlag = invoiceJson.getString("authenticateFlag");
        if ("1".equals(allowDeduction) && (InputInvoiceTypeEnum.canDeduction(invoiceType).booleanValue() || StringUtils.isNotEmpty((CharSequence)authenticateFlag))) {
            if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("authenticate_flag"))) {
                    dynamicObject.set("authenticate_flag", (Object)"0");
                }
                return;
            }
            Date authenticateTime = invoiceJson.getDate("authenticateTime");
            if (authenticateTime == null) {
                if ("2".equals(authenticateFlag)) {
                    authenticateTime = invoiceJson.getDate("selectAuthenticateTime");
                } else if ("3".equals(authenticateFlag)) {
                    authenticateTime = invoiceJson.getDate("scanAuthenticateTime");
                }
            }
            if (!"0".equals(authenticateFlag)) {
                if (authenticateTime != null) {
                    dynamicObject.set("authenticate_time", (Object)authenticateTime);
                }
                if (invoiceJson.getDate("selectTime") != null) {
                    dynamicObject.set("select_time", (Object)invoiceJson.getDate("selectTime"));
                }
                if (!StringUtils.isEmpty((CharSequence)invoiceJson.getString("taxPeriod"))) {
                    dynamicObject.set("tax_period", (Object)DateUtils.stringToDate(invoiceJson.getString("taxPeriod"), "yyyyMM"));
                } else if (!StringUtils.isEmpty((CharSequence)invoiceJson.getString("tax_period"))) {
                    dynamicObject.set("tax_period", (Object)DateUtils.stringToDate(invoiceJson.getString("tax_period"), "yyyyMM"));
                }
                String deductionPurpose = invoiceJson.getString("deductionPurpose");
                if (StringUtils.isNotEmpty((CharSequence)deductionPurpose)) {
                    dynamicObject.set("deduction_purpose", (Object)deductionPurpose);
                }
                if ("2".equals(deductionPurpose)) {
                    if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("notDeductibleType"))) {
                        dynamicObject.set("not_deductible_type", (Object)invoiceJson.getString("notDeductibleType"));
                    }
                } else {
                    dynamicObject.set("not_deductible_type", null);
                }
            } else if ("0".equals(authenticateFlag)) {
                String oldAuthenticateFlag = dynamicObject.getString("authenticate_flag");
                Date taxPeriod = dynamicObject.getDate("tax_period");
                if ("inputInit".equals(invoiceJson.getString("downResource")) && taxPeriod != null) {
                    boolean initDataNotUpdate;
                    Date startDate = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(new Date(), -1));
                    boolean bl = initDataNotUpdate = ("1".equals(oldAuthenticateFlag) || "2".equals(oldAuthenticateFlag) || "3".equals(oldAuthenticateFlag)) && taxPeriod.compareTo(startDate) >= 0;
                    if (initDataNotUpdate) {
                        if ("1".equals(oldAuthenticateFlag) && StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("effectiveTaxAmount"))) {
                            dynamicObject.set("effective_tax_amount", (Object)invoiceJson.getBigDecimal("effectiveTaxAmount"));
                        }
                        return;
                    }
                }
                String invoiceStatus = invoiceJson.getString("invoiceStatus");
                if ("4".equals(oldAuthenticateFlag) && !InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && ("0".equals(invoiceStatus) || "7".equals(invoiceStatus))) {
                    if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("effectiveTaxAmount"))) {
                        dynamicObject.set("effective_tax_amount", (Object)invoiceJson.getBigDecimal("effectiveTaxAmount"));
                    }
                    return;
                }
                dynamicObject.set("authenticate_time", null);
                dynamicObject.set("select_time", null);
                dynamicObject.set("tax_period", null);
                dynamicObject.set("deduction_purpose", (Object)"");
                dynamicObject.set("not_deductible_type", null);
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("effectiveTaxAmount"))) {
                dynamicObject.set("effective_tax_amount", (Object)invoiceJson.getBigDecimal("effectiveTaxAmount"));
            }
            dynamicObject.set("authenticate_flag", (Object)authenticateFlag);
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("manageStatus"))) {
                dynamicObject.set("manage_status", (Object)invoiceJson.getString("manageStatus"));
            }
        }
        if ("1".equals(allowDeduction) && InputInvoiceTypeEnum.canTransportDeduction(invoiceType).booleanValue()) {
            String transportDeduction = invoiceJson.getString("transportDeduction");
            if (StringUtils.isEmpty((CharSequence)transportDeduction)) {
                if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("transport_deduction"))) {
                    return;
                }
                transportDeduction = "0";
            }
            dynamicObject.set("transport_deduction", (Object)transportDeduction);
            if (!"0".equals(transportDeduction)) {
                dynamicObject.set("authenticate_time", (Object)new Date());
                if (!StringUtils.isEmpty((CharSequence)invoiceJson.getString("taxPeriod"))) {
                    dynamicObject.set("tax_period", (Object)DateUtils.stringToDate(invoiceJson.getString("taxPeriod"), "yyyyMM"));
                } else if (!StringUtils.isEmpty((CharSequence)invoiceJson.getString("tax_period"))) {
                    dynamicObject.set("tax_period", (Object)DateUtils.stringToDate(invoiceJson.getString("tax_period"), "yyyyMM"));
                }
                Object totalTaxAmount = invoiceJson.get((Object)"totalTaxAmount");
                if (totalTaxAmount == null) {
                    totalTaxAmount = invoiceJson.get((Object)"taxAmount");
                }
                dynamicObject.set("effective_tax_amount", totalTaxAmount);
            } else {
                dynamicObject.set("authenticate_time", null);
                dynamicObject.set("tax_period", null);
                dynamicObject.set("effective_tax_amount", null);
            }
        }
    }

    public String getBillNo(JSONObject invoiceJson) {
        String invoiceCode = invoiceJson.getString("invoiceCode");
        String billno = StringUtils.isNotBlank((CharSequence)invoiceCode) ? invoiceCode + "-" + invoiceJson.getString("invoiceNo") : invoiceJson.getString("invoiceNo");
        if (billno != null && billno.length() > 36) {
            billno = billno.substring(0, 36);
        }
        return billno;
    }

    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        this.setInvoiceValue(invoiceJson, dynamicObject);
    }

    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
    }

    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        Long receiverId;
        Integer salelistSum;
        this.setInvoiceValue(invoiceJson, dynamicObject);
        String salelistComplete = invoiceJson.getString("salelistComplete");
        if (StringUtils.isNotEmpty((CharSequence)salelistComplete)) {
            dynamicObject.set("salelist_complete", (Object)invoiceJson.getString("salelistComplete"));
        }
        if ((salelistSum = invoiceJson.getInteger("salelistSum")) != null) {
            dynamicObject.set("salelist_sum", (Object)salelistSum);
        } else {
            dynamicObject.set("salelist_sum", (Object)0);
        }
        if (InputInvoiceTypeEnum.isVatType(this.invoiceType) && StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
        this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), dynamicObject);
        if (InvoiceConvertUtils.isInvoiceAmountInvoiceType(this.invoiceType)) {
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoiceAmount"))) {
                dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceAmount", BigDecimal.class));
            } else {
                dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "amount", BigDecimal.class));
            }
        } else {
            dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        }
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("invoice_status", (Object)invoiceJson.getString("invoiceStatus"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalTaxAmount"))) {
            dynamicObject.set("total_tax_amount", (Object)this.getObject(invoiceJson, "totalTaxAmount", BigDecimal.class));
        } else {
            dynamicObject.set("total_tax_amount", (Object)this.getObject(invoiceJson, "taxAmount", BigDecimal.class));
        }
        dynamicObject.set("buyer_name", (Object)InvoiceSaveService.subStringByLength(invoiceJson.getString("buyerName"), 150));
        dynamicObject.set("buyer_tax_no", (Object)InvoiceSaveService.subStringByLength(invoiceJson.getString("buyerTaxNo"), 150));
        if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("buyerTaxNo"))) {
            dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerIdNo"));
        }
        dynamicObject.set("saler_name", (Object)invoiceJson.getString("salerName"));
        dynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
        if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("salerTaxNo"))) {
            dynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerIdNo"));
        }
        dynamicObject.set("total_amount", (Object)this.getObject(invoiceJson, "totalAmount", BigDecimal.class));
        if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("is_revise"))) {
            dynamicObject.set("is_revise", (Object)"0");
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("companySeal"))) {
            dynamicObject.set("company_seal", (Object)invoiceJson.getString("companySeal"));
        } else {
            String company_seal = dynamicObject.getString("company_seal");
            if (StringUtils.isEmpty((CharSequence)company_seal)) {
                dynamicObject.set("company_seal", (Object)"0");
            }
        }
        if ("1".equals(invoiceJson.getString("continuousNo"))) {
            dynamicObject.set("continuous_no", (Object)"1");
        } else {
            dynamicObject.set("continuous_no", (Object)"0");
        }
        String originalState = dynamicObject.getString("original_state");
        Date original_time = dynamicObject.getDate("original_time");
        long receiver = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("receiver"));
        if (receiver <= 0L) {
            RequestContext request = RequestContext.get();
            receiver = Long.parseLong(request.getUserId());
        }
        if ((receiverId = TenantUtils.getUserId(invoiceJson.getString("receiver"))) > 0L) {
            receiver = receiverId;
        }
        if (!this.isAllowSave(invoiceJson) && "1".equals(invoiceJson.getString("originalState")) && !"1".equals(dynamicObject.getString("original_state"))) {
            originalState = "0";
            InvoiceSaveService.setExtInfo(dynamicObject, "prevOriginalState", "1");
            InvoiceSaveService.setExtInfo(dynamicObject, "prevReceiver", receiver + "");
            dynamicObject.set("original_state", (Object)"0");
            invoiceJson.put("originalState", (Object)"0");
        } else {
            InvoiceSaveService.setExtInfo(dynamicObject, "prevOriginalState", null);
            InvoiceSaveService.setExtInfo(dynamicObject, "prevReceiver", null);
        }
        if ("1".equals(originalState)) {
            if (original_time == null) {
                dynamicObject.set("original_time", (Object)InvoiceSaveService.getDate(invoiceJson, "originalTime"));
            } else if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("originalTime"))) {
                dynamicObject.set("original_time", (Object)InvoiceSaveService.getDate(invoiceJson, "originalTime"));
            }
            if ("1".equals(invoiceJson.getString("excel_all_invoice_import"))) {
                this.replenishReceiver(invoiceJson, dynamicObject);
            } else {
                dynamicObject.set("receiver", (Object)receiver);
            }
        } else {
            dynamicObject.set("original_time", null);
            dynamicObject.set("receiver", (Object)0);
        }
        this.setEtaxInvoiceNo(invoiceJson, dynamicObject);
        this.setSourceAndRiskLevel(invoiceJson, dynamicObject);
        dynamicObject.set("proxy_mark", (Object)invoiceJson.getString("proxyMark"));
        dynamicObject.set("dest_area", (Object)invoiceJson.getString("destArea"));
        dynamicObject.set("source_area", (Object)invoiceJson.getString("sourceArea"));
        dynamicObject.set("collect_type", (Object)invoiceJson.getString("collect_type"));
        this.setSpecialTypeMark(dynamicObject, invoiceJson);
    }

    public void setSpecialTypeMark(DynamicObject dynamicObject, JSONObject invoiceJson) {
        if (dynamicObject == null || invoiceJson == null) {
            return;
        }
        if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(this.invoiceType)) {
            dynamicObject.set("special_type_mark", (Object)SpecialTypeMarkEnum.USERED_CAR.getCode());
        } else if (InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(this.invoiceType)) {
            dynamicObject.set("special_type_mark", (Object)SpecialTypeMarkEnum.MOTOR_VEHICLE.getCode());
        } else if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(this.invoiceType)) {
            dynamicObject.set("special_type_mark", (Object)SpecialTypeMarkEnum.TOLL_FEE.getCode());
        } else if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("specialTypeMark"))) {
            dynamicObject.set("special_type_mark", (Object)invoiceJson.getString("specialTypeMark"));
        }
    }

    public void setSalerType(DynamicObject dynamicObject, JSONObject invoiceJson) {
        if (dynamicObject == null || invoiceJson == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("salerType"))) {
            dynamicObject.set("saler_type", (Object)invoiceJson.getString("salerType"));
        }
    }

    public void setInvoiceDate(Date invoiceDate, DynamicObject dynamicObject) {
        this.setInvoiceDate(invoiceDate, dynamicObject, "invoice_date");
    }

    public void setInvoiceDate(Date invoiceDate, DynamicObject dynamicObject, String filedKey) {
        boolean notUpdate;
        if (dynamicObject == null || StringUtils.isBlank((CharSequence)filedKey)) {
            return;
        }
        Date preInvoiceDate = dynamicObject.getDate(filedKey);
        if (preInvoiceDate == null || !DateUtils.isTimeZero(invoiceDate)) {
            dynamicObject.set(filedKey, (Object)invoiceDate);
            return;
        }
        boolean bl = notUpdate = preInvoiceDate != null && DateUtils.format(preInvoiceDate).equals(DateUtils.format(invoiceDate)) && !DateUtils.isTimeZero(preInvoiceDate);
        if (!notUpdate) {
            dynamicObject.set(filedKey, (Object)invoiceDate);
        }
    }

    private void replenishReceiver(JSONObject invoiceJson, DynamicObject dynamicObject) {
        boolean updateFlag;
        if (invoiceJson.containsKey((Object)"originalState") && "1".equals(invoiceJson.getString("originalState")) && invoiceJson.containsKey((Object)"receiver") && (updateFlag = this.getUpdateFlag(dynamicObject))) {
            String receiver = invoiceJson.getString("receiver");
            Long receiverId = 0L;
            if (!StringUtils.isBlank((CharSequence)receiver)) {
                receiverId = TenantUtils.getUserId(receiver);
            }
            dynamicObject.set("receiver", (Object)receiverId);
        }
    }

    private boolean getUpdateFlag(DynamicObject dynamicObject) {
        String tenantNo = TenantUtils.getTenantNo();
        String serialNo = dynamicObject.getString("serial_no");
        QFilter invoiceFilter = new QFilter("serial_no", "=", (Object)serialNo).and("tenant_no", "=", (Object)tenantNo);
        DynamicObject checkObj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"expense_status", (QFilter[])invoiceFilter.toArray());
        if (checkObj != null) {
            String expenseStatus = checkObj.getString("expense_status");
            return "1".equals(expenseStatus) || "30".equals(expenseStatus);
        }
        return true;
    }

    public void setSourceAndRiskLevel(JSONObject invoiceJson, DynamicObject mainDynamicObject) {
        String invoiceSource = DeductionUtils.convertInvoiceSource(invoiceJson.getString("invoiceSource"));
        String invoiceRiskLevel = DeductionUtils.convertInvoiceRiskLevel(invoiceJson.getString("invoiceRiskLevel"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceSource)) {
            mainDynamicObject.set("invoice_source", (Object)invoiceSource);
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceRiskLevel)) {
            mainDynamicObject.set("invoice_risk_level", (Object)invoiceRiskLevel);
        }
    }

    public void setEtaxInvoiceNo(JSONObject invoiceJson, DynamicObject mainDynamicObject) {
        String electronicNo = this.getJSONValue(invoiceJson, String.class, "etaxInvoiceNo", "electronicNo");
        Long id = mainDynamicObject.getLong("id");
        if (id == 0L) {
            mainDynamicObject.set("electronic_no", (Object)electronicNo);
        } else {
            String collectType = invoiceJson.getString("collect_type");
            if ((CollectTypeEnum.PC_SHUIPAN.getCode().equals(collectType) || CollectTypeEnum.PC_UPLOAD.getCode().equals(collectType) || CollectTypeEnum.TAX_EXCEL_IMPORT.getCode().equals(collectType)) && !StringUtils.isEmpty((CharSequence)electronicNo)) {
                mainDynamicObject.set("electronic_no", (Object)("-".equals(electronicNo) ? "" : electronicNo));
            }
        }
    }

    public void setInvoiceValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        this.setOrgAndTaxOrg(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_type", (Object)this.invoiceType);
        dynamicObject.set("creator", (Object)InvoiceSaveService.getOperateUser(invoiceJson));
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("billno", (Object)this.getBillNo(invoiceJson));
        dynamicObject.set("aws_serial_no", (Object)invoiceJson.getString("serialNo"));
        if (dynamicObject.get("createtime") == null) {
            dynamicObject.set("createtime", (Object)InvoiceSaveService.getDate(invoiceJson, "billCreateTime1"));
        }
        String originalState = invoiceJson.getString("originalState");
        if (this.isAllowSave(invoiceJson)) {
            if ("1".equals(originalState)) {
                dynamicObject.set("original_state", (Object)"1");
            }
            if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("original_state"))) {
                dynamicObject.set("original_state", (Object)"0");
            }
            if ("1".equals(invoiceJson.getString("excel_all_invoice_import")) && "0".equals(originalState)) {
                dynamicObject.set("original_state", (Object)"0");
            }
        } else {
            String original_state = dynamicObject.getString("original_state");
            if (!"1".equals(original_state)) {
                dynamicObject.set("original_state", (Object)"0");
            }
        }
        if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("expense_status"))) {
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("expendStatus"))) {
                dynamicObject.set("expense_status", (Object)invoiceJson.getString("expendStatus"));
            } else {
                dynamicObject.set("expense_status", (Object)"1");
            }
        }
        boolean isShowDown = SysParamUtil.getSysParamByOrgId(RequestContext.get().getOrgId(), "invoicepool_show_down");
        if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("resource")) || !isShowDown && "\u7a0e\u76d8".equals(dynamicObject.getString("resource"))) {
            String sourceSys = invoiceJson.getString("sourceSys");
            if (sourceSys != null) {
                dynamicObject.set("resource", (Object)sourceSys);
            } else {
                dynamicObject.set("resource", (Object)invoiceJson.getString("resource"));
            }
        }
        Date createTime = InvoiceSaveService.getDate(invoiceJson, "billCreateTime1");
        this.setDelete(invoiceJson, dynamicObject, createTime);
        dynamicObject.set("modifier", (Object)InvoiceSaveService.getOperateUser(invoiceJson));
    }

    private void setDelete(JSONObject invoiceJson, DynamicObject dynamicObject, Date createTime) {
        String oldDelete = dynamicObject.getString("delete");
        String userDelete = invoiceJson.getString("delete");
        String invoiceSaveFrom = invoiceJson.getString(InvoiceSaveConstant.INVOICE_SAVE_FROM);
        if ("1".equals(oldDelete)) {
            dynamicObject.set("delete", (Object)oldDelete);
        } else if (StringUtils.isNotEmpty((CharSequence)userDelete) && InputInvoiceConstant.checkDeleteValidity(userDelete)) {
            dynamicObject.set("delete", (Object)userDelete);
        } else if (StringUtils.isEmpty((CharSequence)oldDelete)) {
            dynamicObject.set("delete", (Object)"1");
        } else if ("99".equals(userDelete)) {
            dynamicObject.set("delete", (Object)oldDelete);
        } else {
            boolean updagteDelete;
            boolean bl = updagteDelete = "2".equals(oldDelete) && InvoiceSaveConstant.INVOICE_SAVE_FROM_VALUE.equals(invoiceSaveFrom);
            if (!updagteDelete) {
                dynamicObject.set("delete", (Object)"1");
            }
        }
        if (!"1".equals(oldDelete) && createTime != null) {
            dynamicObject.set("createtime", (Object)createTime);
        }
    }

    private void setOrgAndTaxOrg(JSONObject invoiceJson, DynamicObject dynamicObject) {
        Long taxOrg;
        if (dynamicObject == null) {
            return;
        }
        Long orgId = this.getOrgId(invoiceJson);
        if (this.overrideOrg(dynamicObject, invoiceJson).booleanValue()) {
            dynamicObject.set("org", (Object)orgId);
        }
        if ((taxOrg = invoiceJson.getLong("tax_org")) != null) {
            dynamicObject.set("tax_org", (Object)taxOrg);
        } else if (InputInvoiceTypeEnum.needCheck(this.invoiceType).booleanValue()) {
            dynamicObject.set("tax_org", (Object)TenantUtils.getTaxOrgId(null, invoiceJson.getString("buyerTaxNo")));
        } else {
            dynamicObject.set("tax_org", (Object)TenantUtils.getTaxOrgId(orgId));
        }
    }

    public Long getOrgId(JSONObject invoiceJson) {
        Long orgId;
        if (this.newOrgId != null) {
            return this.newOrgId;
        }
        String buyerTaxNo = invoiceJson.getString("buyerTaxNo");
        String replaceOrg = invoiceJson.getString("replaceorg");
        if (!StringUtils.isEmpty((CharSequence)buyerTaxNo) && "1".equals(replaceOrg) && (orgId = TenantUtils.getOrgByNumberOrTaxNo(null, buyerTaxNo)) > 0L) {
            this.newOrgId = orgId;
            return orgId;
        }
        String org_id = invoiceJson.getString("org_id");
        Long orgId2 = null;
        if (StringUtils.isEmpty((CharSequence)org_id)) {
            orgId2 = RequestContext.get().getOrgId();
        } else if (StringUtils.isNumeric((CharSequence)org_id)) {
            orgId2 = Long.parseLong(org_id);
        }
        this.newOrgId = orgId2;
        return orgId2;
    }

    public Boolean checkIdIsNull(Object id) {
        if (id == null) {
            return Boolean.TRUE;
        }
        try {
            return Integer.parseInt(id.toString()) == 0;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    private Boolean overrideOrg(DynamicObject dynamicObject, JSONObject invoiceJson) {
        if (dynamicObject == null) {
            return Boolean.TRUE;
        }
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("org"));
        Long newOrgId = this.getOrgId(invoiceJson);
        if (orgId <= 0L) {
            return Boolean.TRUE;
        }
        logger.info("\u53d1\u7968overrideOrg{},\u65e7\u7ec4\u7ec7{},\u65b0\u7ec4\u7ec7{}", new Object[]{dynamicObject.getString("serial_no"), orgId, newOrgId});
        if (InvoiceSaveConstant.REPLACEORG_BUYERTAX.equals(invoiceJson.getString("replaceorg"))) {
            return Boolean.TRUE;
        }
        if ("0".equals(invoiceJson.getString("overrideOrg")) && orgId > 0L) {
            return Boolean.FALSE;
        }
        if (!"2".equals(dynamicObject.getString("delete")) && InvoiceSaveConstant.REPLACEORG_INTERCEPT.equals(invoiceJson.getString("replaceorg")) && orgId.compareTo(newOrgId) != 0) {
            DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            throw new MsgException("0900", String.format(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u5f52\u5c5e%1$s\u7ec4\u7ec7", (String)"InvoiceSaveService_1", (String)"imc-rim-common", (Object[])new Object[0]), orgObject.get("name")));
        }
        Object expense_status = DynamicObjectUtil.getValue(dynamicObject, "expense_status");
        Boolean isUsed = ExpenseConstant.isUsed(expense_status);
        logger.info("orgId:{},isUsed:{}", (Object)orgId, (Object)isUsed);
        if (orgId > 0L && isUsed.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void notOverrideOrg(JSONObject invoiceJson) {
        invoiceJson.put("overrideOrg", (Object)"0");
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    private Long getRimUser(JSONObject invoiceJson) {
        Object rim_user = invoiceJson.get((Object)"rim_user");
        if (rim_user == null) {
            return 0L;
        }
        return Long.parseLong(rim_user.toString());
    }

    public void setSerialNo(JSONObject invoiceJson, DynamicObject dynamicObject) {
        String awsSerial = invoiceJson.getString("serialNo");
        if (!StringUtils.isBlank((CharSequence)awsSerial)) {
            QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)awsSerial);
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no", (QFilter[])new QFilter[]{serialNoFilter});
            if (null != idObject) {
                dynamicObject.set("serial_no", (Object)UUID.randomUUIDZero());
            } else {
                dynamicObject.set("serial_no", (Object)awsSerial);
            }
        } else {
            dynamicObject.set("serial_no", (Object)UUID.randomUUIDZero());
        }
    }

    private static void setSerialNo(DynamicObject mainObject, DynamicObject invoiceObject) {
        String serailNo = mainObject.getString("serial_no");
        if (StringUtils.isBlank((CharSequence)serailNo)) {
            serailNo = invoiceObject.getString("serial_no");
        }
        if (StringUtils.isBlank((CharSequence)serailNo)) {
            serailNo = UUID.randomUUIDZero();
        }
        mainObject.set("serial_no", (Object)serailNo);
        invoiceObject.set("serial_no", (Object)serailNo);
    }

    public void deleteRelation(Long mainId, Long collectUser, Long rimUser) {
        QFilter[] qFilters;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        Map entity = mainEntityType.getAllEntities();
        EntityType collectUserType = (EntityType)entity.get("collect_user_entry");
        QFilter filter = new QFilter("id", "=", (Object)mainId);
        QFilter userFilter = new QFilter("collect_user_entry.collect_user", "=", (Object)collectUser);
        if (rimUser > 0L) {
            QFilter rimFilter = new QFilter("collect_user_entry.rim_user", "=", (Object)rimUser);
            qFilters = new QFilter[]{filter, userFilter, rimFilter};
        } else {
            qFilters = new QFilter[]{filter, userFilter};
        }
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice", (String)"collect_user_entry.id as id", (QFilter[])qFilters);
        ArrayList<Long> idList = new ArrayList<Long>(collect.size());
        for (DynamicObject obj : collect) {
            idList.add(obj.getLong("id"));
        }
        DeleteServiceHelper.delete((IDataEntityType)collectUserType, (Object[])idList.toArray());
    }

    public Long getInvoiceType() {
        return this.invoiceType;
    }

    public static Date getDate(JSONObject invoiceJson, String key) {
        String billCreateTime1 = invoiceJson.getString(key);
        if (!StringUtils.isEmpty((CharSequence)billCreateTime1)) {
            try {
                return invoiceJson.getDate(key);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return new Date();
    }

    public static void setExtInfo(DynamicObject main, String extKey, String extValue) {
        String extInfo = main.getString("ext_info");
        JSONObject extObject = null;
        if (StringUtils.isEmpty((CharSequence)extInfo)) {
            extObject = new JSONObject();
        } else {
            try {
                extObject = JSONObject.parseObject((String)extInfo);
            }
            catch (Exception e) {
                extObject = new JSONObject();
            }
        }
        if (StringUtils.isEmpty((CharSequence)extValue)) {
            extObject.remove((Object)extKey);
        } else {
            extObject.put(extKey, (Object)extValue);
        }
        main.set("ext_info", (Object)extObject.toJSONString());
    }

    public <T> T getJSONValue(JSONObject invoiceJson, Class<T> clazz, String ... keys) {
        for (String key : keys) {
            try {
                Object value = invoiceJson.getObject(key, clazz);
                if (value == null) continue;
                return (T)value;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private FileConvertResult generatePdf(String tenantId, String serialNo) {
        if (this instanceof OrdinarySaveService || this instanceof SpecialSaveService || this instanceof TollSaveService) {
            try (DLock lock = DLock.create((String)"generatePdfLock", (String)"generatePdfLock");){
                String tenantNo;
                String entity;
                DynamicObject[] detail;
                if (lock.tryLock() && (detail = InvoiceQueryService.loadBySerialNo(entity = InputInvoiceTypeEnum.getEntity(this.invoiceType), tenantNo = TenantUtils.getTenantNo(), new String[]{serialNo})) != null && detail.length > 0) {
                    Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(detail[0]);
                    InvoiceConvertService convertService = InvoiceConvertService.newInstance(this.invoiceType);
                    JSONObject result = convertService.convert(mainMap);
                    PdfHandleService pdfService = new PdfHandleService();
                    byte[] pdfByte = pdfService.generate(result);
                    FileConvertResult fileConvertResult = FileConvertUtils.convert((byte[])pdfByte, (String)"pdf");
                    return fileConvertResult;
                }
            }
        }
        return null;
    }

    private static void setDefaultValue(JSONObject invoiceJson) {
        if (!"1".equals(invoiceJson.getString("proxyMark"))) {
            invoiceJson.put("proxyMark", (Object)"0");
        }
    }

    private static void setReplaceOrgFlag(JSONObject invoiceJson) {
        String isShowUncheck = RimConfigUtils.getConfig("rim_config", "replaceorg");
        invoiceJson.put("replaceorg", (Object)isShowUncheck);
    }

    protected Map<String, String> getGoodsCodeMap(DynamicObjectCollection itemCollect) {
        if (itemCollect != null) {
            HashMap<String, String> nameMap = new HashMap<String, String>(itemCollect.size());
            for (DynamicObject item : itemCollect) {
                String goods_code = item.getString("goods_code");
                String goods_name = item.getString("goods_name");
                if (!StringUtils.isNotBlank((CharSequence)goods_code) || !StringUtils.isNotBlank((CharSequence)goods_name)) continue;
                nameMap.put(goods_name, goods_code);
            }
            return nameMap;
        }
        return new HashMap<String, String>(0);
    }

    protected void setGoodsCode(DynamicObject itemObject, Map<String, String> nameMap, JSONObject itemJson) {
        String goods_code = itemJson.getString("goodsCode");
        if (StringUtils.isNotBlank((CharSequence)goods_code)) {
            itemObject.set("goods_code", (Object)goods_code);
        } else {
            String goodsName = itemJson.getString("goodsName");
            if (StringUtils.isNotBlank((CharSequence)goodsName)) {
                itemObject.set("goods_code", (Object)nameMap.get(goodsName));
            }
        }
    }

    protected <T> T getObject(JSONObject json, String fieldKey, Class<T> clazz) {
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            try {
                BigDecimal big = json.getBigDecimal(fieldKey);
                if (big.compareTo(maxAmount) > 0) {
                    return (T)BigDecimal.ZERO;
                }
                return (T)big;
            }
            catch (Exception e) {
                return (T)BigDecimal.ZERO;
            }
        }
        if (Date.class.isAssignableFrom(clazz)) {
            try {
                return (T)json.getDate(fieldKey);
            }
            catch (Exception e) {
                return null;
            }
        }
        return (T)json.get((Object)fieldKey);
    }

    public static boolean ignoreGoodsName(String goodsName, BigDecimal num, String unit, BigDecimal unitPrice) {
        return StringUtils.isNotEmpty((CharSequence)goodsName) && !goodsName.contains("*") && BigDecimal.ZERO.compareTo(num) == 0 && StringUtils.isEmpty((CharSequence)unit) && BigDecimal.ZERO.compareTo(unitPrice) == 0 && (goodsName.contains("\u5408\u8ba1") || goodsName.contains("\u8be6\u89c1") && goodsName.contains("\u6e05\u5355"));
    }

    private void toEmptyAll0BuyerTaxNo(JSONObject invoiceJson) {
        String buyerTaxNo;
        if (InputInvoiceTypeEnum.needCheck(this.invoiceType).booleanValue() && !StringUtils.isEmpty((CharSequence)(buyerTaxNo = invoiceJson.getString("buyerTaxNo"))) && StringUtils.isBlank((CharSequence)(buyerTaxNo = buyerTaxNo.replace("0", "")))) {
            invoiceJson.put("buyerTaxNo", (Object)"");
        }
        this.trimString(invoiceJson, "buyerName", "salerName");
    }

    private void trimString(JSONObject invoiceJson, String ... keys) {
        for (String key : keys) {
            String value = invoiceJson.getString(key);
            if (value == null) continue;
            invoiceJson.put(key, (Object)value.trim());
        }
    }

    private boolean synConvert(JSONObject invoiceJson, String serialNo) {
        boolean synConvert = "true".equals(invoiceJson.getString("synConvert"));
        if (synConvert) {
            SnapshotService snapshotService = new SnapshotService();
            JSONObject fileResult = snapshotService.getResultAndUpdateSerial(invoiceJson.getString("fileHash"), serialNo);
            if (!fileResult.isEmpty()) {
                invoiceJson.putAll((Map)fileResult);
            } else {
                snapshotService.start("invoicesave");
            }
            FileSaveTask fileSaveTask = new FileSaveTask(RequestContext.get(), serialNo, invoiceJson);
            fileSaveTask.call();
        }
        return synConvert;
    }

    private static String getOperateUser(JSONObject invoiceJson) {
        String operate = invoiceJson.getString(InvoiceSaveConstant.OPERATE_USER_ID);
        if (StringUtils.isEmpty((CharSequence)operate)) {
            operate = RequestContext.get().getUserId();
        }
        return operate;
    }

    public static String getBillDeductionFlag(DynamicObject mainDynamicObject, String collectType) {
        if (CollectTypeEnum.PC_SHUIPAN.getCode().equals(collectType) || CollectTypeEnum.TAX_EXCEL_IMPORT.getCode().equals(collectType)) {
            try {
                String extInfo = mainDynamicObject.getString("ext_info");
                JSONObject extObj = JSON.parseObject((String)extInfo);
                String billDeductionFlag = extObj.getString(InvoiceSaveConstant.EXT_BILL_DEDUCTION_FLAG);
                if ("0".equals(billDeductionFlag)) {
                    return "0";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static String subString(String str, int maxLength) {
        if (str == null || str.length() < maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }

    public String getLockKey(JSONObject invoiceJson) {
        return this.invoiceType + invoiceJson.getString("invoiceCode") + invoiceJson.getString("invoiceNo");
    }

    private boolean isAllowSave(JSONObject invoiceJson) {
        return !"1".equals(invoiceJson.getString("forbid_save"));
    }

    private void setCustomFieldValue(JSONObject invoiceJson, DynamicObject mainObject, DynamicObject invoiceObject) {
        String cusFields = RimConfigUtils.getConfig("rim_invoice_save", "cus_fields");
        if (StringUtils.isNotEmpty((CharSequence)cusFields)) {
            String[] fields;
            for (String fieldInfo : fields = cusFields.split(",")) {
                String[] field = fieldInfo.split(":");
                if (field.length <= 1) continue;
                DynamicObjectUtil.setDynamicObjectValue(mainObject, field[1], invoiceJson, field[0]);
                DynamicObjectUtil.setDynamicObjectValue(invoiceObject, field[1], invoiceJson, field[0]);
            }
        }
    }

    public static String subStringByLength(String value, int length) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (value.length() < length) {
            length = value.length();
        }
        return value.substring(0, length);
    }
}

