/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.query.convert.impl.AirConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.StringUtils;

public class AirEleSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        String invoiceStatus = invoiceJson.getString("invoiceStatus");
        String invoiceStateByCN = TaxInvoiceConvertUtil.getInvoiceStateByCN(invoiceStatus);
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)invoiceStateByCN)) {
            invoiceStatus = invoiceStateByCN;
        }
        dynamicObject.set("invoice_status", (Object)invoiceStatus);
        dynamicObject.set("international_flag", (Object)invoiceJson.getString("internationalFlag"));
        dynamicObject.set("gp_order_no", (Object)invoiceJson.getString("gpOrderNo"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("issuing_status", (Object)invoiceJson.getString("issuingStatus"));
        dynamicObject.set("customer_name", (Object)invoiceJson.getString("customerName"));
        dynamicObject.set("customer_identity_num", (Object)invoiceJson.getString("customerIdentityNum"));
        dynamicObject.set("endorsement", (Object)invoiceJson.getString("endorsement"));
        dynamicObject.set("place_of_departure", (Object)invoiceJson.getString("placeOfDeparture"));
        dynamicObject.set("destination", (Object)invoiceJson.getString("destination"));
        dynamicObject.set("issuing_status", (Object)invoiceJson.getString("invoiceStatus"));
        dynamicObject.set("carrier", (Object)invoiceJson.getString("carrier"));
        dynamicObject.set("flight_num", (Object)invoiceJson.getString("flightNum"));
        dynamicObject.set("seat_grade", (Object)invoiceJson.getString("seatGrade"));
        String gradeName = invoiceJson.getString("seatGradeName");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)gradeName)) {
            gradeName = AirConvertService.convertSeatName(DynamicObjectUtil.fieldToString(invoiceJson.getString("seatGrade")));
        }
        dynamicObject.set("seat_grade_name", (Object)gradeName);
        dynamicObject.set("carrier_date", (Object)invoiceJson.getDate("carrierDate"));
        dynamicObject.set("air_time", (Object)invoiceJson.getString("airTime"));
        dynamicObject.set("fare_basis", (Object)invoiceJson.getString("fareBasis"));
        dynamicObject.set("free_bag_allowance", (Object)invoiceJson.getString("freeBaggageAllowance"));
        dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceAmount", BigDecimal.class));
        dynamicObject.set("fuel_surcharge", (Object)this.getObject(invoiceJson, "fuelSurcharge", BigDecimal.class));
        dynamicObject.set("tax_rate", (Object)this.getObject(invoiceJson, "taxRate", BigDecimal.class));
        dynamicObject.set("tax_amount", (Object)this.getObject(invoiceJson, "taxAmount", BigDecimal.class));
        dynamicObject.set("airport_construction_fee", (Object)this.getObject(invoiceJson, "airportConstructionFee", BigDecimal.class));
        dynamicObject.set("other_total_tax_amount", (Object)this.getObject(invoiceJson, "otherTotalTaxAmount", BigDecimal.class));
        dynamicObject.set("total_amount", (Object)this.getObject(invoiceJson, "totalAmount", BigDecimal.class));
        dynamicObject.set("electronic_ticket_num", (Object)invoiceJson.getString("electronicTicketNum"));
        dynamicObject.set("verification_code", (Object)invoiceJson.getString("verificationCode"));
        dynamicObject.set("purchaser_name", (Object)invoiceJson.getString("purchaserName"));
        String purchaserUnifiedSocialCreditCode = invoiceJson.getString("purchaserUnifiedSocialCreditCode");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)purchaserUnifiedSocialCreditCode)) {
            purchaserUnifiedSocialCreditCode = invoiceJson.getString("buyerTaxNo");
        }
        dynamicObject.set("pur_unified_cre_code", (Object)purchaserUnifiedSocialCreditCode);
        dynamicObject.set("sales_unit_code", (Object)invoiceJson.getString("salesUnitCode"));
        Date tkrq = this.getIssueDate(invoiceJson);
        this.setInvoiceDate(tkrq, dynamicObject, "issue_date");
        this.setInvoiceDate(tkrq, dynamicObject, "invoice_date");
        dynamicObject.set("promptinformation", (Object)invoiceJson.getString("promptInformation"));
        dynamicObject.set("promptinformation", (Object)invoiceJson.getString("promptInformation"));
        dynamicObject.set("insurance_premium", (Object)this.getObject(invoiceJson, "insurancePremium", BigDecimal.class));
        dynamicObject.set("filling_unit", (Object)invoiceJson.getString("fillingUnit"));
        String sellerName = invoiceJson.getString("sellerName");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)sellerName)) {
            sellerName = invoiceJson.getString("salerName");
        }
        dynamicObject.set("seller_name", (Object)sellerName);
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
        if (dynamicObject.containsProperty("tax_recorded_status") && StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
    }

    private Date getIssueDate(JSONObject invoiceJson) {
        Object issueDate = this.getJSONValue(invoiceJson, Object.class, "issueDate", "invoiceDate");
        Date tkrq = null;
        if (issueDate instanceof Long) {
            tkrq = new Date((Long)issueDate);
        }
        if (issueDate instanceof Integer) {
            try {
                tkrq = new SimpleDateFormat("yyyyMMdd").parse(issueDate + "");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (issueDate instanceof String) {
            try {
                tkrq = new SimpleDateFormat("yyyy-MM-dd").parse(issueDate + "");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tkrq;
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("items");
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemJson = items.getJSONObject(i);
                DynamicObject itemObject = collection.addNew();
                itemObject.set("seq", (Object)i);
                itemObject.set("entry_place_of_departure", (Object)itemJson.getString("placeOfDeparture"));
                itemObject.set("entry_destination", (Object)itemJson.getString("destination"));
                itemObject.set("entry_carrier", (Object)itemJson.getString("carrier"));
                itemObject.set("entry_flight_num", (Object)itemJson.getString("flightNum"));
                itemObject.set("entry_seat_grade", (Object)itemJson.getString("seatGrade"));
                itemObject.set("entry_carrier_date", (Object)itemJson.getDate("carrierDate"));
                itemObject.set("entry_air_time", (Object)itemJson.getString("airTime"));
                itemObject.set("entry_flight_segment", (Object)itemJson.getString("flightSegment"));
                itemObject.set("entry_fare_basis", (Object)itemJson.getString("fareBasis"));
                itemObject.set("entry_effective_date", (Object)itemJson.getDate("effectiveDate"));
                itemObject.set("entry_expiration_date", (Object)itemJson.getDate("expirationDate"));
                itemObject.set("entry_free_bag_allowance", (Object)itemJson.getString("freeBaggageAllowance"));
            }
        }
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        DynamicObject invDynObj;
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        String invoiceNo = invoiceJson.getString("invoiceNo");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceNoFilter});
        if (null == idObject) {
            invDynObj = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invDynObj.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invDynObj);
        } else {
            invDynObj = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invDynObj;
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        Date tkrq = this.getIssueDate(invoiceJson);
        this.setInvoiceDate(tkrq, dynamicObject, "invoice_date");
        dynamicObject.set("total_tax_amount", (Object)this.getObject(invoiceJson, "taxAmount", BigDecimal.class));
        String invoiceStatus = invoiceJson.getString("invoiceStatus");
        String invoiceStateByCN = TaxInvoiceConvertUtil.getInvoiceStateByCN(invoiceStatus);
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)invoiceStateByCN)) {
            invoiceStatus = invoiceStateByCN;
        }
        dynamicObject.set("invoice_status", (Object)invoiceStatus);
        dynamicObject.set("buyer_name", (Object)invoiceJson.getString("purchaserName"));
        String purchaserUnifiedSocialCreditCode = invoiceJson.getString("purchaserUnifiedSocialCreditCode");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)purchaserUnifiedSocialCreditCode)) {
            purchaserUnifiedSocialCreditCode = invoiceJson.getString("buyerTaxNo");
        }
        dynamicObject.set("buyer_tax_no", (Object)purchaserUnifiedSocialCreditCode);
        String sellerName = invoiceJson.getString("sellerName");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)sellerName)) {
            sellerName = invoiceJson.getString("salerName");
        }
        dynamicObject.set("saler_name", (Object)sellerName);
    }
}

