/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.utils.BigDecimalUtil;

public class ElectricSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        super.setSpecialTypeMark(dynamicObject, invoiceJson);
        dynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
        dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
        dynamicObject.set("buyer_account", (Object)invoiceJson.getString("buyerAccount"));
        dynamicObject.set("buyer_address_phone", (Object)invoiceJson.getString("buyerAddressPhone"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoiceAmount"))) {
            dynamicObject.set("invoice_amount", (Object)invoiceJson.getBigDecimal("invoiceAmount"));
        } else {
            dynamicObject.set("invoice_amount", (Object)invoiceJson.getBigDecimal("amount"));
        }
        this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), dynamicObject);
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("invoice_status", (Object)invoiceJson.getString("invoiceStatus"));
        dynamicObject.set("drawer", (Object)invoiceJson.getString("drawer"));
        dynamicObject.set("proxy_mark", (Object)invoiceJson.getString("proxyMark"));
        dynamicObject.set("remark", (Object)StringUtils.substring((String)invoiceJson.getString("remark"), (int)0, (int)1024));
        this.setSalerType(dynamicObject, invoiceJson);
        dynamicObject.set("saler_name", (Object)invoiceJson.getString("salerName"));
        dynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
        dynamicObject.set("saler_account", (Object)invoiceJson.getString("salerAccount"));
        dynamicObject.set("saler_address_phone", (Object)invoiceJson.getString("salerAddressPhone"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getString("totalAmount"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalTaxAmount"))) {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("totalTaxAmount"));
        } else {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("taxAmount"));
        }
        dynamicObject.set("type", (Object)invoiceJson.getString("type"));
        BigDecimal total = dynamicObject.getBigDecimal("total_amount");
        if (total != null && total.compareTo(BigDecimal.ZERO) >= 0) {
            dynamicObject.set("type", (Object)"0");
        } else {
            dynamicObject.set("type", (Object)"1");
        }
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
        if (dynamicObject.containsProperty("tax_recorded_status") && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        boolean isPurchaseTicket = false;
        HashMap validMap = Maps.newHashMap();
        Long invoiceType = invoiceJson.getLong("invoiceType");
        validMap.put("invoice_type", invoiceType);
        validMap.put("buyer_tax_no", invoiceJson.getString("salerTaxNo"));
        validMap.put("buyer_name", invoiceJson.getString("salerName"));
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("items");
            Map<String, String> nameMap = this.getGoodsCodeMap(collection);
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                boolean verifyPerson;
                JSONObject itemJson = items.getJSONObject(i);
                boolean ignoreFlag = ElectricSaveService.ignoreGoodsName(itemJson.getString("goodsName"), this.getObject(itemJson, "num", BigDecimal.class), itemJson.getString("unit"), this.getObject(itemJson, "unitPrice", BigDecimal.class));
                if (ignoreFlag && items.size() > 1) continue;
                if (i == 0) {
                    dynamicObject.set("main_goods_name", (Object)itemJson.getString("goodsName"));
                }
                DynamicObject itemObject = collection.addNew();
                itemObject.set("detail_amount", (Object)BigDecimalUtil.transDecimal(itemJson.get((Object)"detailAmount")));
                itemObject.set("discount_type", (Object)itemJson.getString("discountType"));
                this.setGoodsCode(itemObject, nameMap, itemJson);
                itemObject.set("seq", (Object)i);
                itemObject.set("goods_name", (Object)itemJson.getString("goodsName"));
                itemObject.set("num", (Object)BigDecimalUtil.transDecimal(itemJson.get((Object)"num")));
                itemObject.set("preferential_policy", (Object)itemJson.getString("preferentialPolicy"));
                itemObject.set("spec_model", (Object)itemJson.getString("specModel"));
                try {
                    itemObject.set("tax_amount", (Object)itemJson.getBigDecimal("taxAmount"));
                    itemObject.set("tax_rate", (Object)itemJson.getBigDecimal("taxRate"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                itemObject.set("unit", (Object)itemJson.getString("unit"));
                itemObject.set("unit_price", (Object)BigDecimalUtil.transDecimal(itemJson.get((Object)"unitPrice")));
                itemObject.set("zerotaxrate_flag", (Object)itemJson.getString("zeroTaxRateFlag"));
                itemObject.set("version_no", (Object)itemJson.getString("versionNo"));
                if (!InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) continue;
                String goodsCode = itemObject.getString("goods_code");
                boolean goodCodeCheck = StringUtils.isEmpty((CharSequence)goodsCode) ? true : !goodsCode.startsWith("101");
                BigDecimal taxRate = BigDecimalUtil.transDecimal(itemJson.getString("taxRate"));
                boolean isZeroRate = BigDecimal.ZERO.compareTo(taxRate) != 0;
                boolean bl = verifyPerson = !VerifyUtil.isPersonInvoice(validMap);
                if (isZeroRate || goodCodeCheck || verifyPerson) continue;
                isPurchaseTicket = true;
            }
        }
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        String remark;
        super.setMainFieldValue(invoiceJson, dynamicObject);
        JSONArray items = invoiceJson.getJSONArray("items");
        if (!CollectionUtils.isEmpty((Collection)items)) {
            JSONObject itemJson = items.getJSONObject(0);
            dynamicObject.set("main_goods_name", (Object)itemJson.getString("goodsName"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(remark = invoiceJson.getString("remark"))) && remark.length() > 1024) {
            dynamicObject.set("remark", (Object)invoiceJson.getString("remark").substring(0, 1024));
        } else {
            dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
        }
    }
}

