/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.TenantUtils;

public class GeneralSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
        dynamicObject.set("buyer_tax_no", (Object)GeneralSaveService.subString(invoiceJson.getString("buyerTaxNo"), 20));
        dynamicObject.set("check_code", (Object)invoiceJson.getString("checkCode"));
        dynamicObject.set("drawer", (Object)invoiceJson.getString("drawer"));
        dynamicObject.set("entrance", (Object)invoiceJson.getString("entrance"));
        dynamicObject.set("exit", (Object)invoiceJson.getString("exit"));
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("payee", (Object)invoiceJson.getString("payee"));
        dynamicObject.set("place", (Object)invoiceJson.getString("place"));
        dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
        dynamicObject.set("reviewer", (Object)invoiceJson.getString("reviewer"));
        dynamicObject.set("saler_name", (Object)invoiceJson.getString("salerName"));
        dynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
        dynamicObject.set("time", (Object)invoiceJson.getString("time"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("totalTaxAmount"));
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("buyer_tax_no", (Object)GeneralSaveService.subString(invoiceJson.getString("buyerTaxNo"), 20));
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        if (!InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(this.invoiceType)) {
            return super.getInvoiceDynamicObject(invoiceJson);
        }
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceJson.getString("invoiceNo"));
        QFilter invoiceCodeFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoiceCode"))) {
            invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceJson.getString("invoiceCode"));
        } else if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("exit"))) {
            invoiceCodeFilter = new QFilter("exit", "=", (Object)invoiceJson.getString("exit"));
        }
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            invoiceDynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
            invoiceDynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }
}

