/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.utils.MetadataUtil;

public class InvoiceHisSaveService {
    public static List<DynamicObject> createDynamicObject(Map<String, String> oldValueMap, DynamicObject newObject) {
        DynamicObjectType type = newObject.getDynamicObjectType();
        DataEntityPropertyCollection propertyCollection = type.getProperties();
        String pk = newObject.getPkValue().toString();
        String table = type.getName();
        Date createTime = new Date();
        RequestContext request = RequestContext.get();
        String traceid = request.getTraceId();
        String creater = request.getUserId();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        for (IDataEntityProperty property : propertyCollection) {
            String key = property.getName();
            if (InvoiceHisSaveService.notHis(key)) continue;
            String newValue = InvoiceHisSaveService.getString(newObject, type.getName(), key);
            String oldValue = null;
            if (oldValueMap != null) {
                oldValue = oldValueMap.get(key);
            }
            if (String.valueOf(newValue).equals(String.valueOf(oldValue))) continue;
            DynamicObject hisObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_his");
            hisObject.set("data_table", (Object)table);
            hisObject.set("data_pk", (Object)pk);
            hisObject.set("field_name", (Object)key);
            hisObject.set("old_value", (Object)oldValue);
            hisObject.set("new_value", (Object)newValue);
            hisObject.set("traceid", (Object)traceid);
            hisObject.set("creater", (Object)creater);
            hisObject.set("create_time", (Object)createTime);
            list.add(hisObject);
        }
        return list;
    }

    public static Map<String, String> dynamicObjectToMap(DynamicObject object) {
        HashMap<String, String> dataMap = new HashMap<String, String>(8);
        Object pk = object.getPkValue();
        if (pk == null || "0".equals(pk.toString())) {
            return dataMap;
        }
        DynamicObjectType type = object.getDynamicObjectType();
        DataEntityPropertyCollection propertyCollection = type.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String key = property.getName();
            if (InvoiceHisSaveService.notHis(key)) continue;
            dataMap.put(key, InvoiceHisSaveService.getString(object, type.getName(), key));
        }
        return dataMap;
    }

    private static String getString(DynamicObject object, String entityId, String fieldId) {
        Object value = object.get(fieldId);
        if (value instanceof Date) {
            Format format = MetadataUtil.getDateFormat(entityId, fieldId);
            if (null != format) {
                return format.format(value);
            }
        } else if (value instanceof BigDecimal) {
            Format format = MetadataUtil.getDateFormat(entityId, fieldId);
            if (null != format) {
                return format.format(value);
            }
        } else if (null != value) {
            return value.toString();
        }
        return "";
    }

    private static boolean notHis(String key) {
        return key.equals("items") || key.equals("id") || key.equals("update_time") || key.equals("create_time") || key.equals("collect_user_entry") || key.equals("collect_org_entry");
    }
}

