/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.TenantUtils;

public class TaxProofSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
        dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("tax_authority_name", (Object)invoiceJson.getString("taxAuthorityName"));
        dynamicObject.set("tax_paid_proof_no", (Object)invoiceJson.getString("taxPaidProofNo"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("taxPaidProofNo"));
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceCodeFilter = new QFilter("tax_paid_proof_no", "=", (Object)invoiceJson.getString("taxPaidProofNo"));
        QFilter buyerTaxNoFilter = new QFilter("buyer_tax_no", "=", (Object)invoiceJson.getString("buyerTaxNo"));
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, buyerTaxNoFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }

    @Override
    public String getLockKey(JSONObject invoiceJson) {
        return this.invoiceType + invoiceJson.getString("buyer_tax_no") + this.getJSONValue(invoiceJson, String.class, "taxPaidProofNo");
    }

    @Override
    public String getBillNo(JSONObject invoiceJson) {
        return invoiceJson.getString("taxPaidProofNo");
    }
}

