/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.TenantUtils;

public class TrainSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        Date travelDate = invoiceJson.getDate("travelDate");
        if (travelDate == null) {
            travelDate = invoiceJson.getDate("invoiceDate");
        }
        dynamicObject.set("travel_date", (Object)travelDate);
        dynamicObject.set("passenger_name", (Object)invoiceJson.getString("passengerName"));
        String customerIdNo = invoiceJson.getString("customerIdNo");
        String customerIdentityNum = invoiceJson.getString("customerIdentityNum");
        String idNum = StringUtils.isEmpty((String)customerIdentityNum) ? customerIdNo : customerIdentityNum;
        dynamicObject.set("customer_id_no", (Object)idNum);
        String seatGrade = invoiceJson.getString("seatGrade");
        String seat = invoiceJson.getString("seat");
        String seat_grade = StringUtils.isEmpty((String)seatGrade) ? seat : seatGrade;
        dynamicObject.set("seat_grade", (Object)seat_grade);
        String printingSequenceNo = invoiceJson.getString("printingSequenceNo");
        String sequenceNo = invoiceJson.getString("sequenceNo");
        String invoiceNo = StringUtils.isEmpty((String)printingSequenceNo) ? sequenceNo : printingSequenceNo;
        dynamicObject.set("sequence_no", (Object)invoiceNo);
        dynamicObject.set("station_get_off", (Object)invoiceJson.getString("stationGetOff"));
        dynamicObject.set("station_get_on", (Object)invoiceJson.getString("stationGetOn"));
        dynamicObject.set("tax_rate", (Object)invoiceJson.getBigDecimal("taxRate"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("totalTaxAmount"));
        dynamicObject.set("train_num", (Object)invoiceJson.getString("trainNum"));
        dynamicObject.set("train_time", (Object)invoiceJson.getString("trainTime"));
        dynamicObject.set("business_type", (Object)invoiceJson.getString("businessType"));
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("trainNum"));
        dynamicObject.set("invoice_no", (Object)this.getJSONValue(invoiceJson, String.class, "printingSequenceNo", "sequenceNo"));
        BigDecimal totalAmount = invoiceJson.getBigDecimal("totalAmount");
        BigDecimal totalTaxAmount = invoiceJson.getBigDecimal("totalTaxAmount");
        dynamicObject.set("invoice_amount", (Object)(totalTaxAmount == null ? totalAmount : totalAmount.subtract(totalTaxAmount)));
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        String printingSequenceNo = invoiceJson.getString("printingSequenceNo");
        String sequenceNo = invoiceJson.getString("sequenceNo");
        String invoiceNo = StringUtils.isEmpty((String)printingSequenceNo) ? sequenceNo : printingSequenceNo;
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceCodeFilter = new QFilter("train_num", "=", (Object)invoiceJson.getString("trainNum"));
        QFilter invoiceNoFilter = new QFilter("sequence_no", "=", (Object)invoiceNo);
        Date travelDate = invoiceJson.getDate("travelDate");
        if (travelDate == null) {
            travelDate = invoiceJson.getDate("invoiceDate");
        }
        QFilter travelDateFilter = new QFilter("travel_date", "=", (Object)travelDate);
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, travelDateFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }

    @Override
    public String getLockKey(JSONObject invoiceJson) {
        return this.invoiceType + invoiceJson.getString("trainNum") + this.getJSONValue(invoiceJson, String.class, "printingSequenceNo", "sequenceNo");
    }

    @Override
    public String getBillNo(JSONObject invoiceJson) {
        String printingSequenceNo = invoiceJson.getString("printingSequenceNo");
        String sequenceNo = invoiceJson.getString("sequenceNo");
        return StringUtils.isEmpty((String)printingSequenceNo) ? sequenceNo : printingSequenceNo;
    }
}

