/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;

public class TransportSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("insurance_premium", (Object)invoiceJson.getBigDecimal("insurancePremium"));
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("passenger_name", (Object)invoiceJson.getString("passengerName"));
        dynamicObject.set("seat_grade", (Object)invoiceJson.getString("seatNo"));
        dynamicObject.set("currency", (Object)invoiceJson.getString("currency"));
        dynamicObject.set("sequence_no", (Object)invoiceJson.getString("sequenceNo"));
        dynamicObject.set("station_get_off", (Object)invoiceJson.getString("stationGetOff"));
        dynamicObject.set("station_get_on", (Object)invoiceJson.getString("stationGetOn"));
        dynamicObject.set("tax_rate", (Object)invoiceJson.getBigDecimal("taxRate"));
        dynamicObject.set("time", (Object)invoiceJson.getString("time"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("totalTaxAmount"));
        dynamicObject.set("train_num", (Object)invoiceJson.getBigDecimal("trainNum"));
        dynamicObject.set("customer_id_no", (Object)invoiceJson.getString("customerIdNo"));
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        Long invoiceType = invoiceJson.getLong("invoiceType");
        BigDecimal totalAmount = invoiceJson.getBigDecimal("totalAmount");
        BigDecimal totalTaxAmount = invoiceJson.getBigDecimal("totalTaxAmount");
        if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType)) {
            BigDecimal insurancePremium = invoiceJson.getBigDecimal("insurancePremium");
            if (insurancePremium == null) {
                insurancePremium = BigDecimal.ZERO;
            }
            BigDecimal subtract = totalAmount.subtract(insurancePremium);
            dynamicObject.set("invoice_amount", (Object)(totalTaxAmount == null ? totalAmount : subtract.subtract(totalTaxAmount)));
        } else if (InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
            dynamicObject.set("invoice_amount", (Object)(totalTaxAmount == null ? totalAmount : totalAmount.subtract(totalTaxAmount)));
        }
    }
}

