/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class WithHoldSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
        dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
        dynamicObject.set("saler_name", (Object)invoiceJson.getString("salerName"));
        dynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
        this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), dynamicObject);
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalTaxAmount"))) {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("totalTaxAmount"));
        } else {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("taxAmount"));
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoiceAmount"))) {
            dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceAmount", BigDecimal.class));
        } else {
            dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceMoney", BigDecimal.class));
        }
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("salerTaxNo"));
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        String invoiceNo = invoiceJson.getString("invoiceNo");
        String salerTaxNo = invoiceJson.getString("salerTaxNo");
        QFilter filter1 = new QFilter("invoice_no", "=", (Object)invoiceNo).and("saler_tax_no", "=", (Object)salerTaxNo);
        Date invoiceDate = invoiceJson.getDate("invoiceDate");
        QFilter filter2 = null;
        if (invoiceDate != null) {
            invoiceDate = DateUtils.trunc(invoiceDate);
            filter2 = new QFilter("invoice_date", ">=", (Object)invoiceDate);
            filter2.and(new QFilter("invoice_date", "<", (Object)DateUtils.addDay(invoiceDate, 1)));
        }
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, filter1, filter2});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }
}

