/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.verify;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.VerifyNameEnum;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;

public class VerifyStatisticsService {
    private static Log LOGGER = LogFactory.getLog(VerifyStatisticsService.class);

    public static void asyncSaveVerifyStatistics(JSONArray invoiceArray, Long orgId, String userId) {
        ThreadPools.executeOnceIncludeRequestContext((String)"AsynSaveVerifyStatisticsRun", () -> VerifyStatisticsService.saveVerifyStatistics(invoiceArray, orgId, userId));
    }

    public static void saveVerifyStatistics(JSONArray invoiceArray, Long orgId, String userId) {
        LOGGER.info("\u4fdd\u5b58\u5408\u89c4\u6027\u6821\u9a8c\u7ed3\u679c{},orgId:{},userId:{}", new Object[]{invoiceArray, orgId, userId});
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        RequestContext requestContext = RequestContext.get();
        Long loginOrg = requestContext.getOrgId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = requestContext.getUserId();
        }
        DynamicObject dynamicObject = null;
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoice = invoiceArray.getJSONObject(i);
            String serialNo = invoice.getString("serialNo");
            if (StringUtils.isEmpty((CharSequence)serialNo) || "1".equals(invoice.get((Object)"notInDB"))) continue;
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_verify_statistics");
            if (orgId == null || orgId < 1L) {
                QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"org_id as org", (QFilter[])new QFilter[]{filter});
                if (obj != null) {
                    dynamicObject.set("org", (Object)obj.getLong("org"));
                } else {
                    dynamicObject.set("org", (Object)loginOrg);
                }
            } else {
                dynamicObject.set("org", (Object)orgId);
            }
            dynamicObject.set("creator", (Object)userId);
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
            dynamicObject.set("invoice_type", (Object)invoiceType);
            dynamicObject.set("total_amount", invoice.get((Object)"totalAmount"));
            dynamicObject.set("serial_no", (Object)serialNo);
            dynamicObject.set("createtime", (Object)new Date());
            if (FpzsMainService.isFilter(invoice).booleanValue()) {
                dynamicObject.set("compliance", (Object)"0");
                JSONArray verifyArray = invoice.getJSONArray("verifyResult");
                if (!CollectionUtils.isEmpty((Collection)verifyArray)) {
                    dynamicObject.set("compliance", (Object)"0");
                    DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("items");
                    for (int index = 0; index < verifyArray.size(); ++index) {
                        JSONObject itemJson = verifyArray.getJSONObject(index);
                        DynamicObject itemObject = collection.addNew();
                        itemObject.set("seq", (Object)(index + 1));
                        itemObject.set("verify_name", (Object)itemJson.getString("configType"));
                        itemObject.set("verify_description", (Object)itemJson.getString("configType"));
                        itemObject.set("risk_grade", (Object)VerifyNameEnum.getRiskGradeByCode(itemJson.getString("configType")));
                    }
                }
            } else {
                dynamicObject.set("compliance", (Object)"1");
            }
            dynamicObjects.add(dynamicObject);
        }
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
    }
}

