/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.message.exception;

import kd.imc.rim.common.message.constant.ErrorType;

public class MsgException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private String errorMsg;

    public MsgException(ErrorType errorType) {
        super(errorType.getName(), null, false, false);
        this.errorMsg = errorType.getName();
        this.errorCode = errorType.getCode();
    }

    public MsgException(String errorMsg) {
        super(errorMsg, null, false, false);
        this.errorMsg = errorMsg;
    }

    public MsgException(String errorCode, String errorMsg) {
        super(errorMsg, null, false, false);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public MsgException(Throwable cause, String errorMsg) {
        super(errorMsg, cause);
        this.errorCode = "0999";
        this.errorMsg = errorMsg;
    }

    public MsgException(Throwable cause, String errorCode, String errorMsg) {
        super(errorMsg, cause);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"errcode\":\"").append(this.errorCode).append('\"');
        sb.append(",\"description\":\"").append(this.errorMsg).append('\"');
        sb.append('}');
        return sb.toString();
    }
}

