/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.multitenant.service.impl.FpzsLocalService;
import kd.imc.rim.common.multitenant.service.impl.FpzsRemoteService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractFpzsService {
    private static final Log logger = LogFactory.getLog(AbstractFpzsService.class);
    private static final List<String> NOT_DEDUCTIBLE_TYPE_LIST = new ArrayList<String>(Arrays.asList("1", "2", "3", "4", "5"));

    public static AbstractFpzsService newInstance() {
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            return new FpzsRemoteService();
        }
        return new FpzsLocalService();
    }

    public abstract Map<String, Object> save(Map<String, Object> var1);

    protected void pushBdsBySave(ExpenseDTO dto) {
        String expenseNum = dto.getExpenseNum();
        String pushBdsImageSys = RimConfigUtils.getConfig("push_bds_image_sys");
        if (!"1".equals(pushBdsImageSys)) {
            logger.info("\u672a\u5f00\u542f\u63a8\u9001\u81f3\u5f71\u50cf\u914d\u7f6e:{}", (Object)expenseNum);
            return;
        }
        try {
            JSONObject map = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
            String billId = (String)map.get((Object)"expenseId");
            String entityId = (String)map.get((Object)"entityId");
            AttachQueryService attachQueryService = new AttachQueryService();
            JSONArray invoiceAttachObj = attachQueryService.queryFpzsAttach(billId, entityId, "4", true);
            logger.info("pushBdsBySave \u9644\u4ef6\u5185\u5bb9\uff1a{}", (Object)invoiceAttachObj);
            map.put("attachList", (Object)invoiceAttachObj);
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"bds", (String)"ReceiveRimService", (String)"saveExpenseInfo", (Object[])new Object[]{map});
        }
        catch (Exception e) {
            logger.info("beanToMap Exception:", (Object)e);
        }
    }

    public abstract Map<String, Object> delete(Map<String, Object> var1);

    protected void pushBdsByDelete(ExpenseDTO dto) {
        String pushBdsImageSys = RimConfigUtils.getConfig("push_bds_image_sys");
        if (!"1".equals(pushBdsImageSys)) {
            logger.info("\u672a\u5f00\u542f\u63a8\u9001\u81f3\u5f71\u50cf\u914d\u7f6e:{}", (Object)dto.getExpenseNum());
            return;
        }
        String expenseId = dto.getExpenseId();
        if (StringUtils.isEmpty((String)expenseId)) {
            return;
        }
        try {
            JSONObject map = JSON.parseObject((String)JSONObject.toJSONString((Object)dto));
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"bds", (String)"ReceiveRimService", (String)"deleteExpenseInfo", (Object[])new Object[]{map});
        }
        catch (Exception e) {
            logger.info("beanToMap Exception:", (Object)e);
        }
    }

    public abstract Map<String, Object> deleteAttach(Map<String, Object> var1);

    public abstract Map<String, Object> deleteInvoice(List<String> var1);

    public Map<String, Object> query(List<String> param, String resource) {
        return this.query(param, resource, null);
    }

    public abstract Map<String, Object> query(List<String> var1, String var2, String var3);

    public void convertDateLong(Map<String, Object> bodyMap, String ... timeKeys) {
        if (bodyMap == null) {
            return;
        }
        for (String timeKey : timeKeys) {
            String pattern = "yyyy-MM-dd HH:mm:ss";
            if ("invoice_date".equals(timeKey) || "invoiceDate".equals(timeKey)) {
                pattern = "yyyy-MM-dd";
            }
            try {
                Long time = (Long)bodyMap.get(timeKey);
                Date date = new Date(time);
                SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                String dateString = formatter.format(date);
                bodyMap.put(timeKey, dateString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map<String, Object> query(List<String> param) {
        return this.query(param, null);
    }

    public abstract Map<String, Object> queryVerify(Map<String, Object> var1);

    public abstract Map<String, Object> check(Map<String, Object> var1);

    public abstract Map<String, Object> checkNew(Map<String, Object> var1);

    protected ExpenseDTO getExpenseDTO(Map<String, Object> param) {
        JSONArray invoiceData;
        String json = SerializationUtils.toJsonString(param);
        logger.info("getExpenseDTO-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String billId = jsonObj.getString("billId");
        String billNo = jsonObj.getString("billNo");
        String billType = jsonObj.getString("billType");
        String entityId = jsonObj.getString("entityId");
        String viewPage = jsonObj.getString("viewPage");
        String resource = jsonObj.getString("resource");
        String status = jsonObj.getString("status");
        String billUser = jsonObj.getString("billUser");
        String batch = jsonObj.getString("batch");
        String updateInvoiceOrg = jsonObj.getString("updateInvoiceOrg");
        if (StringUtils.isEmpty((String)billUser)) {
            billUser = RequestContext.get().getUserId();
        }
        Long orgId = jsonObj.getLong("orgId");
        ExpenseDTO dto = new ExpenseDTO();
        Boolean isAllowRepeat = jsonObj.getBoolean("isAllowRepeat");
        if (isAllowRepeat != null) {
            dto.setAllowRepeat(isAllowRepeat);
        }
        dto.setExpenseId(billId);
        dto.setExpenseNum(billNo);
        dto.setExpenseType(billType);
        dto.setResource(resource);
        dto.setEntityId(entityId);
        dto.setViewPage(viewPage);
        dto.setStatus(status);
        dto.setBillUser(billUser);
        dto.setOrgId(orgId);
        dto.setOriginalId(jsonObj.getString("originalId"));
        dto.setOriginalType(jsonObj.getString("originalType"));
        if (StringUtils.isNotEmpty((String)dto.getOriginalId()) && StringUtils.isEmpty((String)dto.getOriginalType())) {
            dto.setOriginalType(dto.getEntityId());
        }
        dto.setBatch(batch);
        this.setBotpBillList(jsonObj, dto);
        if (StringUtils.equals((String)updateInvoiceOrg, (String)"1")) {
            dto.setUpdateInvoiceOrg(true);
        }
        if (dto.getOrgId() == null || dto.getOrgId() < 0L) {
            dto.setOrgId(RequestContext.get().getOrgId());
        }
        if ((invoiceData = jsonObj.getJSONArray("invoiceData")) != null) {
            boolean updateDeductionPurpose = false;
            if (dto.getOrgId() != null && dto.getOrgId() > 0L) {
                updateDeductionPurpose = SysParamUtil.getSysParamByOrgId(dto.getOrgId(), "update_deduction_purpose");
                logger.info("\u7ec4\u7ec7id: {}, \u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014\uff1a{}", (Object)dto.getOrgId(), (Object)updateDeductionPurpose);
            }
            ArrayList<ExpenseInvoiceDTO> subList = new ArrayList<ExpenseInvoiceDTO>(invoiceData.size());
            List serialNoList = invoiceData.stream().map(t -> (JSONObject)t).filter(t -> StringUtils.isNotBlank((String)t.getString("serialNo"))).map(t -> t.getString("serialNo")).collect(Collectors.toList());
            HashMap<String, Boolean> SerialNoMap = new HashMap<String, Boolean>(invoiceData.size());
            if (!CollectionUtils.isEmpty(serialNoList)) {
                QFilter filter = new QFilter("serial_no", "in", serialNoList);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_type,serial_no", (QFilter[])new QFilter[]{filter});
                for (DynamicObject object : collection) {
                    if (!StringUtils.isNotBlank((String)object.getString("serial_no")) || object.getLong("invoice_type") <= 0L) continue;
                    long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(object.getLong("invoice_type"));
                    SerialNoMap.put(object.getString("serial_no"), InputInvoiceTypeEnum.canTransportDeduction(invoiceType));
                }
            }
            for (int i = 0; i < invoiceData.size(); ++i) {
                String deductionFlag;
                JSONObject invoice = invoiceData.getJSONObject(i);
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                Boolean allowRepeat = invoice.getBoolean("isAllowRepeat");
                if (allowRepeat == null) {
                    allowRepeat = Boolean.FALSE;
                }
                invoiceDto.setAllowRepeat(allowRepeat);
                invoiceDto.setExpenseAmount(invoice.getBigDecimal("amount"));
                invoiceDto.setSerialNo(invoice.getString("serialNo"));
                String deductionPurpose = invoice.getString("deductionPurpose");
                invoiceDto.setDeductionPurpose(deductionPurpose);
                String notDeductibleType = invoice.getString("notDeductibleType");
                if ("2".equals(deductionPurpose)) {
                    if (StringUtils.isNotBlank((String)notDeductibleType) && NOT_DEDUCTIBLE_TYPE_LIST.contains(notDeductibleType)) {
                        invoiceDto.setNotDeductibleType(notDeductibleType);
                    } else {
                        invoiceDto.setNotDeductibleType("5");
                    }
                }
                if ("true".equals(deductionFlag = invoice.getString("deductionFlag")) || "1".equals(deductionFlag)) {
                    invoiceDto.setDeductionFlag("1");
                } else if ("false".equals(deductionFlag) || "0".equals(deductionFlag)) {
                    invoiceDto.setDeductionFlag("0");
                }
                logger.info("\u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014: \u53d1\u7968\u6d41\u6c34\u53f7: {}, \u4f20\u5165\u7684\u62b5\u6263\u6807\u8bc6deductionFlag\uff1a{}, \u62b5\u6263\u7528\u9014\uff1a{}", new Object[]{invoiceDto.getSerialNo(), invoice.getString("deductionFlag"), invoiceDto.getDeductionPurpose()});
                Boolean canTransportDeduction = false;
                if (StringUtils.isNotBlank((String)invoice.getString("serialNo")) && SerialNoMap.containsKey(invoice.getString("serialNo"))) {
                    canTransportDeduction = (Boolean)SerialNoMap.get(invoice.getString("serialNo"));
                }
                if (!canTransportDeduction.booleanValue() && updateDeductionPurpose && StringUtils.isBlank((String)invoiceDto.getDeductionPurpose()) && StringUtils.isNotBlank((String)deductionFlag)) {
                    invoiceDto.setDeductionFlag("1");
                    logger.info("\u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014 \u53c2\u6570\u751f\u6548, dto\u7684\u62b5\u6263\u6807\u8bc6\uff1a{}", (Object)invoiceDto.getDeductionFlag());
                    if ("true".equals(deductionFlag) || "1".equals(deductionFlag)) {
                        invoiceDto.setDeductionPurpose("1");
                    } else if ("false".equals(deductionFlag) || "0".equals(deductionFlag)) {
                        invoiceDto.setDeductionPurpose("2");
                        if (StringUtils.isNotBlank((String)notDeductibleType) && NOT_DEDUCTIBLE_TYPE_LIST.contains(notDeductibleType)) {
                            invoiceDto.setNotDeductibleType(notDeductibleType);
                        } else {
                            invoiceDto.setNotDeductibleType("5");
                        }
                    }
                }
                invoiceDto.setDeductionAmount(invoice.getBigDecimal("deductionTaxAmount"));
                invoiceDto.setEffectiveTaxAmount(invoice.getBigDecimal("effectiveTaxAmount"));
                invoiceDto.setOutputAmount(invoice.getBigDecimal("outputAmount"));
                invoiceDto.setRemark(invoice.getString("remark"));
                invoiceDto.setEntryId(invoice.getString("entryId"));
                invoiceDto.setOriginalState(invoice.getString("originalState"));
                invoiceDto.setOrgId(invoice.getLong("invoiceOrgId"));
                invoiceDto.setExtInfo(invoice.getJSONObject("extInfo"));
                invoiceDto.setInvoiceResource(invoice.getString("invoiceResource"));
                subList.add(invoiceDto);
            }
            dto.setInvoiceList(subList);
        }
        dto.setAttachList(jsonObj);
        JSONObject coverData = jsonObj.getJSONObject("coverData");
        if (coverData != null) {
            ArrayList<ExpenseCoverDTO> coverList = new ArrayList<ExpenseCoverDTO>(1);
            ExpenseCoverDTO expenseCoverDTO = new ExpenseCoverDTO();
            expenseCoverDTO.setCoverNo(coverData.getString("coveNo"));
            expenseCoverDTO.setBase64(coverData.getString("base64"));
            String type = coverData.getString("coveType");
            if (type != null && (type.equalsIgnoreCase("pdf") || "1".equals(type))) {
                expenseCoverDTO.setFileType(1);
            } else {
                expenseCoverDTO.setFileType(2);
            }
            coverList.add(expenseCoverDTO);
            dto.setCoverDTOList(coverList);
            jsonObj.remove((Object)"coverData");
            jsonObj.put("coverMsg", (Object)String.format(ResManager.loadKDString((String)"\u5c01\u9762\u6570\u91cf%1$s,base64: %2$s", (String)"AbstractFpzsService_0", (String)"imc-rim-common", (Object[])new Object[0]), coverList.size(), StringUtils.length((String)expenseCoverDTO.getBase64())));
            this.saveExpenseLog(String.valueOf(param.get("rim_operate_method")), billId, billNo, jsonObj.toJSONString());
        } else {
            this.saveExpenseLog(String.valueOf(param.get("rim_operate_method")), billId, billNo, json);
        }
        return dto;
    }

    private void setBotpBillList(JSONObject jsonObj, ExpenseDTO dto) {
        try {
            JSONArray botpBillArray = jsonObj.getJSONArray("botpBillList");
            if (botpBillArray != null) {
                ArrayList<Map<String, String>> botpBillList = new ArrayList<Map<String, String>>(botpBillArray.size());
                for (int i = 0; i < botpBillArray.size(); ++i) {
                    JSONObject rowIdObject = botpBillArray.getJSONObject(i);
                    HashMap<String, String> resultMap = new HashMap<String, String>(2);
                    resultMap.put("billId", rowIdObject.getString("billId"));
                    resultMap.put("entityId", rowIdObject.getString("entityId"));
                    botpBillList.add(resultMap);
                }
                dto.setBotpBillList(botpBillList);
            }
        }
        catch (Exception e) {
            logger.info("\u5904\u7406botp\u5173\u8054\u5173\u7cfb\u51fa\u9519");
        }
    }

    protected void saveExpenseLog(String logType, String billId, String billNo, String content) {
        try (TXHandle h = TX.requiresNew();){
            try {
                InvoiceLog.insertExpenseLog(logType, billId, billNo, content);
            }
            catch (Throwable e) {
                h.markRollback();
            }
        }
    }

    public abstract Map<String, Object> saveVoucher(Map<String, Object> var1);

    public abstract Map<String, Object> saveVoucherCover(Map<String, Object> var1);

    public abstract Map<String, Object> queryInvoiceAndFile(Map<String, Object> var1);

    public abstract Map<String, Object> queryInvoice(Map<String, Object> var1);

    public abstract Map<String, Object> queryAttach(Map<String, Object> var1);

    public abstract Map<String, Object> queryCover(Map<String, Object> var1);

    public abstract Map<String, Object> deleteVoucher(Map<String, Object> var1);

    public Map<String, Object> syncSimInvoice(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        try {
            String originalState;
            String json = SerializationUtils.toJsonString(param);
            logger.info("syncSimInvoice-param:" + json);
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            String orgId = jsonObj.getString("orgId");
            String buyerOrgId = jsonObj.getString("buyerOrgId");
            String serialNo = jsonObj.getString("serialNo");
            QFilter filter = new QFilter("orderno", "=", (Object)serialNo);
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter[]{filter});
            if (idObject == null) {
                logger.info("syncSimInvoice\u9500\u9879\u53d1\u7968\u4e0d\u5b58\u5728{}", (Object)serialNo);
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"FpzsService_6", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"sim_vatinvoice");
            JSONObject invoiceObj = new JSONObject();
            invoiceObj.put("originalParam", (Object)jsonObj);
            invoiceObj.put("dataSource", (Object)"simInvoice");
            if (StringUtils.isEmpty((String)orgId) && StringUtils.isNotEmpty((String)buyerOrgId)) {
                QFilter filter1 = new QFilter("serial_no", "=", (Object)serialNo);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"org_id as org", (QFilter[])new QFilter[]{filter1});
                if (obj == null) {
                    invoiceObj.put("org_id", (Object)buyerOrgId);
                } else {
                    invoiceObj.put("org_id", (Object)obj.getLong("org"));
                }
            } else {
                invoiceObj.put("org_id", (Object)orgId);
            }
            invoiceObj.put("serialNo", (Object)serialNo);
            String invoicetype = invoiceObject.getString("invoicetype");
            String inputType = "";
            if ("026".equals(invoicetype)) {
                inputType = "1";
            } else if ("028".equals(invoicetype)) {
                inputType = "2";
            } else if ("007".equals(invoicetype)) {
                inputType = "3";
            } else if ("004".equals(invoicetype)) {
                inputType = "4";
            } else if ("08xdp".equals(invoicetype)) {
                inputType = "27";
            } else if ("10xdp".equals(invoicetype)) {
                inputType = "26";
            } else if ("025".equals(invoicetype)) {
                inputType = "5";
            }
            invoiceObj.put("invoiceType", (Object)inputType);
            invoiceObj.put("invoiceAmount", invoiceObject.get("invoiceamount"));
            invoiceObj.put("type", invoiceObject.get("issuetype"));
            invoiceObj.put("payee", invoiceObject.get("payee"));
            invoiceObj.put("salerTaxNo", invoiceObject.get("salertaxno"));
            invoiceObj.put("machineNo", invoiceObject.get("jqbh"));
            invoiceObj.put("invoiceNo", invoiceObject.get("invoiceno"));
            invoiceObj.put("buyerTaxNo", invoiceObject.get("buyertaxno"));
            invoiceObj.put("originalInvoiceNo", invoiceObject.get("originalinvoiceno"));
            invoiceObj.put("invoiceCode", invoiceObject.get("invoicecode"));
            invoiceObj.put("serialNo", (Object)serialNo);
            invoiceObj.put("checkCode", invoiceObject.get("checkcode"));
            invoiceObj.put("totalAmount", invoiceObject.get("totalamount"));
            invoiceObj.put("salerAddressPhone", invoiceObject.get("saleraddr"));
            invoiceObj.put("totalTaxAmount", invoiceObject.get("totaltax"));
            invoiceObj.put("originalInvoiceCode", invoiceObject.get("originalinvoicecode"));
            invoiceObj.put("salerName", invoiceObject.get("salername"));
            invoiceObj.put("remark", invoiceObject.get("remark"));
            invoiceObj.put("checkStatus", (Object)"1");
            invoiceObj.put("buyerAddressPhone", invoiceObject.get("buyeraddr"));
            invoiceObj.put("drawer", invoiceObject.get("drawer"));
            invoiceObj.put("reviewer", invoiceObject.get("reviewer"));
            invoiceObj.put("invoiceDate", invoiceObject.get("issuetime"));
            invoiceObj.put("buyerName", invoiceObject.get("buyername"));
            String issueSource = invoiceObject.getString("issuesource");
            invoiceObj.put("invalidDate", invoiceObject.get("invaliddate"));
            String pdfFileurl = (String)invoiceObject.get("pdffileurl");
            String fileType = "1";
            String fileUrl = null;
            String xmlFileUrl = null;
            boolean electricFlag = false;
            if ("26".equals(inputType) || "27".equals(inputType)) {
                fileUrl = (String)invoiceObject.get("fileurl");
                if (StringUtils.isNotEmpty((String)fileUrl)) {
                    electricFlag = true;
                    fileType = "4";
                }
                if (StringUtils.isNotEmpty((String)pdfFileurl)) {
                    electricFlag = true;
                }
                xmlFileUrl = (String)invoiceObject.get("xmlfileurl");
            } else if (StringUtils.isEmpty((String)pdfFileurl)) {
                pdfFileurl = (String)invoiceObject.get("fileurl");
                if ("2".equals(inputType)) {
                    fileType = "4";
                }
            }
            if (!StringUtils.isEmpty((String)pdfFileurl) || electricFlag) {
                invoiceObj.put("generatePdf", (Object)"0");
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_IMG2);
                JSONObject object = new JSONObject();
                if ("26".equals(inputType) || "27".equals(inputType)) {
                    object.put("sim_down_file", (Object)"1");
                    object.put("snapshot_url", (Object)xmlFileUrl);
                    if ("1".equals(fileType)) {
                        object.put("fileUrl", (Object)pdfFileurl);
                    } else {
                        object.put("fileUrl", (Object)fileUrl);
                        object.put("ofd_url", (Object)pdfFileurl);
                    }
                } else {
                    object.put("fileUrl", (Object)pdfFileurl);
                }
                object.put("fileType", (Object)fileType);
                object.put("invoiceType", (Object)inputType);
                object.put("serialNo", (Object)serialNo);
                service.insert(serialNo, object);
            }
            if ("1".equals(originalState = jsonObj.getString("originalState"))) {
                invoiceObj.put("originalState", (Object)"1");
            }
            invoiceObj.put("buyerAccount", invoiceObject.get("buyerbank"));
            String invoicestatus = invoiceObject.getString("invoicestatus");
            if ("6".equals(invoicestatus)) {
                invoiceObj.put("invoiceStatus", (Object)"2");
            } else {
                invoiceObj.put("invoiceStatus", (Object)invoicestatus);
            }
            DynamicObjectCollection items = invoiceObject.getDynamicObjectCollection("items");
            JSONArray itemArray = new JSONArray();
            for (DynamicObject item : items) {
                JSONObject itemObj = new JSONObject();
                itemObj.put("unitPrice", item.get("unitprice"));
                itemObj.put("num", item.get("num"));
                itemObj.put("preferentialPolicy", item.get("taxpremark"));
                itemObj.put("zeroTaxRateFlag", item.get("zerotaxmark"));
                itemObj.put("taxRate", item.get("taxrate"));
                itemObj.put("unit", item.get("unit"));
                itemObj.put("specModel", item.get("specification"));
                itemObj.put("detailAmount", item.get("amount"));
                itemObj.put("vatException", item.get("zzstsgl"));
                itemObj.put("goodsCode", item.get("goodscode"));
                itemObj.put("taxAmount", item.get("tax"));
                itemObj.put("goodsName", item.get("goodsname"));
                itemObj.put("discountType", item.get("rowtype"));
                itemArray.add((Object)itemObj);
            }
            invoiceObj.put("items", (Object)itemArray);
            invoiceObj.put("resource", (Object)"\u5f00\u7968\u7ba1\u7406");
            invoiceObj.put("collect_type", (Object)CollectTypeEnum.PC_SIM.getCode());
            invoiceObj.put("needUserRelation", (Object)"0");
            InvoiceSaveService saveService = InvoiceSaveService.newInstance(inputType);
            InvoiceSaveResult saveResult = saveService.save(invoiceObj);
            Object voucher = jsonObj.get((Object)"voucherInfo");
            if (voucher != null) {
                JSONObject voucherInfo = null;
                JSONArray serialNoArray = new JSONArray();
                serialNoArray.add((Object)saveResult.getSerialNo());
                if (voucher instanceof List) {
                    JSONArray voucherInfoArray = jsonObj.getJSONArray("voucherInfo");
                    HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                    VoucherService voucherService = new VoucherService();
                    for (int i = 0; i < voucherInfoArray.size(); ++i) {
                        JSONObject vouch = voucherInfoArray.getJSONObject(i);
                        String vouchId = vouch.getString("vouchId");
                        String resource = vouch.getString("resource");
                        if (!StringUtils.isNotEmpty((String)vouchId) || !StringUtils.isNotEmpty((String)resource)) continue;
                        voucherParam.put("voucherInfo", vouch);
                        voucherParam.put("serialNoArray", serialNoArray);
                        voucherService.saveVoucher(voucherParam);
                    }
                } else {
                    voucherInfo = jsonObj.getJSONObject("voucherInfo");
                    HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                    String vouchId = voucherInfo.getString("vouchId");
                    String resource = voucherInfo.getString("resource");
                    if (StringUtils.isNotEmpty((String)vouchId) && StringUtils.isNotEmpty((String)resource)) {
                        VoucherService voucherService = new VoucherService();
                        voucherParam.put("voucherInfo", voucherInfo);
                        voucherParam.put("serialNoArray", serialNoArray);
                        voucherService.saveVoucher(voucherParam);
                    }
                }
            }
            if (!StringUtils.isEmpty((String)pdfFileurl) || electricFlag) {
                FileHandleService.startDownAwsFile("0");
            }
        }
        catch (Exception e) {
            logger.error("syncSimInvoice-error:", (Throwable)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"FpzsService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return ResultContant.createSuccessJSONObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean fileExists(String url) {
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(url));){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("syncSimInvoice-\u6587\u4ef6\u4e0d\u5b58\u5728{}", (Object)url);
            return false;
        }
    }

    public abstract List<Map<String, String>> queryFile(List<String> var1);

    public Map<String, Object> queryPermissionByOrgId(Long orgId) {
        if (orgId == null) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (StringUtils.isEmpty((String)taxNo)) {
            logger.info("\u8bb8\u53ef\u63a7\u5236\u5f53\u524d\u7ec4\u7ec7{}\u7a0e\u53f7\u4e3a\u7a7a", (Object)orgId);
            return ResultContant.createJSONObject(ErrorType.NO_ACCESS);
        }
        QFilter taxFilter = new QFilter("epinfo.number", "=", (Object)taxNo);
        QFilter groupFilter = new QFilter("servergroup", "=", (Object)"1");
        QFilter stateFilter = new QFilter("authstate", "=", (Object)"1");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"id,orginfo.id as org_id,authstate", (QFilter[])new QFilter[]{taxFilter, groupFilter, stateFilter});
        if (collect == null || collect.isEmpty()) {
            logger.info("\u8bb8\u53ef\u63a7\u5236\u5f53\u524d\u7ec4\u7ec7{}\u7a0e\u53f7{}\u672a\u6388\u6743", (Object)orgId, (Object)taxNo);
            return ResultContant.createJSONObject(ErrorType.NO_ACCESS);
        }
        JSONObject returnResult = ResultContant.createSuccessJSONObject();
        return returnResult;
    }

    public abstract Map<String, Object> signInvoice(List<String> var1);

    public abstract Map<String, Object> unSignInvoice(List<String> var1);

    public abstract Map<String, Object> dapVoucherWriteBack(Map<String, Object> var1);

    public abstract Map<String, Object> recognitionCheck(Map<String, Object> var1);

    public abstract Map<String, Object> editInvoice(Map<String, Object> var1);

    public void setParamValue(DynamicObject mainInvoice, JSONObject paramJson) {
        for (String key : paramJson.keySet()) {
            try {
                String columnKey = AbstractFpzsService.camelToUnderscore(key);
                if ("currencyId".equals(key)) {
                    columnKey = "currencyid";
                }
                DynamicObjectUtil.setDynamicObjectValue(mainInvoice, columnKey, paramJson, key);
            }
            catch (Exception exception) {}
        }
    }

    public static String camelToUnderscore(String camelCase) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public abstract Map<String, Object> outInvoiceApply(Map<String, Object> var1);

    public abstract Map<String, Object> outInvoiceDownloadResult(Map<String, Object> var1);

    public abstract Map<String, Object> stopInvoiceDownload(Map<String, Object> var1);
}

