/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.multitenant.model.MultiTenantConfig;
import kd.imc.rim.common.multitenant.service.MultiApiService;
import kd.imc.rim.common.utils.FileUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MultiTenantService {
    private static final Log logger = LogFactory.getLog(MultiTenantService.class);
    private boolean multiTenantFlag = false;
    private MultiApiService apiService = MultiApiService.newInstance();
    public static String LOCAL_FILE = "LOCAL_FILE";

    public MultiTenantService() {
        if (this.apiService != null) {
            this.multiTenantFlag = this.apiService.isMultiTenant();
        }
    }

    public boolean isMultiTenant() {
        return this.multiTenantFlag;
    }

    public Object doPost(String service, String method, Object param, Long orgId, Long userId) {
        JSONObject params = new JSONObject();
        RequestContext context = RequestContext.get();
        if (orgId == null || orgId <= 0L) {
            orgId = context.getOrgId();
        }
        if (userId == null || userId <= 0L) {
            userId = Long.parseLong(context.getUserId());
        }
        params.put("reqOrgNumber", (Object)this.getOrgNumber(orgId));
        params.put("reqUerNumber", (Object)this.getUserNumber(userId));
        params.put("reqTenantId", (Object)context.getTenantId());
        params.put("reqAccountId", (Object)context.getAccountId());
        params.put("reqTraceId", (Object)context.getTraceId());
        params.put("reqService", (Object)service);
        params.put("reqMethod", (Object)method);
        params.put("reqParam", param);
        try {
            Object result = this.apiService.doPost("/kapi/v2/rim/multitenant/fpzs/service", "multitenant/fpzs/service", params);
            String reslutStr = null;
            reslutStr = result instanceof String ? (String)result : SerializationUtils.toJsonString((Object)result);
            JSONObject resultObject = JSONObject.parseObject((String)reslutStr);
            if ("0000".equals(resultObject.getString("errorCode"))) {
                return resultObject.get((Object)"data");
            }
            throw new KDBizException(new ErrorCode(resultObject.getString("errorCode"), resultObject.getString("message")), new Object[]{resultObject.get((Object)"data")});
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("http\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"http\u8bf7\u6c42\u51fa\u9519[%1$s],traceId:%2$s", (String)"MultiTenantService_0", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage(), context.getTraceId()));
        }
    }

    public Object doPost(String service, String method, Object param) {
        return this.doPost(service, method, param, 0L, 0L);
    }

    public String getOrgNumber(long orgId) {
        DynamicObject receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (receiverObj != null) {
            return receiverObj.getString("number");
        }
        return null;
    }

    public Long getOrgId(String orgNumber) {
        DynamicObject receiverObj;
        if (StringUtils.isNotEmpty((CharSequence)orgNumber) && (receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray())) != null) {
            return receiverObj.getLong("id");
        }
        return 0L;
    }

    public String getUserNumber(long orgId) {
        DynamicObject receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (receiverObj != null) {
            return receiverObj.getString("number");
        }
        return null;
    }

    public Long getUserId(String orgNumber) {
        DynamicObject receiverObj;
        if (StringUtils.isNotEmpty((CharSequence)orgNumber) && (receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray())) != null) {
            return receiverObj.getLong("id");
        }
        return 0L;
    }

    public MultiTenantConfig getMultiTenantConfig() {
        return this.apiService.getMultiTenantConfig();
    }

    public Map<String, String> queryLocalUrl(Set<String> urlList) {
        return this.queryLocalUrl(urlList, false);
    }

    public Map<String, String> queryLocalUrl(Set<String> urlList, boolean down) {
        HashMap<String, String> fileMap = new HashMap<String, String>(8);
        if (urlList != null && !urlList.isEmpty()) {
            HashSet urlIdSet = new HashSet(urlList.size());
            urlList.forEach(url -> urlIdSet.add(FileUtils.getFileId(url)));
            QFilter filter = new QFilter("fileid", "in", urlIdSet);
            DynamicObjectCollection objList = QueryServiceHelper.query((String)"rim_download_file", (String)"id,file_url,http_url", (QFilter[])new QFilter[]{filter});
            for (DynamicObject obj : objList) {
                String remoteUrl = obj.getString("http_url");
                String localUrl = obj.getString("file_url");
                if (StringUtils.isEmpty((CharSequence)localUrl)) continue;
                fileMap.put(remoteUrl, localUrl);
            }
            if (down) {
                urlList.forEach(url -> {
                    String local;
                    if (fileMap.get(url) == null && StringUtils.isNotEmpty((CharSequence)(local = this.getLocalUrl((String)url, true)))) {
                        fileMap.put((String)url, local);
                    }
                });
            }
        }
        return fileMap;
    }

    public String getLocalUrl(String remoteUrl, boolean down) {
        if (!this.multiTenantFlag || StringUtils.isEmpty((CharSequence)remoteUrl)) {
            return remoteUrl;
        }
        String fileId = FileUtils.getFileId(remoteUrl);
        Pair<String, String> pair = FileUtils.queryFileUrl(fileId);
        if (pair != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.getLeft()))) {
            return (String)pair.getLeft();
        }
        if (down) {
            return this.apiService.downloadFile(remoteUrl, fileId);
        }
        return null;
    }

    public String getLocalUrl(String remoteUrl) {
        return this.getLocalUrl(remoteUrl, true);
    }

    public String getRemoteUrl(String localUrl, String fileName) {
        if (!this.multiTenantFlag) {
            return localUrl;
        }
        if (StringUtils.isEmpty((CharSequence)localUrl)) {
            return localUrl;
        }
        String fileId = FileUtils.getFileId(localUrl);
        Pair<String, String> pair = FileUtils.queryFileUrl(fileId);
        if (pair != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.getRight()))) {
            return (String)pair.getRight();
        }
        String remoteUrl = this.apiService.uploadFile(localUrl, fileName);
        if (StringUtils.isNotEmpty((CharSequence)remoteUrl)) {
            FileUtils.saveFilePath(remoteUrl, localUrl, fileId, FileUtils.getFileType(fileName));
        }
        return remoteUrl;
    }

    public String uploadFileUrl(String fileUrl) {
        if (!this.multiTenantFlag) {
            return fileUrl;
        }
        return this.getLocalUrl(fileUrl);
    }
}

