/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.service.ExpenseCallBackService;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.input.InputInvoiceDataService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.multitenant.service.AbstractFpzsService;
import kd.imc.rim.common.service.RecognitionCheckAPIService;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang.StringUtils;

public class FpzsLocalService
extends AbstractFpzsService {
    private static final Log logger = LogFactory.getLog(FpzsLocalService.class);

    @Override
    public Map<String, Object> save(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        param.put("rim_operate_method", "\u4fdd\u5b58\u5355\u636e\u53d1\u7968\u5173\u7cfb");
        ExpenseDTO dto = this.getExpenseDTO(param);
        try {
            ExpenseService service = new ExpenseService();
            service.save(dto);
            this.pushBdsBySave(dto);
        }
        catch (MsgException e) {
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> delete(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        param.put("rim_operate_method", "\u5220\u9664\u5355\u636e\u53d1\u7968\u5173\u7cfb");
        ExpenseDTO dto = this.getExpenseDTO(param);
        ExpenseService service = new ExpenseService();
        try (TXHandle h = TX.requiresNew();){
            try {
                service.delete(dto);
                if (!StringUtils.isEmpty((String)dto.getEntityId()) && !StringUtils.isEmpty((String)dto.getExpenseId())) {
                    ExpenseDTO dto1 = new ExpenseDTO();
                    if (dto.getExpenseId().startsWith(dto.getEntityId())) {
                        dto1.setExpenseId(dto.getExpenseId());
                    } else {
                        dto1.setExpenseId(dto.getEntityId() + '_' + dto.getExpenseId());
                    }
                    dto1.setResource("aws");
                    service.delete(dto1);
                }
                this.pushBdsByDelete(dto);
            }
            catch (Throwable e) {
                logger.error("\u5220\u9664\u62a5\u9500\u5355\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> deleteAttach(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String json = SerializationUtils.toJsonString(param);
        logger.info("deleteAttach-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String billId = jsonObj.getString("billId");
        if (StringUtils.isEmpty((String)billId)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String entityId = jsonObj.getString("entityId");
        String resource = jsonObj.getString("resource");
        JSONArray attachNoArray = jsonObj.getJSONArray("attachIds");
        ArrayList<String> attachIds = new ArrayList<String>(8);
        if (attachNoArray != null) {
            for (int i = 0; i < attachNoArray.size(); ++i) {
                attachIds.add(attachNoArray.getString(i));
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                AttachQueryService attachQueryService = new AttachQueryService();
                attachQueryService.deleteFpzsAttach(billId, entityId, resource, attachIds);
            }
            catch (Throwable e) {
                logger.error("\u5220\u9664\u9644\u4ef6\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
        JSONObject result = ResultContant.createSuccessJSONObject();
        return result;
    }

    @Override
    public Map<String, Object> deleteInvoice(List<String> serialList) {
        if (serialList == null || serialList.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        QFilter serialFilter = new QFilter("serial_no", "in", serialList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type", (QFilter[])new QFilter[]{serialFilter});
        ArrayList<Object> pkList = new ArrayList<Object>(collect.size());
        for (DynamicObject obj : collect) {
            pkList.add(obj.get("id"));
        }
        InputInvoiceDataService service = new InputInvoiceDataService();
        service.deleteInvoice(pkList.toArray());
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> query(List<String> param, String resource, String orgType) {
        List<Map<String, DynamicObject>> list = VerifyUtil.queryInvoiceDynamicObjectBySerialNos(param, false);
        JSONArray data = new JSONArray();
        for (Map<String, DynamicObject> map : list) {
            DynamicObject mainObj = map.get("main");
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainObj.get("invoice_type"));
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType);
            convertService.setResource(resource);
            convertService.setOrgType(orgType);
            Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObj);
            Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(map.get("file"));
            JSONObject bodyMap = DynamicObjectUtil.dynamicObjectToMap(map.get("detail"));
            try {
                Object uncheckTag = bodyMap.get("invoice_detail_tag");
                if (uncheckTag != null) {
                    bodyMap = JSONObject.parseObject((String)(uncheckTag + "")).getJSONObject("detail");
                    this.convertDateLong((Map<String, Object>)bodyMap, "modifytime", "invoice_date", "createtime");
                }
            }
            catch (Exception uncheckTag) {
                // empty catch block
            }
            InvoiceConvertService.putAll(mainMap, fileMap);
            InvoiceConvertService.putAll(mainMap, bodyMap);
            InvoiceConvertService.updateAirInvocieAmount(invoiceType, mainMap, bodyMap);
            JSONObject json = convertService.convert(mainMap);
            data.add((Object)json);
        }
        JSONObject result = ResultContant.createSuccessJSONObject();
        result.put("data", data);
        return result;
    }

    @Override
    public Map<String, Object> queryVerify(Map<String, Object> param) {
        String json = SerializationUtils.toJsonString(param);
        logger.info("queryVerify-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        VerifyService.convertBuyerInfo(jsonObj, jsonObj);
        VerifyService.convertSalerInfo(jsonObj, jsonObj);
        JSONObject result = ResultContant.createSuccessJSONObject();
        JSONArray serialNos = jsonObj.getJSONArray("serialNos");
        if (serialNos == null || serialNos.isEmpty()) {
            result.put("data", new JSONArray());
        } else {
            ArrayList<String> serialNoList = new ArrayList<String>(serialNos.size());
            for (int i = 0; i < serialNos.size(); ++i) {
                serialNoList.add(serialNos.getString(i));
            }
            JSONArray resultList = VerifyUtil.verifyBySerialNos((Map<String, Object>)jsonObj, serialNoList, true);
            result.put("data", resultList);
        }
        return result;
    }

    @Override
    public Map<String, Object> check(Map<String, Object> param) {
        DynamicObject dynamicObject;
        String check_status;
        String json = SerializationUtils.toJsonString(param);
        logger.info("check-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String billId = jsonObj.getString("billId");
        String entityId = jsonObj.getString("entityId");
        String serialNo = jsonObj.getString("serialNo");
        String invoiceCode = jsonObj.getString("invoiceCode");
        String invoiceNo = jsonObj.getString("invoiceNo");
        String invoiceAmount = jsonObj.getString("invoiceAmount");
        String invoiceDate = jsonObj.getString("invoiceDate");
        String checkCode = jsonObj.getString("checkCode");
        if (StringUtils.isNotEmpty((String)serialNo)) {
            String check_status2;
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject dynamicObject2 = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"serial_no,check_status", (QFilter[])new QFilter[]{serialFilter});
            if (dynamicObject2 != null && "1".equals(check_status2 = dynamicObject2.getString("check_status"))) {
                ArrayList<String> serailList = new ArrayList<String>(8);
                serailList.add(dynamicObject2.getString("serial_no"));
                Map<String, Object> map = this.query(serailList, "4");
                JSONObject result = ResultContant.createSuccessJSONObject();
                result.put("data", map);
                return result;
            }
            DynamicObject uncheckDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_uncheck", (String)"serial_no,check_status,invoice_code,invoice_no,invoice_date,invoice_amount,check_code", (QFilter[])new QFilter[]{serialFilter});
            if (uncheckDynamicObject != null) {
                Date date;
                if (StringUtils.isEmpty((String)invoiceCode)) {
                    invoiceCode = uncheckDynamicObject.getString("invoice_code");
                }
                if (StringUtils.isEmpty((String)invoiceNo)) {
                    invoiceNo = uncheckDynamicObject.getString("invoice_no");
                }
                if (StringUtils.isEmpty((String)checkCode)) {
                    checkCode = uncheckDynamicObject.getString("check_code");
                }
                if (StringUtils.isEmpty((String)invoiceDate) && (date = uncheckDynamicObject.getDate("invoice_date")) != null) {
                    invoiceDate = DateUtils.format(date, "yyyyMMdd");
                }
                if (StringUtils.isEmpty((String)invoiceAmount)) {
                    invoiceAmount = BigDecimalUtil.transDecimal(uncheckDynamicObject.get("invoice_amount")).toString();
                }
            }
        }
        if (StringUtils.isEmpty((String)invoiceDate)) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)invoiceNo)) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)checkCode) && StringUtils.isEmpty((String)invoiceAmount)) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u548c\u6821\u9a8c\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"FpzsService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        invoiceDate = invoiceDate.replace("-", "");
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no,check_status", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter});
        if (!CollectionUtils.isEmpty((Collection)mainCollection) && "1".equals(check_status = (dynamicObject = (DynamicObject)mainCollection.get(0)).getString("check_status"))) {
            ArrayList<String> serailList = new ArrayList<String>(8);
            serailList.add(dynamicObject.getString("serial_no"));
            return this.query(serailList, "4");
        }
        String invoiceType = InvoiceConvertUtils.checkInvoiceType(invoiceCode, invoiceNo);
        Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
        Long orgId = RequestContext.get().getOrgId();
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoice_type, invoiceDate, new BigDecimal(invoiceAmount), checkCode, null);
        CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo);
        JSONObject result = ResultContant.createSuccessJSONObject();
        if (checkResult != null && "0000".equals(checkResult.getErrcode())) {
            Object invoiceEntity = checkResult.getData();
            String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
            JSONObject invoiceJson = JSON.parseObject((String)invoiceCheckStr);
            try {
                InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance(invoiceJson.getString("invoiceType"));
                InvoiceSaveResult saveResult = invoiceSaveService.save(invoiceJson);
                ArrayList<String> serailList = new ArrayList<String>(8);
                serailList.add(saveResult.getSerialNo());
                return this.query(serailList, "4");
            }
            catch (MsgException e) {
                return ResultContant.createJSONObject("0001", e.getErrorMsg());
            }
        }
        if (checkResult != null) {
            String errorCode = checkResult.getErrcode();
            result.put("errcode", errorCode);
            result.put("description", CheckContant.getCheckResultDesc(errorCode));
            return result;
        }
        result.put("errcode", "0005");
        result.put("description", CheckContant.getCheckResultDesc(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"FpzsService_4", (String)"imc-rim-common", (Object[])new Object[0])));
        return result;
    }

    @Override
    public Map<String, Object> checkNew(Map<String, Object> param) {
        DynamicObject dynamicObject;
        String check_status;
        String json = SerializationUtils.toJsonString(param);
        logger.info("check-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String billId = jsonObj.getString("billId");
        String entityId = jsonObj.getString("entityId");
        String serialNo = jsonObj.getString("serialNo");
        String invoiceCode = jsonObj.getString("invoiceCode");
        String invoiceNo = jsonObj.getString("invoiceNo");
        String invoiceAmount = jsonObj.getString("invoiceAmount");
        String totalAmount = jsonObj.getString("totalAmount");
        String invoiceDate = jsonObj.getString("invoiceDate");
        String checkCode = jsonObj.getString("checkCode");
        if (StringUtils.isNotEmpty((String)serialNo)) {
            String check_status2;
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject dynamicObject2 = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"serial_no,check_status", (QFilter[])new QFilter[]{serialFilter});
            if (dynamicObject2 != null && "1".equals(check_status2 = dynamicObject2.getString("check_status"))) {
                ArrayList<String> serailList = new ArrayList<String>(8);
                serailList.add(dynamicObject2.getString("serial_no"));
                Map<String, Object> map = this.query(serailList, "4");
                return map;
            }
            DynamicObject uncheckDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_uncheck", (String)"serial_no,check_status,invoice_code,invoice_no,invoice_date,invoice_amount,check_code", (QFilter[])new QFilter[]{serialFilter});
            if (uncheckDynamicObject != null) {
                Date date;
                if (StringUtils.isEmpty((String)invoiceCode)) {
                    invoiceCode = uncheckDynamicObject.getString("invoice_code");
                }
                if (StringUtils.isEmpty((String)invoiceNo)) {
                    invoiceNo = uncheckDynamicObject.getString("invoice_no");
                }
                if (StringUtils.isEmpty((String)checkCode)) {
                    checkCode = uncheckDynamicObject.getString("check_code");
                }
                if (StringUtils.isEmpty((String)invoiceDate) && (date = uncheckDynamicObject.getDate("invoice_date")) != null) {
                    invoiceDate = DateUtils.format(date, "yyyyMMdd");
                }
                if (StringUtils.isEmpty((String)invoiceAmount)) {
                    invoiceAmount = BigDecimalUtil.transDecimal(uncheckDynamicObject.get("invoice_amount")).toString();
                }
            }
        }
        if (StringUtils.isEmpty((String)invoiceDate)) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)invoiceNo)) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        invoiceDate = invoiceDate.replace("-", "");
        if (invoiceNo.length() == 20 && !StringUtils.isEmpty((String)totalAmount)) {
            invoiceAmount = totalAmount;
        }
        if (StringUtils.isEmpty((String)checkCode) && StringUtils.isEmpty((String)invoiceAmount)) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u548c\u6821\u9a8c\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"FpzsService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no,check_status", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter});
        if (!CollectionUtils.isEmpty((Collection)mainCollection) && "1".equals(check_status = (dynamicObject = (DynamicObject)mainCollection.get(0)).getString("check_status"))) {
            ArrayList<String> serailList = new ArrayList<String>(8);
            serailList.add(dynamicObject.getString("serial_no"));
            return this.query(serailList, "4");
        }
        String invoiceType = InvoiceConvertUtils.checkInvoiceType(invoiceCode, invoiceNo);
        Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
        Long orgId = RequestContext.get().getOrgId();
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoice_type, invoiceDate, new BigDecimal(invoiceAmount), checkCode, null);
        CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo);
        JSONObject result = ResultContant.createSuccessJSONObject();
        try {
            if (checkResult != null && "0000".equals(checkResult.getErrcode())) {
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                JSONObject invoiceJson = JSON.parseObject((String)invoiceCheckStr);
                InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance(invoiceJson.getString("invoiceType"));
                InvoiceSaveResult saveResult = invoiceSaveService.save(invoiceJson);
                ArrayList<String> serailList = new ArrayList<String>(8);
                serailList.add(saveResult.getSerialNo());
                return this.query(serailList, "4");
            }
            if (checkResult != null) {
                String errorCode = checkResult.getErrcode();
                result.put("errcode", errorCode);
                result.put("description", checkResult.getDescription());
                return result;
            }
            result.put("errcode", "0005");
            result.put("description", CheckContant.getCheckResultDesc(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"FpzsService_4", (String)"imc-rim-common", (Object[])new Object[0])));
            return result;
        }
        catch (MsgException e) {
            result.put("errcode", e.getErrorCode());
            result.put("description", e.getMessage());
            return result;
        }
    }

    @Override
    public Map<String, Object> saveVoucherCover(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        try {
            VoucherService service = new VoucherService();
            service.saveVoucherCover(param);
        }
        catch (MsgException e) {
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> saveVoucher(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        try {
            VoucherService service = new VoucherService();
            service.saveVoucher(param);
        }
        catch (MsgException e) {
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> queryInvoiceAndFile(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String billId = String.valueOf(param.get("billId"));
        if (StringUtils.isEmpty((String)billId)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        Map<String, Object> invoice = this.queryInvoice(param);
        Map<String, Object> attach = this.queryAttach(param);
        Map<String, Object> cover = this.queryCover(param);
        JSONObject result = ResultContant.createSuccessJSONObject();
        result.put("invoiceData", invoice.get("data"));
        result.put("attachment", attach.get("data"));
        result.put("coverData", cover.get("data"));
        return result;
    }

    @Override
    public Map<String, Object> queryInvoice(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String billId = String.valueOf(param.get("billId"));
        if (StringUtils.isEmpty((String)billId)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("expenseId", (Object)billId);
        jsonObj.put("entityId", param.get("entityId"));
        List<String> list = InvoiceQueryService.querySerialByCondition(jsonObj);
        return this.query(list);
    }

    @Override
    public Map<String, Object> queryAttach(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String billId = String.valueOf(param.get("billId"));
        if (StringUtils.isEmpty((String)billId)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        JSONObject result = ResultContant.createSuccessJSONObject();
        String entityId = String.valueOf(param.get("entityId"));
        String resource = null;
        if (param.get("resource") != null) {
            resource = String.valueOf(param.get("resource"));
        }
        AttachQueryService attachQueryService = new AttachQueryService();
        JSONArray array = attachQueryService.queryFpzsAttach(billId, entityId, resource, true);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject attach = array.getJSONObject(i);
            String attachNo1 = attach.getString("attachNo_1");
            if (!StringUtils.isNotBlank((String)attachNo1)) continue;
            attach.put("attachNo", (Object)attachNo1);
        }
        result.put("data", (Object)array);
        return result;
    }

    @Override
    public Map<String, Object> queryCover(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String billId = String.valueOf(param.get("billId"));
        if (StringUtils.isEmpty((String)billId)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        ExpenseRelationService relationService = new ExpenseRelationService();
        JSONArray cover = relationService.queryCover(billId);
        JSONObject result = ResultContant.createSuccessJSONObject();
        result.put("data", (Object)cover);
        return result;
    }

    @Override
    public Map<String, Object> deleteVoucher(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        try {
            VoucherService service = new VoucherService();
            service.deleteVoucher(param);
        }
        catch (MsgException e) {
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public List<Map<String, String>> queryFile(List<String> serialList) {
        if (CollectionUtils.isEmpty(serialList)) {
            return null;
        }
        QFilter filter = new QFilter("serial_no", "in", serialList);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice_file", (String)"ofd_url,pdf_url,image_url,original_type,snapshot_url,pixel,region,rotation_angle", (QFilter[])new QFilter[]{filter});
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(serialList.size());
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            for (DynamicObject obj : collection) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                String fileType = obj.getString("original_type");
                map.put("fileType", fileType);
                if ("1".equals(fileType)) {
                    map.put("downloadUrl", obj.getString("pdf_url"));
                } else if ("4".equals(fileType)) {
                    map.put("downloadUrl", obj.getString("ofd_url"));
                } else if ("2".equals(fileType)) {
                    map.put("downloadUrl", obj.getString("image_url"));
                }
                map.put("imageUrl", obj.getString("image_url"));
                map.put("snapshotUrl", obj.getString("snapshot_url"));
                map.put("pixel", obj.getString("pixel"));
                map.put("region", obj.getString("region"));
                map.put("rotationAngle", obj.getString("rotation_angle"));
                list.add(map);
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> signInvoice(List<String> serialNos) {
        logger.info("\u53d1\u7968\u7b7e\u6536\u53c2\u6570:" + serialNos);
        if (serialNos == null || serialNos.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
        try {
            boolean signResult = invoiceCollectService.signInvoice(serialNos, "1");
            if (!signResult) {
                return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u7b7e\u6536\u5931\u8d25\u3002", (String)"FpzsService_8", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            ExpenseCallBackService.signInvoiceBatch(serialNos, "1");
        }
        catch (MsgException e) {
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        catch (Exception e) {
            logger.error("\u53d1\u7968\u7b7e\u6536\u5931\u8d25", (Throwable)e);
            throw e;
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> unSignInvoice(List<String> serialNos) {
        if (serialNos == null || serialNos.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
        try {
            boolean signResult = invoiceCollectService.signInvoice(serialNos, "0");
            if (!signResult) {
                return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u53cd\u7b7e\u6536\u5931\u8d25\u3002", (String)"FpzsService_9", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            ExpenseCallBackService.unSignInvoiceBatch(serialNos);
        }
        catch (MsgException e) {
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> dapVoucherWriteBack(Map<String, Object> param) {
        if (CollectionUtils.isEmpty(param)) {
            logger.error("\u51ed\u8bc1\u53cd\u5199\u53d1\u7968\u4e91consumer\u6267\u884c,\u5931\u8d25:\u53c2\u6570\u4e0d\u6b63\u786e");
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        logger.info("\u540c\u6b65\u51ed\u8bc1\u6570\u636e\u5230\u6536\u7968\u7ba1\u7406\u53c2\u6570\uff1a{}", JSON.toJSON(param));
        String voucherOpValue = (String)param.get("voucherOpValue");
        Map billPkMap = (Map)param.get("billPkMap");
        if (!CollectionUtils.isEmpty((Map)billPkMap)) {
            VoucherService service = new VoucherService();
            List<JSONObject> voucherInfoList = service.getVoucherInfoList(billPkMap);
            for (JSONObject paramObj : voucherInfoList) {
                if ("2".equals(voucherOpValue)) {
                    service.deleteVoucher((Map<String, Object>)paramObj);
                    continue;
                }
                service.saveVoucher((Map<String, Object>)paramObj);
            }
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public Map<String, Object> recognitionCheck(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String paramStr = SerializationUtils.toJsonString(param);
        logger.info("\u3010\u53d1\u7968\u52a9\u624b\u5fae\u670d\u52a1\u3011recognitionCheck-param:" + paramStr);
        JSONObject paramJson = JSONObject.parseObject((String)paramStr);
        String fileDownUrl = paramJson.getString("fileDownUrl");
        String fileType = paramJson.getString("fileType");
        if (StringUtils.isBlank((String)fileDownUrl)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a", (String)"FpzsService_10", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)fileType)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a", (String)"FpzsService_11", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String verifyFlag = paramJson.getString("verifyFlag");
        String billType = paramJson.getString("billType");
        if (StringUtils.equals((String)verifyFlag, (String)"1") && StringUtils.isBlank((String)billType)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u5408\u89c4\u6027\u6821\u9a8c\u542f\u7528\u65f6\uff0c\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsService_12", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Long orgId = paramJson.getLong("orgId");
        if (orgId == null || orgId == 0L) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5f52\u5c5e\u7ec4\u7ec7\u4e3a\u7a7a", (String)"FpzsService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        paramJson.put("collect_type", (Object)CollectTypeEnum.API_UPLOAD.getCode());
        paramJson.put("resource", (Object)"\u53d1\u7968\u52a9\u624b");
        JSONObject result = ResultContant.createSuccessJSONObject();
        try {
            JSONArray recognitionCheckResult = RecognitionCheckAPIService.getInstance().execute(paramJson);
            result.put("data", (Object)recognitionCheckResult);
        }
        catch (MsgException e) {
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff1a", (Object)e);
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        catch (Exception e) {
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff1a", (Object)e);
            return ResultContant.createJSONObject("9999", String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u67e5\u9a8c\u5931\u8d25\uff0c\u5185\u90e8\u7a0b\u5e8f\u51fa\u73b0\u9519\u8bef\uff1a%1$s", (String)"FpzsService_14", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
        return result;
    }

    @Override
    public Map<String, Object> editInvoice(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String paramStr = SerializationUtils.toJsonString(param);
        logger.info("\u3010\u53d1\u7968\u52a9\u624b\u5fae\u670d\u52a1\u3011editInvoice-param:" + paramStr);
        JSONObject paramJson = JSONObject.parseObject((String)paramStr);
        String invoiceType = paramJson.getString("invoiceType");
        String serialNo = paramJson.getString("serialNo");
        if (StringUtils.isEmpty((String)invoiceType) || StringUtils.isEmpty((String)serialNo)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53d1\u7968\u7c7b\u578b\u548c\u53d1\u7968\u6d41\u6c34\u53f7\u662f\u5426\u6709\u503c", (String)"FpzsService_20", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (!InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType))) {
            return ResultContant.createJSONObject(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u652f\u6301\u7f16\u8f91\u6d77\u5916\u53d1\u7968,\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53d1\u7968\u7c7b\u578b", (String)"FpzsService_17", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        paramJson.put("invoiceType", (Object)InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode());
        String totalAmount = paramJson.getString("totalAmount");
        String currencyName = paramJson.getString("currencyName");
        if (StringUtils.isEmpty((String)currencyName) || StringUtils.isEmpty((String)totalAmount)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d\u4e0e\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsService_21", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        try {
            DynamicObject[] mainInvoices = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields("rim_invoice"), (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"rim_inv_oversea", (String)MetadataUtil.getFields("rim_inv_oversea"), (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
            if (invoices == null || invoices.length == 0 || mainInvoices == null || mainInvoices.length == 0) {
                return ResultContant.createJSONObject(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u5bf9\u5e94\u7684\u6d77\u5916\u53d1\u7968\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"FpzsService_18", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            DynamicObject mainInvoice = mainInvoices[0];
            DynamicObject overseaInvoice = invoices[0];
            String expenseStatus = mainInvoice.getString("expense_status");
            if ("60".equals(expenseStatus) || "65".equals(expenseStatus) || "70".equals(expenseStatus)) {
                return ResultContant.createJSONObject(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u4fee\u6539\u672a\u7528\uff0c\u5728\u7528\u72b6\u6001\u4e0b\u7684\u53d1\u7968", (String)"FpzsService_19", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String dbInvoiceNo = mainInvoice.getString("invoice_no");
            Date dbInvoiceDate = mainInvoice.getDate("invoice_date");
            this.subStringParam(paramJson);
            this.setParamValue(mainInvoice, paramJson);
            this.setParamValue(overseaInvoice, paramJson);
            mainInvoice.set("invoice_no", (Object)dbInvoiceNo);
            mainInvoice.set("invoice_date", (Object)dbInvoiceDate);
            overseaInvoice.set("invoice_no", (Object)dbInvoiceNo);
            overseaInvoice.set("invoice_date", (Object)dbInvoiceDate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{overseaInvoice});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainInvoice});
            return ResultContant.createJSONObject(ErrorType.SUCCESS.getCode(), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EInvoiceZipXmlDealService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.info("\u4fee\u6539\u5931\u8d25\uff1a", (Object)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DeductionUtils_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    private void subStringParam(JSONObject paramJson) {
        paramJson.put("buyerAddress", (Object)InvoiceSaveService.subStringByLength(paramJson.getString("buyerAddress"), 300));
        paramJson.put("buyerAccount", (Object)InvoiceSaveService.subStringByLength(paramJson.getString("buyerAccount"), 250));
        paramJson.put("salerAddress", (Object)InvoiceSaveService.subStringByLength(paramJson.getString("salerAddress"), 300));
        paramJson.put("salerAccount", (Object)InvoiceSaveService.subStringByLength(paramJson.getString("salerAccount"), 250));
        paramJson.put("country", (Object)InvoiceSaveService.subStringByLength(paramJson.getString("country"), 500));
        paramJson.put("buyerName", (Object)InvoiceSaveService.subStringByLength(paramJson.getString("buyerName"), 150));
        paramJson.put("salerName", (Object)InvoiceSaveService.subStringByLength(paramJson.getString("salerName"), 150));
    }

    @Override
    public Map<String, Object> outInvoiceApply(Map<String, Object> param) {
        InputOutInvoiceApplyService applyService;
        boolean typeCheck;
        logger.info("\u9500\u9879\u53d1\u7968\u4e0b\u8f7d\u7533\u8bf7\u3010\u5fae\u670d\u52a1\u3011\u53c2\u6570:{}", param);
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        JSONObject paramObj = new JSONObject(param);
        String invoiceType = paramObj.getString("invoiceType");
        String taxNo = paramObj.getString("taxNo");
        String dataType = paramObj.getString("dataType");
        Date firstDate = paramObj.getDate("firstDate");
        Date endDate = paramObj.getDate("endDate");
        Long orgId = paramObj.getLong("orgId");
        if (StringUtils.isEmpty((String)invoiceType) || StringUtils.isEmpty((String)taxNo) || firstDate == null || endDate == null) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5[invoiceType,taxNo,firstDate,endDate,orgId]", (String)"FpzsOpenApiService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (endDate.before(firstDate) || !DateUtils.isMonth(firstDate, endDate)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u548c\u622a\u6b62\u65e5\u671f\u9700\u5728\u540c\u4e00\u6708\u4efd\u4e0a\u4e14\u622a\u6b62\u65e5\u4e0d\u80fd\u5927\u4e8e\u8d77\u59cb\u65e5", (String)"FpzsOpenApiService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)dataType)) {
            dataType = "2";
        }
        if (!(typeCheck = (applyService = InvoiceDownServiceFactory.newInstanceForApply(taxNo)).checkDownCustom(dataType, invoiceType, taxNo))) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d1\u7968\u7c7b\u578b", (String)"FpzsOpenApiService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject result = applyService.applyInputOutDownInvoice(null, null, invoiceType, dataType, orgId, taxNo, firstDate, endDate);
        logger.info("\u3010\u5fae\u670d\u52a1\u3011\u53d1\u7968\u4e0b\u8f7d\u7533\u8bf7\u7ed3\u679c\uff1a{}", (Object)result);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = new JSONObject();
            data.put("batchNo", (Object)result.getString("batchNo"));
            return ResultContant.createSuccessJSONObject(data);
        }
        return result;
    }

    @Override
    public Map<String, Object> outInvoiceDownloadResult(Map<String, Object> param) {
        logger.info("\u9500\u9879\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u3010\u5fae\u670d\u52a1\u3011\u53c2\u6570:{}", param);
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        JSONObject paramObj = new JSONObject(param);
        String batchNo = paramObj.getString("batchNo");
        if (StringUtils.isEmpty((String)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7batchNo\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsOpenApiService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        QFilter batchFilter = new QFilter("batch_no", "=", (Object)batchNo);
        DynamicObject object = QueryServiceHelper.queryOne((String)"rim_down_log", (String)"gov_status, total_num, success_num, description", (QFilter[])new QFilter[]{batchFilter});
        if (object == null) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6b21\u53f7\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7ed3\u679c", (String)"FpzsOpenApiService_4", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String govStatus = object.getString("gov_status");
        String status = "fail";
        if ("6".equals(govStatus) || "8".equals(govStatus)) {
            status = "wait";
        } else if ("5".equals(govStatus) || "7".equals(govStatus)) {
            status = "fail";
        } else if ("1".equals(govStatus) || "9".equals(govStatus)) {
            status = "success";
        }
        JSONObject data = new JSONObject();
        data.put("govStatus", (Object)govStatus);
        data.put("status", (Object)status);
        data.put("totalNum", (Object)object.getString("total_num"));
        data.put("successNum", (Object)object.getString("success_num"));
        data.put("description", (Object)object.getString("description"));
        return ResultContant.createSuccessJSONObject(data);
    }

    @Override
    public Map<String, Object> stopInvoiceDownload(Map<String, Object> param) {
        logger.info("\u505c\u6b62\u9500\u9879\u53d1\u7968\u4e0b\u8f7d\u3010\u5fae\u670d\u52a1\u3011\u53c2\u6570:{}", param);
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        JSONObject paramObj = new JSONObject(param);
        String batchNo = paramObj.getString("batchNo");
        if (StringUtils.isEmpty((String)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7batchNo\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsOpenApiService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        QFilter batchFilter = new QFilter("batch_no", "=", (Object)batchNo);
        DynamicObject[] object = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"gov_status, total_num, success_num, description", (QFilter[])new QFilter[]{batchFilter});
        if (object == null || object.length <= 0) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6b21\u53f7\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7ed3\u679c", (String)"FpzsOpenApiService_4", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        DynamicObject logObj = object[0];
        logObj.set("gov_status", (Object)"7");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
        return ResultContant.createSuccessJSONObject();
    }
}

