/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.multitenant.service.AbstractInputService;
import kd.imc.rim.common.multitenant.service.impl.FpzsLocalService;
import kd.imc.rim.common.service.RecognitionCheckAPIService;
import org.apache.commons.lang.StringUtils;

public class InputLocalService
extends AbstractInputService {
    private static final Log logger = LogFactory.getLog(InputLocalService.class);

    @Override
    public Map<String, String> queryInvoiceSerialNo(List<Map<String, String>> param) {
        String json = SerializationUtils.toJsonString(param);
        return InvoiceQueryService.querySerialByCodeAndNo(JSONArray.parseArray((String)json));
    }

    @Override
    public Map<String, Object> invoiceRecognitionCheck(Map<String, Object> param) {
        String json = SerializationUtils.toJsonString(param);
        JSONObject data = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)json));
        ApiResult result = null;
        try {
            JSONArray execute = RecognitionCheckAPIService.getInstance().execute(data);
            result = ApiResult.success((Object)execute);
        }
        catch (MsgException e) {
            result = ApiResult.fail((String)e.getMessage(), (String)e.getErrorCode());
            result.setData((Object)new JSONArray());
        }
        catch (Exception e) {
            result = ApiResult.fail((String)e.getMessage(), (String)"9999");
            result.setData((Object)new JSONArray());
        }
        return ApiResult.toMap((ApiResult)result);
    }

    @Override
    public Map<String, Object> queryInvoice(Map<String, Object> param) {
        String json = SerializationUtils.toJsonString(param);
        logger.info("queryInvoice-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        List<String> serialList = InvoiceQueryService.querySerialByCondition(jsonObj);
        if (CollectionUtils.isEmpty(serialList)) {
            return ResultContant.createSuccessJSONObject();
        }
        FpzsLocalService fpzsService = new FpzsLocalService();
        return fpzsService.query(serialList, "4");
    }

    @Override
    public Map<String, Object> queryInvoiceByExpenseId(String expenseId) {
        if (StringUtils.isEmpty((String)expenseId)) {
            return ResultContant.createSuccessJSONObject();
        }
        HashMap<String, String> param = new HashMap<String, String>(8);
        param.put("expenseId", expenseId);
        return this.queryInvoiceByExpense(param);
    }

    @Override
    public Map<String, Object> queryInvoiceByExpense(Map<String, String> param) {
        QFilter filter;
        DynamicObjectCollection collection;
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        logger.info("queryInvoiceByExpense-param:" + param);
        String expenseId = param.get("expenseId");
        String entityId = param.get("entityId");
        if (StringUtils.isEmpty((String)expenseId)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"expenseId\u4e0d\u80fd\u4e3a\u7a7a", (String)"InputLocalService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject json = new JSONObject();
        json.put("expenseId", (Object)expenseId);
        json.put("entityId", (Object)entityId);
        List<String> serialList = InvoiceQueryService.querySerialByCondition(json);
        if (CollectionUtils.isEmpty(serialList)) {
            return ResultContant.createSuccessJSONObject();
        }
        FpzsLocalService fpzsService = new FpzsLocalService();
        Map<String, Object> result = fpzsService.query(serialList, "4");
        JSONArray data = (JSONArray)result.get("data");
        if (!CollectionUtils.isEmpty((Collection)data) && !CollectionUtils.isEmpty((Collection)(collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_num,expense_id,status,serial_no", (QFilter[])new QFilter[]{filter = new QFilter("serial_no", "in", serialList)})))) {
            String serialNo;
            HashMap<String, Set> expenseInfoMap = new HashMap<String, Set>(16);
            QFilter filterExpense = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObject batchObject = QueryServiceHelper.queryOne((String)"rim_expense", (String)"batch", (QFilter[])filterExpense.toArray());
            for (DynamicObject expense : collection) {
                serialNo = expense.getString("serial_no");
                Set expenseIdSet = expenseInfoMap.getOrDefault(serialNo, new HashSet(8));
                HashMap<String, String> map = new HashMap<String, String>(4);
                map.put("expenseNum", expense.getString("expense_num"));
                map.put("expenseId", expense.getString("expense_id"));
                map.put("status", expense.getString("status"));
                if (batchObject != null) {
                    map.put("batch", batchObject.getString("batch"));
                }
                expenseIdSet.add(map);
                expenseInfoMap.put(serialNo, expenseIdSet);
            }
            for (int i = 0; i < data.size(); ++i) {
                JSONObject invoice = data.getJSONObject(i);
                serialNo = invoice.getString("serialNo");
                Set set = (Set)expenseInfoMap.get(serialNo);
                if (set == null) continue;
                invoice.put("expenseInfo", (Object)set);
            }
        }
        JSONObject returnResult = ResultContant.createSuccessJSONObject();
        returnResult.put("data", data);
        return returnResult;
    }

    @Override
    public Map<String, Object> queryByArchive(Map<String, String> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        JSONObject returnData = new JSONObject();
        String coverNo = param.get("coverNo");
        QFilter coverFilter = new QFilter("cover_no", "=", (Object)coverNo);
        DynamicObjectCollection coverObjs = QueryServiceHelper.query((String)"rim_cover", (String)"id,cover_no,cover_type,cover_url,snapshot_url", (QFilter[])coverFilter.toArray());
        if (coverObjs == null || coverObjs.size() < 1) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u5c01\u9762\u4e0d\u5b58\u5728", (String)"InputLocalService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        FpzsLocalService fpzsService = new FpzsLocalService();
        QFilter coverIdFilter = new QFilter("cover_id", "=", (Object)((DynamicObject)coverObjs.get(0)).get("id").toString());
        DynamicObjectCollection coverRelationObjs = QueryServiceHelper.query((String)"rim_cover_relation", (String)"cover_id,expense_id,resource", (QFilter[])coverIdFilter.toArray());
        if (coverRelationObjs != null && coverRelationObjs.size() > 0) {
            String expenseId = ((DynamicObject)coverRelationObjs.get(0)).getString("expense_id");
            QFilter expenseIdFilter = new QFilter("expense_id", "=", (Object)expenseId);
            QFilter resourceFilter = new QFilter("resource", "=", ((DynamicObject)coverRelationObjs.get(0)).get("resource"));
            DynamicObjectCollection expenseRelationObjs = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id,expense_num,entityid,serial_no,expense_type,resource", (QFilter[])new QFilter[]{expenseIdFilter, resourceFilter});
            ArrayList<String> serialList = new ArrayList<String>(expenseRelationObjs.size());
            String billId = null;
            String entityId = null;
            String resource = null;
            for (DynamicObject obj : expenseRelationObjs) {
                serialList.add(obj.getString("serial_no"));
                if (StringUtils.isEmpty((String)obj.getString("expense_id"))) continue;
                billId = obj.getString("expense_id");
                entityId = obj.getString("entityid");
                resource = obj.getString("resource");
            }
            if (!CollectionUtils.isEmpty(serialList)) {
                JSONObject json = new JSONObject();
                json.put("serialNos", serialList);
                Map<String, Object> result = fpzsService.query(serialList, "4");
                JSONArray invoiceData = (JSONArray)result.get("data");
                returnData.put("invoiceData", (Object)invoiceData);
            }
            ExpenseRelationService ers = new ExpenseRelationService();
            JSONObject coverAndAttach = ers.queryCoverAndAttach(billId, entityId, resource, null);
            returnData.putAll((Map)coverAndAttach);
            returnData.put("expenseInfo", (Object)ers.queryExpenseInfo(expenseId, entityId, resource));
        }
        return ResultContant.createSuccessJSONObject(returnData);
    }
}

