/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InvoiceUploadErrorType;
import kd.imc.rim.common.helper.ExcelInvoiceUploadHelper;
import kd.imc.rim.common.invoice.recognition.listener.IRecognitionListener;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;

public class ExcelInvoiceUploadService {
    private static ExcelInvoiceUploadService instance = null;
    private static Log logger = LogFactory.getLog(ExcelInvoiceUploadService.class);

    private ExcelInvoiceUploadService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelInvoiceUploadService getInstance() {
        Class<ExcelInvoiceUploadService> clazz = ExcelInvoiceUploadService.class;
        synchronized (ExcelInvoiceUploadService.class) {
            if (instance == null) {
                instance = new ExcelInvoiceUploadService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public JSONObject uploadExcelInvoice(String fileUrl, String fileName, IRecognitionListener recognitionListener, JSONObject businessParam) {
        if (StringUtils.isEmpty((CharSequence)fileName) || !FileUtils.isExcel(fileName)) {
            return InvoiceUploadErrorType.getFailResult();
        }
        Long orgId = RequestContext.get().getOrgId();
        if (businessParam == null) {
            businessParam = new JSONObject();
        }
        if (businessParam != null && businessParam.getLong("org_id") != null) {
            orgId = businessParam.getLong("org_id");
        }
        JSONObject tips = new JSONObject();
        JSONObject result = new JSONObject();
        int excelType = 0;
        JSONArray recognitionResultData = null;
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl));){
            JSONArray failResultData = null;
            Boolean isAdmin = Boolean.FALSE;
            if (businessParam != null && businessParam.getBoolean("isAdmin") != null) {
                isAdmin = businessParam.getBoolean("isAdmin");
            }
            JSONObject fileParam = new JSONObject();
            fileParam.put("fileName", (Object)fileName);
            fileParam.put("fileUrl", (Object)fileUrl);
            fileParam.put("isAdmin", (Object)isAdmin);
            fileParam.put("orgId", (Object)orgId);
            fileParam.put("resource", (Object)businessParam.getString("resource"));
            if ("import_tax_excel".equals(businessParam.getString("itemKey"))) {
                JSONObject recognitionResult = ExcelInvoiceUploadHelper.getResolveTaxExcelResult(fileInputStream, fileParam, recognitionListener, tips);
                recognitionResultData = recognitionResult.getJSONArray("successData");
                recognitionResultData.add(new JSONObject().put("desc", (Object)ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u6b63\u5728\u540e\u53f0\u6267\u884c", (String)"ExcelInvoiceUploadService_0", (String)"imc-rim-common", (Object[])new Object[0])));
                failResultData = recognitionResult.getJSONArray("failData");
            } else if ("\u6536\u7968\u7ba1\u7406".equals(businessParam.getString("resource"))) {
                JSONObject recognitionResult = ExcelInvoiceUploadHelper.getResolveResult(fileInputStream, fileParam, recognitionListener, tips);
                recognitionResultData = recognitionResult.getJSONArray("successData");
                recognitionResultData.add(new JSONObject().put("desc", (Object)ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u6b63\u5728\u540e\u53f0\u6267\u884c", (String)"ExcelInvoiceUploadService_0", (String)"imc-rim-common", (Object[])new Object[0])));
                failResultData = recognitionResult.getJSONArray("failData");
            } else {
                JSONObject recognitionResult = ExcelInvoiceUploadHelper.recognitionFpzsExcel(fileParam, recognitionListener);
                recognitionResultData = recognitionResult.getJSONArray("successData");
                failResultData = recognitionResult.getJSONArray("failData");
            }
            result.put("errcode", (Object)"0000");
            result.put("description", (Object)ResManager.loadKDString((String)"\u8bc6\u522b\u67e5\u9a8c\u6210\u529f", (String)"ExcelInvoiceUploadService_1", (String)"imc-rim-common", (Object[])new Object[0]));
            result.put("data", (Object)recognitionResultData);
            if (!CollectionUtils.isEmpty((Collection)failResultData)) {
                result.put("failData", (Object)failResultData);
            }
            result.put("excelType", (Object)excelType);
            result.put("tips", (Object)tips);
        }
        catch (Exception e) {
            logger.info("\u4e0a\u4f20excel\u51fa\u9519\uff1a", (Object)e);
            String errorMessage = String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u67e5\u9a8c\u5931\u8d25:%1$s", (String)"ExcelInvoiceUploadService_2", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage());
            if ("import_tax_excel".equals(businessParam.getString("itemKey"))) {
                errorMessage = e.getMessage();
            }
            recognitionResultData = new JSONArray();
            recognitionResultData.add(new JSONObject().put("desc", (Object)e.getMessage()));
            result.put("errcode", (Object)"0001");
            result.put("description", (Object)errorMessage);
            result.put("data", (Object)recognitionResultData);
        }
        return result;
    }
}

