/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.utils.DateUtils;

public class InvoiceAutoFillBillService {
    private static Log logger = LogFactory.getLog(InvoiceAutoFillBillService.class);
    private static final String ATTACH_NO_PRE = "invoice_";

    public void autoFill(IFormView view, JSONObject returnData) {
        if (!InvoiceAutoFillBillService.isInvoiceOperate(view)) {
            return;
        }
        JSONArray invoiceData = returnData.getJSONArray("invoiceData");
        if (invoiceData != null && !invoiceData.isEmpty()) {
            this.hanleInvoice(view, invoiceData);
        } else {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u672a\u5bfc\u5165\u53d1\u7968");
        }
        JSONArray attachData = returnData.getJSONArray("attachData");
        if (attachData != null && !attachData.isEmpty()) {
            this.hanleAttach(view, attachData);
        } else {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u672a\u5bfc\u5165\u9644\u4ef6");
        }
    }

    public void autoUpdateAttach(IFormView view) {
        String entityId;
        if (!InvoiceAutoFillBillService.isInvoiceOperate(view)) {
            return;
        }
        AttachQueryService attachQueryService = new AttachQueryService();
        Map customParam = view.getFormShowParameter().getCustomParams();
        String expenseId = (String)customParam.get("billId");
        JSONArray attaches = attachQueryService.queryFpzsAttach(expenseId, entityId = (String)customParam.get("entityId"), null, true);
        if (attaches != null) {
            this.updateAttach(view, attaches);
        } else {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u9644\u4ef6\u6570\u636e\u6709\u8bef");
        }
    }

    private void updateAttach(IFormView view, JSONArray attachData) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u586b\u5145\u9644\u4ef6\u53c2\u6570\uff0ccustomParams\uff1a{}", (Object)customParams);
        String attachpanelkey = (String)customParams.get("attachpanelkey");
        if (StringUtils.isBlank((CharSequence)attachpanelkey)) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u672a\u914d\u7f6e\u5355\u636e\u9644\u4ef6\u9762\u677f");
            return;
        }
        String pPageId = view.getFormShowParameter().getParentPageId();
        IFormView pView = view.getViewNoPlugin(pPageId);
        if (pView instanceof IMobileView) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u79fb\u52a8\u7aef\u4e0d\u505a\u81ea\u52a8\u586b\u5145");
            return;
        }
        AttachmentPanel filePanel = (AttachmentPanel)pView.getControl(attachpanelkey);
        if (filePanel == null) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u672a\u83b7\u53d6\u5230\u9644\u4ef6\u9762\u677f");
            return;
        }
        List attachmentRowDataInBill = filePanel.getAttachmentData();
        Set attachNoSet = attachData.stream().map(v -> {
            String attachNo = ((JSONObject)v).getString("attachNo_1");
            if (StringUtils.isBlank((CharSequence)attachNo)) {
                attachNo = ((JSONObject)v).getString("attachNo");
            }
            return attachNo;
        }).collect(Collectors.toSet());
        for (Map attachmentRowData : attachmentRowDataInBill) {
            String uid = (String)attachmentRowData.get("uid");
            if (!StringUtils.isNotBlank((CharSequence)uid) || !uid.startsWith(ATTACH_NO_PRE) || attachNoSet.contains(uid.replace(ATTACH_NO_PRE, ""))) continue;
            filePanel.remove(attachmentRowData);
        }
        pView.updateView(attachpanelkey);
        view.sendFormAction(pView);
    }

    private void hanleAttach(IFormView view, JSONArray attachData) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u586b\u5145\u9644\u4ef6\u53c2\u6570\uff0ccustomParams\uff1a{}", (Object)customParams);
        String attachpanelkey = (String)customParams.get("attachpanelkey");
        if (StringUtils.isBlank((CharSequence)attachpanelkey)) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u672a\u914d\u7f6e\u5355\u636e\u9644\u4ef6\u9762\u677f");
            return;
        }
        String pPageId = view.getFormShowParameter().getParentPageId();
        IFormView pView = view.getViewNoPlugin(pPageId);
        if (pView instanceof IMobileView) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u79fb\u52a8\u7aef\u4e0d\u505a\u81ea\u52a8\u586b\u5145");
            return;
        }
        IDataModel model = pView.getModel();
        AttachmentPanel filePanel = (AttachmentPanel)pView.getControl(attachpanelkey);
        if (filePanel == null) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u672a\u83b7\u53d6\u5230\u9644\u4ef6\u9762\u677f");
            return;
        }
        List attachmentRowDataInBill = filePanel.getAttachmentData();
        Set oldUids = attachmentRowDataInBill.stream().map(data -> (String)data.get("uid")).collect(Collectors.toSet());
        List needAppendAttachDatas = attachData.stream().map(v -> (JSONObject)v).filter(attach -> !oldUids.contains(attach.getString("attachNo"))).collect(Collectors.toList());
        logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\uff0c\u53d1\u7968\u96c6\u6210,\u540c\u6b65\u9644\u4ef6-->\u672c\u6b21\u8ffd\u52a0\u7684\u9644\u4ef6:" + JSONObject.toJSONString(needAppendAttachDatas));
        ArrayList newAttachmentDatas = Lists.newArrayListWithExpectedSize((int)needAppendAttachDatas.size());
        long currentTimeMillis = System.currentTimeMillis();
        for (JSONObject attachJSON : needAppendAttachDatas) {
            JSONObject attachmentDataForUpload = new JSONObject();
            attachmentDataForUpload.put("billPkId", (Object)String.valueOf(model.getDataEntity().getPkValue()));
            String type = "jpg";
            String url = attachJSON.getString("attachUrl");
            url = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(url);
            logger.info("\u89e3\u5bc6\u540e\u7684\u5730\u5740\uff1a" + url);
            int lastIndexOfDot = url.lastIndexOf(46);
            if (lastIndexOfDot >= 0) {
                type = url.substring(lastIndexOfDot + 1);
            }
            attachmentDataForUpload.put("type", (Object)type);
            String attachmentName = attachJSON.getString("attachName");
            if (!attachmentName.endsWith("." + type)) {
                attachmentName = attachmentName + "." + type;
            }
            attachmentDataForUpload.put("name", (Object)attachmentName);
            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = attachmentFileService.getInputStream(url);
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                String filePath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachmentName, (InputStream)new ByteArrayInputStream(bytes), 30000);
                attachmentDataForUpload.put("url", (Object)filePath);
                attachmentDataForUpload.put("size", (Object)bytes.length);
            }
            catch (IOException e) {
                logger.error("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                return;
            }
            attachmentDataForUpload.put("client", (Object)"web");
            attachmentDataForUpload.put("uid", (Object)(ATTACH_NO_PRE + attachJSON.getString("attachNo")));
            attachmentDataForUpload.put("entityNum", (Object)model.getDataEntityType().getName());
            attachmentDataForUpload.put("status", (Object)"success");
            attachmentDataForUpload.put("createdate", (Object)currentTimeMillis);
            attachmentDataForUpload.put("lastModified", (Object)currentTimeMillis);
            newAttachmentDatas.add(attachmentDataForUpload);
        }
        filePanel.upload((List)newAttachmentDatas);
        pView.updateView(attachpanelkey);
        view.sendFormAction(pView);
    }

    private void hanleInvoice(IFormView view, JSONArray invoiceData) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u586b\u5145\u53d1\u7968\u53c2\u6570\uff0ccustomParams\uff1a{}", (Object)customParams);
        String billInvoiceHeadKey = (String)customParams.get("billInvoiceHeadKey");
        JSONObject headKeyMap = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)billInvoiceHeadKey) && customParams.get("headKeyMap") != null) {
            headKeyMap = JSONObject.parseObject((String)JSONObject.toJSONString(customParams.get("headKeyMap")));
        }
        String billInvoiceItemKey = (String)customParams.get("billInvoiceItemKey");
        JSONObject itemKeyMap = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)billInvoiceItemKey) && customParams.get("itemKeyMap") != null) {
            itemKeyMap = JSONObject.parseObject((String)JSONObject.toJSONString(customParams.get("itemKeyMap")));
        }
        if (StringUtils.isBlank((CharSequence)billInvoiceHeadKey) && StringUtils.isBlank((CharSequence)billInvoiceItemKey)) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u53d1\u7968\u5934\u5206\u5f55\u6807\u8bc6\u548c\u53d1\u7968\u660e\u7ec6\u884c\u5206\u5f55\u6807\u8bc6\u4e3a\u7a7a");
        }
        JSONArray toBillInvoiceArr = new JSONArray();
        for (int i = 0; i < invoiceData.size(); ++i) {
            JSONObject invoice = invoiceData.getJSONObject(i);
            JSONObject entryInvoice = this.autoFillJson(billInvoiceHeadKey, headKeyMap, invoice);
            toBillInvoiceArr.add((Object)entryInvoice);
            JSONArray items = invoice.getJSONArray("items");
            JSONArray entryInvoiceItems = new JSONArray();
            entryInvoice.put("items", (Object)entryInvoiceItems);
            if (items != null) {
                for (int j = 0; j < items.size(); ++j) {
                    JSONObject item = items.getJSONObject(j);
                    JSONObject entryInvoiceItem = this.autoFillJson(billInvoiceItemKey, itemKeyMap, item);
                    entryInvoiceItems.add((Object)entryInvoiceItem);
                }
                continue;
            }
            JSONObject item = this.createItemOfHead(itemKeyMap, entryInvoice);
            if (item == null) continue;
            entryInvoiceItems.add((Object)item);
        }
        this.fillEntry(view, toBillInvoiceArr);
    }

    private void fillEntry(IFormView view, JSONArray toBillInvoiceArr) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        String billInvoiceHeadKey = (String)customParams.get("billInvoiceHeadKey");
        String billInvoiceItemKey = (String)customParams.get("billInvoiceItemKey");
        String pPageId = view.getFormShowParameter().getParentPageId();
        IFormView pView = view.getViewNoPlugin(pPageId);
        IDataModel model = pView.getModel();
        DynamicObject bill = model.getDataEntity(true);
        if (bill.getDynamicObjectType().getProperty(billInvoiceHeadKey) == null) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u53d1\u7968\u5934\u5206\u5f55\u6807\u8bc6\uff1a{}\u4e0d\u5b58\u5728", (Object)billInvoiceHeadKey);
            return;
        }
        this.updateExists(model, toBillInvoiceArr, billInvoiceHeadKey, billInvoiceItemKey);
        if (toBillInvoiceArr.isEmpty()) {
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u53d1\u7968\u5934\u5206\u5f55\u66f4\u65b0\u5b8c\u6210\uff0c\u65e0\u9700\u751f\u6210\u65b0\u6570\u636e");
            view.sendFormAction(pView);
            return;
        }
        DynamicObjectCollection headColl = bill.getDynamicObjectCollection(billInvoiceHeadKey);
        DataEntityPropertyCollection collProp = headColl.getDynamicObjectType().getProperties();
        int[] indexs = model.batchCreateNewEntryRow(billInvoiceHeadKey, toBillInvoiceArr.size());
        long[] headIds = ORM.create().genLongIds((IDataEntityType)headColl.getDynamicObjectType(), toBillInvoiceArr.size());
        for (int i = 0; i < toBillInvoiceArr.size(); ++i) {
            JSONObject invoice = toBillInvoiceArr.getJSONObject(i);
            invoice.put("id", (Object)headIds[i]);
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u53d1\u7968\u5934\u5206\u5f55\u521b\u5efa\u5b8c\u6210\uff1a{}", (Object)headIds[i]);
            this.fillEntryField(model, collProp, indexs[i], invoice);
            model.getEntryRowEntity(billInvoiceHeadKey, indexs[i]).set("id", invoice.get((Object)"id"));
            this.fillItemEntryField(model, billInvoiceItemKey, invoice);
        }
        view.sendFormAction(pView);
    }

    private void updateExists(IDataModel model, JSONArray toBillInvoiceArr, String billInvoiceHeadKey, String billInvoiceItemKey) {
        int i;
        DynamicObjectCollection headColl = model.getDataEntity(true).getDynamicObjectCollection(billInvoiceHeadKey);
        DataEntityPropertyCollection collProp = headColl.getDynamicObjectType().getProperties();
        Set serialnoSet = headColl.stream().map(v -> v.getString("serialno")).collect(Collectors.toSet());
        JSONObject updateInvoiceArr = new JSONObject();
        for (i = 0; i < toBillInvoiceArr.size(); ++i) {
            JSONObject invoice = toBillInvoiceArr.getJSONObject(i);
            String serialNo = invoice.getString("serialNo");
            if (!serialnoSet.contains(serialNo)) continue;
            updateInvoiceArr.put(serialNo, toBillInvoiceArr.remove(i--));
        }
        for (i = 0; i < headColl.size(); ++i) {
            String serialno = (String)model.getValue("serialno", i);
            logger.info("\u3010\u81ea\u52a8\u586b\u5145\u5355\u636e\u3011\u53d1\u7968\u5934\u5206\u5f55\u66f4\u65b0\u5b8c\u6210\uff1a{}", (Object)serialno);
            JSONObject updateInvoice = updateInvoiceArr.getJSONObject(serialno);
            if (updateInvoice == null) continue;
            this.fillEntryField(model, collProp, i, updateInvoice);
            long id = (Long)model.getEntryRowEntity(billInvoiceHeadKey, i).getPkValue();
            this.updateItemEntryField(model, billInvoiceItemKey, updateInvoice, id);
        }
    }

    private void updateItemEntryField(IDataModel model, String itemKey, JSONObject invoice, long id) {
        if (model.getDataEntity(true).getDynamicObjectType().getProperty(itemKey) == null) {
            return;
        }
        JSONArray items = invoice.getJSONArray("items");
        if (items == null || items.isEmpty()) {
            return;
        }
        DynamicObjectCollection itemColl = model.getDataEntity(true).getDynamicObjectCollection(itemKey);
        DataEntityPropertyCollection itemCollProp = itemColl.getDynamicObjectType().getProperties();
        int i = 0;
        for (int j = 0; j < itemColl.size(); ++j) {
            long invoiceheadentryid = (Long)model.getValue("invoiceheadentryid", j);
            if (id != invoiceheadentryid) continue;
            this.fillEntryField(model, itemCollProp, j, (JSONObject)items.remove(i));
        }
        if (!items.isEmpty()) {
            this.fillItemEntryField(model, itemKey, invoice);
        }
    }

    private void fillItemEntryField(IDataModel model, String itemKey, JSONObject invoice) {
        if (model.getDataEntity(true).getDynamicObjectType().getProperty(itemKey) == null) {
            return;
        }
        JSONArray items = invoice.getJSONArray("items");
        if (items == null || items.isEmpty()) {
            return;
        }
        Object headId = invoice.get((Object)"id");
        DataEntityPropertyCollection itemCollProp = model.getDataEntity(true).getDynamicObjectCollection(itemKey).getDynamicObjectType().getProperties();
        int[] indexs = model.batchCreateNewEntryRow(itemKey, items.size());
        for (int i = 0; i < items.size(); ++i) {
            JSONObject item = items.getJSONObject(i);
            item.put("invoiceheadentryid", headId);
            this.fillEntryField(model, itemCollProp, indexs[i], item);
        }
    }

    private void fillEntryField(IDataModel model, DataEntityPropertyCollection collProp, int index, JSONObject invoice) {
        for (Map.Entry entry : invoice.entrySet()) {
            String tempStr;
            IDataEntityProperty prop;
            Object value;
            String key = (String)entry.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"seq") || StringUtils.equals((CharSequence)key, (CharSequence)"id") || (value = entry.getValue()) == null || (prop = (IDataEntityProperty)collProp.get((Object)(key = key.toLowerCase()))) == null) continue;
            if (prop instanceof DateTimeProp && StringUtils.isNotBlank((CharSequence)(tempStr = value.toString()))) {
                value = DateUtils.stringToDate(tempStr);
            }
            model.setValue(key, value, index);
        }
    }

    private JSONObject createItemOfHead(JSONObject keyMap, JSONObject invoice) {
        return null;
    }

    private JSONObject autoFillJson(String billEntryKey, JSONObject keyMap, JSONObject invoice) {
        String billKey;
        JSONObject entryItemJson = new JSONObject();
        if (keyMap != null) {
            for (Map.Entry entry : keyMap.entrySet()) {
                billKey = (String)entry.getKey();
                String invoiceKeys = (String)entry.getValue();
                String[] invoicekeyArr = invoiceKeys.split(",");
                Object value = null;
                for (String invoiceKey : invoicekeyArr) {
                    Object tempValue = invoice.get((Object)invoiceKey);
                    if (tempValue == null) continue;
                    if (value == null) {
                        value = tempValue;
                        continue;
                    }
                    value = null;
                    break;
                }
                if (value == null) continue;
                entryItemJson.put(billKey, value);
            }
        }
        for (Map.Entry entry : invoice.entrySet()) {
            billKey = (String)entry.getKey();
            Object value = entryItemJson.get((Object)billKey);
            if (value != null) continue;
            entryItemJson.put(billKey, entry.getValue());
        }
        return entryItemJson;
    }

    public static boolean isInvoiceOperate(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        return InvoiceAutoFillBillService.isInvoiceOperate(customParams);
    }

    private static boolean isInvoiceOperate(Map<String, Object> customParams) {
        Object isOperation = customParams.get("isOperation");
        return isOperation instanceof Boolean && (Boolean)isOperation != false;
    }
}

