/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;

public class InvoiceCollectEditService {
    public static Map<String, String> getFieldMap(String entityName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        HashMap filedMap = Maps.newHashMap();
        if (dataEntityType != null) {
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (property.getDisplayName() == null) continue;
                filedMap.put(property.getName(), property.getDisplayName().getLocaleValue());
            }
        }
        return filedMap;
    }

    public static String getModifyName(String key, Map<String, String> filedMap) {
        String convertKey = InvoiceCollectEditService.getConvertKey(key);
        if (convertKey != null) {
            return filedMap.get(convertKey);
        }
        return filedMap.get(InvoiceCollectEditService.humpToLine(key));
    }

    public static String humpToLine(String str) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getConvertKey(String key) {
        HashMap map = Maps.newHashMap();
        map.put("electronicTicketNum", "eticket_no");
        map.put("otherTotalTaxAmount", "other_amount");
        map.put("customerIdentityNum", "customer_id_no");
        map.put("buyerIdNo", "buyer_cardno");
        map.put("certificateNo", "certificate_num");
        map.put("commodityInspectionNo", "commodity_inspection_num");
        map.put("engineNo", "engine_num");
        map.put("amount", "invoice_amount");
        map.put("limitedCount", "limite_people");
        map.put("ftime", "time");
        map.put("produceArea", "producing_area");
        map.put("vehicleIdentificationNo", "vehicle_identification_code");
        map.put("seat", "seat_grade");
        map.put("printingSequenceNo", "sequence_no");
        map.put("seatNo", "seat_grade");
        if (map.keySet().contains(key)) {
            return (String)map.get(key);
        }
        return null;
    }
}

