/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.IFrameMessage;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.recognitionnew.task.FileByteUploadTask;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.SHA1Util;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.file.model.FileConvertResult;
import org.apache.commons.lang.StringUtils;

public class WechatCardService {
    private static Log logger = LogFactory.getLog(WechatCardService.class);
    private static final String WECHAT_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String WECHAT_TOKEN_CACHE = "wx_token";
    private static final String WECHAT_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=wx_card";
    private static final String WECHAT_TICKET_CACHE = "wx_ticket";
    private static final String WECHAT_GETINVOICE_URL = "https://api.weixin.qq.com/card/invoice/reimburse/getinvoicebatch?access_token=%s";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
    private static ThreadPool wxUploadThreadPool = ThreadPools.newFixedThreadPool((String)"wxUploadThread", (int)10);
    private static final String WXCARD_HTML_URL = "kingdee/imc/wxcard/wxcard.html";
    private static final String APPID = "wxec5627ffcbf9b442";
    private static final String SECRET = "2c5eb14959c6e9bf1c173580abaa62ae";
    private static final String CARD_TYPE = "INVOICE";
    private static WechatCardService wcs = new WechatCardService();

    public static WechatCardService getInstance() {
        return wcs;
    }

    public void loadJs(Html htmlap, String pageId) {
        if (htmlap != null) {
            String url = "kingdee/imc/wxcard/wxcard.html?pageId=" + pageId;
            String htmlContent = "<iframe id='wxcard' name='wxcard' style='display:none' src='" + url + "' ></iframe>";
            htmlap.setConent(htmlContent);
        }
    }

    public void postMsg(Html htmlap, String pageId) {
        if (htmlap != null) {
            String url = "kingdee/imc/wxcard/wxcard.html?pageId=" + pageId;
            JSONObject param = new JSONObject();
            param.put("param", (Object)this.getWechatParam());
            param.put("pageId", (Object)pageId);
            String postUrl = RequestContext.get().getClientFullContextPath() + url;
            IFormView view = htmlap.getView();
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            IFrameMessage msg = new IFrameMessage("openWXCard", postUrl, (Object)param.toJSONString());
            proxy.invokeControlMethod("htmlap", "postMessage", new Object[]{msg});
        }
    }

    public JSONObject getInvoiceJSON(String backData, String mainPageId) {
        JSONObject batchParam = this.convertParam(backData);
        JSONArray item_list = this.getInvoiceBatch(batchParam);
        if (item_list == null || item_list.isEmpty()) {
            CacheHelper.remove(WECHAT_TOKEN_CACHE);
            item_list = this.getInvoiceBatch(batchParam);
        }
        JSONObject checkResult = this.convertCheckInfoBatch(item_list, mainPageId);
        return checkResult;
    }

    public boolean isEmpty(String backData) {
        JSONObject back = JSONObject.parseObject((String)backData);
        JSONArray items = back.getJSONArray("cardAry");
        return items == null || items.isEmpty();
    }

    private JSONObject convertParam(String backData) {
        JSONObject param = new JSONObject();
        JSONObject back = JSONObject.parseObject((String)backData);
        JSONArray items = back.getJSONArray("cardAry");
        if (items == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5fae\u4fe1\u5361\u5305\u53d1\u7968\u6570\u636e", (String)"WechatCardService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray item_list = new JSONArray();
        param.put("item_list", (Object)item_list);
        for (int i = 0; i < items.size(); ++i) {
            JSONObject item = items.getJSONObject(i);
            String encryptCode = item.getString("encryptCode");
            String cardId = item.getString("cardId");
            if (StringUtils.isBlank((String)encryptCode)) {
                cardId = item.getString("card_id");
                encryptCode = item.getString("encrypt_code");
            }
            if (StringUtils.isBlank((String)encryptCode) || StringUtils.isBlank((String)cardId)) continue;
            JSONObject itemJson = new JSONObject();
            itemJson.put("card_id", (Object)cardId);
            itemJson.put("encrypt_code", (Object)encryptCode);
            item_list.add((Object)itemJson);
        }
        return param;
    }

    private JSONObject getWechatParam() {
        String aceessToken = this.getWechatAccessToken();
        if (StringUtils.isBlank((String)aceessToken)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6aceessToken\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"WechatCardService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String ticket = this.getWechatTicket(aceessToken);
        if (StringUtils.isBlank((String)ticket)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6ticket\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"WechatCardService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        String nonceStr = UUID.randomUUID();
        String signStr = ticket + APPID + timestamp + nonceStr + CARD_TYPE;
        String sign = SHA1Util.getSha1(signStr);
        JSONObject param = new JSONObject();
        param.put("type", (Object)"3");
        JSONObject sdkNeedParams = new JSONObject();
        param.put("sdkNeedParams", (Object)sdkNeedParams);
        sdkNeedParams.put("cardSign", (Object)sign);
        sdkNeedParams.put("signType", (Object)"SHA1");
        sdkNeedParams.put("timeStamp", (Object)timestamp);
        sdkNeedParams.put("nonceStr", (Object)nonceStr);
        sdkNeedParams.put("cardType", (Object)CARD_TYPE);
        sdkNeedParams.put("canMultiSelect", (Object)"1");
        logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u83b7\u53d6\u5fae\u4fe1accessToken\uff0csdkNeedParams\uff1a{}", (Object)sdkNeedParams.toJSONString());
        return param;
    }

    private String getWechatAccessToken() {
        String accessToken = CacheHelper.get(WECHAT_TOKEN_CACHE);
        if (StringUtils.isNotBlank((String)accessToken)) {
            return accessToken;
        }
        String url = String.format(WECHAT_TOKEN_URL, APPID, SECRET);
        logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u83b7\u53d6\u5fae\u4fe1accessToken\uff0curl\uff1a{}", (Object)url);
        try {
            String resultStr = HttpUtil.doGet(url, AwsFpyService.newInstance().getProxy());
            logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u83b7\u53d6\u5fae\u4fe1accessToken\uff0cresultStr\uff1a{}", (Object)resultStr);
            JSONObject result = JSONObject.parseObject((String)resultStr);
            accessToken = result.getString("access_token");
            if (StringUtils.isBlank((String)accessToken)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"WechatCardService_3", (String)"imc-rim-common", (Object[])new Object[0]), result.getString("errmsg")));
            }
        }
        catch (Exception e) {
            logger.error("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"WechatCardService_3", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
        CacheHelper.put(WECHAT_TOKEN_CACHE, accessToken, 3600);
        return accessToken;
    }

    private String getWechatTicket(String aceessToken) {
        String ticket = CacheHelper.get(WECHAT_TICKET_CACHE);
        if (StringUtils.isNotBlank((String)ticket)) {
            return ticket;
        }
        String url = String.format(WECHAT_TICKET_URL, aceessToken);
        logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u83b7\u53d6\u5fae\u4fe1getWechatTicket\uff0curl\uff1a{}\uff0caceessToken\uff1a{}", (Object)url, (Object)aceessToken);
        try {
            String resultStr = HttpUtil.doGet(url, AwsFpyService.newInstance().getProxy());
            JSONObject result = JSONObject.parseObject((String)resultStr);
            logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u83b7\u53d6\u5fae\u4fe1getWechatTicket\uff0cresultStr\uff1a{}", (Object)resultStr);
            String errcode = result.getString("errcode");
            if (StringUtils.isBlank((String)errcode) || !StringUtils.equals((String)errcode, (String)"0")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1ticket\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"WechatCardService_4", (String)"imc-rim-common", (Object[])new Object[0]), result.getString("errmsg")));
            }
            ticket = result.getString("ticket");
        }
        catch (Exception e) {
            logger.error("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u83b7\u53d6\u5fae\u4fe1ticket\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1ticket\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"WechatCardService_4", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
        CacheHelper.put(WECHAT_TICKET_CACHE, ticket, 3600);
        return ticket;
    }

    private JSONArray getInvoiceBatch(JSONObject param) {
        JSONArray invoiceList = new JSONArray();
        String url = String.format(WECHAT_GETINVOICE_URL, this.getWechatAccessToken());
        logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u6279\u91cf\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\uff0curl\uff1a{}\uff0cparam\uff1a{}", (Object)url, (Object)param);
        try {
            String result = HttpUtil.doPostJson(url, AwsFpyService.newInstance().getProxy(), null, param.toJSONString());
            logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u6279\u91cf\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\uff0curl\uff1a{}\uff0cresult\uff1a{}", (Object)url, (Object)result);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String errcode = resultJson.getString("errcode");
            if (!StringUtils.equals((String)"0", (String)errcode)) {
                new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"WechatCardService_5", (String)"imc-rim-common", (Object[])new Object[0]), resultJson.getString("errmsg")));
            }
            invoiceList = resultJson.getJSONArray("item_list");
        }
        catch (Exception e) {
            logger.error("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u6279\u91cf\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"WechatCardService_5", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
        return invoiceList;
    }

    public JSONObject convertCheckInfoBatch(JSONArray item_list, String indexPageId) {
        JSONArray success = new JSONArray();
        JSONArray fail = new JSONArray();
        JSONObject result = new JSONObject();
        result.put("success", (Object)success);
        result.put("fail", (Object)fail);
        if (item_list == null || item_list.isEmpty()) {
            return result;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)item_list.size());
        for (int i = 0; i < item_list.size(); ++i) {
            JSONObject item = item_list.getJSONObject(i);
            logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u5fae\u4fe1\u5361\u5305\u8fd4\u56de\u7684\u53d1\u7968\u4fe1\u606f\uff0cuser_info\uff1a{}", (Object)item);
            JSONObject convertParam = this.convertCheckInfo(item);
            list.add(convertParam);
        }
        for (JSONObject convertParam : list) {
            JSONObject checkResultJson = this.check(convertParam, indexPageId);
            if (!"0000".equals(checkResultJson.getString("errcode"))) {
                convertParam.put("errcode", (Object)checkResultJson.getString("errcode"));
                convertParam.put("description", (Object)checkResultJson.getString("description"));
                fail.add((Object)convertParam);
                continue;
            }
            success.add((Object)checkResultJson);
        }
        return result;
    }

    private JSONObject convertCheckInfo(JSONObject item) {
        String invoiceType;
        String payee;
        String title;
        String check_code;
        String fee_without_tax;
        String tax;
        String billing_time;
        String fee;
        JSONObject user_info = item.getJSONObject("user_info");
        JSONObject checkInfo = new JSONObject();
        Future uploadFuture = null;
        String pdf_url = user_info.getString("pdf_url");
        if (StringUtils.isNotBlank((String)pdf_url)) {
            try {
                String fileName = UUID.randomUUID() + ".pdf";
                String fileId = FileUtils.downLoadAndUpload(pdf_url, fileName);
                InputStream fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(fileId);
                byte[] streamByte = FileUtils.getByte(fileInputStream);
                uploadFuture = wxUploadThreadPool.submit((Callable)new FileByteUploadTask(RequestContext.get(), streamByte, "pdf"));
            }
            catch (Exception e) {
                logger.error("\u5fae\u4fe1\u5361\u5305\u6587\u4ef6\u5904\u7406\u5931\u8d25:" + pdf_url, (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)(fee = user_info.getString("fee")))) {
            BigDecimal total_amount = new BigDecimal(fee).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            checkInfo.put("total_amount", (Object)total_amount);
        }
        if (StringUtils.isNotBlank((String)(billing_time = user_info.getString("billing_time")))) {
            Long time = Long.parseLong(billing_time);
            if (billing_time.length() < 12) {
                time = time * 1000L;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            checkInfo.put("invoice_date", (Object)format.format(time));
        }
        String billing_no = user_info.getString("billing_no");
        String billing_code = user_info.getString("billing_code");
        if (StringUtils.isNotBlank((String)billing_no)) {
            if (billing_no.length() == 20) {
                checkInfo.put("invoice_no", (Object)billing_no);
            } else if (billing_no.length() > 8) {
                checkInfo.put("invoice_code", (Object)billing_no);
                checkInfo.put("invoice_no", (Object)billing_code);
            } else {
                checkInfo.put("invoice_code", (Object)billing_code);
                checkInfo.put("invoice_no", (Object)billing_no);
            }
        }
        if (StringUtils.isNotBlank((String)(tax = user_info.getString("tax")))) {
            BigDecimal total_tax_amount = new BigDecimal(tax).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            checkInfo.put("total_tax_amount", (Object)total_tax_amount);
        }
        if (StringUtils.isNotBlank((String)(fee_without_tax = user_info.getString("fee_without_tax")))) {
            BigDecimal invoice_amount = new BigDecimal(fee_without_tax).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            checkInfo.put("invoice_amount", (Object)invoice_amount);
        }
        if (StringUtils.isNotBlank((String)(check_code = user_info.getString("check_code")))) {
            checkInfo.put("check_code", (Object)check_code);
        }
        if (StringUtils.isNotBlank((String)(title = user_info.getString("title")))) {
            checkInfo.put("buyer_name", (Object)title);
        }
        if (StringUtils.isNotBlank((String)(payee = item.getString("payee")))) {
            checkInfo.put("saler_name", (Object)payee);
        }
        if (StringUtils.isNotBlank((String)(invoiceType = InvoiceConvertUtils.checkInvoiceType(checkInfo.getString("invoice_code"), checkInfo.getString("invoice_no"))))) {
            checkInfo.put("invoice_type", (Object)invoiceType);
        }
        try {
            JSONObject uploadResult;
            if (null != uploadFuture && (uploadResult = (JSONObject)uploadFuture.get(15L, TimeUnit.SECONDS)) != null && "0000".equals(uploadResult.getString("errcode"))) {
                FileConvertResult fileConvertResult = (FileConvertResult)uploadResult.get((Object)"data");
                checkInfo.put("pdfUrl", (Object)fileConvertResult.getPdfUrl());
                checkInfo.put("imageUrl", (Object)fileConvertResult.getImageUrl());
                checkInfo.put("snapshotUrl", (Object)fileConvertResult.getSnapshotUrl());
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e1) {
            logger.info("pdf\u6587\u4ef6\u539f\u4ef6\u4e0a\u4f20\u4fe1\u606f\u8d85\u65f6.");
        }
        logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u67e5\u9a8c\u7ed3\u6784\u5316\u53c2\u6570\u4fe1\u606f\uff1a{}", (Object)checkInfo);
        return checkInfo;
    }

    private JSONObject check(JSONObject checkInfo, String indexPageId) {
        JSONObject checkResultJson = new JSONObject();
        JSONObject businessParam = FpzsMainService.getBusinessParam(indexPageId, CollectTypeEnum.H5_HANDWORK.getCode());
        businessParam.put("resource", (Object)ResManager.loadKDString((String)"\u5fae\u4fe1\u5361\u5305", (String)"CollectTypeEnum_14", (String)"imc-rim-common", (Object[])new Object[0]));
        String invoice_code = checkInfo.getString("invoice_code");
        String invoice_no = checkInfo.getString("invoice_no");
        String invoice_date = checkInfo.getString("invoice_date");
        BigDecimal total_amount = checkInfo.getBigDecimal("total_amount");
        BigDecimal invoice_amount = checkInfo.getBigDecimal("invoice_amount");
        String check_code = checkInfo.getString("check_code");
        if (invoice_no.length() == 20) {
            checkResultJson = this.invoiceCollectService.checkInvoiceOfWx("", invoice_no, null, invoice_date, total_amount, "", checkInfo, businessParam);
        } else {
            String invoiceType = InvoiceConvertUtils.checkInvoiceType(invoice_code, invoice_no);
            Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
            if ("1".equals(invoiceType) || "3".equals(invoiceType) || "5".equals(invoiceType) || "15".equals(invoiceType)) {
                if (InvoiceConvertUtils.isBlockChainType(invoice_code, invoice_no) || InvoiceConvertUtils.isYunNanBlockchain(invoice_code, invoice_no)) {
                    String check_code5 = check_code;
                    if (check_code5.length() > 5) {
                        check_code5 = check_code5.substring(check_code5.length() - 6);
                    }
                    checkResultJson = this.invoiceCollectService.checkInvoiceOfWx(invoice_code, invoice_no, invoice_type, invoice_date, invoice_amount, check_code5, checkInfo, businessParam);
                } else {
                    String check_code6 = check_code;
                    if (check_code6 != null && check_code6.length() > 6) {
                        check_code6 = check_code6.substring(check_code6.length() - 7);
                    }
                    checkResultJson = this.invoiceCollectService.checkInvoiceOfWx(invoice_code, invoice_no, invoice_type, invoice_date, null, check_code6, checkInfo, businessParam);
                }
            } else if ("2".equals(invoiceType) || "4".equals(invoiceType)) {
                checkResultJson = this.invoiceCollectService.checkInvoiceOfWx(invoice_code, invoice_no, invoice_type, invoice_date, invoice_amount, null, checkInfo, businessParam);
            } else if ("12".equals(invoiceType)) {
                checkResultJson = this.invoiceCollectService.checkInvoiceOfWx(invoice_code, invoice_no, invoice_type, invoice_date, total_amount, null, checkInfo, businessParam);
            } else if ("13".equals(invoiceType)) {
                checkResultJson = this.invoiceCollectService.checkInvoiceOfWx(invoice_code, invoice_no, invoice_type, invoice_date, total_amount, null, checkInfo, businessParam);
            }
        }
        logger.info("\u3010\u5fae\u4fe1\u5361\u5305\u3011\u5fae\u4fe1\u5361\u5305\u67e5\u9a8c\u7ed3\u679c\uff1a" + checkResultJson);
        return checkResultJson;
    }
}

