/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AesUtil {
    private static Log LOGGER = LogFactory.getLog(AesUtil.class);
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final String DEFAULT_ALGORITHM = "AES";

    public static String encrypt(String content, String key) throws Exception {
        byte[] iv = new byte[12];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(iv);
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8.name());
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        GCMParameterSpec params = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)AesUtil.getSecretKey(key), params);
        byte[] encryptData = cipher.doFinal(contentBytes);
        assert (encryptData.length == contentBytes.length + 16);
        byte[] message = new byte[12 + contentBytes.length + 16];
        System.arraycopy(iv, 0, message, 0, 12);
        System.arraycopy(encryptData, 0, message, 12, encryptData.length);
        return Base64.getEncoder().encodeToString(message);
    }

    public static String decrypt(String content, String key) throws Exception {
        byte[] byteEncrypt = Base64.getDecoder().decode(content);
        if (byteEncrypt.length < 28) {
            throw new IllegalArgumentException();
        }
        GCMParameterSpec params = new GCMParameterSpec(128, byteEncrypt, 0, 12);
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        cipher.init(2, (Key)AesUtil.getSecretKey(key), params);
        byte[] byteDecrypt = cipher.doFinal(byteEncrypt, 12, byteEncrypt.length - 12);
        return new String(byteDecrypt, StandardCharsets.UTF_8.name());
    }

    private static SecretKeySpec getSecretKey(String key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KeyGenerator kg = KeyGenerator.getInstance(DEFAULT_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(key.getBytes(StandardCharsets.UTF_8.name()));
        kg.init(128, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), DEFAULT_ALGORITHM);
    }

    public static String base64Encode(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        try {
            return Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("base64\u52a0\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String base64DecodeToString(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        try {
            return new String(Base64.getDecoder().decode(content), StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            LOGGER.error("base64\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

