/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.DateUtils;

public class AisinoConvertUtil {
    private static Log LOGGER = LogFactory.getLog(AisinoConvertUtil.class);

    public static Long getAlleleInvoiceType(String invoiceNo, Long invoiceType) {
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20) {
            if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType)) {
                return InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode();
            }
            if (InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType)) {
                return InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode();
            }
        }
        return invoiceType;
    }

    public static String getAlleleAwsInvoiceType(String invoiceNo, String awsType) {
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20) {
            if ("1".equals(awsType)) {
                return "26";
            }
            if ("2".equals(awsType)) {
                return "27";
            }
        }
        return awsType;
    }

    public static JSONObject convertInvoiceMainInfo(JSONObject invoice) {
        if (invoice == null) {
            return null;
        }
        JSONObject resultInvoice = new JSONObject();
        resultInvoice.put("invoiceCode", (Object)invoice.getString("fpdm"));
        String invoiceNo = invoice.getString("fphm");
        resultInvoice.put("invoiceNo", (Object)invoiceNo);
        if (StringUtils.isNotEmpty((CharSequence)invoice.getString("jkshm"))) {
            resultInvoice.put("invoiceNo", (Object)invoice.getString("jkshm"));
        }
        String invoiceType = HolytaxInvoiceTypeEnum.getAwsTypeByHolytaxType(invoice.getString("fplx"));
        if ("26".equals(invoiceType = AisinoConvertUtil.getAlleleAwsInvoiceType(invoiceNo, invoiceType)) || "27".equals(invoiceType)) {
            resultInvoice.put("invoiceCode", (Object)"");
        }
        resultInvoice.put("invoiceType", (Object)invoiceType);
        resultInvoice.put("invoiceDate", (Object)invoice.getString("kprq"));
        resultInvoice.put("buyerTaxNo", (Object)invoice.getString("nsrsbh"));
        resultInvoice.put("salerTaxNo", (Object)invoice.getString("xfsbh"));
        resultInvoice.put("salerName", (Object)invoice.getString("xfnsrmc"));
        resultInvoice.put("buyerName", (Object)invoice.getString("buyerName"));
        resultInvoice.put("invoiceAmount", invoice.get((Object)"fpje"));
        resultInvoice.put("taxAmount", invoice.get((Object)"fpse"));
        resultInvoice.put("totalTaxAmount", invoice.get((Object)"fpse"));
        resultInvoice.put("effectiveTaxAmount", invoice.get((Object)"yxse"));
        String invoiceStatus = invoice.getString("fpzt");
        resultInvoice.put("invoiceStatus", (Object)invoiceStatus);
        resultInvoice.put("selectTime", (Object)DateUtils.getStandardDate(invoice.getString("gxsj")));
        String taxPeriod = invoice.getString("ssq");
        if (StringUtils.isNotEmpty((CharSequence)taxPeriod)) {
            taxPeriod = taxPeriod.replaceAll("-", "");
        }
        resultInvoice.put("taxPeriod", (Object)taxPeriod);
        String rzrq = invoice.getString("rzrq");
        String selectAuthenticateTime = DateUtils.getStandardDate(rzrq);
        resultInvoice.put("selectAuthenticateTime", (Object)selectAuthenticateTime);
        resultInvoice.put("manageStatus", invoice.get((Object)"glzt"));
        String deductionPurpose = AisinoConvertUtil.deductionPurposeConvert(invoice.getString("rzlx"));
        resultInvoice.put("deductionPurpose", (Object)deductionPurpose);
        if ("2".equals(deductionPurpose)) {
            resultInvoice.put("notDeductibleType", (Object)invoice.getString("bdkyy"));
        }
        String checkFlag = invoice.getString("gxzt");
        String checkAuthenticateFlag = invoice.getString("rzzt");
        String authenticateFlag = "0";
        if ("1".equals(checkAuthenticateFlag)) {
            authenticateFlag = "2";
        } else if ("1".equals(checkFlag)) {
            authenticateFlag = "1";
        }
        resultInvoice.put("checkFlag", (Object)checkFlag);
        resultInvoice.put("checkAuthenticateFlag", (Object)checkAuthenticateFlag);
        resultInvoice.put("authenticateFlag", (Object)authenticateFlag);
        if ("21".equals(invoiceType)) {
            resultInvoice.put("deductionPurpose", (Object)invoice.getString("yt"));
        }
        return resultInvoice;
    }

    public static String deductionPurposeConvert(String deductionPurposeParam) {
        if (StringUtils.isNotEmpty((CharSequence)deductionPurposeParam)) {
            switch (deductionPurposeParam) {
                case "1": {
                    return "1";
                }
                case "2": {
                    return "3";
                }
                case "4": {
                    return "2";
                }
            }
            return "";
        }
        return "";
    }
}

