/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import org.apache.commons.codec.binary.Base64;

public class BwService {
    private static Log LOGGER = LogFactory.getLog(BwService.class);
    private String url;
    private String proxy;
    private Integer conSec;
    private Integer socketSec;
    private String jwtApiUserName;
    private String jwtPassword;
    private int tokenExpiredTime;

    public BwService(String url, String proxy, int conSec, int socketSec, String jwtApiUserName, String jwtPassword, Integer tokenExpiredTime) {
        this.url = url;
        this.proxy = proxy;
        this.conSec = conSec;
        this.socketSec = socketSec;
        this.jwtApiUserName = jwtApiUserName;
        this.jwtPassword = jwtPassword;
        this.tokenExpiredTime = tokenExpiredTime;
    }

    public static BwService newInstance() {
        int socketSec;
        Map<String, String> map = ImcConfigUtil.getValue("rim_deduction");
        String url = map.get("bw_url");
        String proxy = map.get("bw_proxy");
        int conSec = BigDecimalUtil.transDecimal(map.get("bw_connect")).intValue();
        if (conSec < 1) {
            conSec = 20;
        }
        if ((socketSec = BigDecimalUtil.transDecimal(map.get("bw_socket")).intValue()) < 1) {
            socketSec = 60;
        }
        String jwtApiUserName = map.get("jwt_apiusername");
        String jwtPassword = map.get("jwt_password");
        String tokenExpiredTime = map.get("token_expiredtime");
        if (StringUtils.isEmpty((String)jwtApiUserName) || StringUtils.isEmpty((String)jwtPassword)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u767e\u671bJWT\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e3a\u7a7a,\u8bf7\u5728rim_config\u8fdb\u884c\u914d\u7f6e", (String)"BwService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        int time = 600000;
        if (!StringUtils.isEmpty((String)tokenExpiredTime)) {
            try {
                time = Integer.parseInt(tokenExpiredTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new BwService(url, proxy, conSec, socketSec, jwtApiUserName, jwtPassword, time);
    }

    public JSONObject postAppJson(String methodCode, String body) throws Exception {
        String url = this.url + methodCode;
        String testResult = CommonUtils.getUnitTestResult("Bw-", methodCode);
        if (!StringUtils.isEmpty((String)testResult)) {
            return JSONObject.parseObject((String)testResult);
        }
        HashMap headers = Maps.newHashMap();
        String jwtToken = this.createJwtToken();
        LOGGER.info("postAppJson jwtToken:{}", (Object)jwtToken);
        headers.put("apiToken", jwtToken);
        String str = HttpUtil.doPostJson(url, this.proxy, headers, body, this.conSec, this.socketSec);
        try {
            JSONObject result = JSONObject.parseObject((String)str);
            if (result.get((Object)"status") != null) {
                JSONObject message = new JSONObject();
                message.put("error_code", result.get((Object)"status"));
                message.put("error_message", result.get((Object)"msg"));
                result.put("message", (Object)message);
                return result;
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("postAppJson-Exception:" + str, (Throwable)e);
            return null;
        }
    }

    public String createJwtToken() throws NoSuchAlgorithmException, InvalidKeyException {
        long timestamp = System.currentTimeMillis();
        HashMap payloadClaims = Maps.newHashMap();
        HashMap headerClaims = Maps.newHashMap();
        headerClaims.put("typ", "JWT");
        headerClaims.put("alg", "HS256");
        payloadClaims.put("iss", this.jwtApiUserName);
        payloadClaims.put("iat", (timestamp - 50000L) / 1000L);
        LOGGER.info("tokenExpiredTime:{}, timestamp:{}, iat:{}, exp:{}", new Object[]{this.tokenExpiredTime, timestamp, (timestamp - 50000L) / 1000L, (timestamp + (long)this.tokenExpiredTime) / 1000L});
        payloadClaims.put("exp", (timestamp + (long)this.tokenExpiredTime) / 1000L);
        payloadClaims.put("jti", String.valueOf(timestamp));
        String payload = JSONObject.toJSONString((Object)payloadClaims);
        String header = JSONObject.toJSONString((Object)headerClaims);
        String headerEnc = Base64.encodeBase64URLSafeString((byte[])header.getBytes(StandardCharsets.UTF_8));
        String payloadEnc = Base64.encodeBase64URLSafeString((byte[])payload.getBytes(StandardCharsets.UTF_8));
        String content = String.format("%s.%s", headerEnc, payloadEnc);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(this.jwtPassword.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        byte[] signatureBytes = mac.doFinal(content.getBytes(StandardCharsets.UTF_8));
        String signature = Base64.encodeBase64URLSafeString((byte[])signatureBytes);
        String token = String.format("%s.%s", content, signature);
        CacheHelper.put("bw_jwt_token", token, this.tokenExpiredTime);
        return token;
    }
}

