/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import oracle.sql.CLOB;
import org.apache.commons.collections.CollectionUtils;

public class DBUtils {
    private static Log logger = LogFactory.getLog(DBUtils.class);
    private static final String DBKEY = "taxc";

    public static List<Map<String, Object>> query(String sql) {
        return DBUtils.query(DBKEY, sql);
    }

    public static List<Map<String, Object>> query(String sql, Object[] params) {
        return DBUtils.query(DBKEY, sql, params);
    }

    public static JSONArray queryJSONArray(String sql, Object[] params) {
        return DBUtils.queryJSONArray(DBKEY, sql, params);
    }

    public static boolean execute(String sql, Object[] params) {
        return DBUtils.execute(DBKEY, sql, params);
    }

    public static boolean execute(String dbKey, String sql, Object[] params) {
        logger.info("\u6267\u884csql:{}", (Object)sql);
        return DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])params);
    }

    public static JSONArray queryJSONArray(String dbKey, String sql, Object[] params) {
        return (JSONArray)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])params, rs -> {
            JSONArray list1 = new JSONArray();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                JSONObject hm = new JSONObject();
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = rsmd.getColumnName(i + 1);
                    Object columnValue = rs.getObject(columnName);
                    if (columnValue instanceof CLOB) {
                        hm.put(columnName.toUpperCase(), (Object)DBUtils.readOracleClob((CLOB)columnValue));
                        continue;
                    }
                    hm.put(columnName.toUpperCase(), columnValue);
                }
                list1.add((Object)hm);
            }
            return list1;
        });
    }

    public static List<Map<String, Object>> query(String dbKey, String sql, Object[] params) {
        return (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])params, rs -> {
            ArrayList list1 = new ArrayList(8);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> hm = new HashMap<String, Object>(8);
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = rsmd.getColumnName(i + 1);
                    Object columnValue = rs.getObject(columnName);
                    if (columnValue instanceof CLOB) {
                        hm.put(columnName.toUpperCase(), DBUtils.readOracleClob((CLOB)columnValue));
                        continue;
                    }
                    hm.put(columnName.toUpperCase(), columnValue);
                }
                list1.add(hm);
            }
            return list1;
        });
    }

    public static List<Map<String, Object>> query(String dbKey, String sql) {
        return DBUtils.query(dbKey, sql, null);
    }

    private static String readOracleClob(CLOB clob) throws SQLException {
        int len;
        Reader reader = clob.getCharacterStream();
        StringBuilder buff = new StringBuilder();
        int blockSize = 1024;
        char[] block = new char[blockSize];
        do {
            try {
                len = reader.read(block);
                if (len <= 0) continue;
                buff.append(block, 0, len);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        } while (len == blockSize);
        return buff.toString();
    }

    public static boolean execute(String sql) {
        return DB.execute((DBRoute)DBRoute.of((String)DBKEY), (String)sql);
    }

    public static String getQueryFields(String ... args) {
        StringBuilder queryFields = new StringBuilder();
        for (String arg : args) {
            queryFields.append(arg);
            queryFields.append(',');
        }
        return queryFields.subSequence(0, queryFields.length() - 1).toString();
    }

    public static String getSqlCondition(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "''";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append('\'').append(str).append('\'');
        }
        return sb.toString();
    }

    public static void deleteByIds(String entityName, List<Object> primaryKeys) {
        if (StringUtils.isEmpty((CharSequence)entityName) || CollectionUtils.isEmpty(primaryKeys)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String tableName = entityType.getAlias();
        String sql = "delete " + tableName + " where fid =?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(primaryKeys.size());
        for (Object primaryKey : primaryKeys) {
            params.add(new Object[]{primaryKey});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)DBKEY), (String)sql, params);
    }
}

