/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DES3Util {
    private static Log logger = LogFactory.getLog(DES3Util.class);

    public static String ees3DecodeECB(String key, String data) throws Exception {
        byte[] basecon = Base64.getDecoder().decode(data);
        byte[] bOut = DES3Util.ees3DecodeECB(key.getBytes(StandardCharsets.UTF_8.name()), basecon);
        return new String(bOut, StandardCharsets.UTF_8.name());
    }

    public static String ees3DecodeECBzip(String key, String data) throws Exception {
        byte[] basecon = Base64.getDecoder().decode(data);
        byte[] zipcon = DES3Util.unGZip(basecon);
        byte[] bOut = DES3Util.ees3DecodeECB(key.getBytes(StandardCharsets.UTF_8.name()), zipcon);
        return new String(bOut, StandardCharsets.UTF_8.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unGZip(byte[] data) {
        byte[] b = null;
        ByteArrayInputStream bis = null;
        GZIPInputStream gzip = null;
        OutputStream baos = null;
        try {
            bis = new ByteArrayInputStream(data);
            gzip = new GZIPInputStream(bis);
            byte[] buf = new byte[1024];
            int num = -1;
            baos = new ByteArrayOutputStream();
            while ((num = gzip.read(buf, 0, buf.length)) != -1) {
                ((ByteArrayOutputStream)baos).write(buf, 0, num);
            }
            b = ((ByteArrayOutputStream)baos).toByteArray();
        }
        catch (Exception ex) {
            logger.error("gzip\u89e3\u538b\u5931\u8d25", (Throwable)ex);
        }
        finally {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException iOException) {}
            }
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return b;
    }

    public static byte[] des3EncodeECB(byte[] key, byte[] data) throws Exception {
        SecretKey deskey = null;
        DESedeKeySpec spec = new DESedeKeySpec(key);
        SecretKeyFactory keyfactory = DES3Util.getInstance();
        deskey = keyfactory.generateSecret(spec);
        Cipher cipher = DES3Util.getCipher();
        cipher.init(1, deskey);
        byte[] bOut = cipher.doFinal(data);
        return bOut;
    }

    public static byte[] ees3DecodeECB(byte[] key, byte[] data) throws Exception {
        SecretKey deskey = null;
        DESedeKeySpec spec = new DESedeKeySpec(key);
        SecretKeyFactory keyfactory = DES3Util.getInstance();
        deskey = keyfactory.generateSecret(spec);
        Cipher cipher = DES3Util.getCipher();
        cipher.init(2, deskey);
        return cipher.doFinal(data);
    }

    private static SecretKeyFactory getInstance() throws NoSuchAlgorithmException {
        return SecretKeyFactory.getInstance("d#e#s#e#d#e".replace("#", ""));
    }

    private static Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance("de#s#ede/E#CB/PKCS##5Padd#ing".replace("#", ""));
        return cipher;
    }
}

