/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import org.apache.commons.compress.utils.Lists;

public class DateUtils {
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String HHMMSSSSS = "HHmmssSSS";

    public static Date trunc(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static Date addHour(Date date, int hour) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(11, hour);
        return cd.getTime();
    }

    public static Date addSecond(Date date, int isecond) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(13, isecond);
        return cd.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, iyear);
        return cd.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getFirstDateOfThreeMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -3);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfHalfYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -6);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfOneYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -12);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonthZero(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date stringToDate(String datestr) {
        return DateUtils.stringToDate(datestr, YYYY_MM_DD);
    }

    public static Date stringToDate(String datestr, String dateformat) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_0", (String)"imc-rim-common", (Object[])new Object[0]), datestr, dateformat), e);
        }
        return date;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String format(Date date) {
        return DateUtils.format(date, YYYY_MM_DD);
    }

    public static Date getFirstDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getLastDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getFirstDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime(weekEndSta);
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getDayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date resultTime = calendar.getTime();
        return resultTime;
    }

    public static Date getDayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        Date resultTime = calendar.getTime();
        return resultTime;
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getLastDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, day);
        return DateUtils.getDayEndTime(calendar.getTime());
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static Date getLastDay() {
        Calendar calendar = Calendar.getInstance();
        int date = calendar.get(5);
        calendar.set(5, date - 1);
        return calendar.getTime();
    }

    public static int compare(Date date1, Date date2) {
        String date1Str = DateUtils.format(date1, YYYYMMDD);
        String date2Str = DateUtils.format(date2, YYYYMMDD);
        return Integer.parseInt(date1Str) - Integer.parseInt(date2Str);
    }

    public static boolean isMonth(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year1 = calendar1.get(1);
        int year2 = calendar2.get(1);
        int month1 = calendar1.get(2);
        int month2 = calendar2.get(2);
        return year1 == year2 && month1 == month2;
    }

    public static Date getFormatDate(String dateFormatStr, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
        String formatDateStr = null;
        Date newDate = null;
        try {
            formatDateStr = sdf.format(date);
            newDate = sdf.parse(formatDateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_0", (String)"imc-rim-common", (Object[])new Object[0]), date, dateFormatStr), e);
        }
        return newDate;
    }

    public static Map<Date, Date> cutTimeRange(Date starttime, Date endtime, int num) {
        HashMap<Date, Date> result = new HashMap<Date, Date>(num);
        if (!ObjectUtils.isEmpty((Object)starttime) && !ObjectUtils.isEmpty((Object)endtime) && num > 1) {
            Date dateTemp = starttime;
            long diff = endtime.getTime() - starttime.getTime();
            long days = diff / 86400000L;
            for (int i = 1; i < num; ++i) {
                long temp = dateTemp.getTime() + 86400000L * (days / (long)num);
                result.put(dateTemp, new Date(temp));
                dateTemp = new Date(temp += 86400000L);
            }
            result.put(dateTemp, endtime);
        }
        return result;
    }

    public static long daysBetween(Date one, Date two) {
        long difference = (DateUtils.trunc(one).getTime() - DateUtils.trunc(two).getTime()) / 86400000L;
        return difference;
    }

    public static String unitTest() {
        Date today = new Date();
        DateUtils.trunc(today);
        DateUtils.addDay(today, 1);
        DateUtils.addMonth(today, 1);
        DateUtils.addYear(today, 1);
        DateUtils.getFirstDateOfMonth(today);
        DateUtils.getLastDateOfMonth(today);
        DateUtils.stringToDate("2018-09-01");
        DateUtils.stringToDate("2018-09-09-1 12:00", YYYY_MM_DD);
        DateUtils.format(today, YYYY_MM_DD);
        DateUtils.format(today);
        DateUtils.getFirstDayOfWeek();
        DateUtils.getLastDayOfWeek();
        DateUtils.getDayStartTime(today);
        DateUtils.getDayEndTime(today);
        DateUtils.getLastDayOfMonth();
        DateUtils.getNowYear();
        DateUtils.getNowMonth();
        DateUtils.addHour(today, 1);
        DateUtils.getDayStart(today);
        DateUtils.getDayEnd(today);
        DateUtils.compare(today, today);
        DateUtils.getFirstDateOfHalfYear(new Date());
        DateUtils.getFirstDateOfOneYear(new Date());
        Date s1 = DateUtils.stringToDate("2022-08-01");
        Date s2 = DateUtils.stringToDate("2022-08-31");
        DateUtils.cutTimeRange(s1, s2, 3);
        DateUtils.daysBetween(s1, s2);
        DateUtils.getFormatDate(YYYY_MM_DD, new Date());
        DateUtils.isMonth(new Date(), new Date());
        DateUtils.addSecond(new Date(), 1);
        DateUtils.matchyyyyMM("202202");
        ArrayList initDateList = Lists.newArrayList();
        DateUtils.getMonthGroup(DateUtils.addMonth(new Date(), -3), initDateList);
        return "success";
    }

    public static boolean isOverdue(Date one, Date two) {
        if (null == one || null == two) {
            return false;
        }
        two = DateUtils.truncFirstDate(two);
        return one.getTime() < two.getTime();
    }

    public static Date truncFirstDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static String getStandardDate(String dataStr) {
        String standardDate = "";
        if (StringUtils.isNotEmpty((CharSequence)dataStr)) {
            dataStr = dataStr.replaceAll("-", "");
            Date rzrqDate = DateUtils.stringToDate(dataStr, YYYYMMDD);
            standardDate = DateUtils.format(rzrqDate);
        }
        return standardDate;
    }

    public static boolean matchyyyyMM(String dateStr) {
        Pattern pattern = Pattern.compile("^(21|20|19){1}[0-9]{2}(((0){1}[1-9]{1})|((1){1}(0|1|2){1}))$");
        Matcher isMatch = pattern.matcher(dateStr);
        return isMatch.matches();
    }

    public static void getMonthGroup(Date begin, List<Map<String, Date>> dateList) {
        if (dateList == null) {
            dateList = Lists.newArrayList();
        }
        SimpleDateFormat format = new SimpleDateFormat(YYYYMM);
        Calendar calendar = Calendar.getInstance();
        Date currentDate = new Date();
        String data = format.format(begin);
        String current = format.format(currentDate);
        calendar.setTime(begin);
        if (!data.equals(current)) {
            HashMap<String, Date> dealDate = new HashMap<String, Date>(2);
            dealDate.put("begin", DateUtils.getFirstDateOfMonth(begin));
            dealDate.put("end", DateUtils.getLastDateOfMonthZero(begin));
            calendar.set(5, 1);
            calendar.add(2, 1);
            dateList.add(dealDate);
            DateUtils.getMonthGroup(calendar.getTime(), dateList);
        }
    }

    public static boolean isTimeZero(Date date) {
        if (date == null) {
            return false;
        }
        LocalTime time = date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        return time.equals(LocalTime.MIN);
    }
}

