/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.FpzsConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimRetryPostUtil;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;

public class DeductionUtils {
    private static Log logger = LogFactory.getLog(DeductionUtils.class);
    private static final Long TRAIN_INVOICE_TYPE = 961640926684439552L;
    private static final Long AIR_INVOICE_TYPE = 961641064953820160L;
    private static final Long TRANSPORT_INVOICE_TYPE = 961642651029877760L;
    private static final Long SHIP_INVOICE_TYPE = 961642939052733440L;
    private static final BigDecimal TRAIN_INVOICE_TAXRATE_ONE = new BigDecimal("0.090000");
    private static final BigDecimal AIR_INVOICE_TAXRATE_ONE = new BigDecimal("0.090000");
    private static final BigDecimal TRANSPORT_INVOICE_TAXRATE_ONE = new BigDecimal("0.030000");
    private static final BigDecimal SHIP_INVOICE_TAXRATE_ONE = new BigDecimal("0.030000");
    private static final BigDecimal TRAIN_INVOICE_TAXRATE_TWO = new BigDecimal("0.090000");
    private static final BigDecimal AIR_INVOICE_TAXRATE_TWO = new BigDecimal("0.090000");
    private static final BigDecimal TRANSPORT_INVOICE_TAXRATE_TWO = new BigDecimal("0.030000");
    private static final BigDecimal SHIP_INVOICE_TAXRATE_TWO = new BigDecimal("0.030000");
    private static final String FIRST_TAX_PERIOD = "2019-03-31 23:59:59";
    private static Map<Long, BigDecimal> taxRateMap1 = new HashMap<Long, BigDecimal>();
    private static Map<Long, BigDecimal> taxRateMap2 = new HashMap<Long, BigDecimal>();

    public static BigDecimal airTaxAmountByInvoiceDate(Date invoiceDate, BigDecimal invoiceAmount, BigDecimal fuelSurcharge, String customerName, BigDecimal otherTotalTaxAmount, BigDecimal totalAmount, BigDecimal airportConstructionFee, String placeOfDeparture, String destination) {
        BigDecimal totalTaxAmount = null;
        if (null != invoiceAmount && null != fuelSurcharge && null != invoiceDate) {
            boolean flag = false;
            try {
                flag = invoiceDate.after(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(FIRST_TAX_PERIOD));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (DeductionUtils.checkPlace(placeOfDeparture) || DeductionUtils.checkPlace(destination)) {
                flag = false;
            }
            BigDecimal taxRate = DeductionUtils.taxRateByInvoiceDate(invoiceDate, 961641064953820160L, new Object[0]);
            BigDecimal totalAmountTemp = new BigDecimal("0");
            if (null != airportConstructionFee) {
                try {
                    if (airportConstructionFee.compareTo(FpzsConstant.sysMaxAmount) < 0) {
                        totalAmountTemp = totalAmountTemp.add(airportConstructionFee);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (otherTotalTaxAmount == null) {
                otherTotalTaxAmount = BigDecimal.ZERO;
            }
            try {
                if (otherTotalTaxAmount.compareTo(FpzsConstant.sysMaxAmount) < 0) {
                    totalAmountTemp = totalAmountTemp.add(otherTotalTaxAmount);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fuelSurcharge.compareTo(FpzsConstant.sysMaxAmount) < 0) {
                totalAmountTemp = totalAmountTemp.add(fuelSurcharge);
            }
            if (invoiceAmount.compareTo(FpzsConstant.sysMaxAmount) < 0) {
                totalAmountTemp = totalAmountTemp.add(invoiceAmount);
            }
            if (null != totalAmount && totalAmountTemp.compareTo(totalAmount) > 0) {
                if (!flag) {
                    return BigDecimal.ZERO;
                }
                totalTaxAmount = totalAmount.subtract(otherTotalTaxAmount);
                if ((totalTaxAmount = totalTaxAmount.divide(new BigDecimal("1.00").add(taxRate), 6, 4).multiply(taxRate).setScale(2, 4)).compareTo(new BigDecimal("0")) == 0) {
                    totalTaxAmount = new BigDecimal(0);
                }
                return totalTaxAmount;
            }
            if (flag) {
                totalTaxAmount = invoiceAmount.add(fuelSurcharge);
                if ((totalTaxAmount = totalTaxAmount.divide(new BigDecimal("1.00").add(taxRate), 6, 4).multiply(taxRate).setScale(2, 4)).compareTo(new BigDecimal("0")) == 0) {
                    totalTaxAmount = new BigDecimal(0);
                }
            }
        }
        return totalTaxAmount;
    }

    public static BigDecimal trainTaxAmountByInvoiceDate(Date invoiceDate, BigDecimal totalAmount, String passageName, String customerIdentityNum, String stationGetOn, String stationGetOff, String businessType) {
        BigDecimal totalTaxAmount = null;
        if (null != totalAmount && null != invoiceDate && (StringUtils.isNotEmpty((CharSequence)passageName) || StringUtils.isNotEmpty((CharSequence)customerIdentityNum))) {
            BigDecimal taxRate;
            boolean flag = false;
            try {
                flag = invoiceDate.after(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(FIRST_TAX_PERIOD));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if ("2".equals(businessType) || "3".equals(businessType) || "4".equals(businessType)) {
                flag = false;
            }
            if (DeductionUtils.checkPlace(stationGetOn) || DeductionUtils.checkPlace(stationGetOff)) {
                flag = false;
            }
            if (flag && (totalTaxAmount = totalAmount.divide(new BigDecimal("1.00").add(taxRate = DeductionUtils.taxRateByInvoiceDate(invoiceDate, 961640926684439552L, new Object[0])), 6, 4).multiply(taxRate).setScale(2, 4)).compareTo(new BigDecimal("0")) == 0) {
                totalTaxAmount = new BigDecimal(0);
            }
        }
        return totalTaxAmount;
    }

    public static BigDecimal passengerTransport16TaxAmountByInvoiceDate(Date invoiceDate, BigDecimal totalAmount, String passageName, String customerIdNo, BigDecimal insurancePremium, String stationGetOn, String stationGetOff) {
        BigDecimal totalTaxAmount = null;
        if (null != totalAmount && null != invoiceDate && (StringUtils.isNotEmpty((CharSequence)passageName) || StringUtils.isNotEmpty((CharSequence)customerIdNo))) {
            boolean flag = false;
            try {
                flag = invoiceDate.after(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(FIRST_TAX_PERIOD));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (DeductionUtils.checkPlace(stationGetOn) || DeductionUtils.checkPlace(stationGetOff)) {
                flag = false;
            }
            if (flag) {
                BigDecimal taxRate;
                if (null != insurancePremium) {
                    totalAmount = totalAmount.subtract(insurancePremium);
                }
                if ((totalTaxAmount = totalAmount.divide(new BigDecimal("1.00").add(taxRate = DeductionUtils.taxRateByInvoiceDate(invoiceDate, 961642651029877760L, new Object[0])), 6, 4).multiply(taxRate).setScale(2, 4)).compareTo(new BigDecimal("0")) == 0) {
                    totalTaxAmount = new BigDecimal(0);
                }
            }
        }
        return totalTaxAmount;
    }

    public static BigDecimal passengerTransport20TaxAmountByInvoiceDate(Date invoiceDate, BigDecimal totalAmount, String passageName, String customerIdNo, String stationGetOn, String stationGetOff) {
        BigDecimal totalTaxAmount = null;
        if (null != totalAmount && null != invoiceDate && (StringUtils.isNotEmpty((CharSequence)passageName) || StringUtils.isNotEmpty((CharSequence)customerIdNo))) {
            BigDecimal taxRate;
            boolean flag = false;
            try {
                flag = invoiceDate.after(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(FIRST_TAX_PERIOD));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (DeductionUtils.checkPlace(stationGetOn) || DeductionUtils.checkPlace(stationGetOff)) {
                flag = false;
            }
            if (flag && (totalTaxAmount = totalAmount.divide(new BigDecimal("1.00").add(taxRate = DeductionUtils.taxRateByInvoiceDate(invoiceDate, 961642939052733440L, new Object[0])), 6, 4).multiply(taxRate).setScale(2, 4)).compareTo(new BigDecimal("0")) == 0) {
                totalTaxAmount = new BigDecimal(0);
            }
        }
        return totalTaxAmount;
    }

    public static BigDecimal taxRateByInvoiceDateAndInvoiceType(Date invoiceDate, Long invoiceType, Object ... param) {
        BigDecimal taxRate = null;
        if (null != invoiceDate && null != invoiceType) {
            boolean flag = false;
            try {
                flag = invoiceDate.after(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(FIRST_TAX_PERIOD));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (flag) {
                try {
                    Date secondTaxPeriod = new Date(System.currentTimeMillis());
                    int compare = DeductionUtils.compare_date(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(FIRST_TAX_PERIOD), secondTaxPeriod, invoiceDate);
                    taxRate = compare == 1 ? taxRateMap1.get(invoiceType) : taxRateMap2.get(invoiceType);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return taxRate;
    }

    public static BigDecimal taxRateByInvoiceDate(Date invoiceDate, Long invoiceType, Object ... param) {
        BigDecimal taxRate = null;
        if (null != invoiceDate) {
            try {
                Date secondTaxPeriod = new Date(System.currentTimeMillis());
                int compare = DeductionUtils.compare_date(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(FIRST_TAX_PERIOD), secondTaxPeriod, invoiceDate);
                taxRate = compare == 1 ? taxRateMap1.get(invoiceType) : taxRateMap2.get(invoiceType);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return taxRate;
    }

    public static int compare_date(Date Date1, Date Date2, Date Date3) {
        try {
            if (Date1.getTime() < Date3.getTime() && Date3.getTime() < Date2.getTime()) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static boolean checkPlace(String place) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((CharSequence)place) && (place.contains("\u9999\u6e2f") || place.contains("\u6fb3\u95e8") || place.contains("\u53f0\u6e7e"))) {
            flag = true;
        }
        return flag;
    }

    public static boolean countDeductionType(Long invoiceType) {
        return null != invoiceType && (961640926684439552L == invoiceType || 961641064953820160L == invoiceType || 961642651029877760L == invoiceType || 961642939052733440L == invoiceType);
    }

    public static void unitTest() {
    }

    public static void deleteCheckCache(JSONObject invoice, Long invoiceType) {
        if (!InputInvoiceTypeEnum.needCheck(invoiceType).booleanValue()) {
            return;
        }
        if (!ObjectUtils.isEmpty((Object)invoice) && !"0".equals(invoice.getString("invoiceStatus"))) {
            QFilter filter1 = null;
            if (!InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
                filter1 = new QFilter("invoice_code", "=", (Object)invoice.getString("invoiceCode"));
            }
            QFilter filter2 = new QFilter("invoice_no", "=", (Object)invoice.getString("invoiceNo"));
            DeleteServiceHelper.delete((String)"rim_check_result", (QFilter[])new QFilter[]{filter1, filter2});
        }
    }

    public static void addBuyerInfo(JSONObject invoiceJson, String taxNo, String companyName, String addFlag) {
        if (ObjectUtils.isEmpty((Object)invoiceJson) || StringUtils.isEmpty((CharSequence)taxNo)) {
            return;
        }
        if ("1".equals(addFlag)) {
            String buyerTaxNo;
            String buyerName = invoiceJson.getString("buyerName");
            if (StringUtils.isEmpty((CharSequence)buyerName)) {
                invoiceJson.put("buyerName", (Object)companyName);
            }
            if (StringUtils.isEmpty((CharSequence)(buyerTaxNo = invoiceJson.getString("buyerTaxNo")))) {
                invoiceJson.put("buyerTaxNo", (Object)taxNo);
            }
        }
    }

    public static void setTaxDownCollectInfo(JSONObject invoiceJson) {
        String updateDelete;
        if (invoiceJson == null) {
            return;
        }
        invoiceJson.put("allowDeduction", (Object)"1");
        logger.info("\u6570\u636e\u6765\u6e90\u4e0d\u4e3a\u7a7a\u65f6\u7684\u6765\u6e90{}", (Object)invoiceJson.getString("resource"));
        if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("resource"))) {
            String dkType = DeductionConstant.getDkType(invoiceJson.getString("taxNo"));
            logger.info("\u83b7\u53d6\u7684\u62b5\u6263\u7c7b\u578b\u548c\u7a0e\u53f7{}\uff0c{}", (Object)dkType, (Object)invoiceJson.getString("taxNo"));
            if ("4".equals(dkType)) {
                invoiceJson.put("resource", (Object)"\u7535\u5b50\u7a0e\u5c40\u4e0b\u8f7d");
            } else if ("5".equals(dkType)) {
                invoiceJson.put("resource", (Object)"\u4e50\u4f01\u4e0b\u8f7d");
            } else {
                invoiceJson.put("resource", (Object)"\u7a0e\u76d8");
            }
        }
        if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("collect_type"))) {
            invoiceJson.put("collect_type", (Object)CollectTypeEnum.PC_SHUIPAN.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("overrideOrg"))) {
            String downOverrideOrg = RimConfigUtils.getConfig("rim_deduction", "down_override_org");
            if (StringUtils.isNotEmpty((CharSequence)downOverrideOrg)) {
                invoiceJson.put("overrideOrg", (Object)downOverrideOrg);
            } else {
                invoiceJson.put("overrideOrg", (Object)"0");
            }
        }
        if ("0".equals(updateDelete = RimConfigUtils.getConfig("rim_deduction", "update_delete"))) {
            invoiceJson.put("delete", (Object)"99");
        }
    }

    public static JSONObject setBatchNo2Result(JSONObject result, String asyncFlag, String batchNo, String taskNo) {
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            if (data == null) {
                data = new JSONObject();
            }
            asyncFlag = Optional.ofNullable(asyncFlag).orElse("0");
            data.put("asyncFlag", (Object)asyncFlag);
            if (batchNo != null) {
                data.put("batchNo", (Object)batchNo);
            }
            data.put("taskNo", (Object)taskNo);
            result.put("data", (Object)data);
        }
        return result;
    }

    public static JSONObject setBatchNo2Result(JSONObject result, String asyncFlag, String batchNo) {
        return DeductionUtils.setBatchNo2Result(result, asyncFlag, batchNo, UUID.randomUUID());
    }

    public static void showResult(AbstractFormPlugin plugin) {
        String title = plugin.getPageCache().get("deduct_title");
        String resultCache = plugin.getPageCache().get("operation_result");
        DeductionConstant.removeLoopLoginCache(plugin.getPageCache());
        JSONObject result = JSONObject.parseObject((String)resultCache);
        if (ResultContant.isSuccess(result).booleanValue()) {
            String message = result.getString("message");
            Integer failNum = result.getIntValue("failNum");
            Integer successNum = result.getIntValue("successNum");
            ViewUtil.showMessage(plugin, title, message, successNum, failNum);
            BillList billlist = (BillList)plugin.getControl("billlistap");
            billlist.clearSelection();
            billlist.refresh();
        } else {
            String description = result != null ? String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%1$s", (String)"DeductionUtils_1", (String)"imc-rim-common", (Object[])new Object[0]), result.getString("description")) : ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DeductionUtils_2", (String)"imc-rim-common", (Object[])new Object[0]);
            plugin.getView().showTipNotification(description);
        }
    }

    public static Set<String> getHolyRetryErrcodes() {
        HashSet<String> set = new HashSet<String>(8);
        set.addAll(Arrays.asList(DeductionConstant.DEFAULT_COLLECT_ERRCODE));
        set.add("0200");
        String retryErrcode = RimConfigUtils.getConfig("rim_deduction", "retry_errcode");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)retryErrcode)) {
            List<String> multiValues = CommonUtils.getMultiValues(retryErrcode);
            set.addAll(multiValues);
        }
        return set;
    }

    public static Set<String> getEtaxRetryErrcodes() {
        HashSet<String> set = new HashSet<String>(8);
        set.addAll(Arrays.asList(DeductionConstant.DEFAULT_COLLECT_ERRCODE));
        set.addAll(Arrays.asList(DeductionConstant.E_TAX_COLLECT_ERRCODE));
        String retryErrcode = RimConfigUtils.getConfig("rim_deduction", "all_e_retry_errcode");
        if (StringUtils.isNotEmpty((CharSequence)retryErrcode)) {
            List<String> multiValues = CommonUtils.getMultiValues(retryErrcode);
            set.addAll(multiValues);
        }
        return set;
    }

    public static JSONObject eTaxClientLogin(Long orgId, String taxNo) {
        NewEtaxDeductService deductService;
        JSONObject login;
        String loginKey = "e_down_login_" + taxNo;
        String loginConfig = RimConfigUtils.getConfig("rim_deduction", "e_login_lock");
        int failTimes = 0;
        if ("1".equals(loginConfig)) {
            String loginCache = CacheHelper.get(loginKey);
            int loginTimes = InvoiceDownloadConstant.getPageSizeFromConfig(5, "e_login_retry_times");
            if (StringUtils.isNotEmpty((CharSequence)loginCache) && (failTimes = Integer.parseInt(loginCache)) >= loginTimes) {
                return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u767b\u9646\u5df2\u9501\u5b9a30\u5206\u949f", (String)"DeductionUtils_3", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        if (!ResultContant.isSuccess(login = (deductService = new NewEtaxDeductService(orgId)).login(taxNo)).booleanValue()) {
            boolean flag = DeductionUtils.isNotConfig(login);
            if (login == null) {
                login = ResultContant.createJSONObject(ErrorType.ALl_E_LOGIN_FAIL);
            }
            login.put("errcode", (Object)ErrorType.NEED_LOGIN.getCode());
            if (!"1".equals(loginConfig) || flag) {
                return login;
            }
            int loginFailTimes = InvoiceDownloadConstant.getPageSizeFromConfig(1800, "e_login_fail_times");
            CacheHelper.put(loginKey, String.valueOf(++failTimes), loginFailTimes);
            return login;
        }
        JSONObject data = login.getJSONObject("data");
        if (deductService.needOpenLoginPage(data)) {
            int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(1, "all_e_login_retry_times");
            int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "all_e_login_sleep_times");
            Predicate<JSONObject> predicate = s -> ResultContant.isSuccess(s) == false || deductService.needOpenLoginPage(s.getJSONObject("data"));
            login = RimRetryPostUtil.retryPost(() -> DeductionUtils.getLoginStatus(orgId, taxNo), predicate, retryTime, sleepTime);
            logger.info("\u83b7\u53d6\u624b\u5de5\u767b\u5f55\u7ed3\u679c{},{}", (Object)taxNo, (Object)login);
            if (ResultContant.isSuccess(login).booleanValue() && !deductService.needOpenLoginPage(login.getJSONObject("data"))) {
                DeductionUtils.removeLoginCache(loginConfig, loginKey);
                return login;
            }
            if (login == null) {
                login = new JSONObject();
            }
            login.put("errcode", (Object)ErrorType.NEED_LOGIN.getCode());
            login.put("description", (Object)ErrorType.NEED_LOGIN.getName());
            return login;
        }
        DeductionUtils.removeLoginCache(loginConfig, loginKey);
        return login;
    }

    public static boolean isNotConfig(JSONObject login) {
        return login != null && (StringUtils.contains((CharSequence)login.getString("description"), (CharSequence)"\u5ba2\u6237\u7aef\u672a\u542f\u52a8") || StringUtils.contains((CharSequence)login.getString("description"), (CharSequence)ResManager.loadKDString((String)"\u6570\u7535\u914d\u7f6e", (String)"DeductionUtils_5", (String)"imc-rim-common", (Object[])new Object[0])) || ErrorType.NEED_LOGIN.getCode().equals(login.getString("errcode")));
    }

    private static void removeLoginCache(String loginConfig, String loginKey) {
        if ("1".equals(loginConfig)) {
            CacheHelper.remove(loginKey);
        }
    }

    private static JSONObject getLoginStatus(Long orgId, String taxNo) {
        JSONObject paramJson = new JSONObject();
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        paramJson.put("request_path", (Object)"/fpdk/etax/login/status");
        String checkAuth = RimConfigUtils.getConfig("rim_deduction", "e_tax_check_auth");
        checkAuth = Optional.ofNullable(checkAuth).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).orElse("0");
        paramJson.put("checkAuth", (Object)(!"0".equals(checkAuth) ? 1 : 0));
        AwsFpyService service = AwsFpyService.newInstance();
        return service.allEPostAppJson(orgId, taxNo, paramJson);
    }

    public static String convertInvoiceSource(String invoiceSource) {
        if (StringUtils.isEmpty((CharSequence)invoiceSource)) {
            return invoiceSource;
        }
        switch (invoiceSource) {
            case "\u65e0": 
            case "Empty": {
                return "0";
            }
            case "\u589e\u503c\u7a0e\u53d1\u7968\u7ba1\u7406\u7cfb\u7edf": 
            case "VAT Invoice Management System": {
                return "1";
            }
            case "\u7535\u5b50\u53d1\u7968\u670d\u52a1\u5e73\u53f0": 
            case "E-Invoice Service Platform": {
                return "2";
            }
        }
        return invoiceSource;
    }

    public static String convertInvoiceRiskLevel(String invoiceRiskLevel) {
        if (StringUtils.isEmpty((CharSequence)invoiceRiskLevel)) {
            return invoiceRiskLevel;
        }
        switch (invoiceRiskLevel) {
            case "\u65e0": 
            case "Empty": {
                return "0";
            }
            case "\u6b63\u5e38": 
            case "Normal": {
                return "1";
            }
            case "\u7591\u70b9\u53d1\u7968": 
            case "Questionable Invoice": {
                return "2";
            }
            case "\u5f02\u5e38\u51ed\u8bc1": 
            case "Abnormal Voucher": {
                return "3";
            }
        }
        return invoiceRiskLevel;
    }

    public static String convertInvoiceRiskLevelToAws(String invoiceRiskLevel) {
        if (StringUtils.isEmpty((CharSequence)invoiceRiskLevel)) {
            return "\u6b63\u5e38";
        }
        switch (invoiceRiskLevel) {
            case "0": {
                return "\u65e0";
            }
            case "1": {
                return "\u6b63\u5e38";
            }
            case "2": {
                return "\u7591\u70b9\u53d1\u7968";
            }
            case "3": {
                return "\u5f02\u5e38\u51ed\u8bc1";
            }
        }
        return invoiceRiskLevel;
    }

    public static Date getParamTaxPeriod(String taxPeriod) {
        if (StringUtils.isEmpty((CharSequence)taxPeriod)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductionUtils_14", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Date taxPeriodDate = null;
        if (!DateUtils.matchyyyyMM(taxPeriod)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DeductionUtils_13", (String)"imc-rim-common", (Object[])new Object[0]), taxPeriod, "yyyyMM"));
        }
        try {
            taxPeriodDate = DateUtils.stringToDate(taxPeriod, "yyyyMM");
        }
        catch (Exception e) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), e.getMessage());
        }
        Date lastDate = DateUtils.getLastDateOfMonth(new Date());
        if (taxPeriodDate.compareTo(lastDate) > 0) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f[%1$s]\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6708\u4efd", (String)"DeductionUtils_15", (String)"imc-rim-common", (Object[])new Object[0]), taxPeriod));
        }
        return taxPeriodDate;
    }

    public static void saveInvoiceToInputTable(JSONArray invoiceArray, Long orgId, String taxNo, String batchNo) {
        DeductionUtils.saveInvoiceToInputTable(invoiceArray, orgId, taxNo, batchNo, null, null, null);
    }

    public static void saveInvoiceToInputTable(JSONArray invoiceArray, Long orgId, String taxNo, String batchNo, String resource, String collect_type, String overrideOrg) {
        if (!CollectionUtils.isEmpty((Collection)invoiceArray)) {
            for (int i = 0; i < invoiceArray.size(); ++i) {
                JSONObject invoice = invoiceArray.getJSONObject(i);
                Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
                String invoiceCode = StringUtils.trimToEmpty((String)invoice.getString("invoiceCode"));
                String invoiceNo = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "invoiceNo", "jkshm", "customDeclarationNo");
                DynamicObject accountObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_input_table");
                accountObject.set("org", (Object)orgId);
                accountObject.set("tax_no", (Object)taxNo);
                accountObject.set("batch_no", (Object)batchNo);
                accountObject.set("invoice_type", (Object)invoiceType);
                accountObject.set("invoice_code", (Object)invoiceCode);
                accountObject.set("invoice_no", (Object)invoiceNo);
                accountObject.set("electronic_no", (Object)invoice.getString("etaxInvoiceNo"));
                accountObject.set("collect_type", (Object)collect_type);
                accountObject.set("override_org", (Object)overrideOrg);
                accountObject.set("resource", (Object)resource);
                Object date = invoice.get((Object)"invoiceDate");
                if (date instanceof Long) {
                    accountObject.set("invoice_date", (Object)new Date((Long)date));
                } else {
                    accountObject.set("invoice_date", (Object)invoice.getDate("invoiceDate"));
                }
                accountObject.set("invoice_amount", (Object)BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount")));
                accountObject.set("total_amount", (Object)BigDecimalUtil.transDecimal(invoice.get((Object)"totalAmount")));
                BigDecimal totalTaxAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount"));
                if (BigDecimal.ZERO.compareTo(totalTaxAmount) == 0) {
                    totalTaxAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"skje"));
                }
                accountObject.set("total_tax_amount", (Object)totalTaxAmount);
                String invoiceStatus = invoice.getString("invoiceStatus");
                accountObject.set("invoice_status", (Object)invoiceStatus);
                accountObject.set("invoice_source", (Object)DeductionUtils.convertInvoiceSource(invoice.getString("invoiceSource")));
                accountObject.set("invoice_risk_level", (Object)DeductionUtils.convertInvoiceRiskLevel(invoice.getString("invoiceRiskLevel")));
                accountObject.set("status", (Object)"3");
                accountObject.set("effective_tax_amount", (Object)invoice.getBigDecimal("effectiveTaxAmount"));
                accountObject.set("authenticate_flag", (Object)"0");
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("checkFlag")) && "1".equals(invoice.getString("checkFlag"))) {
                    accountObject.set("authenticate_flag", (Object)"1");
                }
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("checkAuthenticateFlag")) && "1".equals(invoice.getString("checkAuthenticateFlag"))) {
                    accountObject.set("authenticate_flag", (Object)"2");
                }
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("scanAuthenticateFlag")) && "1".equals(invoice.getString("scanAuthenticateFlag"))) {
                    accountObject.set("authenticate_flag", (Object)"3");
                }
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("authenticateFlag"))) {
                    accountObject.set("authenticate_flag", (Object)invoice.getString("authenticateFlag"));
                }
                accountObject.set("select_time", StringUtils.isEmpty((CharSequence)invoice.getString("selectTime")) ? null : DateUtils.stringToDate(invoice.getString("selectTime"), "yyyy-MM-dd"));
                Date authenticateTime = null;
                if ("2".equals(accountObject.getString("authenticate_flag"))) {
                    authenticateTime = StringUtils.isEmpty((CharSequence)invoice.getString("selectAuthenticateTime")) ? null : DateUtils.stringToDate(invoice.getString("selectAuthenticateTime"));
                } else if ("3".equals(accountObject.getString("authenticate_flag"))) {
                    authenticateTime = StringUtils.isEmpty((CharSequence)invoice.getString("scanAuthenticateTime")) ? null : DateUtils.stringToDate(invoice.getString("scanAuthenticateTime"));
                }
                accountObject.set("authenticate_time", (Object)authenticateTime);
                accountObject.set("tax_period", StringUtils.isEmpty((CharSequence)invoice.getString("taxPeriod")) ? null : DateUtils.stringToDate(invoice.getString("taxPeriod"), "yyyyMM"));
                String deductionPurpose = invoice.getString("deductionPurpose");
                accountObject.set("deduction_purpose", (Object)deductionPurpose);
                if ("2".equals(deductionPurpose)) {
                    accountObject.set("not_deductible_type", (Object)invoice.getString("notDeductibleType"));
                }
                accountObject.set("manage_status", (Object)invoice.getString("manageStatus"));
                accountObject.set("buyer_name", (Object)invoice.getString("buyerName"));
                accountObject.set("buyer_tax_no", (Object)invoice.getString("buyerTaxNo"));
                accountObject.set("saler_name", (Object)invoice.getString("salerName"));
                accountObject.set("saler_tax_no", (Object)invoice.getString("salerTaxNo"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{accountObject});
            }
        }
    }

    public static void handleInputTable(Object[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            return;
        }
        String userId = RequestContext.get().getUserId();
        DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
        DynamicObject[] inputTables = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_input_table"));
        ArrayList<JSONObject> invoiceList = new ArrayList<JSONObject>(inputTables.length);
        Long orgId = null;
        String taxNo = null;
        for (DynamicObject inputTable : inputTables) {
            if (!"3".equals(inputTable.getString("status"))) continue;
            if (orgId == null) {
                orgId = DynamicObjectUtil.getDynamicObjectLongValue(inputTable.get("org"));
            }
            if (taxNo == null) {
                taxNo = inputTable.getString("tax_no");
            }
            inputTable.set("modifytime", (Object)new Date());
            inputTable.set("status", (Object)"1");
            JSONObject invoice = InvoiceConvertService.convertInviceMainInfo(inputTable);
            invoice.put("salerTaxNo", (Object)DynamicObjectUtil.fieldToString(inputTable.get("saler_tax_no")));
            invoice.put("collect_type", inputTable.get("collect_type"));
            invoice.put("overrideOrg", inputTable.get("override_org"));
            invoice.put("resource", inputTable.get("resource"));
            invoice.put("etaxInvoiceNo", inputTable.get("electronic_no"));
            invoiceList.add(invoice);
        }
        SaveServiceHelper.update((DynamicObject[])inputTables);
        operateService.asyncSaveDownInvoice(invoiceList, orgId, userId, taxNo);
    }

    public static String checkDeductionFiled(JSONObject invoice) {
        if (invoice == null) {
            return null;
        }
        String authenticateFlag = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "authenticate_flag", "authenticateFlag");
        String taxPeriod = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "tax_period", "taxPeriod");
        String deductionPurpose = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "deduction_purpose", "deductionPurpose");
        String notDeductibleType = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "not_deductible_type", "notDeductibleType");
        Date selectTime = CommonUtils.getJsonValue((Map<String, Object>)invoice, Date.class, "select_time", "selectTime");
        String transportDeduction = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "transport_deduction", "transportDeduction");
        String authenticateTime = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, true, "authenticate_time", "selectAuthenticateTime", "scanAuthenticateTime", "authenticateTime");
        if ("4".equals(authenticateFlag)) {
            if (ObjectUtils.isEmpty((Object)taxPeriod) || ObjectUtils.isEmpty((Object)deductionPurpose)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u9884\u52fe\u9009\u72b6\u6001,\u62b5\u6263\u7528\u9014\u548c\u7a0e\u671f\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DeductionUtils_6", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            if ("2".equals(deductionPurpose) && ObjectUtils.isEmpty((Object)notDeductibleType)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u62b5\u6263\u7528\u9014\u4e3a'\u4e0d\u62b5\u6263'\u65f6\uff0c\u4e0d\u62b5\u6263\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductionUtils_8", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        if ("1".equals(authenticateFlag)) {
            if (ObjectUtils.isEmpty((Object)selectTime) || ObjectUtils.isEmpty((Object)taxPeriod) || ObjectUtils.isEmpty((Object)deductionPurpose)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u5df2\u52fe\u9009\u72b6\u6001,\u62b5\u6263\u7528\u9014\uff0c\u52fe\u9009\u65f6\u95f4\u548c\u7a0e\u671f\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DeductionUtils_7", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            if ("2".equals(deductionPurpose) && ObjectUtils.isEmpty((Object)notDeductibleType)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u62b5\u6263\u7528\u9014\u4e3a'\u4e0d\u62b5\u6263'\u65f6\uff0c\u4e0d\u62b5\u6263\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductionUtils_8", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        if ("2".equals(authenticateFlag) || "3".equals(authenticateFlag)) {
            if (ObjectUtils.isEmpty((Object)selectTime) || ObjectUtils.isEmpty((Object)taxPeriod) || ObjectUtils.isEmpty((Object)deductionPurpose) || ObjectUtils.isEmpty((Object)authenticateTime)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u8ba4\u8bc1\u72b6\u6001,\u62b5\u6263\u7528\u9014\uff0c\u52fe\u9009\u65f6\u95f4\uff0c\u7a0e\u671f\u548c\u8ba4\u8bc1\u65f6\u95f4\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DeductionUtils_9", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            if ("2".equals(deductionPurpose) && ObjectUtils.isEmpty((Object)notDeductibleType)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u62b5\u6263\u7528\u9014\u4e3a'\u4e0d\u62b5\u6263'\u65f6\uff0c\u4e0d\u62b5\u6263\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductionUtils_8", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        if (("1".equals(transportDeduction) || "2".equals(transportDeduction)) && ObjectUtils.isEmpty((Object)taxPeriod)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u4e3a\u9884\u62b5\u6263\u6216\u5df2\u62b5\u6263\u65f6\uff0c\u62b5\u6263\u7a0e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductionUtils_10", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean isAgricItems(String goodsCode) {
        return DeductionUtils.isAgricItems(goodsCode, "0.03");
    }

    public static boolean isAgricItems(String goodsCode, String taxRate) {
        if (StringUtils.isEmpty((CharSequence)goodsCode) || StringUtils.isEmpty((CharSequence)taxRate)) {
            return false;
        }
        if (BigDecimalUtil.transDecimal(taxRate).compareTo(new BigDecimal("0.03")) != 0) {
            return false;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)goodsCode);
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_agric_goodscode", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return object != null;
    }

    public static String convertAgricPrehandleType(String deductibleMode) {
        if (StringUtils.isEmpty((CharSequence)deductibleMode)) {
            return deductibleMode;
        }
        switch (deductibleMode) {
            case "13": {
                return "1";
            }
            case "14": {
                return "2";
            }
            case "15": {
                return "5";
            }
            case "16": {
                return "4";
            }
            case "17": {
                return "3";
            }
        }
        return null;
    }

    static {
        taxRateMap1.put(TRAIN_INVOICE_TYPE, TRAIN_INVOICE_TAXRATE_ONE);
        taxRateMap1.put(AIR_INVOICE_TYPE, AIR_INVOICE_TAXRATE_ONE);
        taxRateMap1.put(TRANSPORT_INVOICE_TYPE, TRANSPORT_INVOICE_TAXRATE_ONE);
        taxRateMap1.put(SHIP_INVOICE_TYPE, SHIP_INVOICE_TAXRATE_ONE);
        taxRateMap2.put(TRAIN_INVOICE_TYPE, TRAIN_INVOICE_TAXRATE_TWO);
        taxRateMap2.put(AIR_INVOICE_TYPE, AIR_INVOICE_TAXRATE_TWO);
        taxRateMap2.put(TRANSPORT_INVOICE_TYPE, TRANSPORT_INVOICE_TAXRATE_TWO);
        taxRateMap2.put(SHIP_INVOICE_TYPE, SHIP_INVOICE_TAXRATE_TWO);
    }
}

