/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.imc.rim.common.utils.DateUtils;

public class DynamicObjectUtil {
    private static final Log log = LogFactory.getLog(DynamicObjectUtil.class);

    public static DynamicObject jsonToDynamicObject(JSONObject json, DynamicObject obj) {
        DataEntityPropertyCollection collect = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : collect) {
            if (property instanceof EntryProp) {
                JSONArray array = json.getJSONArray(property.getName());
                if (array == null || array.isEmpty()) continue;
                DynamicObjectCollection collectEntry = obj.getDynamicObjectCollection(property.getName());
                DynamicObjectType subType = collectEntry.getDynamicObjectType();
                DataEntityPropertyCollection subPropertyCollect = subType.getProperties();
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject subJson = array.getJSONObject(i);
                    DynamicObject subObj = collectEntry.addNew();
                    for (IDataEntityProperty subProperty : subPropertyCollect) {
                        DynamicObjectUtil.setDynamicObjectValue(subProperty, subJson, subObj);
                    }
                }
                continue;
            }
            DynamicObjectUtil.setDynamicObjectValue(property, json, obj);
        }
        return obj;
    }

    public static void setDynamicObjectValue(DynamicObject obj, String objectField, JSONObject json, String jsonValKey) {
        if (json == null || obj == null || json.get((Object)jsonValKey) == null) {
            return;
        }
        try {
            DynamicProperty property = obj.getDynamicObjectType().getProperty(objectField);
            if (property instanceof BasedataProp) {
                obj.set(property.getName(), (Object)json.getLong(jsonValKey));
            } else if (property instanceof DecimalProp) {
                obj.set(property.getName(), (Object)json.getBigDecimal(jsonValKey));
            } else if (property instanceof DateTimeProp) {
                obj.set(property.getName(), (Object)json.getDate(jsonValKey));
            } else {
                obj.set(property.getName(), (Object)json.getString(jsonValKey));
            }
        }
        catch (Exception e) {
            log.info("json\u8f6c\u6362DynamicObject\u62a5\u9519{},{}", (Object)objectField, json.get((Object)jsonValKey));
        }
    }

    private static void setDynamicObjectValue(IDataEntityProperty property, JSONObject json, DynamicObject obj) {
        if (json == null) {
            return;
        }
        try {
            if (property instanceof BasedataProp) {
                obj.set(property.getName(), (Object)json.getLong(property.getName()));
            } else if (property instanceof DecimalProp) {
                obj.set(property.getName(), (Object)json.getBigDecimal(property.getName()));
            } else if (property instanceof DateTimeProp) {
                obj.set(property.getName(), (Object)json.getDate(property.getName()));
            } else {
                obj.set(property.getName(), (Object)json.getString(property.getName()));
            }
        }
        catch (Exception e) {
            log.info("json\u8f6c\u6362DynamicObject\u62a5\u9519{},{}", (Object)property.getName(), json.get((Object)property.getName()));
        }
    }

    public static JSONObject dynamicObject2Json(DynamicObject dynamicObject) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        JSONObject json = new JSONObject();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            json.put(field, dynamicObject.get(field));
        }
        return json;
    }

    public static Map<String, Object> dynamicObject2Map(DynamicObject dynamicObject) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        HashMap map = Maps.newHashMapWithExpectedSize((int)collect.size());
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            map.put(field, dynamicObject.get(field));
        }
        return map;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject obj, boolean id2String) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(obj.getDynamicObjectType().getProperties().size());
        DataEntityPropertyCollection collect = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectCollection collection = obj.getDynamicObjectCollection(field);
                map.put(field, DynamicObjectUtil.dynamicObjectColletction2ListMap(collection, id2String));
                continue;
            }
            Object fieldObj = obj.get(field);
            if (id2String && (property.getPropertyType() == Long.class || property.getPropertyType() == Long.TYPE || fieldObj instanceof Long)) {
                if (fieldObj == null) continue;
                map.put(field, String.valueOf(fieldObj));
                continue;
            }
            if (fieldObj instanceof DynamicObject) {
                Object pkValue = ((DynamicObject)fieldObj).getPkValue();
                map.put(field, id2String ? pkValue.toString() : pkValue);
                continue;
            }
            map.put(field, obj.get(field));
        }
        return map;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject obj) {
        return DynamicObjectUtil.dynamicObjectToMap(obj, false);
    }

    public static List<Map<String, Object>> dynamicObjectslist2ListMap(List<DynamicObject> objs) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.size());
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtil.dynamicObjectToMap(obj, true));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjectColletction2ListMap(DynamicObjectCollection collection) {
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(collection, false);
    }

    public static List<Map<String, Object>> dynamicObjectColletction2ListMap(DynamicObjectCollection collection, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)collection.size());
        for (DynamicObject obj : collection) {
            list.add(DynamicObjectUtil.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjects2ListMap(DynamicObject[] objs, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.length);
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtil.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static long getDynamicObjectLongValue(Object value) {
        try {
            if (value instanceof DynamicObject) {
                return Long.parseLong(((DynamicObject)value).getPkValue().toString());
            }
            return Long.parseLong(value.toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Object getValue(DynamicObject object, String fieldId) {
        try {
            return object.get(fieldId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String fieldToString(Object value) {
        return DynamicObjectUtil.fieldToString(value, null);
    }

    public static String fieldToString(Object value, String format) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Date) {
            if (StringUtils.isEmpty((CharSequence)format)) {
                format = "yyyy-MM-dd";
            }
            return DateUtils.format((Date)value, format);
        }
        if (value instanceof BigDecimal) {
            if (StringUtils.isEmpty((CharSequence)format)) {
                format = "#0.##";
            }
            DecimalFormat decimalFormat = new DecimalFormat(format);
            return decimalFormat.format(value);
        }
        return value.toString();
    }

    public static Object htmlEncode(Object obj) {
        if (obj instanceof String) {
            String input = (String)obj;
            StringBuilder output = new StringBuilder();
            int len = input.length();
            for (int i = 0; i < len; ++i) {
                char ch = input.charAt(i);
                if (ch == '&') {
                    output.append("&amp;");
                    continue;
                }
                if (ch == '<') {
                    output.append("&lt;");
                    continue;
                }
                if (ch == '>') {
                    output.append("&gt;");
                    continue;
                }
                if (ch == '\"') {
                    output.append("&quot;");
                    continue;
                }
                output.append(ch);
            }
            return output.toString();
        }
        return obj;
    }

    public static DynamicObject stringToDynamicObject(String objStr, String entityName) {
        if (objStr == null) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        Object[] objects = DynamicObjectSerializeUtil.deserialize((String)objStr, (DynamicObjectType)type);
        if (objects != null && objects.length > 0) {
            return (DynamicObject)objects[0];
        }
        return null;
    }

    public static DynamicObjectCollection stringToDynamicObjectCollection(String objStr, String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        Object[] objects = DynamicObjectSerializeUtil.deserialize((String)objStr, (DynamicObjectType)type);
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (objects != null && objects.length > 0) {
            for (Object object : objects) {
                result.add((Object)((DynamicObject)object));
            }
        }
        return result;
    }

    public static String dynamicObjectToString(DynamicObject object, String entityName) {
        if (object == null) {
            return null;
        }
        DynamicObjectType type = new DynamicObjectType(entityName);
        return DynamicObjectSerializeUtil.serialize((Object[])new Object[]{object}, (DynamicObjectType)type);
    }

    public static String dynamicObjectCollectionToString(DynamicObjectCollection object, String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return DynamicObjectSerializeUtil.serialize((Object[])object.toArray(new Object[object.size()]), (DynamicObjectType)type);
    }
}

