/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang.StringUtils;

public class FileUploadUtils {
    private static final Log logger = LogFactory.getLog(FileUploadUtils.class);
    private static final String FMT_ATT_PATH = "/%s/%s/%s%s/rim/%s/%s/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadBase64(String storePath, String fileName, String base64) {
        int index = (fileName = fileName.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (index != -1) {
            fileName = fileName.substring(index + 1);
        }
        InputStream stream = null;
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            byte[] bytes1 = Base64.getDecoder().decode(base64);
            stream = new ByteArrayInputStream(bytes1);
            FileItem fileItem = new FileItem(fileName, storePath, stream);
            if (fileService.exists(storePath)) {
                logger.info("delete-file-uploadBase64:{}", (Object)storePath);
                fileService.delete(storePath);
            }
            String path = fileService.upload(fileItem);
            FileUploadUtils.saveBasAttachmentSync(path, fileName, "rim_fpzs_main", "", bytes1.length);
            String string = path;
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + storePath, (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadBytes(String storePath, String fileName, byte[] bytes) {
        int index = (fileName = fileName.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (index != -1) {
            fileName = fileName.substring(index + 1);
        }
        InputStream stream = null;
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            logger.info("\u4e0a\u4f20\u6587\u4ef6:{}\u5927\u5c0f{}", (Object)storePath, (Object)bytes.length);
            stream = new ByteArrayInputStream(bytes);
            FileItem fileItem = new FileItem(fileName, storePath, stream);
            String path = fileService.upload(fileItem);
            FileUploadUtils.saveBasAttachmentSync(path, fileName, "rim_fpzs_main", "", bytes.length);
            String string = path;
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + storePath, (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String upload(String storePath, String fileName, InputStream in) {
        int index = (fileName = fileName.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (index != -1) {
            fileName = fileName.substring(index + 1);
        }
        try {
            int length = in.available();
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            FileItem fileItem = new FileItem(fileName, storePath, in);
            String path = fileService.upload(fileItem);
            FileUploadUtils.saveBasAttachmentSync(path, fileName, "rim_fpzs_main", "", length);
            return path;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + storePath, (Throwable)e);
            return null;
        }
    }

    public static void delete(String fileFullName) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        if (fileService.exists(fileFullName)) {
            logger.info("delete-file-delete:{}", (Object)fileFullName);
            fileService.delete(fileFullName);
        }
    }

    public static String getSHA256FromCache(String url) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (tempFileCache.exists(url)) {
            String fileHash = FileUtils.getSHA256(tempFileCache.getInputStream(url));
            return fileHash;
        }
        return null;
    }

    public static String getSHA256FromAttach(String url) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String fileHash = FileUtils.getSHA256(service.getInputStream(url));
        return fileHash;
    }

    public static void moveToNewPath(String oldFileFullName, String newFileFullName) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream fileInputStream = service.getInputStream(oldFileFullName);){
            String fileName = newFileFullName.substring(newFileFullName.lastIndexOf(47) + 1, newFileFullName.length());
            FileUploadUtils.upload(newFileFullName, fileName, fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (service.exists(oldFileFullName)) {
            logger.info("delete-file-moveToNewPath:{}", (Object)oldFileFullName);
            service.delete(oldFileFullName);
        }
    }

    public static String getSnapshotPathByUploadUrl(String uploadUrl) {
        return FileUploadUtils.getInvoiceDir("inv") + FileUploadUtils.getFileIdByUploadUrl(uploadUrl);
    }

    public static String getFileIdByUploadUrl(String uploadUrl) {
        if (StringUtils.isEmpty((String)uploadUrl)) {
            return UUID.randomUUIDZero();
        }
        return MD5.md5Hex(uploadUrl);
    }

    public static String getInvoiceDir(String type) {
        RequestContext context = RequestContext.get();
        Calendar calendar = Calendar.getInstance();
        String year = String.valueOf(calendar.get(1));
        int tempMonth = calendar.get(2) + 1;
        String month = tempMonth >= 10 ? String.valueOf(tempMonth) : "0" + tempMonth;
        int date = calendar.get(5);
        return String.format(FMT_ATT_PATH, context.getTenantId(), context.getAccountId(), year, month, date, type);
    }

    public static void saveBasAttachmentSync(String path, String fileName, String billtype, String interid, int fileSize) {
        ThreadPools.executeOnceIncludeRequestContext((String)"saveBasAttachmentSync", () -> FileUploadUtils.saveBasAttachment(path, fileName, billtype, interid, fileSize));
    }

    public static void saveBasAttachment(String path, String fileName, String billtype, String interid, int fileSize) {
        try {
            logger.info("\u4fdd\u5b58bos_attachment,{},{}", (Object)path, (Object)fileName);
            QFilter billIdsFilter = new QFilter("ffileid", "=", (Object)path);
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"bos_attachment", (String)"id", (QFilter[])billIdsFilter.toArray());
            DynamicObject dynamicObject = null;
            Date today = new Date();
            if (idObject != null) {
                return;
            }
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            dynamicObject.set("fcreatetime", (Object)today);
            dynamicObject.set("finterid", (Object)UUID.randomUUIDZero());
            if (StringUtils.isEmpty((String)billtype)) {
                billtype = "rim_fpzs_main";
            }
            if (!StringUtils.isEmpty((String)interid)) {
                dynamicObject.set("finterid", (Object)interid);
            }
            dynamicObject.set("fbilltype", (Object)"rim_fpzs_main");
            dynamicObject.set("fmodifytime", (Object)today);
            dynamicObject.set("faliasfilename", (Object)fileName);
            dynamicObject.set("fattachmentname", (Object)fileName);
            dynamicObject.set("fextname", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
            int size = fileSize / 1024;
            if (size > 0) {
                dynamicObject.set("fattachmentsize", (Object)size);
            } else {
                dynamicObject.set("fattachmentsize", (Object)1);
            }
            dynamicObject.set("fcreatemen", (Object)RequestContext.get().getUserId());
            dynamicObject.set("fattachmentpanel", (Object)"attachmentpanel");
            dynamicObject.set("ffileid", (Object)path);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Throwable e) {
            logger.info("\u4fdd\u5b58bos_attachment1\u5931\u8d25:{},{}", (Object)path, (Object)fileName);
        }
    }

    public static String getTempFileUrl(String fileName, InputStream inputStream, int timeout) {
        return FileUploadUtils.getTempFileUrl(fileName, inputStream, timeout, false, null, null);
    }

    public static String getTempFileUrl(String fileName, InputStream inputStream, int timeout, String entityId, String permissionItemId) {
        return FileUploadUtils.getTempFileUrl(fileName, inputStream, timeout, true, entityId, permissionItemId);
    }

    public static String getTempFileUrl(String fileName, InputStream inputStream, int timeout, boolean isPermission, String entityId, String permissionItemId) {
        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inputStream, timeout);
        if (isPermission) {
            PermissionUtils.addTempFilePermission(urls, entityId, permissionItemId, timeout);
        }
        return urls;
    }
}

