/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static Log logger = LogFactory.getLog(HttpUtil.class);
    public static final int connectTimeout = 20000;
    public static final int socketTimeout = 60000;

    public static CloseableHttpClient getConnection(String proxy, boolean redirectsEnabled) {
        return HttpUtil.getConnection(proxy, redirectsEnabled, 20000, 60000);
    }

    public static CloseableHttpClient getConnection(String proxy) {
        return HttpUtil.getConnection(proxy, true, 20000, 60000);
    }

    public static CloseableHttpClient getConnection(String proxy, boolean redirectsEnabled, int connectTime, int readTime) {
        int connectionRequestTimeout = 1200000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTime).setSocketTimeout(readTime).setRedirectsEnabled(redirectsEnabled).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        if (StringUtils.isNotEmpty((CharSequence)proxy)) {
            String[] values = proxy.trim().split(":");
            if (values.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"HttpUtil_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            HttpHost httpHost = new HttpHost(values[0], Integer.parseInt(values[1]));
            httpClientBuilder.setProxy(httpHost);
        }
        try {
            SSLContext sslContexts = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            httpClientBuilder.setSSLContext(sslContexts);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.info("\u521b\u5efahttp\u8fde\u63a5\u5931\u8d25" + e);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String proxy) {
        HttpGet httpGet = HttpUtil.getHttpGet(url);
        CloseableHttpClient httpclient = HttpUtil.getConnection(proxy);
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity resEntity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)resEntity);
                EntityUtils.consume((HttpEntity)resEntity);
                String string = result;
                return string;
            }
            logger.info("doGet:{},{}", (Object)url, (Object)statusCode);
        }
        catch (IOException e) {
            logger.error("Failed to post get.", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            try {
                httpGet.abort();
                httpGet.releaseConnection();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return null;
    }

    public static String doPost(String url, String proxy, Map<String, String> headers, HttpEntity httpEntity, int connectTime, int readTime) throws IOException {
        long start = System.currentTimeMillis();
        CloseableHttpClient client = HttpUtil.getConnection(proxy, true, connectTime, readTime);
        HttpPost post = new HttpPost(url);
        post.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        CloseableHttpResponse response = null;
        String rs = "";
        BufferedReader in = null;
        try {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    post.setHeader(k, v);
                }
            } else {
                post.setHeader("Connection", "close");
            }
            RequestContext request = RequestContext.get();
            if (request != null) {
                post.setHeader("tenantId", request.getTenantId());
                post.setHeader("traceId", request.getTraceId());
            }
            post.setEntity(httpEntity);
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                in = new BufferedReader(new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8.name()));
                StringBuilder sb = new StringBuilder();
                String line = "";
                String NL = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    sb.append(line).append(NL);
                }
                rs = sb.toString();
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (ConnectTimeoutException e) {
            logger.info("\u8bf7\u6c42\u8d85\u65f6\uff0cConnectTimeout:{}ms-{}", (Object)connectTime, (Object)url);
            throw new MsgException("1022", ResManager.loadKDString((String)"\u8bf7\u6c42\u8fde\u63a5\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"HttpUtil_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        catch (SocketTimeoutException e) {
            logger.info("\u8bf7\u6c42\u8d85\u65f6\uff0cSocketTimeout:{}ms-{}", (Object)readTime, (Object)url);
            throw new MsgException("1022", ResManager.loadKDString((String)"\u8bf7\u6c42\u5904\u7406\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"HttpUtil_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("doPost-Exception", (Throwable)e);
            throw new MsgException("1021", ResManager.loadKDString((String)"\u8fde\u63a5\u88ab\u62d2\u7edd", (String)"HttpUtil_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            if (in != null) {
                in.close();
            }
            try {
                post.abort();
                post.releaseConnection();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        logger.info("HttpUtil-doPost:" + url + " proxy:" + proxy + " \u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "\uff0c\u7ed3\u679c\uff1a" + rs);
        return rs;
    }

    public static String doPost(String url, String proxy, Map<String, String> headers, HttpEntity httpEntity) throws IOException {
        return HttpUtil.doPost(url, proxy, headers, httpEntity, 20000, 60000);
    }

    public static String doPostJson(String url, String proxy, Map<String, String> headers, String body, int connectTime, int readTime) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        return HttpUtil.doPost(url, proxy, headers, (HttpEntity)new StringEntity(body, StandardCharsets.UTF_8.name()), connectTime, readTime);
    }

    public static String doPostJson(String url, String proxy, Map<String, String> headers, String body) throws IOException {
        return HttpUtil.doPostJson(url, proxy, headers, body, 20000, 60000);
    }

    public static String postFormData(String url, String proxy, Map<String, String> headers, InputStream inputStream, String fileName, Map<String, Object> bodyMap, int connectionTimeout, int readTimeout) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("postFormData:{}:{},proxy:{}", new Object[]{start, url, proxy});
        Boolean redirectsEnabled = Boolean.TRUE;
        CloseableHttpClient httpclient = HttpUtil.getConnection(proxy, redirectsEnabled, connectionTimeout, readTimeout);
        HttpPost httppost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            RequestContext request;
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((request = RequestContext.get()) != null) {
                httppost.setHeader("tenantId", request.getTenantId());
                httppost.setHeader("traceId", request.getTraceId());
            }
            try {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                if (inputStream != null) {
                    builder.addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA, fileName);
                }
                if (bodyMap != null) {
                    for (Map.Entry<String, Object> entry : bodyMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        if (entry.getValue() instanceof byte[]) {
                            builder.addBinaryBody(entry.getKey(), (byte[])entry.getValue(), ContentType.MULTIPART_FORM_DATA, fileName);
                            continue;
                        }
                        builder.addTextBody(entry.getKey(), (String)entry.getValue());
                    }
                }
                HttpEntity entity = builder.build();
                httppost.setEntity(entity);
                response = (CloseableHttpResponse)httpclient.execute((HttpUriRequest)httppost);
                int statusCode = response.getStatusLine().getStatusCode();
                logger.info("postFormData:{},{},{}ms,statusCode:{},proxy:{}", new Object[]{start, url, System.currentTimeMillis() - start, statusCode, proxy});
                if (statusCode == 200) {
                    HttpEntity resEntity = response.getEntity();
                    String result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = result;
                    return string;
                }
            }
            catch (ConnectTimeoutException e) {
                logger.info("\u8bf7\u6c42\u8d85\u65f6\uff0cConnectTimeout:{}ms-{}", (Object)connectionTimeout, (Object)url);
                throw new MsgException("1022", ResManager.loadKDString((String)"\u8bf7\u6c42\u8fde\u63a5\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"HttpUtil_1", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            catch (SocketTimeoutException e) {
                logger.info("\u8bf7\u6c42\u8d85\u65f6\uff0cSocketTimeout:{}ms-{}", (Object)readTimeout, (Object)url);
                throw new MsgException("1022", ResManager.loadKDString((String)"\u8bf7\u6c42\u5904\u7406\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"HttpUtil_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        catch (MsgException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("postFormData:{} exception:{}-" + e, (Object)start, (Object)url);
            throw new MsgException("1021", ResManager.loadKDString((String)"\u8fde\u63a5\u88ab\u62d2\u7edd", (String)"HttpUtil_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            try {
                httppost.abort();
                httppost.releaseConnection();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static HttpGet getHttpGet(String url) {
        URIBuilder bulider = null;
        HttpGet httpGet = null;
        try {
            bulider = new URIBuilder(url);
            httpGet = new HttpGet(bulider.build());
        }
        catch (URISyntaxException e) {
            throw new MsgException(e, "0009", String.format(ResManager.loadKDString((String)"url\u9519\u8bef:%1$s", (String)"HttpUtil_4", (String)"imc-rim-common", (Object[])new Object[0]), url));
        }
        return httpGet;
    }

    public static String replaceUrl(String fileUrl) {
        String urlReplace = RimConfigUtils.getConfig("url_replace");
        if (StringUtils.isNotEmpty((CharSequence)urlReplace)) {
            try {
                Object obj = JSONObject.parse((String)urlReplace);
                if (obj instanceof List) {
                    JSONArray array = JSONArray.parseArray((String)urlReplace);
                    for (int i = 0; i < array.size(); ++i) {
                        fileUrl = HttpUtil.replaceUrl(fileUrl, array.getJSONObject(i));
                    }
                } else {
                    fileUrl = HttpUtil.replaceUrl(fileUrl, JSONObject.parseObject((String)urlReplace));
                }
            }
            catch (Exception e) {
                logger.error("\u66ff\u6362url\u9519\u8bef{}:{}", (Object)urlReplace, (Object)fileUrl);
            }
        }
        return fileUrl;
    }

    private static String replaceUrl(String fileUrl, JSONObject config) {
        try {
            String replaceTo = config.getString("replaceTo");
            Object beReplaced = config.get((Object)"beReplaced");
            if (beReplaced instanceof List) {
                JSONArray array = config.getJSONArray("beReplaced");
                for (int i = 0; i < array.size(); ++i) {
                    fileUrl = fileUrl.replace(array.getString(i), replaceTo);
                }
            } else if (beReplaced != null) {
                fileUrl = fileUrl.replace(beReplaced.toString(), replaceTo);
            }
        }
        catch (Exception e) {
            logger.error("\u66ff\u6362url\u9519\u8bef{}:{}", (Object)config, (Object)fileUrl);
        }
        return fileUrl;
    }

    public static String getProxy(String url, String proxy) {
        if (!StringUtils.isEmpty((CharSequence)proxy)) {
            return proxy;
        }
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            int port = uri.getPort();
            proxy = HttpUtil.getProxy(domain, port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proxy;
    }

    public static String getProxy(String domain, int port) {
        Map<String, String> proxyMap = ImcConfigUtil.getValue("bdm_http_proxy");
        String proxy = null;
        if (port > 0) {
            proxy = proxyMap.get(domain + ':' + port);
        }
        if (StringUtils.isEmpty(proxy)) {
            proxy = proxyMap.get(domain);
        }
        return proxy;
    }
}

