/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.utils.CacheHelper;

public class ImcConfigUtil {
    private static final String CONFIG_FIELD_TYPE = "config_type";
    private static final String CONFIG_FIELD_KEY = "config_key";
    private static final String CONFIG_FIELD_VALUE = "config_value";
    private static final String CONFIG_FIELDS = "config_type,config_key,config_value";
    private static Log logger = LogFactory.getLog(ImcConfigUtil.class);

    public static void removeCache(String configType) {
        CacheHelper.remove(configType);
    }

    public static Map<String, String> getValue(String configType) {
        String configCache = CacheHelper.get(configType, true);
        if (StringUtils.isNotEmpty((CharSequence)configCache)) {
            HashMap<String, String> map = new HashMap();
            map = (Map)SerializationUtils.fromJsonString((String)configCache, map.getClass());
            return map;
        }
        return ImcConfigUtil.putCache(configType);
    }

    public static String getValue(Map<String, String> config, String configType, String defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        String value = config.get(configType);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public static String getValue(String configType, String configKey) {
        Map<String, String> map = ImcConfigUtil.getValue(configType);
        String val = map.get(configKey);
        if (val != null) {
            return val;
        }
        return map.get(configType + "_" + configKey);
    }

    public static Map<String, String> putCache(String configType) {
        QFilter filter = new QFilter(CONFIG_FIELD_TYPE, "=", (Object)configType);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)CONFIG_FIELDS, (QFilter[])new QFilter[]{filter});
        HashMap<String, String> map = new HashMap<String, String>(collection.length);
        String start = configType + "_";
        for (DynamicObject obj : collection) {
            String type = obj.getString(CONFIG_FIELD_KEY);
            if (type.startsWith(start)) {
                map.put(type.replace(start, ""), obj.getString(CONFIG_FIELD_VALUE));
                continue;
            }
            map.put(type, obj.getString(CONFIG_FIELD_VALUE));
        }
        if (!map.isEmpty()) {
            String cacheStr = SerializationUtils.toJsonString(map);
            CacheHelper.put(configType, cacheStr, 86400);
        } else {
            CacheHelper.put(configType, "{}", 3600);
        }
        return map;
    }
}

