/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.FileUtils;
import org.apache.commons.lang.StringUtils;

public class InvoiceCheckUtils {
    private static final Set<String> SPECIAL_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate"}));
    private static final Set<String> GENERAL_PAPER_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TAXI_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount", "place"}));
    private static final Set<String> TRAIN_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "trainNum", "printingSequenceNo", "invoiceDate", "totalAmount", "stationGetOn", "stationGetOff"}));
    private static final Set<String> AIR_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "electronicTicketNum", "printNum", "invoiceDate", "invoiceAmount", "totalAmount", "otherTotalTaxAmount", "placeOfDeparture", "destination"}));
    private static final Set<String> QUOTA_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "totalAmount", "place"}));
    private static final Set<String> TRANSPORT_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount", "stationGetOn", "stationGetOff"}));
    private static final Set<String> ROAD_BRIDGE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TAX_PROOF_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "buyerTaxNo", "taxPaidProofNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> BOAT_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount", "stationGetOn", "stationGetOff"}));
    private static final Set<String> OTHER_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "totalAmount"}));
    private static final Set<String> HGJKS_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TRAIN_REFUND_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "number", "totalAmount"}));
    private static final Set<String> FINANCIAL_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "totalAmount", "invoiceDate"}));
    private static final Set<String> ELECTRIC_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TAXI_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TRAIN_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "trainNum", "sequenceNo", "invoiceDate", "totalAmount", "passengerName"}));
    private static final Set<String> AIR_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "eticketNo", "printNum", "totalAmount", "invoiceDate", "customerName"}));
    private static final Set<String> QUOTA_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "totalAmount"}));
    private static final Set<String> TRANSPORT_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> ROAD_BRIDGE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> BOAT_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> HGJKS_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "customDeclarationNo", "invoiceDate", "totalTaxAmount"}));
    public static final Set<String> EXPENSE_STATUS_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "30", "60", "65", ""}));
    public static final Set<String> ZERO_FOUR_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"0", "1", "2", "3", "4", ""}));
    public static final Set<String> ONE_FIVE_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5", ""}));
    public static final Set<String> ONE_TWO_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "2", ""}));
    public static final Set<String> ZERO_ONE_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "0", ""}));
    public static final Set<String> ZERO_TWO_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"0", "1", "2", ""}));

    public static ApiResult checkMust(JSONObject invoice, boolean isEdit) {
        return InvoiceCheckUtils.checkMust(invoice, isEdit, true);
    }

    public static ApiResult checkMust(JSONObject invoice, boolean isEdit, boolean needCheckCode) {
        String awsType = invoice.getString("invoiceType");
        if (StringUtils.isBlank((String)awsType)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e3a\u7a7a", (String)"InvoiceCheckUtils_0", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2001");
        }
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsType);
        if (Arrays.asList(InputInvoiceTypeEnum.getVatTypes()).contains(invoiceType) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) {
            ApiResult result;
            InputInvoiceTypeEnum type = InputInvoiceTypeEnum.getInvoiceType(invoiceType);
            if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
                return InvoiceCheckUtils.checkHaveNull(ELECTRIC_INVOICE_MUST, invoice, ResManager.loadKDString((String)"\u6570\u7535\u53d1\u7968", (String)"InvoiceCheckUtils_1", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (needCheckCode && (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType)) && (result = InvoiceCheckUtils.checkHaveNull(Sets.newHashSet((Object[])new String[]{"checkCode"}), invoice, type.getName())) != null) {
                return result;
            }
            if ((InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType)) && (result = InvoiceCheckUtils.checkHaveNull(Sets.newHashSet((Object[])new String[]{"invoiceAmount"}), invoice, type.getName())) != null) {
                return result;
            }
            if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) && (result = InvoiceCheckUtils.checkHaveNull(Sets.newHashSet((Object[])new String[]{"totalAmount"}), invoice, type.getName())) != null) {
                return result;
            }
            return InvoiceCheckUtils.checkHaveNull(SPECIAL_MUST, invoice, ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u53d1\u7968", (String)"InvoiceCheckUtils_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(GENERAL_PAPER_MUST, invoice, InputInvoiceTypeEnum.GENERAL_PAPER.getName());
        }
        if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(TAXI_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TAXI_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(TAXI_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.TAXI_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(TRAIN_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TRAIN_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(TRAIN_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.TRAIN_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(AIR_INVOICE_MUST, invoice, InputInvoiceTypeEnum.AIR_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(AIR_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.AIR_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(QUOTA_INVOICE_MUST, invoice, InputInvoiceTypeEnum.QUOTA_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(QUOTA_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.QUOTA_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(TRANSPORT_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TRANSPORT_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(TRANSPORT_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.TRANSPORT_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(ROAD_BRIDGE_MUST, invoice, InputInvoiceTypeEnum.ROAD_BRIDGE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(ROAD_BRIDGE_MUST_INPUT, invoice, InputInvoiceTypeEnum.ROAD_BRIDGE.getName());
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(TAX_PROOF_MUST, invoice, InputInvoiceTypeEnum.TAX_PROOF.getName());
        }
        if (InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(BOAT_INVOICE_MUST, invoice, InputInvoiceTypeEnum.BOAT_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(BOAT_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.BOAT_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(OTHER_INVOICE_MUST, invoice, InputInvoiceTypeEnum.OTHER_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(HGJKS_INVOICE_MUST, invoice, InputInvoiceTypeEnum.HGJKS.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(HGJKS_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.HGJKS.getName());
        }
        if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(FINANCIAL_INVOICE_MUST, invoice, InputInvoiceTypeEnum.FINANCIAL_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(TRAIN_REFUND_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TRAIN_REFUND.getName());
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u5728\u6807\u51c6\u8303\u56f4", (String)"InvoiceCheckUtils_3", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2002");
    }

    private static ApiResult checkHaveNull(Set<String> fields, JSONObject data, String invoiceTypeName) {
        for (String field : fields) {
            Object value = data.get((Object)field);
            if (Objects.isNull(value)) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%1$s\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%2$s", (String)"InvoiceCheckUtils_4", (String)"imc-rim-common", (Object[])new Object[0]), invoiceTypeName, field), (String)"2001");
            }
            if (!(value instanceof String) || !StringUtils.isBlank((String)((String)value))) continue;
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%1$s\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%2$s", (String)"InvoiceCheckUtils_4", (String)"imc-rim-common", (Object[])new Object[0]), invoiceTypeName, field), (String)"2001");
        }
        return null;
    }

    public static ApiResult checkFieldFormat(JSONObject invoice) {
        String invoiceDate = invoice.getString("invoiceDate");
        if (StringUtils.isNotBlank((String)invoiceDate)) {
            SimpleDateFormat dataFormater = new SimpleDateFormat("yyyy-MM-dd");
            try {
                dataFormater.parse(invoiceDate);
            }
            catch (ParseException e) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"InvoiceCheckUtils_5", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2002");
            }
        }
        try {
            List<String> amountFields = InvoiceCollectField.getAmountField();
            for (String amountField : amountFields) {
                invoice.getBigDecimal(amountField);
            }
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u91d1\u989d\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef", (String)"InvoiceCheckUtils_6", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2002");
        }
        return null;
    }

    public static void enIDNum(DynamicObject invoice) {
    }

    public static void encodeIDNumber(JSONObject invoice, String key, int enlenth) {
        if (invoice == null) {
            return;
        }
        String start = "";
        String end = "";
        String middleOriginal = "";
        String customerIdNo = invoice.getString(key);
        String middle = "";
        if (StringUtils.isNotBlank((String)customerIdNo) && customerIdNo.length() >= 2) {
            if (customerIdNo.length() == 18) {
                if (enlenth == 4) {
                    start = customerIdNo.substring(0, 10);
                    end = customerIdNo.substring(14, 18);
                    middleOriginal = customerIdNo.substring(10, 14);
                    middle = "****";
                } else if (enlenth == 8) {
                    start = customerIdNo.substring(0, 6);
                    end = customerIdNo.substring(14, 18);
                    middleOriginal = customerIdNo.substring(6, 14);
                    middle = "********";
                }
            } else {
                start = customerIdNo.substring(0, customerIdNo.length() - 2);
                middleOriginal = customerIdNo.substring(customerIdNo.length() - 2);
                middle = "**";
            }
            if (!customerIdNo.contains("*")) {
                invoice.put("idNumMiddle", (Object)middleOriginal);
            }
            customerIdNo = start + middle + end;
        }
        invoice.put(key, (Object)customerIdNo);
    }

    public static JSONObject conver(JSONObject source) {
        JSONObject result = new JSONObject();
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(source.getString("invoiceType"));
        result.put("invoice_type", (Object)invoiceType);
        InvoiceCheckUtils.copyValue(source, result, "invoiceIndex", "invoiceIndex");
        InvoiceCheckUtils.copyValue(source, result, "expenseInfo", "expenseInfo");
        InvoiceCheckUtils.copyValue(source, result, "voucherInfo", "voucherInfo");
        InvoiceCheckUtils.copyValue(source, result, "tag", "tag");
        InvoiceCheckUtils.convertExpense(source, result);
        InvoiceCheckUtils.convertVouch(source, result);
        if (Arrays.asList(InputInvoiceTypeEnum.getVatTypes()).contains(invoiceType) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "checkCode", "check_code");
            InvoiceCheckUtils.copyValue(source, result, "invoiceAmount", "invoice_amount");
            InvoiceCheckUtils.copyValue(source, result, "invoiceStatus", "invoice_status");
            InvoiceCheckUtils.copyValue(source, result, "checkStatus", "check_status");
            InvoiceCheckUtils.copyValue(source, result, "specialTypeMark", "special_type_mark");
            InvoiceCheckUtils.convertItems(source, result);
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertTaxAndName(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertInvoiceOffset(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            if (InputInvoiceTypeEnum.isExistEtaxInvoiceNo(invoiceType)) {
                InvoiceCheckUtils.copyValue(source, result, "etaxInvoiceNo", "electronic_no");
            }
        } else if (InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "totalTaxAmount", "total_tax_amount");
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertTaxAndName(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "timeGetOn", "time_get_on");
            InvoiceCheckUtils.copyValue(source, result, "timeGetOff", "time_get_off");
            InvoiceCheckUtils.copyValue(source, result, "mileage", "mileage");
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "trainNum", "train_num");
            InvoiceCheckUtils.copyValue(source, result, "sequenceNo", "sequence_no");
            InvoiceCheckUtils.convertSeatGrade(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertTaxAmount(source, result);
            InvoiceCheckUtils.convertStationAndPassenger(source, result);
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "eticketNo", "eticket_no");
            InvoiceCheckUtils.copyValue(source, result, "printNum", "print_num");
            InvoiceCheckUtils.copyValue(source, result, "customerName", "customer_name");
            InvoiceCheckUtils.copyValue(source, result, "invoiceAmount", "invoice_amount");
            InvoiceCheckUtils.copyValue(source, result, "placeOfDeparture", "place_of_departure");
            InvoiceCheckUtils.copyValue(source, result, "destination", "destination");
            InvoiceCheckUtils.copyValue(source, result, "customerIdNo", "customer_id_no");
            InvoiceCheckUtils.convertAirOther(source, result);
            InvoiceCheckUtils.convertSeatGrade(source, result);
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertTaxAmount(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "invoiceCode", "invoice_code");
            InvoiceCheckUtils.copyValue(source, result, "invoiceNo", "invoice_no");
            InvoiceCheckUtils.copyValue(source, result, "totalAmount", "total_amount");
            InvoiceCheckUtils.copyValue(source, result, "place", "place");
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "customerIdNo", "customer_id_no");
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertTaxAmount(source, result);
            InvoiceCheckUtils.convertStationAndPassenger(source, result);
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "entrance", "entrance");
            InvoiceCheckUtils.copyValue(source, result, "exit", "exit");
            InvoiceCheckUtils.copyValue(source, result, "time", "time");
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "taxPaidProofNo", "tax_paid_proof_no");
            InvoiceCheckUtils.convertBuyerTaxNo(source, result);
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "customDeclarationNo", "custom_declaration_no");
            InvoiceCheckUtils.copyValue(source, result, "deptName", "dept_name");
            InvoiceCheckUtils.copyValue(source, result, "effectiveTaxAmount", "effective_tax_amount");
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertInvoiceOffset(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "invoicingPartyCode", "invoicing_party_code");
            InvoiceCheckUtils.copyValue(source, result, "invoicingPartyName", "invoicing_party_name");
            InvoiceCheckUtils.copyValue(source, result, "payerPartyCode", "payer_party_code");
            InvoiceCheckUtils.copyValue(source, result, "payerPartyName", "payer_party_name");
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceType)) {
            // empty if block
        }
        InvoiceCheckUtils.converFileValue(source, result);
        return result;
    }

    private static void converFileValue(JSONObject source, JSONObject result) {
        String pixel;
        String region;
        String rotationAngle;
        String pdfurl;
        String snapshotUrl = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "snapshotUrl", "imageUrl");
        if (StringUtils.isNotEmpty((String)snapshotUrl)) {
            result.put("snapshot_url", (Object)snapshotUrl);
            result.put("original_type", (Object)"2");
        }
        if (StringUtils.isNotEmpty((String)(pdfurl = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "pdfurl", "pdfUrl")))) {
            result.put("pdf_url", (Object)pdfurl);
            result.put("original_type", (Object)"1");
        }
        String downloadUrl = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "downloadUrl");
        String fileName = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "fileName");
        result.put("original_filename", (Object)fileName);
        String fileType = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "fileType");
        if (StringUtils.isNotEmpty((String)downloadUrl)) {
            if ("4".equals(fileType) || "ofd".equalsIgnoreCase(fileType)) {
                result.put("original_type", (Object)"4");
                result.put("ofd_url", (Object)downloadUrl);
            }
            if ("1".equals(fileType) || "pdf".equalsIgnoreCase(fileType)) {
                result.put("original_type", (Object)"1");
                result.put("pdf_url", (Object)downloadUrl);
            }
            if ("2".equals(fileType) || FileUtils.isImage(fileType)) {
                result.put("original_type", (Object)"2");
                result.put("image_url", (Object)downloadUrl);
                if (StringUtils.isEmpty((String)snapshotUrl)) {
                    result.put("snapshot_url", (Object)snapshotUrl);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(rotationAngle = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "rotationAngle")))) {
            result.put("rotation_angle", (Object)BigDecimalUtil.transDecimal(rotationAngle));
        }
        if (StringUtils.isNotEmpty((String)(region = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "region")))) {
            result.put("region", (Object)region);
        }
        if (StringUtils.isNotEmpty((String)(pixel = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "pixel")))) {
            result.put("pixel", (Object)pixel);
        }
    }

    private static void converHead(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "invoiceCode", "invoice_code");
        InvoiceCheckUtils.copyValue(source, result, "invoiceNo", "invoice_no");
        InvoiceCheckUtils.converDateAndAmount(source, result);
    }

    private static void converDateAndAmount(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "totalAmount", "total_amount");
        InvoiceCheckUtils.copyValue(source, result, "invoiceDate", "invoice_date");
    }

    private static void convertOriginalState(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "originalState", "original_state");
    }

    private static void convertSeatGrade(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "seatGrade", "seat_grade");
    }

    private static void convertTaxAndName(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "salerName", "saler_name");
        InvoiceCheckUtils.copyValue(source, result, "salerTaxNo", "saler_tax_no");
        InvoiceCheckUtils.copyValue(source, result, "buyerName", "buyer_name");
        InvoiceCheckUtils.convertBuyerTaxNo(source, result);
    }

    private static void convertBuyerTaxNo(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "buyerTaxNo", "buyer_tax_no");
    }

    private static void convertOrg(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "resource", "resource");
        InvoiceCheckUtils.copyValue(source, result, "org", "org");
        InvoiceCheckUtils.copyValue(source, result, "tax_org", "tax_org");
    }

    private static void convertAirOther(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "airportConstructionFee", "airport_construction_fee");
        InvoiceCheckUtils.copyValue(source, result, "fuelSurcharge", "fuel_surcharge");
        InvoiceCheckUtils.copyValue(source, result, "insurancePremium", "insurance_premium");
    }

    private static void convertTransportOffset(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "transportDeduction", "transport_deduction");
        InvoiceCheckUtils.copyValue(source, result, "effectiveTaxAmount", "effective_tax_amount");
    }

    private static void convertStationAndPassenger(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "stationGetOn", "station_get_on");
        InvoiceCheckUtils.copyValue(source, result, "stationGetOff", "station_get_off");
        InvoiceCheckUtils.copyValue(source, result, "passengerName", "passenger_name");
    }

    private static void convertInvoiceOffset(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "deductionFlag", "deduction_flag");
        InvoiceCheckUtils.copyValue(source, result, "deductionPurpose", "deduction_purpose");
        InvoiceCheckUtils.copyValue(source, result, "notDeductibleType", "not_deductible_type");
        InvoiceCheckUtils.copyValue(source, result, "authenticateTlag", "authenticate_flag");
        InvoiceCheckUtils.copyValue(source, result, "authenticateFlag", "authenticate_flag");
        InvoiceCheckUtils.copyValue(source, result, "selectTime", "select_time");
        InvoiceCheckUtils.copyValue(source, result, "authenticateTime", "authenticate_time");
        InvoiceCheckUtils.convertTaxAmount(source, result);
    }

    private static void convertTaxAmount(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "totalTaxAmount", "total_tax_amount");
        InvoiceCheckUtils.copyValue(source, result, "taxPeriod", "tax_period");
    }

    private static void convertItems(JSONObject source, JSONObject result) {
        JSONArray oldItems = source.getJSONArray("items");
        JSONArray newItems = new JSONArray();
        result.put("needClear", (Object)Boolean.TRUE);
        if (oldItems != null && !oldItems.isEmpty()) {
            result.put("items", (Object)newItems);
            for (int i = 0; i < oldItems.size(); ++i) {
                JSONObject oldItem = oldItems.getJSONObject(i);
                JSONObject newItem = new JSONObject();
                newItems.add((Object)newItem);
                InvoiceCheckUtils.copyValue(oldItem, newItem, "goodsName", "goods_name");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "specModel", "spec_model");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "unit", "unit");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "num", "num");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "unitPrice", "unit_price");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "detailAmount", "detail_amount");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "taxRate", "tax_rate");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "taxAmount", "tax_amount");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "goodsCode", "goods_code");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "vehPlate", "veh_plate");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "startDate", "start_date");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "endDate", "end_date");
            }
        }
    }

    private static void convertExpense(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "expense_num", "expense_num");
        InvoiceCheckUtils.copyValue(source, result, "expense_status", "expense_status");
    }

    private static void convertVouch(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "account_date", "account_date");
        InvoiceCheckUtils.copyValue(source, result, "vouch_no", "vouch_no");
    }

    private static void copyValue(JSONObject source, JSONObject result, String sourceKey, String resultKey) {
        Object sourceValue = source.get((Object)sourceKey);
        if (!Objects.isNull(sourceValue)) {
            if (sourceValue instanceof String) {
                sourceValue = ((String)sourceValue).trim();
            }
            result.put(resultKey, sourceValue);
        }
    }
}

