/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class InvoiceConfigUtils {
    public static JSONObject getInvoiceConfig(Long invoiceOrgId) {
        String result = InvoiceConfigUtils.get("invoicecloud.configpattern");
        if (result != null && StringUtils.equals((CharSequence)result.trim(), (CharSequence)"2")) {
            return InvoiceConfigUtils.getGroupConfig(invoiceOrgId);
        }
        return InvoiceConfigUtils.getOrgConfig(invoiceOrgId);
    }

    private static String get(String key) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"er_stdconfig", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)key)});
        if (queryOne == null) {
            return null;
        }
        String value = queryOne.getString("value");
        if (value == null || value.trim().equals("")) {
            return null;
        }
        return value;
    }

    public static JSONObject getOrgConfig(Long invoiceOrgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)invoiceOrgId), new QFilter("enable", "=", (Object)true)};
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"er_bd_kdinvoicecloudcfg", (QFilter[])filters);
        if (config == null) {
            return null;
        }
        JSONObject cfg = new JSONObject();
        cfg.put("buyer_tax_no", (Object)Lists.newArrayList((Object[])new String[]{config.getString("taxregnum")}));
        cfg.put("buyer_name", (Object)Lists.newArrayList((Object[])new String[]{config.getString("firmname")}));
        return cfg;
    }

    public static JSONObject getGroupConfig(Long invoiceOrgId) {
        QFilter enableQFilter;
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_bd_kdinvoicecloudcfgct", (Long)invoiceOrgId);
        Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])new QFilter[]{baseDataFilter, enableQFilter = new QFilter("enable", "=", (Object)true)});
        if (configMap == null || configMap.isEmpty()) {
            return null;
        }
        Collection configs = configMap.values();
        JSONObject cfg = new JSONObject();
        List taxRegNums = configs.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("taxregnum"), (CharSequence)"")).collect(Collectors.toList());
        List firmnames = configs.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("firmname"), (CharSequence)"")).collect(Collectors.toList());
        cfg.put("buyer_tax_no", taxRegNums);
        cfg.put("buyer_name", firmnames);
        return cfg;
    }

    public static boolean isZhCn() {
        Lang current = RequestContext.get().getLang();
        return Lang.zh_CN.name().equals(current.name()) || Lang.zh_TW.name().equals(current.name());
    }

    public static boolean showInvoiceInfo() {
        return true;
    }
}

