/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceConvertUtils {
    public static String checkInvoiceType(String invoiceCode, String invoiceNo) {
        if (StringUtils.isNotEmpty((String)invoiceCode) && StringUtils.isNotEmpty((String)invoiceNo)) {
            if (invoiceCode.length() == 12) {
                String lastTwoStr = invoiceCode.substring(invoiceCode.length() - 2);
                String firstStr = invoiceCode.substring(0, 1);
                String sixthStr = invoiceCode.substring(5, 6);
                String eighthStr = invoiceCode.substring(7, 8);
                if (InvoiceConvertUtils.isBlockChainType(invoiceCode, invoiceNo) || InvoiceConvertUtils.isYunNanBlockchain(invoiceCode, invoiceNo)) {
                    return "1";
                }
                if (firstStr.equals("0") && lastTwoStr.equals("12")) {
                    return "15";
                }
                if (firstStr.equals("0") && lastTwoStr.equals("11")) {
                    return "1";
                }
                if (firstStr.equals("0") && lastTwoStr.equals("06")) {
                    return "5";
                }
                if (firstStr.equals("0") && lastTwoStr.equals("07")) {
                    return "5";
                }
                if (firstStr.equals("0") && lastTwoStr.equals("17")) {
                    return "13";
                }
                if ((sixthStr.equals("1") || sixthStr.equals("2")) && eighthStr.equals("2")) {
                    return "12";
                }
                if (firstStr.equals("0") && lastTwoStr.equals("13")) {
                    return "2";
                }
            } else if (invoiceCode.length() == 10) {
                String endStr = invoiceCode.substring(invoiceCode.length() - 3);
                if (endStr.equals("130") || endStr.equals("140") || endStr.equals("160") || endStr.equals("170")) {
                    return "4";
                }
                return "3";
            }
        } else if (StringUtils.isEmpty((String)invoiceCode) && StringUtils.isNotEmpty((String)invoiceNo) && invoiceNo.length() == 20) {
            return "26";
        }
        return "3";
    }

    public static String changeCurrency(String originalCurrency) {
        String resultCurrency = "";
        resultCurrency = StringUtils.isEmpty((String)originalCurrency) ? "RMB" : ("CNY".equals(originalCurrency) ? "RMB" : ("HKD".equals(originalCurrency) ? "HKD" : ("USD".equals(originalCurrency) ? "USD" : originalCurrency)));
        return resultCurrency;
    }

    public static boolean isVatInvoiceType(Long invoiceType) {
        return null != invoiceType && (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType);
    }

    public static boolean isEleInvoiceType(Long invoiceType) {
        return null != invoiceType && (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType));
    }

    public static boolean isInvoiceAmountInvoiceType(Long invoiceType) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType);
    }

    public static boolean isCompanySealInvoice(Long invoiceType) {
        String sealType = RimConfigUtils.getConfig("rim_verify", "sealvatonly");
        if ("1".equals(sealType)) {
            return InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType);
        }
        return InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType);
    }

    public static boolean isVatInvoiceTypeForAws(String invoiceType) {
        return StringUtils.isNotEmpty((String)invoiceType) && ("1".equals(invoiceType) || "2".equals(invoiceType) || "3".equals(invoiceType) || "4".equals(invoiceType) || "5".equals(invoiceType) || "12".equals(invoiceType) || "13".equals(invoiceType) || "15".equals(invoiceType));
    }

    public static boolean isBlockChainType(String invoiceCode, String invoiceNo) {
        return StringUtils.isNotEmpty((String)invoiceCode) && StringUtils.isNotEmpty((String)invoiceNo) && invoiceCode.length() == 12 && invoiceNo.length() == 8 && "14403".equals(invoiceCode.substring(0, 5)) && "9".equals(invoiceCode.substring(8, 9));
    }

    public static boolean isYunNanBlockchain(String invoiceCode, String invoiceNo) {
        if (StringUtils.isEmpty((String)invoiceCode) || StringUtils.isEmpty((String)invoiceNo)) {
            return false;
        }
        if (invoiceCode.length() != 12 || invoiceNo.length() != 8) {
            return false;
        }
        return "5300".equals(invoiceCode.substring(1, 5)) && ("09".equals(invoiceCode.substring(7, 9)) || "19".equals(invoiceCode.substring(7, 9)));
    }

    public static int compareFilePriority(String fileType1, String fileType2) {
        if (StringUtils.isNotEmpty((String)fileType1)) {
            if (fileType1.equals(fileType2)) {
                return 0;
            }
            if (fileType1.equals("4")) {
                return 1;
            }
            Integer fileTypePre = Integer.parseInt(fileType1);
            Integer fileTypeNext = Integer.parseInt(fileType2);
            if (fileTypePre > fileTypeNext) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public static boolean checkRoadBridgeMustInput(JSONObject invoice) {
        return InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoice.getLong("invoiceType")) && StringUtils.isEmpty((String)invoice.getString("invoiceCode")) && StringUtils.isEmpty((String)invoice.getString("exit"));
    }

    public static Pair<Boolean, String> checkShowItems(JSONObject invoice) {
        boolean showItems = false;
        String showType = "0";
        if (invoice != null) {
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
            String originalState = invoice.getString("originalState");
            JSONArray items = invoice.getJSONArray("items");
            if (!CollectionUtils.isEmpty((Collection)items) && items.size() > 8) {
                showItems = true;
                if (InvoiceConvertUtils.checkOriginalState(invoiceType, invoice.getString("invoiceCode"), invoice.getString("invoiceNo")) && "1".equals(originalState)) {
                    showType = "1";
                }
            }
        }
        return Pair.of((Object)showItems, (Object)showType);
    }

    public static boolean checkOriginalState(Long invoiceType, String invoiceCode, String invoiceNo) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) && !InvoiceConvertUtils.isBlockChainType(invoiceCode, invoiceNo) && !InvoiceConvertUtils.isYunNanBlockchain(invoiceCode, invoiceNo) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType);
    }

    public static boolean isValidVatInvoiceCode(Long invoiceType, String invoiceCode) {
        int length;
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            return true;
        }
        return StringUtils.isNotEmpty((String)invoiceCode) && ((length = invoiceCode.length()) == 10 || length == 12);
    }

    public static boolean isSaleListInvoiceType(Long invoiceType) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType);
    }

    public static String getInvoiceCodeAndNo(String invoiceCode, String invoiceNo, String spitChar) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)invoiceCode)) {
            sb.append(invoiceCode);
        }
        if (!StringUtils.isEmpty((String)invoiceNo)) {
            if (sb.length() > 0) {
                sb.append(spitChar);
            }
            sb.append(invoiceNo);
        }
        return sb.toString();
    }

    public static String extractRemarkInvoiceCodeAndNo(String text, String keyword) {
        try {
            Pattern pattern = Pattern.compile("(?<=" + Pattern.quote(keyword) + "):\\s*\\d+");
            Matcher matcher = pattern.matcher(text);
            Pattern pattern1 = Pattern.compile("(?<=" + Pattern.quote(keyword) + ")\\s*\\d+");
            Matcher matcher1 = pattern1.matcher(text);
            if (matcher.find()) {
                return matcher.group(0).replaceAll("[^\\d]", "");
            }
            if (matcher1.find()) {
                return matcher1.group(0).replaceAll("[^\\d]", "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

