/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.SpecialTypeMarkEnum;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;

public class LqConvertUtil {
    private static Log LOGGER = LogFactory.getLog(LqConvertUtil.class);
    public static final String SERVICE_NAME_COLLECT = "InvoiceCollectionService";
    public static final String SERVICE_NAME_DEDUCT = "DeductApiService";

    public static String getInvoiceStatus(String fpzt, String hzsdbs) {
        if ("Y".equals(hzsdbs) || "02".equals(hzsdbs)) {
            return "6";
        }
        return fpzt;
    }

    public static String getDeductionPurpose(String fpyt) {
        if ("1".equals(fpyt)) {
            return "1";
        }
        if ("2".equals(fpyt)) {
            return "3";
        }
        if ("4".equals(fpyt) || "6".equals(fpyt)) {
            return "2";
        }
        return null;
    }

    public static JSONObject convertInvoiceMainInfo(JSONObject invoice, String invoiceType) {
        JSONObject newInvoice = new JSONObject();
        if (!ObjectUtils.isEmpty((Object)invoice)) {
            newInvoice.put("invoiceType", (Object)invoiceType);
            String invoiceDate = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "kprq", "tfrq");
            String gfsbh = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "gfsbh", "jkdwrnsrsbh");
            if (StringUtils.isNotEmpty((CharSequence)invoiceDate) && invoiceDate.indexOf(46) != -1) {
                invoiceDate = invoiceDate.substring(0, invoiceDate.indexOf(46));
            }
            if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getAwsType().equals(invoiceType)) {
                newInvoice.put("invoiceCode", (Object)"");
                newInvoice.put("invoiceNo", (Object)invoice.getString("fphm"));
            } else if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
                String customDeclarationNo = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "hgjkshm", "fphm");
                newInvoice.put("invoiceNo", (Object)customDeclarationNo);
                newInvoice.put("customDeclarationNo", (Object)customDeclarationNo);
                newInvoice.put("buyerTaxNo", (Object)invoice.getString("jkdwrnsrsbh"));
            } else if (InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType)) {
                newInvoice.put("invoiceNo", (Object)invoice.getString("dkdjwspzh"));
                newInvoice.put("buyerTaxNo", (Object)invoice.getString("kjywrsbh"));
                newInvoice.put("invoiceCode", (Object)invoice.getString("bkjnsrsbh"));
                newInvoice.put("salerTaxNo", (Object)invoice.getString("bkjnsrsbh"));
            } else {
                String invoiceCode = Optional.ofNullable(invoice.getString("zzfpDm")).orElseGet(() -> invoice.getString("fpdm"));
                String invoiceNo = Optional.ofNullable(invoice.getString("zzfphm")).orElseGet(() -> invoice.getString("fphm"));
                if ("85".equals(invoiceType)) {
                    newInvoice.put("etaxInvoiceNo", (Object)invoice.getString("fphm"));
                    newInvoice.put("invoiceType", (Object)InputInvoiceTypeEnum.SPECIAL_PAPER.getAwsType());
                } else if ("86".equals(invoiceType)) {
                    newInvoice.put("etaxInvoiceNo", (Object)invoice.getString("fphm"));
                    newInvoice.put("invoiceType", (Object)InputInvoiceTypeEnum.ORDINARY_PAPER.getAwsType());
                } else if ("87".equals(invoiceType)) {
                    newInvoice.put("etaxInvoiceNo", (Object)invoice.getString("fphm"));
                    newInvoice.put("invoiceType", (Object)InputInvoiceTypeEnum.MOTOR_INVOICE.getAwsType());
                } else {
                    newInvoice.put("invoiceCode", (Object)invoiceCode);
                    newInvoice.put("invoiceNo", (Object)invoiceNo);
                }
            }
            if (InvoiceDownloadConstant.isElectricPaper(invoiceType)) {
                newInvoice.put("invoiceCode", (Object)invoice.getString("zzfpDm"));
                newInvoice.put("invoiceNo", (Object)invoice.getString("zzfphm"));
                if (StringUtils.isEmpty((CharSequence)newInvoice.getString("invoiceNo"))) {
                    newInvoice.put("invoiceNo", (Object)newInvoice.getString("etaxInvoiceNo"));
                }
            }
            newInvoice.put("buyerTaxNo", (Object)gfsbh);
            newInvoice.put("invoiceDate", (Object)invoiceDate);
            String invoiceStatus = LqConvertUtil.getInvoiceStatus(invoice.getString("fpzt"), invoice.getString("hzsdbs"));
            newInvoice.put("invoiceStatus", (Object)invoiceStatus);
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("yxdkse"))) {
                newInvoice.put("effectiveTaxAmount", invoice.get((Object)"yxdkse"));
            }
            if (newInvoice.get((Object)"invoiceDate") != null) {
                newInvoice.put("invoiceDate", (Object)DateUtils.format(newInvoice.getDate("invoiceDate"), "yyyy-MM-dd HH:mm:ss"));
            }
            newInvoice.put("invoiceRiskLevel", (Object)LqConvertUtil.getRiskLevel(invoice.getString("ycpzzt")));
        }
        return newInvoice;
    }

    public static String getRiskLevel(String ycpzzt) {
        if (StringUtils.isEmpty((CharSequence)ycpzzt)) {
            return "";
        }
        switch (ycpzzt) {
            case "01": {
                return "\u6b63\u5e38";
            }
            case "02": {
                return "\u5f02\u5e38\u51ed\u8bc1";
            }
            case "03": {
                return "\u7591\u70b9\u53d1\u7968";
            }
        }
        return "";
    }

    public static JSONObject invokeService(JSONObject param) {
        return LqConvertUtil.invokeService(param, SERVICE_NAME_COLLECT);
    }

    public static JSONObject invokeService(JSONObject param, String serviceName) {
        LOGGER.info("\u8bf7\u6c42\u4e50\u4f01\u63a5\u53e3\u53c2\u6570:{}-{}", (Object)serviceName, (Object)param);
        String unitTestResult = CommonUtils.getUnitTestResult("Lq-", param.getString("api_type"));
        if (StringUtils.isNotEmpty((CharSequence)unitTestResult)) {
            JSONObject result = JSONObject.parseObject((String)unitTestResult);
            JSONObject data = result.getJSONObject("data");
            if (data == null) {
                data = new JSONObject();
            }
            String lsh = UUID.randomUUID();
            data.put("lsh", (Object)lsh);
            data.put("pclsh", (Object)lsh);
            result.put("data", (Object)data);
            return result;
        }
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)serviceName, (String)"send", (Object[])new Object[]{param});
    }

    public static String converSpecialTypeMark(String specialTypeMark, String invoiceType) {
        if (StringUtils.isEmpty((CharSequence)specialTypeMark)) {
            return specialTypeMark;
        }
        if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getAwsType().equals(invoiceType) || InvoiceDownloadConstant.isElectricPaper(invoiceType)) {
            ErrorCode errorCode = CommonUtils.getCustomErrorCode("lq_special_type_mark", "ele_" + specialTypeMark);
            if (errorCode != null) {
                return errorCode.getCode();
            }
            switch (specialTypeMark) {
                case "01": {
                    return SpecialTypeMarkEnum.REFINED_OIL.getCode();
                }
                case "02": {
                    return SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS_PURCHASE.getCode();
                }
                case "03": {
                    return SpecialTypeMarkEnum.CONSTRUCTION_SERVICE.getCode();
                }
                case "04": {
                    return SpecialTypeMarkEnum.FREIGHT_SERVICE.getCode();
                }
                case "05": {
                    return SpecialTypeMarkEnum.REAL_ESTATE_SALES_SERVICE.getCode();
                }
                case "06": {
                    return SpecialTypeMarkEnum.REAL_ESTATE_MANAGEMENT_LEASING_SERVICE.getCode();
                }
                case "07": {
                    return SpecialTypeMarkEnum.VEHICLE_AND_VESSEL_TAX_COLLECTION.getCode();
                }
                case "08": {
                    return SpecialTypeMarkEnum.TOLL_FEE.getCode();
                }
                case "09": {
                    return SpecialTypeMarkEnum.PASSENGER_TRANSPORTATION_SERVICE.getCode();
                }
                case "10": {
                    return SpecialTypeMarkEnum.INPATIENT_MEDICAL_SERVICE.getCode();
                }
                case "11": {
                    return SpecialTypeMarkEnum.OUTPATIENT_MEDICAL_SERVICE.getCode();
                }
                case "13": {
                    return SpecialTypeMarkEnum.TRACTOR_AND_COMBINE_HARVESTER.getCode();
                }
                case "15": 
                case "31": {
                    return SpecialTypeMarkEnum.USERED_CAR.getCode();
                }
                case "20": {
                    return SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS.getCode();
                }
            }
        } else {
            ErrorCode errorCode = CommonUtils.getCustomErrorCode("lq_special_type_mark", "paper_" + specialTypeMark);
            if (errorCode != null) {
                return errorCode.getCode();
            }
            switch (specialTypeMark) {
                case "02": {
                    return SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS_PURCHASE.getCode();
                }
                case "03": {
                    return SpecialTypeMarkEnum.RARE_EARTH_MINERAL_PRODUCTS.getCode();
                }
                case "04": {
                    return SpecialTypeMarkEnum.RARE_EARTH_PRODUCTS.getCode();
                }
                case "05": {
                    return SpecialTypeMarkEnum.NAPHTHA.getCode();
                }
                case "08": {
                    return SpecialTypeMarkEnum.REFINED_OIL.getCode();
                }
            }
        }
        return "";
    }

    public static JSONArray getPeriodInvoices(Long invoiceType, JSONObject data) {
        if (data == null) {
            return new JSONArray();
        }
        JSONArray invoices = InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) ? CommonUtils.getJsonValue((Map<String, Object>)data, JSONArray.class, "hgjksgxcljgmx", "jkshm") : (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) ? data.getJSONArray("dkdjmx") : data.getJSONArray("fpmx"));
        return invoices != null ? invoices : new JSONArray();
    }

    public static JSONArray convertPeriodInvoice(JSONArray items, Long invoiceType) {
        JSONArray invoices = new JSONArray();
        if (CollectionUtils.isEmpty((Collection)items)) {
            return invoices;
        }
        for (int i = 0; i < items.size(); ++i) {
            String skssq;
            JSONObject json = items.getJSONObject(i);
            JSONObject invoice = new JSONObject();
            String fplx = json.getString("fplx");
            invoice.put("invoiceDate", (Object)json.getString("kprq"));
            invoice.put("invoiceCode", (Object)json.getString("fpdm"));
            invoice.put("invoiceNo", (Object)json.getString("fphm"));
            if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                invoice.put("invoiceNo", (Object)json.getString("jkshm"));
                invoice.put("customDeclarationNo", (Object)json.getString("jkshm"));
                invoice.put("invoiceDate", (Object)json.getString("tfrq"));
                invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
            } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
                invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.WITHHOLDING.getAwsType());
                invoice.put("invoiceNo", (Object)json.getString("dkdjwspzh"));
                invoice.put("invoiceDate", (Object)json.getString("tfrq"));
                invoice.put("invoiceCode", (Object)json.getString("bkjnsrsbh"));
                invoice.put("salerTaxNo", (Object)json.getString("bkjnsrsbh"));
            } else {
                String invoiceTypeAws;
                if ("85".equals(fplx)) {
                    invoiceTypeAws = InputInvoiceTypeEnum.SPECIAL_PAPER.getAwsType();
                    LqConvertUtil.handleElectricPaper(invoice);
                } else if ("87".equals(fplx)) {
                    invoiceTypeAws = InputInvoiceTypeEnum.MOTOR_INVOICE.getAwsType();
                    LqConvertUtil.handleElectricPaper(invoice);
                } else {
                    invoiceTypeAws = InputInvoiceTypeEnum.getAwsTypeByLqType(fplx);
                    invoice.put("etaxInvoiceNo", (Object)invoice.getString("fphm"));
                    invoice.remove((Object)"invoiceCode");
                    invoice.remove((Object)"invoiceNo");
                }
                invoice.put("invoiceType", (Object)invoiceTypeAws);
            }
            invoice.put("taxPeriod", (Object)json.getString("skssq"));
            invoice.put("selectTime", (Object)json.getString("gxsj"));
            String fpzt = json.getString("fpzt");
            if ("8".equals(fpzt)) {
                fpzt = "3";
            }
            invoice.put("invoiceStatus", (Object)fpzt);
            String sdzt = json.getString("sdzt");
            if ("02".equals(sdzt)) {
                invoice.put("invoiceStatus", (Object)"6");
            }
            invoice.put("authenticateFlag", (Object)"0");
            String hxyt = json.getString("hxyt");
            if ("4".equals(hxyt) || "6".equals(hxyt)) {
                invoice.put("deductionPurpose", (Object)"2");
                if ("4".equals(hxyt)) {
                    invoice.put("authenticateFlag", (Object)"2");
                } else {
                    invoice.put("authenticateFlag", (Object)"1");
                }
            } else if ("1".equals(hxyt)) {
                invoice.put("deductionPurpose", (Object)hxyt);
                invoice.put("authenticateFlag", (Object)"1");
            }
            String gxsj = json.getString("gxsj");
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)gxsj)) {
                invoice.put("selectTime", (Object)DateUtils.format(json.getDate("gxsj")));
            }
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)(skssq = json.getString("skssq")))) {
                invoice.put("taxPeriod", (Object)skssq);
            }
            if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
                invoice.remove((Object)"invoiceStatus");
            }
            invoices.add((Object)invoice);
        }
        return invoices;
    }

    private static void handleElectricPaper(JSONObject invoice) {
        if (invoice == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)invoice.getString("invoiceCode"))) {
            invoice.put("etaxInvoiceNo", (Object)invoice.getString("invoiceNo"));
            invoice.remove((Object)"invoiceCode");
            invoice.remove((Object)"invoiceNo");
        }
    }
}

