/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.StringUtils;

public class PollAwsFpyService {
    private static Log logger = LogFactory.getLog(PollAwsFpyService.class);
    private static int timeout = 600;

    public void receive(JSONObject config, String fpzsPageId, String linkKey) {
        ThreadPools.executeOnceIncludeRequestContext((String)"PollAwsFpyService-receive", () -> {
            String timeCache = "PollAwsTime" + fpzsPageId;
            CacheHelper.put(timeCache, String.valueOf(System.currentTimeMillis()), timeout);
            try (DLock lock = DLock.create((String)("PollAws-" + fpzsPageId));){
                if (lock.tryLock()) {
                    RequestContext req = RequestContext.get();
                    String system = config.getString("client_id");
                    if (req != null) {
                        system = req.getTenantId();
                    }
                    AwsFpyService service = AwsFpyService.newInstance();
                    String token = null;
                    try {
                        token = service.getAccessToken(config.getString("client_id"), config.getString("client_secret"));
                    }
                    catch (IOException e) {
                        logger.error("PollAwsFpyService-token", (Throwable)e);
                        if (lock != null) {
                            if (var5_5 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable) {
                                    var5_5.addSuppressed(throwable);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        return;
                    }
                    if (token == null) {
                        logger.info("PollAwsFpyService-\u83b7\u53d6token\u5931\u8d25");
                        return;
                    }
                    String pollUrl = service.getUrl("msg_polling", token) + "&key=" + linkKey + "&ten=" + system;
                    String receiptUrl = service.getUrl("msg_receipt", token) + "&key=" + linkKey;
                    logger.info("PollAwsFpyService-pollUrl:{}", (Object)pollUrl);
                    while (true) {
                        String time;
                        if (StringUtils.isEmpty((CharSequence)(time = CacheHelper.get(timeCache)))) {
                            logger.info("PollAwsFpyService-{}\u8d85\u65f6{}", (Object)linkKey, (Object)fpzsPageId);
                            return;
                        }
                        IFormView formView = SessionManager.getCurrent().getView(fpzsPageId);
                        if (null == formView) {
                            CacheHelper.remove(timeCache);
                            logger.info("PollAwsFpyService-{}\u9875\u9762\u5df2\u7ecf\u5173\u95ed:{}", (Object)linkKey, (Object)fpzsPageId);
                            return;
                        }
                        String result = HttpUtil.doGet(pollUrl, service.getProxy());
                        if (result == null) {
                            logger.info("PollAwsFpyService-{}\u8fde\u63a5\u5931\u8d25:{}", (Object)linkKey, (Object)fpzsPageId);
                            return;
                        }
                        if (StringUtils.isEmpty((CharSequence)result)) continue;
                        logger.info("PollAwsFpyService-{},getResult:{}", (Object)linkKey, (Object)result);
                        JSONObject resultObj = JSONObject.parseObject((String)result);
                        if (!ResultContant.isSuccess(resultObj).booleanValue()) continue;
                        try {
                            boolean disableSocket = "0".equals(RimConfigUtils.getConfig("rim_fpzs", "enablesocket"));
                            if (disableSocket) {
                                CacheHelper.put(linkKey, resultObj.getJSONObject("data").getString("data"), 120);
                            } else {
                                MsgSendFactory.getSender().send(linkKey, resultObj.getJSONObject("data").getString("data"));
                            }
                            String recip = HttpUtil.doGet(receiptUrl, service.getProxy());
                            logger.info("PollAwsFpyService-{},receipResult:{},disableSocket:{}", new Object[]{linkKey, recip, disableSocket});
                        }
                        catch (Exception exception) {}
                    }
                }
                logger.info("PollAwsFpyService-{}-{}\u957f\u8f6e\u8be2\u5904\u7406\u4e2d", (Object)linkKey);
            }
        });
    }
}

