/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import kd.imc.rim.common.message.exception.MsgException;

public abstract class RimRetryTemplate {
    private static final int DEFAULT_RETRY_TIME = 1;
    private int retryTime = 1;
    private int sleepTime = 0;

    public int getSleepTime() {
        return this.sleepTime;
    }

    public RimRetryTemplate setSleepTime(int sleepTime) {
        if (sleepTime < 0) {
            throw new IllegalArgumentException("sleepTime should equal or bigger than 0");
        }
        this.sleepTime = sleepTime;
        return this;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public RimRetryTemplate setRetryTime(int retryTime) {
        if (retryTime <= 0) {
            throw new IllegalArgumentException("retryTime should bigger than 0");
        }
        this.retryTime = retryTime;
        return this;
    }

    protected abstract JSONObject doBiz(int var1) throws Exception;

    public JSONObject execute() throws InterruptedException {
        for (int i = 0; i < this.retryTime; ++i) {
            try {
                return this.doBiz(i + 1);
            }
            catch (MsgException e) {
                throw e;
            }
            catch (Exception e) {
                Thread.sleep(this.sleepTime);
                continue;
            }
        }
        return null;
    }
}

