/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RandomSingleton;

public class UUID {
    private static final int AISNO_BATCH_LENGTH = 32;
    private static final int ID_LENGTH = 19;
    private static final char[] symbols;

    public static synchronized String next() {
        return UUID.randomUUID();
    }

    public static synchronized String randomUUID() {
        String uuid = java.util.UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        return uuid.toLowerCase();
    }

    public static synchronized String randomUUIDZero() {
        String uuid = java.util.UUID.randomUUID().toString();
        uuid = uuid.replace("-", "") + "0";
        return uuid;
    }

    public static String getBatchNumber() {
        String batchNumber;
        String lockKey = "batchNumberlock" + RequestContext.get().getOrgId();
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(150000L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7f16\u53f7", (String)"UUID_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            batchNumber = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        }
        return batchNumber;
    }

    public static String getBatchNo() {
        return UUID.getBatchNo("rim");
    }

    public static String getBatchNo(String prefix) {
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            prefix = "rim";
        }
        String batchNo = UUID.randomUUID();
        try {
            long longId = ID.genLongId();
            Date createTime = ID.getCreateTime((long)longId);
            StringBuilder sbr = new StringBuilder();
            batchNo = sbr.append(prefix).append('-').append(DateUtils.format(createTime, "yyyyMMdd")).append('-').append(longId).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return batchNo;
    }

    public static String getBatchNoByTaxNo(String taxNo) {
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            taxNo = "";
        }
        int length = 32 - taxNo.length();
        String batchNo = taxNo + UUID.getRandomNum(length);
        if (batchNo.length() < 32) {
            batchNo = batchNo + UUID.getRandomNum(32 - batchNo.length());
        }
        return batchNo;
    }

    public static String getBatchNoForAisino(String taxNo) {
        String randomNum = UUID.getRandom(8);
        return taxNo + randomNum + DateUtils.format(new Date(), "yyyyMMddHHmmssSSS");
    }

    public static String getRandomNum(int length) {
        StringBuilder result = new StringBuilder();
        int count = length % 19 == 0 ? length / 19 : length / 19 + 1;
        for (int i = 0; i < count; ++i) {
            result.append(ID.genLongId());
        }
        String randomNum = result.toString();
        if (randomNum.length() > length) {
            randomNum = randomNum.substring(randomNum.length() - length);
        }
        return randomNum;
    }

    public static String getNumber(String numberPre, String cacheKey, String entityId) {
        return UUID.getNumber(numberPre, cacheKey, entityId, "number");
    }

    public static String getReqid() {
        StringBuilder builder = new StringBuilder();
        builder.append(RequestContext.get().getTraceId()).append('-').append(UUID.getRandomString(6, false, false));
        return builder.toString();
    }

    public static String getNumber(String numberPre, String cacheKey, String entityId, String numberKey) {
        String cacheNumber = CacheHelper.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheNumber) && cacheNumber.contains(numberPre)) {
            cacheNumber = cacheNumber.replace(numberPre, "");
        }
        if (StringUtils.isBlank((CharSequence)cacheNumber)) {
            DynamicObject[] dyObjArr = BusinessDataServiceHelper.load((String)entityId, (String)numberKey, (QFilter[])new QFilter[]{new QFilter(numberKey, "like", (Object)(numberPre + "%"))});
            Integer numberMax = 1;
            Optional<Integer> optional = Arrays.stream(dyObjArr).map(v -> v.getString(numberKey).replace(numberPre, "")).filter(v -> Pattern.matches("^[0-9]+$", v)).map(v -> Integer.parseInt(v)).max((v, u) -> v.compareTo((Integer)u));
            if (optional.isPresent()) {
                numberMax = optional.get();
            }
            cacheNumber = numberMax.toString();
        }
        if (cacheNumber != null && Pattern.matches("^[0-9]+$", cacheNumber)) {
            Integer numberMax = Integer.parseInt(cacheNumber) + 1;
            cacheNumber = numberMax.toString();
        } else {
            cacheNumber = "0001";
        }
        while (cacheNumber.length() < 4) {
            cacheNumber = "0" + cacheNumber;
        }
        cacheNumber = numberPre + cacheNumber;
        CacheHelper.put(cacheKey, cacheNumber);
        return cacheNumber;
    }

    public static String getRandomString(int length, boolean onlyNum, boolean noStartWithZero) {
        if (length < 1) {
            throw new IllegalArgumentException("length < 1: " + length);
        }
        SecureRandom random = RandomSingleton.getInstance();
        char[] buf = new char[length];
        int l = symbols.length;
        if (onlyNum) {
            l = 10;
        }
        int index = random.nextInt(l);
        if (noStartWithZero) {
            index = random.nextInt(l - 1) + 1;
        }
        buf[0] = symbols[index];
        for (int idx = 1; idx < buf.length; ++idx) {
            buf[idx] = symbols[random.nextInt(l)];
        }
        return new String(buf);
    }

    public static String getRandom(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length < 1: " + length);
        }
        SecureRandom random = RandomSingleton.getInstance();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    static {
        int idx;
        symbols = new char[36];
        for (idx = 0; idx < 10; ++idx) {
            UUID.symbols[idx] = (char)(48 + idx);
        }
        for (idx = 10; idx < 36; ++idx) {
            UUID.symbols[idx] = (char)(97 + idx - 10);
        }
    }
}

