/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class ViewUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void openDialog(AbstractFormPlugin plugin, Map<String, Object> customParams, String formId, String callBackKey) {
        ViewUtil.openDialog(plugin, null, customParams, formId, callBackKey);
    }

    public static void openDialog(AbstractFormPlugin plugin, String titleName, Map<String, Object> customParams, String formId, String callBackKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        if (!StringUtils.isEmpty((CharSequence)titleName)) {
            formShowParameter.setCaption(titleName);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, callBackKey);
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        plugin.getView().showForm(formShowParameter);
    }

    public static void openListPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey, boolean lookUp, boolean isMultiSelect, Object[] pkIds) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
        parameter.setLookUp(lookUp);
        if (pkIds != null && pkIds.length > 0) {
            parameter.setSelectedRows(pkIds);
        }
        if (qFilter != null) {
            List filters = parameter.getListFilterParameter().getQFilters();
            filters.add(qFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackKey));
        }
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void setSummaryData(AbstractFormPlugin plugin, String entryentity, Map<String, Object> map) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)plugin.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entryentity, "setFloatButtomData", new Object[]{map});
    }

    public static void hideToolbar(AbstractFormPlugin plugin, String ... button) {
        IFormView mainView = plugin.getView().getMainView();
        if (mainView == null) {
            plugin.getView().setVisible(Boolean.FALSE, button);
        }
    }

    public static void showMessage(AbstractFormPlugin plugin, String message) {
        String[] messages = message.split(LINE_SEPARATOR);
        if (messages.length == 1) {
            plugin.getView().showTipNotification(message);
        } else {
            plugin.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(message);
            plugin.getView().showOperationResult(operationResult);
        }
    }

    public static void showMessage(AbstractFormPlugin plugin, String title, String message, int successNum, int failNum) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            plugin.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f:%1$s\u6210\u529f%2$s\u4efd", (String)"ViewUtil_0", (String)"imc-rim-common", (Object[])new Object[0]), title, successNum), Integer.valueOf(3000));
            return;
        }
        String[] messages = message.split(LINE_SEPARATOR);
        if (successNum == 0 && messages.length == 1) {
            plugin.getView().showTipNotification(message);
        } else {
            plugin.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage("");
            for (String msg : messages) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setMessage(msg);
                errorInfo.setTitle(title);
                operationResult.addErrorInfo(errorInfo);
            }
            operationResult.setShowMessage(false);
            operationResult.setBillCount(successNum + failNum);
            ArrayList<Integer> successPkIds = new ArrayList<Integer>(successNum);
            for (int i = 0; i < successNum; ++i) {
                successPkIds.add(i);
            }
            operationResult.setSuccessPkIds(successPkIds);
            plugin.getView().showOperationResult(operationResult, title);
        }
    }
}

