/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import kd.imc.rim.common.utils.extract.ZipExtractUtil;
import org.apache.commons.codec.binary.Base64;

public class ZipUtil {
    public static JSONObject getXbrl(byte[] fileBytes) {
        return ZipExtractUtil.extractXbrl(fileBytes, false);
    }

    public static JSONObject getXbrl(byte[] fileBytes, boolean verifySign) {
        return ZipExtractUtil.extractXbrl(fileBytes, true);
    }

    public static JSONObject getXml(byte[] fileBytes) {
        return ZipExtractUtil.extractXml(fileBytes, false);
    }

    public static String compress(String str) throws UnsupportedEncodingException {
        if (str == null || str.length() == 0) {
            return null;
        }
        return ZipUtil.compress(str.getBytes("UTF-8"));
    }

    public static String compress(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip2 = new GZIPOutputStream(out);){
            gzip2.write(data);
        }
        catch (IOException gzip2) {
            // empty catch block
        }
        byte[] result = out.toByteArray();
        return Base64.encodeBase64String((byte[])result);
    }
}

