/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils.itextpdf;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.path.DecodeFileFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.url.UrlService;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UrlServiceUtils
extends UrlService {
    private static final Log logger = LogFactory.getLog(UrlServiceUtils.class);

    public static Map<String, String> getAttachmentPreviewUrlAndType(String path) {
        String url;
        HashMap<String, String> map = new HashMap<String, String>(2);
        String previewType = UrlServiceUtils.getPreviewType();
        String previewUrl = UrlServiceUtils.getPreviewUrl(path);
        map.put("url", previewUrl);
        map.put("previewType", previewType);
        if ("0".equals(previewType) && UrlServiceUtils.isExcel(path)) {
            map.put("previewType", "2");
        }
        if (!"0".equals(map.get("previewType")) && !StringUtils.isEmpty((CharSequence)(url = RimConfigUtils.getConfig("rim_fpzs", "preview_replaceurl")))) {
            map.put("replaceurl", url);
        }
        map.put("contextPath", RequestContext.get().getClientFullContextPath());
        logger.info("\u9644\u4ef6\u9884\u89c8\u5730\u5740{}", map);
        return map;
    }

    private static boolean isExcel(String path) {
        if (path == null) {
            return false;
        }
        if (path.endsWith("xls") || path.endsWith("xlsx")) {
            return true;
        }
        if (!path.contains(".")) {
            String realPath = FileUtils.getRealPath(path);
            return realPath.endsWith("xls") || realPath.endsWith("xlsx");
        }
        return false;
    }

    public static String getDownloadUrl(String path, String baseUrl) {
        String newPath = UrlServiceUtils.getDownloadUrl(path);
        return UrlServiceUtils.replacePath(newPath, baseUrl);
    }

    public static String getDownloadUrl(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (path.startsWith("http")) {
                return UrlServiceUtils.getCsPath(path);
            }
            String arfterDecodePath = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
            if (arfterDecodePath.startsWith("http")) {
                return UrlServiceUtils.getCsPath(arfterDecodePath);
            }
            String previewUrl = UrlService.getAttachmentFullUrl((String)arfterDecodePath);
            return UrlServiceUtils.getCsPath(previewUrl);
        }
        return path;
    }

    public static String replacePath(String path, String baseUrl) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)baseUrl)) {
            return path;
        }
        String context = UrlService.getDomainContextUrl();
        if (path.startsWith(context)) {
            return path.replace(context, baseUrl);
        }
        return path;
    }

    private static String getPreviewUrl(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (path.startsWith("http")) {
                return UrlServiceUtils.getCsPath(path);
            }
            String arfterDecodePath = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
            if (arfterDecodePath.startsWith("http")) {
                return UrlServiceUtils.getCsPath(arfterDecodePath);
            }
            String previewUrl = UrlService.getAttachmentPreviewUrl((String)arfterDecodePath);
            return UrlServiceUtils.getCsPath(previewUrl);
        }
        return path;
    }

    public static String getAttachmentPreviewUrl(String path) {
        logger.info("\u89e3\u5bc6\u524d\u7684\u5730\u5740\uff1a" + path);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (path.startsWith("http")) {
                return UrlServiceUtils.getCsPath(path);
            }
            String returnUrl = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
            logger.info("\u89e3\u5bc6\u540e\u7684\u5730\u5740\uff1a" + returnUrl);
            if (returnUrl.startsWith("http")) {
                return UrlServiceUtils.getCsPath(returnUrl);
            }
            String previewType = UrlServiceUtils.getPreviewType();
            if ("0".equals(previewType)) {
                return UrlServiceUtils.getPreviewUrlDefault(path, returnUrl);
            }
            return UrlServiceUtils.getPreviewUrlOther(path, returnUrl);
        }
        return path;
    }

    private static String getPreviewUrlDefault(String path, String arfterDecodePath) {
        String previewUrl;
        String realPath = previewUrl = UrlService.getAttachmentPreviewUrl((String)arfterDecodePath);
        if (!path.contains(".")) {
            realPath = FileUtils.getRealPath(path);
            logger.info("\u9644\u4ef6\u7684\u771f\u5b9e\u5730\u5740\u4e3a\uff1a{}", (Object)realPath);
            if (StringUtils.isEmpty((CharSequence)realPath)) {
                realPath = previewUrl;
            }
        }
        if (realPath.endsWith("xls") || realPath.endsWith("xlsx")) {
            String token = RequestContext.get().getGlobalSessionId();
            try {
                String url = UrlServiceUtils.getCsPath(UrlServiceUtils.encryptAcessToken(previewUrl, token));
                logger.info("excel\u9884\u89c8\u5730\u57401:{}", (Object)url);
                Pair<String, byte[]> pair = FileUtils.getFileContent(url, Boolean.FALSE);
                assert (pair != null);
                String returnUrlStr = new String((byte[])pair.getRight(), StandardCharsets.UTF_8);
                if (StringUtils.isNotEmpty((CharSequence)returnUrlStr)) {
                    logger.info("excel\u9884\u89c8\u5730\u5740{}", (Object)returnUrlStr);
                    JSONObject returnUrlJson = JSONObject.parseObject((String)returnUrlStr);
                    previewUrl = returnUrlJson.getString("url");
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.info("excel\u83b7\u53d6\u8f6c\u6362\u5730\u5740\u5931\u8d25", (Object)e);
                throw new KDBizException(ResManager.loadKDString((String)"excel\u5730\u5740\u8f6c\u6362\u5931\u8d25\uff0c\u65e0\u6cd5\u9884\u89c8\uff0c\u8bf7\u68c0\u67e5\u57df\u540d\u662f\u5426\u51c6\u786e", (String)"UrlServiceUtils_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            return previewUrl;
        }
        return UrlServiceUtils.getCsPath(previewUrl);
    }

    private static String getPreviewUrlOther(String path, String arfterDecodePath) {
        long start = System.currentTimeMillis();
        String previewUrl = UrlService.getAttachmentPreviewUrl((String)arfterDecodePath);
        String token = RequestContext.get().getGlobalSessionId();
        try {
            String url = UrlServiceUtils.getCsPath(UrlServiceUtils.encryptAcessToken(previewUrl, token));
            logger.info("\u9644\u4ef6\u9884\u89c8\u5730\u57401:{}", (Object)url);
            Pair<String, byte[]> pair = FileUtils.getFileContent(url, Boolean.FALSE);
            assert (pair != null);
            String returnUrlStr = new String((byte[])pair.getRight(), StandardCharsets.UTF_8);
            if (StringUtils.isNotEmpty((CharSequence)returnUrlStr)) {
                logger.info("\u9644\u4ef6\u9884\u89c8\u5730\u5740{},{}", (Object)(System.currentTimeMillis() - start), (Object)returnUrlStr);
                JSONObject returnUrlJson = JSONObject.parseObject((String)returnUrlStr);
                previewUrl = returnUrlJson.getString("url");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.info("\u9644\u4ef6\u83b7\u53d6\u8f6c\u6362\u5730\u5740\u5931\u8d25", (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"excel\u5730\u5740\u8f6c\u6362\u5931\u8d25\uff0c\u65e0\u6cd5\u9884\u89c8\uff0c\u8bf7\u68c0\u67e5\u57df\u540d\u662f\u5426\u51c6\u786e", (String)"UrlServiceUtils_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return previewUrl;
    }

    private static String encryptAcessToken(String url, String accessToken) throws UnsupportedEncodingException {
        String value = accessToken + "~~" + System.currentTimeMillis();
        Base64.Encoder encoder = Base64.getEncoder();
        String encodeValue = encoder.encodeToString(value.getBytes("UTF-8"));
        String flag = "&";
        if (url != null && url.indexOf(63) == -1) {
            flag = "?";
        }
        return url + flag + "kdedcba=" + URLEncoder.encode(encodeValue, "UTF-8");
    }

    public static InputStream getAttachmentDecodedStream(InputStream fileInputStream) {
        try {
            if (fileInputStream != null) {
                logger.info("\u89e3\u5bc6\u524d\u7684\u6d41\u6587\u4ef6\uff1a" + fileInputStream.available());
                InputStream decodedStream = null;
                decodedStream = DecodeFileFactory.getDecodeService().getDecodeFileStream(fileInputStream);
                logger.info("\u89e3\u5bc6\u540e\u7684\u6d41\u6587\u4ef6\uff1a" + decodedStream.available());
                return decodedStream;
            }
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6d41\u6587\u4ef6\u5927\u5c0f\u5931\u8d25", (Throwable)e);
        }
        return fileInputStream;
    }

    public static String getCsPath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && !path.contains("kd_cs_ticket")) {
            String csTicketSuffix = UrlServiceUtils.getCsTicketSuffix();
            path = path.contains("?") ? path + "&" + csTicketSuffix : path + "?" + csTicketSuffix;
            return path;
        }
        return path;
    }

    public static String getCsTicketSuffix() {
        String kdCsTicket = UrlServiceUtils.getCsrfToken(RequestContext.get().getGlobalSessionId());
        String kdCsTicketSuffix = "kd_cs_ticket=" + kdCsTicket;
        return kdCsTicketSuffix;
    }

    public static String getCsrfToken(String sessionId) {
        SessionDAO sessionDAO;
        Map sessionInfo;
        String tkey = "kdCsrfToken";
        String returnValue = "";
        if (StringUtils.isNotEmpty((CharSequence)sessionId) && (sessionInfo = (sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId)).getAttributesAsMap(new String[]{tkey})) != null && sessionInfo.size() > 0) {
            returnValue = (String)sessionInfo.get(tkey);
        }
        return returnValue;
    }

    public static String getPreviewType() {
        String previewtype = "0";
        try {
            Map setting;
            String type = RimConfigUtils.getConfig("rim_file_show", "previewtype");
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                return type;
            }
            try {
                Class<SystemParamServiceHelper> clazz = SystemParamServiceHelper.class;
                Method method = clazz.getMethod("loadPublicParametersFromCache", String.class);
                setting = (Map)method.invoke(clazz.newInstance(), "bos_fileserverconfig");
                if (!ObjectUtils.isEmpty((Object)setting) && StringUtils.isNotBlank(setting.get("previewbuttongroup"))) {
                    return (String)setting.get("previewbuttongroup");
                }
            }
            catch (Throwable e) {
                logger.error("\u83b7\u53d66.0\u9884\u89c8\u7c7b\u578b\u9519\u8bef" + e.getMessage());
            }
            Object setStr = SystemParamServiceHelper.loadPublicParameterFromCache((String)"previewconfig");
            if (!ObjectUtils.isEmpty((Object)setStr)) {
                setting = (Map)SerializationUtils.fromJsonString((String)setStr.toString(), Map.class);
                if ("1".equals(setting.get("previewtype"))) {
                    previewtype = "1";
                }
                if ("2".equals(setting.get("previewtype"))) {
                    previewtype = "2";
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u9884\u89c8\u7c7b\u578b\u9519\u8bef" + e.getMessage());
        }
        return previewtype;
    }

    public static String getLoaclIconFullUrl(String path, String baseUrl) {
        String url = UrlServiceUtils.getLoaclIconFullUrl(path);
        return UrlServiceUtils.replacePath(url, baseUrl);
    }

    public static String getLoaclIconFullUrl(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        String domianUrl = UrlService.getDomainContextUrl();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return domianUrl + '/' + path;
    }

    public static String getFileFullUrl(String iconImage) {
        return UrlServiceUtils.getFileFullUrl(iconImage, null);
    }

    public static String getFileFullUrl(String iconImage, String baseUrl) {
        if (!StringUtils.isBlank((CharSequence)iconImage)) {
            iconImage = AttachConstant.isLocalIcon(iconImage) ? UrlServiceUtils.getLoaclIconFullUrl(iconImage, baseUrl) : UrlServiceUtils.getDownloadUrl(iconImage, baseUrl);
        }
        return iconImage;
    }
}

