/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.config.exception.VerifyException;
import kd.imc.aws.ofd.util.Base64Util;
import kd.imc.aws.ofd.util.OfdErrorType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM3Util {
    private static Log LOGGER = LogFactory.getLog(SM3Util.class);
    private static final String ALGORITHM_NAME = "SM3";

    public static String doDigestToBase64Str(byte[] bytes) {
        return Base64Util.base64encoder(SM3Util.doDigest(bytes));
    }

    public static byte[] doDigest(byte[] bytes) {
        MessageDigest messageDigest = SM3Util.createMessageDigest();
        try {
            if (null != bytes) {
                messageDigest.update(bytes);
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.HASH_ERROR.getDescription(), (Throwable)e);
            throw new VerifyException(OfdErrorType.HASH_ERROR);
        }
    }

    private static MessageDigest createMessageDigest() {
        MessageDigest messageDigest;
        BouncyCastleProvider provider = new BouncyCastleProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(ALGORITHM_NAME) : MessageDigest.getInstance(ALGORITHM_NAME, (Provider)provider);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(OfdErrorType.HASH_IDENTIFIES_ERROR.getDescription(), (Throwable)e);
            throw new VerifyException(OfdErrorType.HASH_IDENTIFIES_ERROR);
        }
        return messageDigest;
    }
}

