/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.analysis;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.imc.aws.ofd.util.analysis.IOfdRead;
import kd.imc.aws.ofd.util.analysis.InvoiceReadUtils;
import kd.imc.aws.ofd.util.analysis.OfdReadUtils;
import kd.imc.aws.ofd.util.model.TextCode;
import kd.imc.aws.ofd.util.model.VatInvoice;
import kd.imc.aws.ofd.util.model.VatInvoiceItem;
import kd.imc.rim.file.pdfanalysis.utils.ReUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.SpecialCodeEnum;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class DigitalInvoiceRead
implements IOfdRead {
    @Override
    public JSONObject readData(List<Element> svgList, InvoiceTypeEnum invoiceTypeEnum) {
        VatInvoice invoice = new VatInvoice(invoiceTypeEnum.getCode());
        ArrayList<VatInvoiceItem> initItemList = new ArrayList<VatInvoiceItem>();
        for (int i = 0; i < svgList.size(); ++i) {
            Element pageEle = svgList.get(i);
            List<List<TextCode>> codeList = OfdReadUtils.getListByMap(pageEle);
            JSONObject pageContentJson = OfdReadUtils.getDataJsonByList(codeList);
            this.readData(invoice, initItemList, pageContentJson, codeList, svgList.size(), i);
        }
        InvoiceReadUtils.setModelItemData(invoice, initItemList);
        return OfdReadUtils.getReturnJson("2", null, null, invoice);
    }

    public void readData(VatInvoice invoice, List<VatInvoiceItem> initItemList, JSONObject dataJson, List<List<TextCode>> contentList, int totalNum, int pageIndex) {
        String allText = dataJson.getString("allText");
        Map specialMap = (Map)dataJson.get((Object)"specialMap");
        if (pageIndex == 0) {
            this.setBasicData(invoice, allText);
            this.setSpecialDataToInvoice(specialMap, invoice, contentList);
        }
        InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029\u00a5(?<totalAmount>\\S*)\\s", DigitalPdfConstants.AMOUNT_KEYS);
        if (invoice.getTotalAmount() == null) {
            InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029(?<totalAmount>\\S*)", DigitalPdfConstants.AMOUNT_KEYS);
        }
        this.setRemark(specialMap, invoice, contentList);
        this.setInitItemList(contentList, initItemList);
    }

    public void setBasicData(VatInvoice invoice, String allText) {
        InvoiceReadUtils.setPatternMatchValue(invoice, allText, "(?:\u5f00\u7968\u53f7\u7801|\u53d1\u7968\u53f7\u7801):(?<invoiceNo>\\d{20})|\u5f00\u7968\u65e5\u671f:(?<invoiceDate>\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5)", DigitalPdfConstants.INVOICE_CODE_KEYS);
        InvoiceReadUtils.setInvoiceAmount(invoice, allText);
        InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\u5f00\u7968\u4eba:(?<drawer>\\S*)", DigitalPdfConstants.DRAWER_KEYS);
        invoice.setInvoiceDate(InvoiceReadUtils.formatDate(invoice.getInvoiceDate()));
    }

    private void setRemark(Map<String, TextCode> specialMap, VatInvoice invoice, List<List<TextCode>> contentList) {
        TextCode buyerInfoCode = specialMap.get(SpecialCodeEnum.BUYER_INFO.getCode());
        TextCode totalAmountCode = specialMap.get(SpecialCodeEnum.TOTAL_AMOUNT.getCode());
        if (buyerInfoCode == null) {
            return;
        }
        BigDecimal remarkLeftX = buyerInfoCode.getX().add(buyerInfoCode.getWidth());
        BigDecimal remarkTopY = totalAmountCode == null ? buyerInfoCode.getY().add(new BigDecimal("40")) : totalAmountCode.getY();
        StringBuilder remarkBuilder = new StringBuilder(StringUtils.defaultString((String)invoice.getRemark()));
        for (List<TextCode> pdfTextCodeList : contentList) {
            String lineContent;
            TextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(remarkTopY) <= 0 || StringUtils.isBlank((CharSequence)(lineContent = InvoiceReadUtils.getLineText(pdfTextCodeList, remarkLeftX, null, null)))) continue;
            if (lineContent.startsWith("\u5f00\u7968\u4eba")) break;
            remarkBuilder.append(lineContent);
        }
        invoice.setRemark(remarkBuilder.toString());
    }

    private void setSpecialDataToInvoice(Map<String, TextCode> specialMap, VatInvoice invoice, List<List<TextCode>> contentList) {
        TextCode buyerInfoCode = specialMap.get(SpecialCodeEnum.BUYER_INFO.getCode());
        TextCode salerInfoCode = specialMap.get(SpecialCodeEnum.SALER_INFO.getCode());
        TextCode invoiceDateCode = specialMap.get(SpecialCodeEnum.INVOICE_DATE.getCode());
        TextCode taxRateCode = specialMap.get(SpecialCodeEnum.TAX_RATE.getCode());
        BigDecimal buyerLeftX = buyerInfoCode.getX().add(buyerInfoCode.getWidth());
        BigDecimal buyerRightX = salerInfoCode.getX();
        BigDecimal buyerTopY = invoiceDateCode.getY();
        BigDecimal buyerBottomY = taxRateCode.getY();
        BigDecimal saleLeftX = salerInfoCode.getX().add(buyerInfoCode.getWidth());
        for (List<TextCode> pdfTextCodeList : contentList) {
            TextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(buyerTopY) <= 0 || y.compareTo(buyerBottomY) >= 0) continue;
            this.setInfoData(invoice, pdfTextCodeList, buyerLeftX, buyerRightX, true);
            this.setInfoData(invoice, pdfTextCodeList, saleLeftX, null, false);
        }
    }

    private void setInfoData(VatInvoice invoice, List<TextCode> pdfTextCodeList, BigDecimal leftX, BigDecimal rightX, boolean buyerFlag) {
        String lineContent = InvoiceReadUtils.getLineText(pdfTextCodeList, leftX, rightX, null);
        if (!StringUtils.isBlank((CharSequence)lineContent)) {
            String name = ReUtil.get("\u540d\u79f0:(?<name>\\S*)", (CharSequence)lineContent, 1);
            String taxNo = ReUtil.get("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:(?<taxNo>\\S*)", (CharSequence)lineContent, 1);
            if (buyerFlag) {
                invoice.setBuyerName(name);
                invoice.setBuyerTaxNo(taxNo);
            } else {
                invoice.setSalerName(name);
                invoice.setSalerTaxNo(taxNo);
            }
        }
    }

    public void setInitItemList(List<List<TextCode>> contentList, List<VatInvoiceItem> initItemList) {
        boolean detailFlag = false;
        List<TextCode> headList = null;
        for (List<TextCode> xList : contentList) {
            String everyFirstContent = InvoiceReadUtils.replaceSpaceToEmpty(xList.get(0).getContent());
            if (everyFirstContent.contains("\u9879\u76ee\u540d\u79f0")) {
                detailFlag = true;
                headList = InvoiceReadUtils.getItemHeadList(xList);
                continue;
            }
            if (!detailFlag) continue;
            if (this.isDetailEnd(xList, everyFirstContent)) break;
            initItemList.add(InvoiceReadUtils.getItemByXList(xList, headList, false));
        }
    }

    public boolean isDetailEnd(List<TextCode> xList, String content) {
        if (content.equals("\u5c0f\u8ba1") || content.equals("\u5408\u8ba1")) {
            return true;
        }
        if ("\u5c0f".equals(content) || "\u5408".equals(content)) {
            TextCode nextTextCode = xList.get(1);
            String nextContent = InvoiceReadUtils.replaceSpaceToEmpty(nextTextCode.getContent());
            return "\u8ba1".equals(nextContent);
        }
        return false;
    }
}

