/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.analysis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.imc.aws.ofd.config.exception.ReadException;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.aws.ofd.util.model.TextCode;
import kd.imc.aws.ofd.util.ofd.OfdConvertUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoice;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoiceItem;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OfdAnalysisUtils {
    private static final BigDecimal ONE_TEXT_WIDTH = new BigDecimal("3.17");
    private static final String GOODS_NAME_COMMENT = "\u9879\u76ee\u540d\u79f0";
    private static final String SPEC_MODEL_COMMENT = "\u89c4\u683c\u578b\u53f7";
    private static final String UNIT_COMMENT = "\u5355\u4f4d";
    private static final String NUM_COMMENT = "\u6570\u91cf";
    private static final String UNIT_PRICE_COMMENT = "\u5355\u4ef7";
    private static final String DETAIL_AMOUNT_COMMENT = "\u91d1\u989d";
    private static final String TAX_RATE_COMMENT = "\u7a0e\u7387";
    private static final String TAX_AMOUNT_COMMENT = "\u7a0e\u989d";

    public static VatInvoice getData(byte[] fileBytes) throws DocumentException {
        String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, false, -1);
        Document documents = DocumentHelper.parseText((String)svgStr);
        List svgList = documents.getRootElement().elements("svg");
        VatInvoice vatInvoice = new VatInvoice();
        ArrayList<VatInvoiceItem> itemList = new ArrayList<VatInvoiceItem>();
        for (int i = 0; i < svgList.size(); ++i) {
            Map<BigDecimal, Map<BigDecimal, String>> firstSortMap = OfdAnalysisUtils.firstSort((Element)svgList.get(i));
            Map<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap = OfdAnalysisUtils.secondSort(firstSortMap);
            if (i == svgList.size() - 1) {
                List<TextCode> list = OfdAnalysisUtils.getDataList(secondSortMap);
                OfdAnalysisUtils.setModelData(vatInvoice, list);
                if (vatInvoice.getInvoiceType() == null) {
                    throw new ReadException(OfdErrorType.EXTRACT_ERROR.getErrcode(), OfdErrorType.EXTRACT_ERROR.getDescription());
                }
            }
            itemList.addAll(OfdAnalysisUtils.getItemList(secondSortMap));
        }
        OfdAnalysisUtils.setModelItemData(vatInvoice, itemList);
        return vatInvoice;
    }

    private static Map<BigDecimal, Map<BigDecimal, String>> firstSort(Element svgEle) {
        List elements = svgEle.elements("text");
        TreeMap<BigDecimal, Map<BigDecimal, String>> map = new TreeMap<BigDecimal, Map<BigDecimal, String>>();
        for (Element element : elements) {
            OfdAnalysisUtils.setSvgDataToMap(map, element);
        }
        return map;
    }

    private static void setSvgDataToMap(Map<BigDecimal, Map<BigDecimal, String>> map, Element element) {
        String text = element.getText();
        List tspanList = element.elements("tspan");
        if (tspanList != null && !tspanList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Element tspan : tspanList) {
                sb.append(tspan.getText());
            }
            text = sb.toString();
        }
        BigDecimal x = new BigDecimal(element.attributeValue("x").replace("mm", ""));
        BigDecimal y = new BigDecimal(element.attributeValue("y").replace("mm", ""));
        String transform = element.attributeValue("transform");
        if (StringUtils.isNotEmpty((CharSequence)transform) && transform.contains("matrix")) {
            transform = transform.replace("matrix(", "").replace(")", "");
            String[] ctmStrArr = transform.split(" ");
            BigDecimal a = new BigDecimal(ctmStrArr[0]);
            BigDecimal b = new BigDecimal(ctmStrArr[1]);
            BigDecimal c = new BigDecimal(ctmStrArr[2]);
            BigDecimal d = new BigDecimal(ctmStrArr[3]);
            BigDecimal e = OfdAnalysisUtils.pxToMm(new BigDecimal(ctmStrArr[4]));
            BigDecimal f = OfdAnalysisUtils.pxToMm(new BigDecimal(ctmStrArr[5]));
            if (b.compareTo(BigDecimal.ZERO) != 0 || c.compareTo(BigDecimal.ZERO) != 0) {
                return;
            }
            x = a.multiply(x).add(e).setScale(0, RoundingMode.HALF_UP);
            y = d.multiply(y).add(f).setScale(0, RoundingMode.HALF_UP);
        }
        y = y.setScale(0, RoundingMode.HALF_UP);
        x = x.setScale(0, RoundingMode.HALF_UP);
        Map xMap = map.computeIfAbsent(y, k -> new TreeMap());
        if (text.contains("\u5408") && text.contains("\u8ba1")) {
            text = text.replace(" ", "");
        }
        if ("\u8ba1".equals(text) && xMap.size() == 1) {
            for (Map.Entry entry : xMap.entrySet()) {
                String value = (String)entry.getValue();
                if (!"\u5408".equals(value)) continue;
                xMap.put(entry.getKey(), "\u5408\u8ba1");
                return;
            }
        }
        xMap.put(x, text);
    }

    private static Map<BigDecimal, Map<BigDecimal, TextCode>> secondSort(Map<BigDecimal, Map<BigDecimal, String>> firstSortMap) {
        TreeMap<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap = new TreeMap<BigDecimal, Map<BigDecimal, TextCode>>();
        for (Map.Entry<BigDecimal, Map<BigDecimal, String>> firstMapEntry : firstSortMap.entrySet()) {
            BigDecimal yKey = firstMapEntry.getKey();
            Map<BigDecimal, String> xMap = firstMapEntry.getValue();
            StringBuilder sb = new StringBuilder();
            BigDecimal xFirst = BigDecimal.ZERO;
            BigDecimal lastX = BigDecimal.ZERO;
            for (Map.Entry<BigDecimal, String> xMapEntry : xMap.entrySet()) {
                BigDecimal xKey = xMapEntry.getKey();
                if (xFirst.compareTo(BigDecimal.ZERO) == 0) {
                    xFirst = xKey;
                }
                if (lastX.compareTo(BigDecimal.ZERO) != 0 && lastX.add(ONE_TEXT_WIDTH).compareTo(xKey) < 0) {
                    OfdAnalysisUtils.setSecondSortContentData(secondSortMap, lastX, yKey, sb.toString());
                    sb = new StringBuilder();
                }
                sb.append(xMapEntry.getValue());
                lastX = xKey;
            }
            OfdAnalysisUtils.setSecondSortContentData(secondSortMap, lastX, yKey, sb.toString());
        }
        return secondSortMap;
    }

    private static List<TextCode> getDataList(Map<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap) {
        ArrayList<TextCode> list = new ArrayList<TextCode>();
        for (Map.Entry<BigDecimal, Map<BigDecimal, TextCode>> entryMap : secondSortMap.entrySet()) {
            for (Map.Entry<BigDecimal, TextCode> detailMap : entryMap.getValue().entrySet()) {
                TextCode textCode = detailMap.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)textCode.getContent())) continue;
                list.add(textCode);
            }
        }
        return list;
    }

    private static List<VatInvoiceItem> getItemList(Map<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap) {
        ArrayList<VatInvoiceItem> itemList = new ArrayList<VatInvoiceItem>();
        ArrayList<TextCode> headList = new ArrayList<TextCode>();
        boolean startFlag = false;
        boolean endFlag = false;
        boolean headFlag = false;
        VatInvoiceItem vatInvoiceItem = null;
        for (Map.Entry<BigDecimal, Map<BigDecimal, TextCode>> entryMap : secondSortMap.entrySet()) {
            if (endFlag) break;
            if (startFlag) {
                vatInvoiceItem = new VatInvoiceItem();
            }
            block1: for (Map.Entry<BigDecimal, TextCode> detailMap : entryMap.getValue().entrySet()) {
                TextCode textCode = detailMap.getValue();
                String content = textCode.getContent();
                if ("\u5408\u8ba1".equals(content) || "\u5c0f\u8ba1".equals(content)) {
                    endFlag = true;
                    break;
                }
                if (GOODS_NAME_COMMENT.equals(content)) {
                    startFlag = true;
                    headFlag = true;
                }
                if (!startFlag) continue;
                BigDecimal x = textCode.getX();
                if (headFlag) {
                    OfdAnalysisUtils.setItemHeadList(headList, textCode, content, x);
                    continue;
                }
                for (TextCode head : headList) {
                    BigDecimal lastX = head.getLastX();
                    if (x.compareTo(lastX) > 0) continue;
                    String headContent = head.getContent();
                    OfdAnalysisUtils.setItemModel(vatInvoiceItem, headContent, content);
                    continue block1;
                }
            }
            if (!endFlag && vatInvoiceItem != null) {
                itemList.add(vatInvoiceItem);
            }
            if (!headFlag) continue;
            headFlag = false;
        }
        return itemList;
    }

    private static void setItemHeadList(List<TextCode> headList, TextCode textCode, String content, BigDecimal x) {
        content = content.replace(" ", "");
        BigDecimal xLength = ONE_TEXT_WIDTH.multiply(new BigDecimal(content.length())).setScale(0, RoundingMode.HALF_UP);
        textCode.setLastX(x.add(xLength).add(new BigDecimal("2")));
        textCode.setContent(content);
        headList.add(textCode);
    }

    private static void setItemModel(VatInvoiceItem vatInvoiceItem, String headContent, String content) {
        if (GOODS_NAME_COMMENT.equals(headContent)) {
            vatInvoiceItem.setGoodsName(content);
        } else if (SPEC_MODEL_COMMENT.equals(headContent)) {
            vatInvoiceItem.setSpecModel(content);
        } else if (UNIT_COMMENT.equals(headContent)) {
            vatInvoiceItem.setUnit(content);
        } else if (NUM_COMMENT.equals(headContent)) {
            vatInvoiceItem.setNum(content);
        } else if (UNIT_PRICE_COMMENT.equals(headContent)) {
            vatInvoiceItem.setUnitPrice(content);
        } else if (headContent.contains(TAX_RATE_COMMENT)) {
            vatInvoiceItem.setTaxRate(OfdAnalysisUtils.getTaxRate(content));
        } else if (DETAIL_AMOUNT_COMMENT.equals(headContent)) {
            vatInvoiceItem.setDetailAmount(content);
        } else if (TAX_AMOUNT_COMMENT.equals(headContent)) {
            vatInvoiceItem.setTaxAmount(content);
        }
    }

    private static void setModelData(VatInvoice vatInvoice, List<TextCode> textCodeList) {
        boolean totalAmountNull = true;
        block0: for (int i = 0; i < textCodeList.size(); ++i) {
            InvoiceTypeEnum invoiceType;
            TextCode textCode = textCodeList.get(i);
            String content = textCode.getContent();
            if (vatInvoice.getInvoiceType() == null && (invoiceType = InvoiceTypeEnum.getByDesc(textCode.getContent())) != null) {
                vatInvoice.setInvoiceType(invoiceType.getCode());
                continue;
            }
            if (vatInvoice.getInvoiceNo() == null && content.contains("\u53d1\u7968\u53f7\u7801")) {
                vatInvoice.setInvoiceNo(textCodeList.get(i + 1).getContent());
                ++i;
                continue;
            }
            if (vatInvoice.getInvoiceDate() == null && content.contains("\u5f00\u7968\u65e5\u671f")) {
                vatInvoice.setInvoiceDate(OfdAnalysisUtils.formatDate(textCodeList.get(i + 1).getContent()));
                ++i;
                continue;
            }
            if (vatInvoice.getBuyerName() == null && content.contains("\u540d\u79f0")) {
                vatInvoice.setBuyerName(textCodeList.get(i + 1).getContent());
                ++i;
                continue;
            }
            if (vatInvoice.getSalerName() == null && content.contains("\u540d\u79f0")) {
                vatInvoice.setSalerName(textCodeList.get(i + 1).getContent());
                ++i;
                continue;
            }
            if (vatInvoice.getBuyerTaxNo() == null && content.contains("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7")) {
                vatInvoice.setBuyerTaxNo(textCodeList.get(i + 1).getContent());
                ++i;
                continue;
            }
            if (vatInvoice.getSalerTaxNo() == null && content.contains("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7")) {
                vatInvoice.setSalerTaxNo(textCodeList.get(i + 1).getContent());
                ++i;
                continue;
            }
            if (vatInvoice.getInvoiceAmount() == null && content.contains("\u5408\u8ba1")) {
                vatInvoice.setInvoiceAmount(OfdAnalysisUtils.removeMoneySymbol(textCodeList.get(i + 1).getContent()));
                vatInvoice.setTotalTaxAmount(OfdAnalysisUtils.removeMoneySymbol(textCodeList.get(i + 2).getContent()));
                i += 2;
                continue;
            }
            if (vatInvoice.getTotalAmount() == null && content.contains("\u4ef7\u7a0e\u5408\u8ba1")) {
                vatInvoice.setTotalAmount(OfdAnalysisUtils.removeMoneySymbol(textCodeList.get(i + 3).getContent()));
                totalAmountNull = false;
                i += 3;
                continue;
            }
            if (vatInvoice.getRemark() != null || totalAmountNull) continue;
            StringBuilder sb = new StringBuilder();
            while (true) {
                TextCode textCodeNext;
                if (("\u5907".equals(content = (textCodeNext = textCodeList.get(i)).getContent()) || "\u6ce8".equals(content)) && textCodeNext.getX().compareTo(new BigDecimal("7")) < 0) {
                    ++i;
                    continue;
                }
                if (content.contains("\u5f00\u7968\u4eba")) {
                    vatInvoice.setRemark(sb.toString());
                    vatInvoice.setDrawer(textCodeList.get(i + 1).getContent());
                    continue block0;
                }
                if (i == textCodeList.size() - 1) continue block0;
                sb.append(content);
                ++i;
            }
        }
    }

    private static void setModelItemData(VatInvoice vatInvoice, List<VatInvoiceItem> itemList) {
        ArrayList<VatInvoiceItem> finalItemList = new ArrayList<VatInvoiceItem>();
        block0: for (int i = 0; i < itemList.size(); ++i) {
            VatInvoiceItem vatInvoiceItem = itemList.get(i);
            while (true) {
                if (i == itemList.size() - 1) {
                    finalItemList.add(vatInvoiceItem);
                    continue block0;
                }
                VatInvoiceItem vatInvoiceItemNext = itemList.get(i + 1);
                if (vatInvoiceItemNext.getTaxAmount() != null) {
                    finalItemList.add(vatInvoiceItem);
                    continue block0;
                }
                if (vatInvoiceItemNext.getGoodsName() != null) {
                    vatInvoiceItem.setGoodsName(vatInvoiceItem.getGoodsName() + vatInvoiceItemNext.getGoodsName());
                }
                if (vatInvoiceItemNext.getSpecModel() != null) {
                    vatInvoiceItem.setSpecModel(vatInvoiceItem.getSpecModel() + vatInvoiceItemNext.getSpecModel());
                }
                if (vatInvoiceItemNext.getUnit() != null) {
                    vatInvoiceItem.setUnit(vatInvoiceItem.getUnit() + vatInvoiceItemNext.getUnit());
                }
                ++i;
            }
        }
        vatInvoice.setItem(finalItemList);
    }

    private static String removeMoneySymbol(String str) {
        return str.replace("\u00a5", "");
    }

    private static String getTaxRate(String taxRate) {
        if (taxRate != null && taxRate.contains("%")) {
            String taxRateStr = taxRate.replace("%", "");
            BigDecimal taxRateBig = new BigDecimal(taxRateStr).divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP).stripTrailingZeros();
            taxRate = taxRateBig.toPlainString();
        }
        return taxRate;
    }

    private static String formatDate(String str) {
        return str.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
    }

    private static BigDecimal pxToMm(BigDecimal value) {
        return value.multiply(new BigDecimal("25.4")).divide(new BigDecimal("96"), 6, RoundingMode.HALF_UP);
    }

    private static void setSecondSortContentData(Map<BigDecimal, Map<BigDecimal, TextCode>> contentMap, BigDecimal x, BigDecimal y, String content) {
        Map xMap = contentMap.get(y);
        if (xMap == null) {
            xMap = contentMap.get(y.subtract(BigDecimal.ONE));
        }
        if (xMap == null) {
            xMap = contentMap.get(y.add(BigDecimal.ONE));
        }
        if (xMap == null) {
            xMap = contentMap.computeIfAbsent(y, k -> new TreeMap());
        }
        xMap.put(x, new TextCode(x, y, content));
    }
}

