/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.analysis;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.imc.aws.ofd.util.analysis.IOfdRead;
import kd.imc.aws.ofd.util.analysis.InvoiceReadUtils;
import kd.imc.aws.ofd.util.analysis.OfdReadUtils;
import kd.imc.aws.ofd.util.model.TextCode;
import kd.imc.aws.ofd.util.model.VatInvoice;
import kd.imc.aws.ofd.util.model.VatInvoiceItem;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.SpecialCodeEnum;
import kd.imc.rim.file.utils.StrUtil;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class VatInvoiceRead
implements IOfdRead {
    @Override
    public JSONObject readData(List<Element> svgList, InvoiceTypeEnum invoiceTypeEnum) {
        VatInvoice invoice = new VatInvoice(invoiceTypeEnum.getCode());
        ArrayList<VatInvoiceItem> initItemList = new ArrayList<VatInvoiceItem>();
        for (int i = 0; i < svgList.size(); ++i) {
            Element pageEle = svgList.get(i);
            List<List<TextCode>> codeList = OfdReadUtils.getListByMap(pageEle);
            JSONObject pageContentJson = OfdReadUtils.getDataJsonByList(codeList);
            this.readData(invoice, initItemList, pageContentJson, codeList, svgList.size(), i);
        }
        InvoiceReadUtils.setModelItemData(invoice, initItemList);
        return OfdReadUtils.getReturnJson("1", null, null, invoice);
    }

    public void readData(VatInvoice invoice, List<VatInvoiceItem> initItemList, JSONObject dataJson, List<List<TextCode>> contentList, int totalNum, int pageIndex) {
        Map specialMap = (Map)dataJson.get((Object)"specialMap");
        if (pageIndex == 0) {
            this.setBasicData(invoice, dataJson, contentList, specialMap);
            if (totalNum > 1) {
                return;
            }
        }
        this.setInitItemList(initItemList, contentList, specialMap);
    }

    public void setBasicData(VatInvoice invoice, JSONObject dataJson, List<List<TextCode>> contentList, Map<String, TextCode> specialMap) {
        String invoiceTypeReg;
        Pattern invoiceTypeP;
        Matcher invoiceTypeM;
        String allText = dataJson.getString("allText");
        if (invoice.getInvoiceType() == null && (invoiceTypeM = (invoiceTypeP = Pattern.compile(invoiceTypeReg = "\\S*\u7535\u5b50\u666e\u901a\u53d1\u7968")).matcher(allText)).find()) {
            invoice.setInvoiceType(InvoiceTypeEnum.VAT_ELE_INVOICE_ORDINARY.getCode());
        }
        InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\u673a\u5668\u7f16\u53f7:(?<machineNo>\\d{12})|\u53d1\u7968\u4ee3\u7801:(?<invoiceCode>\\d{12})|\u53d1\u7968\u53f7\u7801:(?<invoiceNo>\\d{8})|\u5f00\u7968\u65e5\u671f:(?<invoiceDate>\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5)|\u6821\u9a8c\u7801:(?<checkCode>\\d{20})", DigitalPdfConstants.MACHINE_KEYS);
        InvoiceReadUtils.setInvoiceAmount(invoice, allText);
        InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029\u00a5(?<totalAmount>\\S*)\\s", DigitalPdfConstants.AMOUNT_KEYS);
        if (invoice.getTotalAmount() == null) {
            InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029(?<totalAmount>\\S*)", DigitalPdfConstants.AMOUNT_KEYS);
        }
        InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\u6536\u6b3e\u4eba:(?<payee>\\S*)\u590d\u6838:(?<reviewer>\\S*)\u5f00\u7968\u4eba:(?<drawer>\\S*)\u9500\u552e\u65b9", DigitalPdfConstants.LAST_KEYS);
        if (StringUtils.isEmpty((CharSequence)invoice.getDrawer())) {
            InvoiceReadUtils.setPatternMatchValue(invoice, allText, "\u6536\u6b3e\u4eba:(?<payee>\\S*)\u590d\u6838:(?<reviewer>\\S*)\u5f00\u7968\u4eba:(?<drawer>\\S*)", DigitalPdfConstants.LAST_KEYS);
        }
        this.setSpecialDataToInvoice(specialMap, invoice, contentList);
        invoice.setInvoiceDate(InvoiceReadUtils.formatDate(invoice.getInvoiceDate()));
    }

    private void setSpecialDataToInvoice(Map<String, TextCode> specialMap, VatInvoice invoice, List<List<TextCode>> contentList) {
        TextCode buyerAccountCode = specialMap.get(SpecialCodeEnum.BUYER_ACCOUNT.getCode());
        TextCode codeAreaCode = specialMap.get(SpecialCodeEnum.CODE_AREA.getCode());
        TextCode machineCode = specialMap.get(SpecialCodeEnum.MACHINE_NO.getCode());
        TextCode taxRateCode = specialMap.get(SpecialCodeEnum.TAX_RATE.getCode());
        TextCode remarkCode = specialMap.get(SpecialCodeEnum.REMARK.getCode());
        BigDecimal buyerLeftX = buyerAccountCode.getX().subtract(new BigDecimal("3.9"));
        BigDecimal buyerRightX = codeAreaCode.getX();
        BigDecimal buyerTopY = machineCode.getY();
        BigDecimal buyerBottomY = taxRateCode.getY();
        this.setInfoData(invoice, contentList, buyerLeftX, buyerRightX, buyerTopY, buyerBottomY, true);
        TextCode totalAmountCode = specialMap.get(SpecialCodeEnum.TOTAL_AMOUNT.getCode());
        TextCode salerAccountCode = specialMap.get(SpecialCodeEnum.SALER_ACCOUNT.getCode());
        BigDecimal saleTopY = totalAmountCode.getY();
        BigDecimal saleBottomY = salerAccountCode.getY().add(new BigDecimal("3.9"));
        BigDecimal remarkLeft = buyerRightX;
        if (remarkCode != null) {
            remarkLeft = remarkCode.getX();
        }
        this.setInfoData(invoice, contentList, buyerLeftX, remarkLeft, saleTopY, saleBottomY, false);
        remarkLeft = remarkLeft.add(new BigDecimal("5"));
        this.setRemarkData(invoice, contentList, remarkLeft, saleTopY, saleBottomY);
    }

    private void setInfoData(VatInvoice invoice, List<List<TextCode>> contentList, BigDecimal leftX, BigDecimal rightX, BigDecimal topY, BigDecimal bottomY, boolean buyerFlag) {
        StringBuilder sb = new StringBuilder();
        JSONObject param = new JSONObject();
        BigDecimal startX = null;
        for (int i = 0; i < contentList.size(); ++i) {
            String lineContent;
            List<TextCode> pdfTextCodeList = contentList.get(i);
            TextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(topY) <= 0 || y.compareTo(bottomY) >= 0 || StringUtils.isBlank((CharSequence)(lineContent = InvoiceReadUtils.getLineText(pdfTextCodeList, leftX, rightX, param)))) continue;
            if (startX == null) {
                startX = param.getBigDecimal("startX");
            }
            BigDecimal currentFirstX = param.getBigDecimal("currentStartX");
            if (sb.length() > 0 && currentFirstX.subtract(startX).abs().compareTo(new BigDecimal("20")) <= 0) {
                this.setInfoDataByReg(invoice, sb.toString(), buyerFlag);
                sb = new StringBuilder();
            }
            sb.append(lineContent);
        }
        this.setInfoDataByReg(invoice, sb.toString(), buyerFlag);
    }

    private void setRemarkData(VatInvoice invoice, List<List<TextCode>> contentList, BigDecimal leftX, BigDecimal topY, BigDecimal bottomY) {
        StringBuilder sb = new StringBuilder();
        for (List<TextCode> pdfTextCodeList : contentList) {
            TextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(topY) <= 0 || y.compareTo(bottomY) >= 0) continue;
            for (TextCode code : pdfTextCodeList) {
                BigDecimal x = code.getX();
                if (x.compareTo(leftX) < 0) continue;
                sb.append(code.getContent());
            }
        }
        invoice.setRemark(sb.toString());
    }

    private boolean setInfoDataByReg(VatInvoice invoice, String text, boolean buyerFlag) {
        boolean flag = false;
        Pattern pattern = Pattern.compile("\u540d\u79f0:(?<name>\\S*)|\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:(?<taxNo>\\S*)|\u5730\u5740\u3001\u7535\u8bdd:(?<addressPhone>\\S*)|\u5f00\u6237\u884c\u53ca\u8d26\u53f7:(?<bankAccount>\\S*)");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            flag = true;
            String name = StrUtil.nullToEmpty(matcher.group("name"));
            String taxNo = StrUtil.nullToEmpty(matcher.group("taxNo"));
            String addressPhone = StrUtil.nullToEmpty(matcher.group("addressPhone"));
            String bankAccount = StrUtil.nullToEmpty(matcher.group("bankAccount"));
            if (buyerFlag) {
                invoice.setBuyerName(name);
                invoice.setBuyerTaxNo(taxNo);
                invoice.setBuyerAccount(bankAccount);
                invoice.setBuyerAddressPhone(addressPhone);
                continue;
            }
            invoice.setSalerName(name);
            invoice.setSalerTaxNo(taxNo);
            invoice.setSalerAccount(bankAccount);
            invoice.setSalerAddressPhone(addressPhone);
        }
        return flag;
    }

    private void setInitItemList(List<VatInvoiceItem> initItemList, List<List<TextCode>> contentList, Map<String, TextCode> specialMap) {
        TextCode taxRateCode = specialMap.get(SpecialCodeEnum.TAX_RATE.getCode());
        TextCode totalCode = specialMap.get(SpecialCodeEnum.COMBINE_TOTAL.getCode());
        if (totalCode == null) {
            totalCode = specialMap.get(SpecialCodeEnum.SUB_TOTAL.getCode());
        }
        BigDecimal topY = taxRateCode.getY();
        BigDecimal bottomY = totalCode.getY();
        boolean headFlag = true;
        List<TextCode> headList = null;
        for (List<TextCode> pdfTextCodeList : contentList) {
            TextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(topY) < 0 || y.compareTo(bottomY) >= 0) continue;
            if (headFlag) {
                headList = InvoiceReadUtils.getItemHeadList(pdfTextCodeList);
                headFlag = false;
                continue;
            }
            initItemList.add(InvoiceReadUtils.getItemByXList(pdfTextCodeList, headList, true));
        }
    }
}

