/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.ofd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.config.exception.ReadException;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.aws.ofd.util.StrUtil;
import kd.imc.aws.ofd.util.analysis.OfdAnalysisUtil;
import kd.imc.aws.ofd.util.analysis.OfdAnalysisUtils;
import kd.imc.aws.ofd.util.analysis.OfdInvoiceDto;
import kd.imc.aws.ofd.util.ofd.OfdConvertUtil;
import kd.imc.aws.ofd.util.ofd.OfdReadUtil;
import kd.imc.aws.ofd.util.ofd.OfdSignUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoice;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;

public class OfdUtil {
    private static Log LOGGER = LogFactory.getLog(OfdUtil.class);

    public static Map<String, Object> getInvoiceMap(byte[] fileBytes) {
        try {
            String docID;
            Map<String, Object> invoiceMap = OfdReadUtil.extractData(fileBytes);
            if ("xbrl".equals(invoiceMap.get("file_type"))) {
                invoiceMap = null;
                return invoiceMap;
            }
            switch (docID = (String)invoiceMap.get("DocID")) {
                case "01": {
                    OfdInvoiceDto ofdInvoiceDto = OfdUtil.changeOfdInvoiceDto(invoiceMap);
                    invoiceMap = new HashMap<String, Object>();
                    invoiceMap.put("ofdInvoiceMap", ofdInvoiceDto);
                    return invoiceMap;
                }
                case "03": {
                    return invoiceMap;
                }
            }
            return invoiceMap;
        }
        catch (ReadException docID) {
            HashMap<String, Object> invoiceMap = new HashMap<String, Object>();
            OfdInvoiceDto ofdInvoiceDto = OfdAnalysisUtil.analysisOfdByCoordinate(fileBytes);
            LOGGER.info("OfdAnalysisUtil analysisOfdByCoordinate result:{}", (Object)JSONObject.toJSONString((Object)ofdInvoiceDto));
            invoiceMap.put("ofdInvoiceMap", ofdInvoiceDto);
            return invoiceMap;
        }
    }

    private static OfdInvoiceDto changeOfdInvoiceDto(Map<String, Object> invoiceMap) {
        Map Buyer;
        OfdInvoiceDto result = new OfdInvoiceDto();
        result.setInvoiceCode(invoiceMap.get("InvoiceCode") == null ? "" : (String)invoiceMap.get("InvoiceCode"));
        result.setInvoiceNo(invoiceMap.get("InvoiceNo") == null ? "" : (String)invoiceMap.get("InvoiceNo"));
        result.setInvoiceDate(invoiceMap.get("IssueDate") == null ? "" : (String)invoiceMap.get("IssueDate"));
        result.setInvoiceAmount(invoiceMap.get("TaxExclusiveTotalAmount") == null ? "" : (String)invoiceMap.get("TaxExclusiveTotalAmount"));
        result.setTotalAmount(invoiceMap.get("TaxInclusiveTotalAmount") == null ? "" : (String)invoiceMap.get("TaxInclusiveTotalAmount"));
        result.setTotalTaxAmount(invoiceMap.get("TaxTotalAmount") == null ? "" : ("***".equals((String)invoiceMap.get("TaxTotalAmount")) ? "0.0" : (String)invoiceMap.get("TaxTotalAmount")));
        result.setCheckCode(invoiceMap.get("InvoiceCheckCode") == null ? "" : (String)invoiceMap.get("InvoiceCheckCode"));
        Map seller = (Map)invoiceMap.get("Seller");
        if (null != seller) {
            result.setSalerName(seller.get("SellerName") == null ? "" : (String)seller.get("SellerName"));
            result.setSalerTaxNo(seller.get("SellerTaxID") == null ? "" : (String)seller.get("SellerTaxID"));
        }
        if (null != (Buyer = (Map)invoiceMap.get("Buyer"))) {
            result.setBuyerName(Buyer.get("BuyerName") == null ? "" : (String)Buyer.get("BuyerName"));
            result.setBuyerTaxNo(Buyer.get("BuyerTaxID") == null ? "" : (String)Buyer.get("BuyerTaxID"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> getAllElectricInvoiceMap(byte[] fileBytes) {
        Map<String, Object> allElectricInvoiceData = null;
        try {
            allElectricInvoiceData = OfdReadUtil.extractAllElectricInvoiceData(fileBytes);
        }
        catch (Exception e) {
            LOGGER.info(OfdErrorType.EXTRACT_ERROR.toString(), (Object)e);
        }
        if (null != allElectricInvoiceData && allElectricInvoiceData.size() != 0 && null != allElectricInvoiceData.get("type") && allElectricInvoiceData.get("type").equals("2")) {
            HashMap invoiceJson = (HashMap)allElectricInvoiceData.get("invoice");
            String invoiceNo = (String)invoiceJson.get("invoiceNo");
            if (!StringUtils.isNotBlank((CharSequence)invoiceNo)) return allElectricInvoiceData;
            if (invoiceNo.length() == 20) return allElectricInvoiceData;
            LOGGER.info("getAllElectricInvoiceMap ofd is not allElectric ");
            throw new ReadException(OfdErrorType.EXTRACT_ALL_ELECTRIC_ERROR);
        }
        OfdInvoiceDto ofdInvoiceDto = OfdAnalysisUtil.analysisOfdByCoordinate(fileBytes);
        if (null == ofdInvoiceDto) return allElectricInvoiceData;
        if (StringUtils.isNotBlank((CharSequence)ofdInvoiceDto.getInvoiceNo()) && ofdInvoiceDto.getInvoiceNo().length() == 20) {
            ofdInvoiceDto.setInvoiceType("26");
            Map invoice = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)ofdInvoiceDto), Map.class);
            allElectricInvoiceData = new HashMap<String, Object>();
            allElectricInvoiceData.put("invoice", invoice);
            allElectricInvoiceData.put("description", "\u6570\u7535\u7968");
            allElectricInvoiceData.put("type", "2");
            return allElectricInvoiceData;
        }
        LOGGER.info("getAllElectricInvoiceMap ofd is not allElectric ");
        throw new ReadException(OfdErrorType.EXTRACT_ALL_ELECTRIC_ERROR);
    }

    public static String getXbrlStr(byte[] fileBytes) {
        String str = null;
        Map<String, Object> invoiceMap = OfdReadUtil.extractData(fileBytes);
        if ("xbrl".equals(invoiceMap.get("file_type"))) {
            str = String.valueOf(invoiceMap.get("file_data"));
        }
        return str;
    }

    public static JSONObject getXbrlJson(byte[] fileBytes) {
        JSONObject jsonObject = null;
        Map<String, Object> invoiceMap = OfdReadUtil.extractData(fileBytes);
        if ("xbrl".equals(invoiceMap.get("file_type"))) {
            jsonObject = new JSONObject();
            jsonObject.put("name", (Object)StrUtil.nullToDefault((String)invoiceMap.get("file_name"), ""));
            jsonObject.put("message", (Object)String.valueOf(invoiceMap.get("file_data")));
        }
        return jsonObject;
    }

    public static JSONObject getInvoiceJSON(byte[] fileBytes) {
        return JSONObject.parseObject((String)JSON.toJSONString(OfdUtil.getInvoiceMap(fileBytes)));
    }

    public static JSONObject getAllElectricInvoiceJSON(byte[] fileBytes) {
        return JSONObject.parseObject((String)JSON.toJSONString(OfdUtil.getAllElectricInvoiceMap(fileBytes)));
    }

    public static boolean verifySign(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, false);
    }

    public static boolean verifySignTax(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, true);
    }

    private static Map<String, Object> verifySignAndGetCerInfo(byte[] fileBytes) {
        return OfdSignUtil.verifySignAndGetCerInfo(fileBytes, true, false);
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.convertToSvg(fileBytes);
    }

    public static byte[] convertToPng(byte[] fileBytes) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, 1, -1);
    }

    public static byte[] convertToImage(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, imageType, -1);
    }

    public static List<Object> convertToMulPngStr(byte[] fileBytes) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, 1, -1);
    }

    public static List<Object> convertToHDMulImageStr(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, -1);
    }

    public static List<Object> convertToMulImageStr(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, imageType, -1);
    }

    public static String convertToImageByPageNo(byte[] fileBytes, float zoomScale, int imageType, int pageNo) {
        List<Object> list = OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, pageNo);
        String rsStr = null;
        if (list != null && !list.isEmpty()) {
            rsStr = (String)list.get(0);
        }
        return rsStr;
    }

    public static List<Object> convertToHDMulPngStr(byte[] fileBytes, float zoomScale) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, 1, -1);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdfNew(fileBytes, -1);
    }

    public static List<byte[]> convertToPdfList(byte[] fileBytes, int pageNo) {
        return OfdConvertUtil.convertToPdfList(fileBytes, pageNo);
    }

    public static byte[] convertToPdfNew(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdfNew(fileBytes, -1);
    }

    public static byte[] convertToHDPng(byte[] fileBytes, float multipleNum) {
        return OfdConvertUtil.convertToImage(fileBytes, multipleNum, 1, -1);
    }

    public static byte[] convertToHDImage(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, zoomScale, imageType, -1);
    }

    public static VatInvoice getVatInvoice(byte[] fileBytes) throws DocumentException {
        return OfdAnalysisUtils.getData(fileBytes);
    }
}

