/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.pdfanalysis.model.FormatAttribute;
import kd.imc.rim.file.pdfanalysis.model.ReceiptPosition;
import kd.imc.rim.file.pdfanalysis.utils.analysis.ContanstPDF;
import kd.imc.rim.file.pdfanalysis.utils.analysis.Coordinate;
import kd.imc.rim.file.pdfanalysis.utils.analysis.CoordinateA;
import kd.imc.rim.file.pdfanalysis.utils.analysis.CoordinateB;
import kd.imc.rim.file.pdfanalysis.utils.analysis.CoordinateC;
import kd.imc.rim.file.pdfanalysis.utils.analysis.DocumentInfo;
import kd.imc.rim.file.pdfanalysis.utils.analysis.InvoiceInfo;
import kd.imc.rim.file.pdfanalysis.utils.analysis.PDFTextStripperNew;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;

public class PDFAnalysisUtil {
    private static Log logger = LogFactory.getLog(PDFAnalysisUtil.class);
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String kpje_key = "(\u5c0f\u5199)";
    public static final String kpje_key2 = "\uff08\u5c0f\u5199\uff09";
    private static final String FPDM = "\u53d1\u7968\u4ee3\u7801";
    private static final String FPHM = "\u53d1\u7968\u53f7\u7801";
    private static final String KPRQ = "\u5f00\u7968\u65e5\u671f";
    private static final String JYM = "\u6821\u9a8c\u7801";
    private static final String MC = "\u540d\u79f0";
    private static final String NSRSBH = "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7";
    private static final String DZDH = "\u5730\u5740\u3001\u7535\u8bdd";
    private static final String KHHJZH = "\u5f00\u6237\u884c\u53ca\u8d26\u53f7";
    private static final String JQBH = "\u673a\u5668\u7f16\u53f7";
    private static final String HJ = "\u5408\u8ba1";
    private static final String HJ_H = "\u5408";
    private static final String HJ_J = "\u8ba1";
    private static final String JSHJ = "\u4ef7\u7a0e\u5408\u8ba1";
    private static final String HWLWFWMC = "\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d\u52a1\u540d\u79f0";
    private static final String HWLWFWMC_P = "\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d";
    private static final String GGXH = "\u89c4\u683c\u578b\u53f7";
    private static final String DW = "\u5355\u4f4d";
    private static final String DW_D = "\u5355";
    private static final String DW_W = "\u4f4d";
    private static final String SL = "\u6570\u91cf";
    private static final String SL_S = "\u6570";
    private static final String SL_L = "\u91cf";
    private static final String DJ = "\u5355\u4ef7";
    private static final String DJ_D = "\u5355";
    private static final String DJ_J = "\u4ef7";
    private static final String JE = "\u91d1\u989d";
    private static final String JE_J = "\u91d1";
    private static final String JE_E = "\u989d";
    private static final String SLV = "\u7a0e\u7387";
    private static final String SLV_S = "\u7a0e";
    private static final String SLV_LV = "\u7387";
    private static final String SE = "\u7a0e\u989d";
    private static final String SE_S = "\u7a0e";
    private static final String SE_E = "\u989d";
    private static final String MMQ = "\u5bc6\u7801\u533a";
    private static final String BZ = "\u5907\u6ce8";
    private static final String MMQ_BZ = "\u5bc6\u7801\u533a\u5907\u6ce8";
    private static ReceiptPosition jqbhR = null;
    private static ReceiptPosition hjR = null;
    private static ReceiptPosition jshjR = null;
    private static ReceiptPosition hwmcR = null;
    private static ReceiptPosition ggxhR = null;
    private static ReceiptPosition danweiR = null;
    private static ReceiptPosition shuliangR = null;
    private static ReceiptPosition danjiaR = null;
    private static ReceiptPosition jineR = null;
    private static ReceiptPosition shuilvR = null;
    private static ReceiptPosition shuieR = null;
    private static ReceiptPosition mmqR = null;
    private static ReceiptPosition bzR = null;
    private static ReceiptPosition xh$R = null;
    private static ReceiptPosition hwmc$R = null;
    private static ReceiptPosition ggxh$R = null;
    private static ReceiptPosition dw$R = null;
    private static ReceiptPosition sl$R = null;
    private static ReceiptPosition dj$R = null;
    private static ReceiptPosition je$R = null;
    private static ReceiptPosition slv$R = null;
    private static ReceiptPosition se$R = null;

    private static String trim(String str) {
        if (str == null) {
            return "";
        }
        str = str.trim();
        str = str.replaceFirst(":", "");
        str = str.replaceFirst("\uff1a", "");
        return str.trim();
    }

    public static JSONObject analysisAllDP(PDDocument document) {
        int Hcount;
        JSONObject returnJSON = new JSONObject();
        DocumentInfo documentInfo = new DocumentInfo();
        if (PDFAnalysisUtil.analysisPDF(document, returnJSON, documentInfo)) {
            return returnJSON;
        }
        InvoiceInfo invoiceInfo = new InvoiceInfo();
        PDFAnalysisUtil.getCoordinate(documentInfo, invoiceInfo);
        List<ReceiptPosition> positionList = documentInfo.getMainList();
        if (null != positionList && positionList.size() == 0) {
            returnJSON.put("error", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u53d1\u7968\u539f\u751f\u6587\u4ef6\uff0c\u8bf7\u4f7f\u7528\u6700\u5de6\u4fa7\u7684\u6309\u94ae\u4e0a\u4f20!", (String)"PDFAnalysisUtil_0", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u53d1\u7968\u539f\u751f\u6587\u4ef6\uff0c\u8bf7\u4f7f\u7528\u6700\u5de6\u4fa7\u7684\u6309\u94ae\u4e0a\u4f20!", (String)"PDFAnalysisUtil_0", (String)"imc-rim-file", (Object[])new Object[0]));
        }
        ArrayList<Float> hjLastX = new ArrayList<Float>();
        HashMap<Float, String> hjText = new HashMap<Float, String>();
        if (invoiceInfo.invoiceNo == 0.0f) {
            ArrayList<Float> FPHMList2 = new ArrayList<Float>(16);
            HashMap<Float, Integer> map = new HashMap<Float, Integer>(16);
            int count = 0;
            block0: for (int i = 0; i < invoiceInfo.FPHMList.size(); ++i) {
                for (int j = i + 1; j < invoiceInfo.FPHMList.size(); ++j) {
                    if (!invoiceInfo.FPHMList.get(i).equals(invoiceInfo.FPHMList.get(j))) continue;
                    FPHMList2.add(invoiceInfo.FPHMList.get(i));
                    continue block0;
                }
            }
            for (Float obj : FPHMList2) {
                if (map.containsKey(obj)) {
                    ++count;
                    map.put(obj, (Integer)map.get(obj) + 1);
                    continue;
                }
                map.put(obj, 1);
            }
            FPHMList2.clear();
            for (Map.Entry entry : map.entrySet()) {
                FPHMList2.add((Float)entry.getKey());
            }
            if (FPHMList2.size() > 0) {
                invoiceInfo.invoiceNo = ((Float)FPHMList2.get(0)).floatValue();
            }
        }
        if ((Hcount = invoiceInfo.Hlist.size()) > 0) {
            invoiceInfo.hj = documentInfo.getFlag().equals("ONE") ? invoiceInfo.Hlist.get(0).floatValue() : invoiceInfo.Hlist.get(Hcount - 1).floatValue();
        }
        PDFAnalysisUtil.getValuesByCoordinate(documentInfo, invoiceInfo, hjLastX, hjText);
        PDFAnalysisUtil.compensateValues(returnJSON, invoiceInfo, hjLastX, hjText);
        PDFAnalysisUtil.getBuyerName(returnJSON, invoiceInfo);
        return returnJSON;
    }

    private static void getBuyerName(JSONObject returnJSON, InvoiceInfo invoiceInfo) {
        float taxNo = invoiceInfo.getTaxNo();
        ArrayList<ReceiptPosition> receiptPositionsTemp = new ArrayList<ReceiptPosition>();
        for (ReceiptPosition receiptPosition : invoiceInfo.getBuyerNameList()) {
            if (!(receiptPosition.getPosLastY() > taxNo)) continue;
            receiptPositionsTemp.add(receiptPosition);
        }
        int listSize = receiptPositionsTemp.size();
        if (listSize == 2) {
            if (((ReceiptPosition)receiptPositionsTemp.get(0)).getPosLastX() > ((ReceiptPosition)receiptPositionsTemp.get(1)).getPosLastX()) {
                invoiceInfo.json.put("buyerName", (Object)((ReceiptPosition)receiptPositionsTemp.get(1)).getText());
            } else {
                invoiceInfo.json.put("buyerName", (Object)((ReceiptPosition)receiptPositionsTemp.get(0)).getText());
            }
        }
        if (listSize > 2) {
            invoiceInfo.json.put("buyerName", (Object)((ReceiptPosition)receiptPositionsTemp.get(listSize - 2)).getText());
        }
    }

    private static void getCoordinate(DocumentInfo documentInfo, InvoiceInfo invoiceInfo) {
        for (ReceiptPosition item : documentInfo.getMainList()) {
            String itemStr = item.getText().trim();
            float postLastY = item.getPosLastY();
            float postLastX = item.getPosLastX();
            if (itemStr.equals("\u53d1") || itemStr.equals("\u7968") || itemStr.equals("\u53f7") || itemStr.equals("\u7801")) {
                invoiceInfo.FPHMList.add(Float.valueOf(postLastY));
            }
            if (itemStr.contains(FPHM)) {
                invoiceInfo.invoiceNo = postLastY;
                continue;
            }
            if (itemStr.contains("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7")) {
                invoiceInfo.taxNo = postLastY;
                invoiceInfo.taxNoX = postLastX;
                invoiceInfo.taxX.add(Float.valueOf(postLastX));
                continue;
            }
            if (itemStr.contains("\u540d\u79f0\uff1a")) {
                invoiceInfo.buyerName = postLastY;
                continue;
            }
            if (itemStr.contains(KPRQ)) {
                invoiceInfo.invoiceDate = postLastY;
                continue;
            }
            if (itemStr.contains("\u5f00\u7968\u4eba")) {
                invoiceInfo.drawer = postLastY;
                continue;
            }
            if (itemStr.contains(JSHJ)) {
                invoiceInfo.totalAmount = postLastY;
                continue;
            }
            if (itemStr.equals(HJ_H) || itemStr.equals(HJ)) {
                invoiceInfo.hj = postLastY;
                invoiceInfo.Hlist.add(Float.valueOf(invoiceInfo.hj));
                continue;
            }
            if (itemStr.contains("\u7535\u5b50\u53d1\u7968")) {
                String values = itemStr;
                int count = 0;
                Matcher matcher = Pattern.compile("\u53d1\u7968").matcher(values);
                while (matcher.find()) {
                    ++count;
                }
                if (count == 2) {
                    if (values.contains("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968")) {
                        values = "27";
                    }
                    if (values.contains("\u666e\u901a\u53d1\u7968")) {
                        values = "26";
                    }
                    invoiceInfo.json.put("invoiceType", (Object)values);
                }
            }
            if (!itemStr.contains("\u65e5") && !itemStr.contains("\u671f")) continue;
            invoiceInfo.dateZBList.add(Float.valueOf(postLastY));
        }
        if (invoiceInfo.invoiceDate == 0.0f && null != invoiceInfo.dateZBList) {
            Iterator<Object> iterator = invoiceInfo.dateZBList.iterator();
            while (iterator.hasNext()) {
                float zb = ((Float)iterator.next()).floatValue();
                if (!(zb > invoiceInfo.taxNo)) continue;
                invoiceInfo.invoiceDate = zb;
            }
        }
    }

    private static void getValuesByCoordinate(DocumentInfo documentInfo, InvoiceInfo invoiceInfo, List<Float> hjLastX, Map<Float, String> hjText) {
        for (ReceiptPosition item : documentInfo.getMainList()) {
            String values;
            String tt;
            if (ContanstPDF.coordinateCE1(item.getPosLastY(), invoiceInfo.invoiceNo)) {
                Pattern pattern;
                String invNo = item.getText();
                if (invNo.contains(FPHM)) {
                    if (invNo.length() > 5) {
                        String tInvNo = invNo.substring(invNo.length() - 20);
                        invoiceInfo.json.put("invoiceNo", (Object)tInvNo);
                        invoiceInfo.setInvoiceNoText(tInvNo);
                    } else if (!item.getText().contains(FPHM) && !item.getText().contains("\u53d1\u7968")) {
                        invoiceInfo.json.put("invoiceNo", (Object)item.getText());
                        invoiceInfo.setInvoiceNoText(item.getText());
                    }
                } else if (!item.getText().contains(FPHM) && !item.getText().contains("\u53d1\u7968") && (pattern = Pattern.compile(".*[0-9].*")).matcher(invNo).matches() && invNo.length() == 20) {
                    invoiceInfo.json.put("invoiceNo", (Object)item.getText());
                    invoiceInfo.setInvoiceNoText(item.getText());
                }
            }
            if ((tt = item.getText()).contains("149800.70")) {
                float a = item.getPosLastY() - invoiceInfo.totalAmount;
                boolean s = ContanstPDF.coordinateCE1(item.getPosLastY(), invoiceInfo.totalAmount);
                logger.info("1111");
            }
            if (ContanstPDF.coordinateCE1(item.getPosLastY(), invoiceInfo.totalAmount)) {
                String regex = "[\\u4E00-\\u9FA5]";
                Pattern pattern = Pattern.compile(regex);
                Matcher match = pattern.matcher(item.getText());
                if (!match.find()) {
                    String values2 = item.getText();
                    values2 = values2.trim().replace("\uffe5", "");
                    values2 = values2.trim().replace("\u00a5", "");
                    invoiceInfo.json.put("totalAmount", (Object)values2);
                }
                invoiceInfo.testList.add(Float.valueOf(invoiceInfo.totalAmount));
            }
            if (ContanstPDF.coordinateCE4(item.getPosLastY(), invoiceInfo.hj) && !item.getText().contains(HJ_H) && !item.getText().contains(HJ_J)) {
                hjLastX.add(Float.valueOf(item.getPosLastX()));
                hjText.put(Float.valueOf(item.getPosLastX()), item.getText());
            }
            if (ContanstPDF.coordinateCE1(item.getPosLastY(), invoiceInfo.drawer)) {
                if (StringUtils.isNotEmpty((CharSequence)item.getText())) {
                    invoiceInfo.json.put("drawer", (Object)item.getText().replace("\u5f00\u7968\u4eba\uff1a", ""));
                } else {
                    invoiceInfo.json.put("drawer", (Object)"");
                }
            }
            if (ContanstPDF.coordinateCE1(item.getPosLastY(), invoiceInfo.invoiceDate) && !item.getText().contains(KPRQ)) {
                invoiceInfo.dateTextList.add(item);
            }
            if (ContanstPDF.coordinateCE1(item.getPosLastY(), invoiceInfo.taxNo) && !item.getText().contains("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7") && item.getText().length() == 18) {
                invoiceInfo.taxList.add(Float.valueOf(item.getPosLastY()));
                invoiceInfo.taxTextList.add(item.getText());
            }
            if (invoiceInfo.invoiceDate == 0.0f && (values = item.getText()).contains("\u5e74") && values.contains("\u6708") && values.contains("\u65e5")) {
                if (values.length() > 11) {
                    invoiceInfo.json.put("invoiceDate", (Object)values.substring(values.length() - 11));
                } else {
                    invoiceInfo.json.put("invoiceDate", (Object)item.getText());
                }
            }
            if (ContanstPDF.coordinateCE5(item.getPosLastX(), Coordinate.label.getPosLastX()) && ContanstPDF.coordinateCE5(item.getPosLastY(), Coordinate.label.getPosLastY()) && (values = item.getText()).contains("\u670d\u52a1")) {
                invoiceInfo.json.put("label", (Object)values);
                continue;
            }
            if (!ContanstPDF.coordinateCE1(item.getPosLastY(), invoiceInfo.buyerName)) continue;
            values = item.getText();
            if (!values.contains(MC)) {
                ReceiptPosition receiptPosition = new ReceiptPosition();
                receiptPosition.setText(values);
                receiptPosition.setPosLastX(item.getPosLastX());
                receiptPosition.setPosLastY(item.getPosLastY());
                invoiceInfo.buyerNameList.add(receiptPosition);
                continue;
            }
            if (values.length() <= 6) continue;
            ReceiptPosition receiptPosition = new ReceiptPosition();
            receiptPosition.setText(values.substring(3));
            receiptPosition.setPosLastX(item.getPosLastX());
            receiptPosition.setPosLastY(item.getPosLastY());
            invoiceInfo.buyerNameList.add(receiptPosition);
        }
        if (invoiceInfo.dateTextList.size() >= 1) {
            int i;
            StringBuffer values = new StringBuffer();
            int datasize = invoiceInfo.dateTextList.size();
            for (i = 0; i < datasize; ++i) {
                for (int j = 0; j < datasize - 1; ++j) {
                    if (!(invoiceInfo.dateTextList.get(j).getPosLastX() > invoiceInfo.dateTextList.get(j + 1).getPosLastX())) continue;
                    ReceiptPosition tempObj = new ReceiptPosition();
                    tempObj = invoiceInfo.dateTextList.get(j);
                    invoiceInfo.dateTextList.set(j, invoiceInfo.dateTextList.get(j + 1));
                    invoiceInfo.dateTextList.set(j + 1, tempObj);
                }
            }
            for (i = 0; i < datasize; ++i) {
                values.append(invoiceInfo.dateTextList.get(i).getText());
            }
            int lengthValues = values.length();
            String data = "";
            if (lengthValues > 11) {
                if (lengthValues == 13) {
                    data = values.substring(lengthValues - 8, lengthValues);
                    invoiceInfo.json.put("invoiceDate", (Object)data);
                } else {
                    data = values.substring(lengthValues - 11, lengthValues);
                    invoiceInfo.json.put("invoiceDate", (Object)data);
                }
            } else {
                invoiceInfo.json.put("invoiceDate", (Object)values);
            }
        } else {
            invoiceInfo.json.put("invoiceDate", (Object)"");
        }
    }

    private static boolean analysisPDF(PDDocument document, JSONObject returnJSON, DocumentInfo documentInfo) {
        try {
            PDPageTree pages = document.getPages();
            int pageCount = pages.getCount();
            if (pageCount == 1) {
                PDFTextStripperNew stripper = new PDFTextStripperNew();
                stripper.setStartPage(1);
                stripper.setEndPage(1);
                stripper.setSortByPosition(true);
                stripper.getText(document);
                documentInfo.setMainList(stripper.getPosList());
            } else if (pageCount > 1) {
                PDFTextStripperNew stripperAddendum = new PDFTextStripperNew();
                stripperAddendum.setStartPage(pageCount);
                stripperAddendum.setEndPage(pageCount);
                stripperAddendum.setSortByPosition(true);
                stripperAddendum.getText(document);
                documentInfo.setMainList(stripperAddendum.getPosList());
                documentInfo.setFlag("MANY");
            }
        }
        catch (Exception e) {
            returnJSON.put("error", (Object)e.getMessage());
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968", (String)"PDFAnalysisUtil_1", (String)"imc-rim-file", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static void compensateValues(JSONObject returnJSON, InvoiceInfo invoiceInfo, List<Float> hjLastX, Map<Float, String> hjText) {
        String invoiceNoText = invoiceInfo.invoiceNoText;
        if (null != invoiceNoText && invoiceNoText.length() == 20) {
            if (hjLastX.size() > 0) {
                Float aFloat = (Float)hjLastX.stream().min((a, b) -> {
                    if (a.floatValue() > b.floatValue()) {
                        return 1;
                    }
                    if (a.floatValue() < b.floatValue()) {
                        return -1;
                    }
                    return 0;
                }).get();
                logger.info("start aFloat= " + aFloat);
                String values = hjText.get(aFloat);
                values = values.trim().replace("\uffe5", "");
                values = values.trim().replace("\u00a5", "");
                invoiceInfo.json.put("invoiceAmount", (Object)values);
            }
            for (int i = 0; i < invoiceInfo.taxList.size(); ++i) {
                logger.info(String.valueOf(invoiceInfo.taxList.get(i)));
                logger.info(invoiceInfo.taxTextList.get(i));
            }
            logger.info(String.valueOf(invoiceInfo.taxList.size()));
            if (invoiceInfo.testList.size() == 0) {
                returnJSON.put("error", (Object)ResManager.loadKDString((String)"PDF\u7248\u5f0f\u683c\u5f0f\u975e\u539f\u751f\u683c\u5f0f,\u65e0\u6cd5\u89e3\u6790", (String)"PDFAnalysisUtil_2", (String)"imc-rim-file", (Object[])new Object[0]));
                returnJSON.put("type", (Object)"1");
                returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968", (String)"PDFAnalysisUtil_1", (String)"imc-rim-file", (Object[])new Object[0]));
            } else {
                if (invoiceInfo.taxList.size() > 1 && invoiceInfo.taxTextList.size() > 1) {
                    if (ContanstPDF.coordinateCE2(invoiceInfo.taxList.get(0).floatValue(), invoiceInfo.taxList.get(1).floatValue())) {
                        invoiceInfo.json.put("salerTaxNo", (Object)invoiceInfo.taxTextList.get(0));
                        invoiceInfo.json.put("buyerTaxNo", (Object)invoiceInfo.taxTextList.get(1));
                    } else {
                        invoiceInfo.json.put("buyerTaxNo", (Object)invoiceInfo.taxTextList.get(0));
                        invoiceInfo.json.put("salerTaxNo", (Object)invoiceInfo.taxTextList.get(1));
                    }
                } else {
                    invoiceInfo.json.put("salerTaxNo", null);
                    invoiceInfo.json.put("buyerTaxNo", null);
                }
                returnJSON.put("type", (Object)"2");
                returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u5168\u7535\u7968", (String)"PDFAnalysisUtil_3", (String)"imc-rim-file", (Object[])new Object[0]));
                returnJSON.put("invoice", (Object)invoiceInfo.json);
            }
        } else {
            returnJSON.put("error", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968\u8bf7\u6309\u5176\u4ed6\u65b9\u5f0f\u8bc6\u522b\u89e3\u6790", (String)"PDFAnalysisUtil_4", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968", (String)"PDFAnalysisUtil_1", (String)"imc-rim-file", (Object[])new Object[0]));
        }
    }

    public static JSONObject readReceiptPdfByAllDP(PDDocument document) {
        JSONObject returnJSON = new JSONObject();
        List<ReceiptPosition> mainList = null;
        try {
            PDPageTree pages = document.getPages();
            int pageCount = pages.getCount();
            if (pageCount == 1) {
                PDFTextStripperNew stripper = new PDFTextStripperNew();
                stripper.setStartPage(1);
                stripper.setEndPage(1);
                stripper.setSortByPosition(true);
                stripper.getText(document);
                mainList = stripper.getPosList();
            } else if (pageCount > 1) {
                PDFTextStripperNew stripperMain = new PDFTextStripperNew();
                stripperMain.setStartPage(1);
                stripperMain.setEndPage(1);
                stripperMain.setSortByPosition(true);
                stripperMain.getText(document);
                mainList = stripperMain.getPosList();
                PDFTextStripperNew stripperAddendum = new PDFTextStripperNew();
                stripperAddendum.setStartPage(2);
                stripperAddendum.setEndPage(2);
                stripperAddendum.setSortByPosition(true);
                stripperAddendum.getText(document);
            }
        }
        catch (Exception e) {
            returnJSON.put("error", (Object)e.getMessage());
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968", (String)"PDFAnalysisUtil_1", (String)"imc-rim-file", (Object[])new Object[0]));
            return returnJSON;
        }
        JSONObject json = new JSONObject();
        JSONObject jsonDetail = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        System.out.println(mainList);
        FormatAttribute formatAttribute = new FormatAttribute();
        formatAttribute.setMainList(mainList);
        formatAttribute.setType(0);
        formatAttribute.setModel(0);
        formatAttribute.setJson(json);
        formatAttribute.setInvoiceLength("");
        PDFAnalysisUtil.getFormatType(formatAttribute);
        if (mainList != null && formatAttribute.getType() == 20 && formatAttribute.getModel() == 1) {
            if (mainList != null) {
                for (ReceiptPosition item : mainList) {
                    String values;
                    if (0.0f == Math.abs(item.getPosLastX() - Coordinate.GMFSH.getPosLastX()) && Math.abs(item.getPosLastY() - Coordinate.GMFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - Coordinate.SSFSH.getPosLastX()) && Math.abs(item.getPosLastY() - Coordinate.SSFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - Coordinate.BUYERNAME.getPosX()) && Math.abs(item.getPosY() - Coordinate.BUYERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - Coordinate.SALERNAME.getPosX()) && Math.abs(item.getPosY() - Coordinate.SALERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - Coordinate.invoiceDate.getPosLastX()) && Math.abs(item.getPosLastY() - Coordinate.invoiceDate.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("invoiceDate", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastY() - Coordinate.invoiceAmount.getPosLastY()) && Math.abs(item.getPosY() - Coordinate.invoiceAmount.getPosY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("invoiceAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - Coordinate.totalTaxAmount.getPosLastX()) && Math.abs(item.getPosLastY() - Coordinate.totalTaxAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalTaxAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - Coordinate.totalAmount.getPosX()) && Math.abs(item.getPosY() - Coordinate.totalAmount.getPosY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - Coordinate.remark.getPosLastX()) && Math.abs(item.getPosLastY() - Coordinate.remark.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("remark", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - Coordinate.drawer.getPosLastX()) && Math.abs(item.getPosLastY() - Coordinate.drawer.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("drawer", (Object)values);
                        continue;
                    }
                    if (0.0f != Math.abs(item.getPosLastY() - Coordinate.invoiceType.getPosLastY()) || Math.abs(item.getPosY() - Coordinate.invoiceType.getPosY()) != 0.0f) continue;
                    values = item.getText();
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09")) {
                        values = "27";
                    }
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09")) {
                        values = "26";
                    }
                    json.put("invoiceType", (Object)values);
                }
            }
            returnJSON.put("type", (Object)"2");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u5168\u7535\u7968", (String)"PDFAnalysisUtil_3", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("invoice", (Object)json);
        } else if (mainList != null && formatAttribute.getType() == 20 && formatAttribute.getModel() == 2) {
            if (mainList != null) {
                for (ReceiptPosition item : mainList) {
                    String values;
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateA.GMFSH.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateA.GMFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateA.SSFSH.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateA.SSFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - CoordinateA.BUYERNAME.getPosX()) && Math.abs(item.getPosY() - CoordinateA.BUYERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - CoordinateA.SALERNAME.getPosX()) && Math.abs(item.getPosY() - CoordinateA.SALERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateA.invoiceDate.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateA.invoiceDate.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("invoiceDate", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateA.invoiceAmount.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateA.invoiceAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("invoiceAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateA.totalTaxAmount.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateA.totalTaxAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalTaxAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosY() - CoordinateA.totalAmount.getPosY()) && Math.abs(item.getPosLastY() - CoordinateA.totalAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateA.remark.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateA.remark.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("remark", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateA.drawer.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateA.drawer.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("drawer", (Object)values);
                        continue;
                    }
                    if (0.0f != Math.abs(item.getPosLastY() - CoordinateA.invoiceType.getPosLastY()) || Math.abs(item.getPosY() - CoordinateA.invoiceType.getPosY()) != 0.0f) continue;
                    values = item.getText();
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09")) {
                        values = "27";
                    }
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09")) {
                        values = "26";
                    }
                    json.put("invoiceType", (Object)values);
                }
            }
            returnJSON.put("type", (Object)"2");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u5168\u7535\u7968", (String)"PDFAnalysisUtil_3", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("invoice", (Object)json);
        } else if (mainList != null && formatAttribute.getType() == 20 && formatAttribute.getModel() == 3) {
            if (mainList != null) {
                for (ReceiptPosition item : mainList) {
                    String values;
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateB.GMFSH.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateB.GMFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateB.SSFSH.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateB.SSFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - CoordinateB.BUYERNAME.getPosX()) && Math.abs(item.getPosY() - CoordinateB.BUYERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - CoordinateB.SALERNAME.getPosX()) && Math.abs(item.getPosY() - CoordinateB.SALERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateB.invoiceDate.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateB.invoiceDate.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("invoiceDate", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateB.invoiceAmount.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateB.invoiceAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("invoiceAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateB.totalTaxAmount.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateB.totalTaxAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalTaxAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosY() - CoordinateB.totalAmount.getPosY()) && Math.abs(item.getPosLastY() - CoordinateB.totalAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateB.remark.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateB.remark.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("remark", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateB.drawer.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateB.drawer.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("drawer", (Object)values);
                        continue;
                    }
                    if (0.0f != Math.abs(item.getPosLastY() - CoordinateB.invoiceType.getPosLastY()) || Math.abs(item.getPosY() - CoordinateB.invoiceType.getPosY()) != 0.0f) continue;
                    values = item.getText();
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09")) {
                        values = "27";
                    }
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09")) {
                        values = "26";
                    }
                    json.put("invoiceType", (Object)values);
                }
            }
            returnJSON.put("type", (Object)"2");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u5168\u7535\u7968", (String)"PDFAnalysisUtil_3", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("invoice", (Object)json);
        } else if (formatAttribute.getType() == 20 && formatAttribute.getModel() == 4) {
            if (mainList != null) {
                for (ReceiptPosition item : mainList) {
                    String values;
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateC.GMFSH.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateC.GMFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateC.SSFSH.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateC.SSFSH.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerTaxNo", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - CoordinateC.BUYERNAME.getPosX()) && Math.abs(item.getPosY() - CoordinateC.BUYERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("buyerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - CoordinateC.SALERNAME.getPosX()) && Math.abs(item.getPosY() - CoordinateC.SALERNAME.getPosY()) == 0.0f) {
                        values = item.getText();
                        json.put("salerName", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateC.invoiceDate.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateC.invoiceDate.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("invoiceDate", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastY() - CoordinateC.invoiceAmount.getPosLastY()) && Math.abs(item.getPosY() - CoordinateC.invoiceAmount.getPosY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("invoiceAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateC.totalTaxAmount.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateC.totalTaxAmount.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalTaxAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosX() - CoordinateC.totalAmount.getPosX()) && Math.abs(item.getPosY() - CoordinateC.totalAmount.getPosY()) == 0.0f) {
                        values = item.getText();
                        values = values.trim().replace("\uffe5", "");
                        json.put("totalAmount", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateC.remark.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateC.remark.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("remark", (Object)values);
                        continue;
                    }
                    if (0.0f == Math.abs(item.getPosLastX() - CoordinateC.drawer.getPosLastX()) && Math.abs(item.getPosLastY() - CoordinateC.drawer.getPosLastY()) == 0.0f) {
                        values = item.getText();
                        json.put("drawer", (Object)values);
                        continue;
                    }
                    if (0.0f != Math.abs(item.getPosLastY() - CoordinateC.invoiceType.getPosLastY()) || Math.abs(item.getPosY() - CoordinateC.invoiceType.getPosY()) != 0.0f) continue;
                    values = item.getText();
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09")) {
                        values = "27";
                    }
                    if (values.equals("\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09")) {
                        values = "26";
                    }
                    json.put("invoiceType", (Object)values);
                }
            }
            returnJSON.put("type", (Object)"2");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u5168\u7535\u7968", (String)"PDFAnalysisUtil_3", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("invoice", (Object)json);
        } else {
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968", (String)"PDFAnalysisUtil_1", (String)"imc-rim-file", (Object[])new Object[0]));
        }
        return returnJSON;
    }

    private static void getFormatType(FormatAttribute formatAttribute) {
        String values;
        for (ReceiptPosition item : formatAttribute.getMainList()) {
            if (0.0f != Math.abs(item.getPosLastX() - Coordinate.invoiceNo.getPosLastX()) || Math.abs(item.getPosLastY() - Coordinate.invoiceNo.getPosLastY()) != 0.0f) continue;
            values = item.getText();
            formatAttribute.getJson().put("invoiceNo", (Object)values);
            formatAttribute.setInvoiceLength(values);
            formatAttribute.setType(values.length());
            if (formatAttribute.getType() != 20) break;
            formatAttribute.setModel(1);
            break;
        }
        if (StringUtils.isEmpty((CharSequence)formatAttribute.getInvoiceLength())) {
            for (ReceiptPosition item : formatAttribute.getMainList()) {
                if (0.0f != Math.abs(item.getPosLastX() - CoordinateA.invoiceNo.getPosLastX()) || Math.abs(item.getPosLastY() - CoordinateA.invoiceNo.getPosLastY()) != 0.0f) continue;
                values = item.getText();
                formatAttribute.getJson().put("invoiceNo", (Object)values);
                formatAttribute.setType(values.length());
                if (formatAttribute.getType() != 20) break;
                formatAttribute.setModel(2);
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)formatAttribute.getInvoiceLength())) {
            for (ReceiptPosition item : formatAttribute.getMainList()) {
                if (0.0f != Math.abs(item.getPosLastX() - CoordinateB.invoiceNo.getPosLastX()) || Math.abs(item.getPosLastY() - CoordinateB.invoiceNo.getPosLastY()) != 0.0f) continue;
                values = item.getText();
                formatAttribute.getJson().put("invoiceNo", (Object)values);
                formatAttribute.setType(values.length());
                if (formatAttribute.getType() != 20) break;
                formatAttribute.setModel(3);
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)formatAttribute.getInvoiceLength())) {
            for (ReceiptPosition item : formatAttribute.getMainList()) {
                if (0.0f != Math.abs(item.getPosLastX() - CoordinateC.invoiceNo.getPosLastX()) || Math.abs(item.getPosLastY() - CoordinateC.invoiceNo.getPosLastY()) != 0.0f) continue;
                values = item.getText();
                formatAttribute.getJson().put("invoiceNo", (Object)values);
                formatAttribute.setType(values.length());
                if (formatAttribute.getType() != 20) break;
                formatAttribute.setModel(4);
                break;
            }
        }
    }

    public static boolean isDigit2(String strNum) {
        Pattern pattern = Pattern.compile("[0-9]{1,}");
        Matcher matcher = pattern.matcher(strNum);
        return matcher.matches();
    }

    private static String extractM(String parm) {
        Pattern p = Pattern.compile("[0-9\\.]+");
        Matcher m = p.matcher(parm);
        StringBuilder str = new StringBuilder();
        while (m.find()) {
            str.append(m.group());
        }
        return str.toString();
    }
}

