/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis.digital;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfTextCode;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoice;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoiceItem;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.ZeroTaxRateFlagEnum;
import kd.imc.rim.file.utils.DateUtil;
import kd.imc.rim.file.utils.StrUtil;
import org.apache.commons.lang3.StringUtils;

public class DigitalPdfUtils {
    public static String formatDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = simpleDateFormat.format(DateUtil.parseDate("yyyy\u5e74MM\u6708dd", str));
            return format;
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String getTaxRate(String taxRate) {
        if (taxRate != null && taxRate.contains("%")) {
            String taxRateStr = taxRate.replace("%", "");
            BigDecimal taxRateBig = new BigDecimal(taxRateStr).divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP).stripTrailingZeros();
            taxRate = taxRateBig.toPlainString();
        }
        return taxRate;
    }

    public static void setSortContentData(Map<BigDecimal, Map<BigDecimal, PdfTextCode>> contentMap, BigDecimal x, BigDecimal y, BigDecimal width, String content, int diff) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        Map<BigDecimal, PdfTextCode> xMap = contentMap.get(y);
        BigDecimal currentY = y;
        for (int i = 1; i <= diff && xMap == null; ++i) {
            currentY = y.subtract(new BigDecimal(i));
            xMap = contentMap.get(currentY);
        }
        if (xMap != null) {
            for (Map.Entry<BigDecimal, PdfTextCode> codeEntry : xMap.entrySet()) {
                PdfTextCode code = codeEntry.getValue();
                if (!DigitalPdfConstants.INFO_KEYS.contains(code.getContent())) continue;
                xMap = null;
                break;
            }
        }
        if (xMap == null) {
            currentY = y;
            xMap = contentMap.computeIfAbsent(y, k -> new TreeMap());
        }
        xMap.put(x, new PdfTextCode(x, currentY, width, content));
    }

    public static List<PdfTextCode> getItemHeadList(List<PdfTextCode> xList) {
        ArrayList<PdfTextCode> headList = new ArrayList<PdfTextCode>(16);
        for (int i = 0; i < xList.size(); ++i) {
            PdfTextCode pdfTextCode = xList.get(i);
            BigDecimal xLength = pdfTextCode.getWidth();
            String content = DigitalPdfUtils.replaceSpaceToEmpty(pdfTextCode.getContent());
            if (content != null && content.length() == 1 && i < xList.size() - 1) {
                PdfTextCode nextPdfTextCode = xList.get(++i);
                content = content + DigitalPdfUtils.replaceSpaceToEmpty(nextPdfTextCode.getContent());
                xLength = xLength.add(nextPdfTextCode.getWidth());
            }
            pdfTextCode.setWidth(xLength.add(pdfTextCode.getX()).add(new BigDecimal("4")));
            pdfTextCode.setContent(content);
            headList.add(pdfTextCode);
        }
        return headList;
    }

    public static VatInvoiceItem getItemByXList(List<PdfTextCode> xList, List<PdfTextCode> headList, boolean vatFlag) {
        VatInvoiceItem vatInvoiceItem = new VatInvoiceItem();
        block0: for (PdfTextCode pdfTextCode : xList) {
            BigDecimal x = pdfTextCode.getX();
            for (int i = 0; i < headList.size(); ++i) {
                PdfTextCode headPre = null;
                PdfTextCode headNext = null;
                if (i > 0) {
                    headPre = headList.get(i - 1);
                }
                if (i < headList.size() - 1) {
                    headNext = headList.get(i + 1);
                }
                PdfTextCode head = headList.get(i);
                if ((headPre != null || x.compareTo(head.getWidth()) >= 0) && (headPre == null || x.compareTo(headPre.getWidth().subtract(new BigDecimal("3"))) < 0) || headNext != null && x.add(pdfTextCode.getWidth()).compareTo(headNext.getX()) >= 0) continue;
                String headContent = head.getContent();
                String content = pdfTextCode.getContent();
                DigitalPdfUtils.setItemModel(vatInvoiceItem, headContent, content, vatFlag);
                continue block0;
            }
        }
        return vatInvoiceItem;
    }

    private static void setItemModel(VatInvoiceItem vatInvoiceItem, String headContent, String content, boolean vatFlag) {
        content = StrUtil.nullToEmpty(content);
        if ("\u9879\u76ee\u540d\u79f0".equals(headContent) || vatFlag && headContent.contains("\u540d\u79f0")) {
            vatInvoiceItem.setGoodsName(StrUtil.nullToEmpty(vatInvoiceItem.getGoodsName()) + content);
        } else if ("\u89c4\u683c\u578b\u53f7".equals(headContent) || headContent.contains("\u4ea7\u6743\u8bc1\u53f7") || headContent.contains("\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730") || headContent.contains("\u8f66\u724c\u53f7")) {
            vatInvoiceItem.setSpecModel(StrUtil.nullToEmpty(vatInvoiceItem.getSpecModel()) + content);
        } else if (headContent.contains("\u5355\u4f4d") || headContent.contains("\u5efa\u7b51\u9879\u76ee\u540d\u79f0") || headContent.contains("\u7c7b\u578b")) {
            vatInvoiceItem.setUnit(StrUtil.nullToEmpty(vatInvoiceItem.getUnit()) + content);
        } else if ("\u6570\u91cf".equals(headContent)) {
            vatInvoiceItem.setNum(content);
        } else if ("\u5355\u4ef7".equals(headContent)) {
            vatInvoiceItem.setUnitPrice(content);
        } else if (headContent.contains("\u7a0e\u7387")) {
            DigitalPdfUtils.setTaxRate(vatInvoiceItem, content);
        } else if ("\u91d1\u989d".equals(headContent)) {
            vatInvoiceItem.setDetailAmount(content);
        } else if ("\u901a\u884c\u65e5\u671f\u8d77".equals(headContent)) {
            vatInvoiceItem.setStartDate(content);
        } else if ("\u901a\u884c\u65e5\u671f\u6b62".equals(headContent)) {
            vatInvoiceItem.setEndDate(content);
        } else if ("\u7a0e\u989d".equals(headContent)) {
            if ("***".equals(content)) {
                content = "0";
            }
            vatInvoiceItem.setTaxAmount(content);
        }
    }

    private static void setTaxRate(VatInvoiceItem vatInvoiceItem, String taxRate) {
        ZeroTaxRateFlagEnum zeroTaxRateFlag = ZeroTaxRateFlagEnum.getZeroTaxRateFlagByMsg(taxRate);
        if (zeroTaxRateFlag != null) {
            vatInvoiceItem.setZeroTaxRateFlag(zeroTaxRateFlag.getValue());
            vatInvoiceItem.setTaxRate("0");
            return;
        }
        String taxRateNum = DigitalPdfUtils.getTaxRate(taxRate);
        if ("0".equals(taxRateNum)) {
            vatInvoiceItem.setZeroTaxRateFlag(ZeroTaxRateFlagEnum.ZERO_RATE.getValue());
        }
        vatInvoiceItem.setTaxRate(taxRateNum);
    }

    public static void setModelItemData(VatInvoice vatInvoice, List<VatInvoiceItem> itemList) {
        ArrayList<VatInvoiceItem> finalItemList = new ArrayList<VatInvoiceItem>();
        block0: for (int i = 0; i < itemList.size(); ++i) {
            VatInvoiceItem vatInvoiceItem = itemList.get(i);
            while (true) {
                if (i == itemList.size() - 1) {
                    String detailAmount = vatInvoiceItem.getDetailAmount();
                    if (detailAmount != null && detailAmount.contains("\u00a5")) continue block0;
                    DigitalPdfUtils.setDiDiItemName(vatInvoiceItem);
                    finalItemList.add(vatInvoiceItem);
                    continue block0;
                }
                VatInvoiceItem vatInvoiceItemNext = itemList.get(i + 1);
                if (vatInvoiceItemNext.getTaxAmount() != null && vatInvoiceItem.getTaxAmount() != null) {
                    DigitalPdfUtils.setDiDiItemName(vatInvoiceItem);
                    finalItemList.add(vatInvoiceItem);
                    continue block0;
                }
                if (vatInvoiceItemNext.getGoodsName() != null) {
                    vatInvoiceItem.setGoodsName(StringUtils.stripToEmpty((String)vatInvoiceItem.getGoodsName()) + vatInvoiceItemNext.getGoodsName());
                }
                if (vatInvoiceItemNext.getSpecModel() != null) {
                    vatInvoiceItem.setSpecModel(StringUtils.stripToEmpty((String)vatInvoiceItem.getSpecModel()) + vatInvoiceItemNext.getSpecModel());
                }
                if (vatInvoiceItemNext.getUnit() != null) {
                    vatInvoiceItem.setUnit(StringUtils.stripToEmpty((String)vatInvoiceItem.getUnit()) + vatInvoiceItemNext.getUnit());
                }
                if (vatInvoiceItemNext.getNum() != null) {
                    vatInvoiceItem.setNum(StringUtils.stripToEmpty((String)vatInvoiceItem.getNum()) + vatInvoiceItemNext.getNum());
                }
                if (vatInvoiceItemNext.getUnitPrice() != null) {
                    vatInvoiceItem.setUnitPrice(StringUtils.stripToEmpty((String)vatInvoiceItem.getUnitPrice()) + vatInvoiceItemNext.getUnitPrice());
                }
                if (vatInvoiceItemNext.getDetailAmount() != null) {
                    vatInvoiceItem.setDetailAmount(StringUtils.stripToEmpty((String)vatInvoiceItem.getDetailAmount()) + vatInvoiceItemNext.getDetailAmount());
                }
                if (vatInvoiceItemNext.getTaxRate() != null) {
                    vatInvoiceItem.setTaxRate(StringUtils.stripToEmpty((String)vatInvoiceItem.getTaxRate()) + vatInvoiceItemNext.getTaxRate());
                }
                ++i;
            }
        }
        vatInvoice.setItem(finalItemList);
    }

    private static void setDiDiItemName(VatInvoiceItem vatInvoiceItem) {
        String goodsName = vatInvoiceItem.getGoodsName();
        if (goodsName != null) {
            goodsName = goodsName.replace("*\u8fd0\u8f93\u670d*\u5ba2\u8fd0\u670d\u8d39", "*\u8fd0\u8f93\u670d\u52a1*\u5ba2\u8fd0\u670d\u52a1\u8d39");
            vatInvoiceItem.setGoodsName(goodsName);
        }
    }

    public static String replaceSpaceToEmpty(String str) {
        if (str != null) {
            str = str.replace(" ", "");
        }
        return str;
    }

    public static String execColon(String str) {
        if (str != null) {
            str = str.replace(DigitalPdfConstants.CN_COLON, DigitalPdfConstants.EN_COLON);
        }
        return str;
    }
}

